/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceRedirect
extends StripeJsonModel {
    public static final String PENDING = "pending";
    public static final String SUCCEEDED = "succeeded";
    public static final String FAILED = "failed";
    public static final String NOT_REQUIRED = "not_required";
    private static final String FIELD_RETURN_URL = "return_url";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_URL = "url";
    @Nullable
    private String mReturnUrl;
    @Nullable
    private String mStatus;
    @Nullable
    private String mUrl;

    private SourceRedirect(@Nullable String returnUrl, @Nullable String status, @Nullable String url) {
        this.mReturnUrl = returnUrl;
        this.mStatus = status;
        this.mUrl = url;
    }

    @Nullable
    public String getReturnUrl() {
        return this.mReturnUrl;
    }

    public void setReturnUrl(@Nullable String returnUrl) {
        this.mReturnUrl = returnUrl;
    }

    @Nullable
    public String getStatus() {
        return this.mStatus;
    }

    public void setStatus(@Nullable String status) {
        this.mStatus = status;
    }

    @Nullable
    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(@Nullable String url) {
        this.mUrl = url;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ((AbstractMap)map).put(FIELD_RETURN_URL, this.mReturnUrl);
        ((AbstractMap)map).put(FIELD_STATUS, this.mStatus);
        ((AbstractMap)map).put(FIELD_URL, this.mUrl);
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_RETURN_URL, this.mReturnUrl);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_STATUS, this.mStatus);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_URL, this.mUrl);
        return jsonObject;
    }

    @Nullable
    public static SourceRedirect fromString(@Nullable String jsonString) {
        try {
            return SourceRedirect.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static SourceRedirect fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String returnUrl = StripeJsonUtils.optString(jsonObject, FIELD_RETURN_URL);
        String status = SourceRedirect.asStatus(StripeJsonUtils.optString(jsonObject, FIELD_STATUS));
        String url = StripeJsonUtils.optString(jsonObject, FIELD_URL);
        return new SourceRedirect(returnUrl, status, url);
    }

    @Nullable
    @VisibleForTesting
    static String asStatus(@Nullable String stringStatus) {
        if (PENDING.equals(stringStatus)) {
            return PENDING;
        }
        if (SUCCEEDED.equals(stringStatus)) {
            return SUCCEEDED;
        }
        if (FAILED.equals(stringStatus)) {
            return FAILED;
        }
        if (NOT_REQUIRED.equals(stringStatus)) {
            return NOT_REQUIRED;
        }
        return null;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SourceRedirect && this.typedEquals((SourceRedirect)obj);
    }

    private boolean typedEquals(@NonNull SourceRedirect sourceRedirect) {
        return ObjectUtils.equals(this.mReturnUrl, sourceRedirect.mReturnUrl) && ObjectUtils.equals(this.mStatus, sourceRedirect.mStatus) && ObjectUtils.equals(this.mUrl, sourceRedirect.mUrl);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mReturnUrl, this.mStatus, this.mUrl);
    }
}

