/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.utils.ObjectUtils;
import java.util.HashMap;
import java.util.Map;

public class AccountParams {
    private static final String API_PARAM_LEGAL_ENTITY = "legal_entity";
    private static final String API_TOS_SHOWN_AND_ACCEPTED = "tos_shown_and_accepted";
    @Nullable
    private Boolean mTosShownAndAccepted;
    @Nullable
    private final BusinessType mBusinessType;
    @Nullable
    private Map<String, Object> mBusinessData;

    private AccountParams(@Nullable BusinessType businessType) {
        this.mBusinessType = businessType;
    }

    @NonNull
    public static AccountParams createAccountParams(boolean tosShownAndAccepted, @Nullable Map<String, Object> legalEntity) {
        return new AccountParams(null).setTosShownAndAccepted(tosShownAndAccepted).setLegalEntity(legalEntity);
    }

    @NonNull
    public static AccountParams createAccountParams(boolean tosShownAndAccepted, @NonNull BusinessType businessType, @Nullable Map<String, Object> businessParams) {
        return new AccountParams(businessType).setTosShownAndAccepted(tosShownAndAccepted).setLegalEntity(businessParams);
    }

    @NonNull
    public AccountParams setTosShownAndAccepted(boolean tosShownAndAccepted) {
        this.mTosShownAndAccepted = tosShownAndAccepted;
        return this;
    }

    @NonNull
    public AccountParams setLegalEntity(@Nullable Map<String, Object> legalEntity) {
        this.mBusinessData = legalEntity;
        return this;
    }

    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> networkReadyMap = new HashMap<String, Object>();
        HashMap<String, Object> tokenMap = new HashMap<String, Object>();
        if (this.mTosShownAndAccepted != null) {
            tokenMap.put(API_TOS_SHOWN_AND_ACCEPTED, this.mTosShownAndAccepted);
        }
        if (this.mBusinessData != null) {
            if (this.mBusinessType != null) {
                tokenMap.put(this.mBusinessType.code, this.mBusinessData);
            } else {
                tokenMap.put(API_PARAM_LEGAL_ENTITY, this.mBusinessData);
            }
        }
        networkReadyMap.put("account", tokenMap);
        StripeNetworkUtils.removeNullAndEmptyParams(networkReadyMap);
        return networkReadyMap;
    }

    public int hashCode() {
        return ObjectUtils.hash(new Object[]{this.mTosShownAndAccepted, this.mBusinessType, this.mBusinessData});
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof AccountParams && this.typedEquals((AccountParams)obj);
    }

    private boolean typedEquals(@NonNull AccountParams accountParams) {
        return ObjectUtils.equals(this.mTosShownAndAccepted, accountParams.mTosShownAndAccepted) && ObjectUtils.equals((Object)this.mBusinessType, (Object)accountParams.mBusinessType) && ObjectUtils.equals(this.mBusinessData, accountParams.mBusinessData);
    }

    public static enum BusinessType {
        Individual("individual"),
        Company("company");

        @NonNull
        public final String code;

        private BusinessType(String code) {
            this.code = code;
        }
    }
}

