/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.stripe.android.ApiVersion;
import com.stripe.android.ErrorParser;
import com.stripe.android.LoggingUtils;
import com.stripe.android.RequestOptions;
import com.stripe.android.StripeError;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.StripeResponse;
import com.stripe.android.StripeSSLSocketFactory;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.TelemetryClientUtil;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.PermissionException;
import com.stripe.android.exception.RateLimitException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentIntentParams;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Token;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Security;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class StripeApiHandler {
    static final String GET = "GET";
    static final String POST = "POST";
    static final String DELETE = "DELETE";
    private static final String LIVE_API_BASE = "https://api.stripe.com";
    private static final String LIVE_LOGGING_BASE = "https://q.stripe.com";
    private static final String LOGGING_ENDPOINT = "https://m.stripe.com/4";
    private static final String CHARSET = "UTF-8";
    private static final String CUSTOMERS = "customers";
    private static final String TOKENS = "tokens";
    private static final String SOURCES = "sources";
    private static final String PAYMENT_METHODS = "payment_methods";
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    private static final SSLSocketFactory SSL_SOCKET_FACTORY = new StripeSSLSocketFactory();
    @NonNull
    private final ApiVersion mApiVersion;

    StripeApiHandler() {
        this(ApiVersion.getDefault());
    }

    private StripeApiHandler(@NonNull ApiVersion apiVersion) {
        this.mApiVersion = apiVersion;
    }

    void logApiCall(@NonNull Map<String, Object> loggingMap, @NonNull RequestOptions options, @Nullable LoggingResponseListener listener) {
        if (options == null || listener != null && !listener.shouldLogTest()) {
            return;
        }
        String apiKey = options.getPublishableApiKey();
        if (apiKey == null || apiKey.trim().isEmpty()) {
            return;
        }
        this.fireAndForgetApiCall(loggingMap, LIVE_LOGGING_BASE, GET, options, listener);
    }

    @Nullable
    PaymentIntent confirmPaymentIntent(@Nullable StripeNetworkUtils.UidProvider uidProvider, @NonNull Context context, @NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey, @Nullable String stripeAccount, @Nullable LoggingResponseListener loggingResponseListener) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = paymentIntentParams.toParamMap();
        StripeNetworkUtils.addUidParamsToPaymentIntent(uidProvider, context, paramMap);
        RequestOptions options = RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        try {
            String apiKey = options.getPublishableApiKey();
            if (StripeTextUtils.isBlank(apiKey)) {
                return null;
            }
            this.setTelemetryData(context, loggingResponseListener);
            SourceParams sourceParams = paymentIntentParams.getSourceParams();
            String sourceType = sourceParams != null ? sourceParams.getType() : null;
            Map<String, Object> loggingParams = LoggingUtils.getPaymentIntentConfirmationParams(context, null, apiKey, sourceType);
            RequestOptions loggingOptions = RequestOptions.builder(publishableKey).build();
            this.logApiCall(loggingParams, loggingOptions, loggingResponseListener);
            String paymentIntentId = PaymentIntent.parseIdFromClientSecret(paymentIntentParams.getClientSecret());
            StripeResponse response = this.requestData(POST, this.confirmPaymentIntentUrl(paymentIntentId), paramMap, options);
            return PaymentIntent.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    PaymentIntent retrievePaymentIntent(@NonNull Context context, @NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey, @Nullable String stripeAccount, @Nullable LoggingResponseListener loggingResponseListener) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = paymentIntentParams.toParamMap();
        RequestOptions options = RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        try {
            String apiKey = options.getPublishableApiKey();
            if (StripeTextUtils.isBlank(apiKey)) {
                return null;
            }
            this.setTelemetryData(context, loggingResponseListener);
            Map<String, Object> loggingParams = LoggingUtils.getPaymentIntentRetrieveParams(context, null, apiKey);
            RequestOptions loggingOptions = RequestOptions.builder(publishableKey).build();
            this.logApiCall(loggingParams, loggingOptions, loggingResponseListener);
            String paymentIntentId = PaymentIntent.parseIdFromClientSecret(paymentIntentParams.getClientSecret());
            StripeResponse response = this.requestData(GET, this.retrievePaymentIntentUrl(paymentIntentId), paramMap, options);
            return PaymentIntent.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    Source createSource(@Nullable StripeNetworkUtils.UidProvider uidProvider, @NonNull Context context, @NonNull SourceParams sourceParams, @NonNull String publishableKey, @Nullable String stripeAccount, @Nullable LoggingResponseListener loggingResponseListener) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.createSource(uidProvider, context, sourceParams, publishableKey, stripeAccount, loggingResponseListener, null);
    }

    @VisibleForTesting
    @Nullable
    Source createSource(@Nullable StripeNetworkUtils.UidProvider uidProvider, @NonNull Context context, @NonNull SourceParams sourceParams, @NonNull String publishableKey, @Nullable String stripeAccount, @Nullable LoggingResponseListener loggingResponseListener, @Nullable StripeResponseListener stripeResponseListener) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = sourceParams.toParamMap();
        StripeNetworkUtils.addUidParams(uidProvider, context, paramMap);
        RequestOptions options = RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        try {
            String apiKey = options.getPublishableApiKey();
            if (StripeTextUtils.isBlank(apiKey)) {
                return null;
            }
            this.setTelemetryData(context, loggingResponseListener);
            Map<String, Object> loggingParams = LoggingUtils.getSourceCreationParams(context, null, apiKey, sourceParams.getType());
            RequestOptions loggingOptions = RequestOptions.builder(publishableKey).build();
            this.logApiCall(loggingParams, loggingOptions, loggingResponseListener);
            StripeResponse response = this.requestData(POST, this.getSourcesUrl(), paramMap, options);
            if (stripeResponseListener != null) {
                stripeResponseListener.onStripeResponse(response);
            }
            return Source.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    Source retrieveSource(@NonNull String sourceId, @NonNull String clientSecret, @NonNull String publishableKey, @Nullable String stripeAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> paramMap = SourceParams.createRetrieveSourceParams(clientSecret);
        RequestOptions options = stripeAccount == null ? RequestOptions.builder(publishableKey).build() : RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        try {
            StripeResponse response = this.requestData(GET, this.getRetrieveSourceApiUrl(sourceId), paramMap, options);
            return Source.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    PaymentMethod createPaymentMethod(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull Context context, @NonNull String publishableKey, @Nullable String stripeAccount, @Nullable LoggingResponseListener loggingResponseListener) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, Object> params = paymentMethodCreateParams.toParamMap();
        StripeNetworkUtils.addUidParams(null, context, params);
        RequestOptions options = RequestOptions.builder(publishableKey, stripeAccount, "source").build();
        String apiKey = options.getPublishableApiKey();
        if (StripeTextUtils.isBlank(apiKey)) {
            return null;
        }
        this.setTelemetryData(context, loggingResponseListener);
        Map<String, Object> loggingParams = LoggingUtils.getPaymentMethodCreationParams(context, null, apiKey);
        RequestOptions loggingOptions = RequestOptions.builder(publishableKey).build();
        this.logApiCall(loggingParams, loggingOptions, loggingResponseListener);
        try {
            StripeResponse response = this.requestData(POST, this.getPaymentMethodsUrl(), params, options);
            return PaymentMethod.fromString(response.getResponseBody());
        }
        catch (CardException unexpected) {
            throw new APIException(unexpected.getMessage(), unexpected.getRequestId(), unexpected.getStatusCode(), null, (Throwable)unexpected);
        }
    }

    @Nullable
    Token createToken(@NonNull Context context, @NonNull Map<String, Object> tokenParams, @NonNull RequestOptions options, @NonNull String tokenType, @Nullable LoggingResponseListener listener) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        try {
            String apiKey = options.getPublishableApiKey();
            if (StripeTextUtils.isBlank(apiKey)) {
                return null;
            }
            List loggingTokens = (List)tokenParams.get("product_usage");
            tokenParams.remove("product_usage");
            this.setTelemetryData(context, listener);
            Map<String, Object> loggingParams = LoggingUtils.getTokenCreationParams(context, loggingTokens, apiKey, tokenType);
            this.logApiCall(loggingParams, options, listener);
        }
        catch (ClassCastException classCastEx) {
            tokenParams.remove("product_usage");
        }
        return this.requestToken(this.getTokensUrl(), tokenParams, options);
    }

    @Nullable
    Source addCustomerSource(@Nullable Context context, @NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String sourceType, @NonNull String secret, @Nullable LoggingResponseListener listener) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("source", sourceId);
        if (context != null) {
            Map<String, Object> loggingParamsMap = LoggingUtils.getAddSourceParams(context, productUsageTokens, publicKey, sourceType);
            RequestOptions loggingOptions = RequestOptions.builder(publicKey).build();
            this.logApiCall(loggingParamsMap, loggingOptions, listener);
        }
        StripeResponse response = this.getStripeResponse(POST, this.getAddCustomerSourceUrl(customerId), paramsMap, RequestOptions.builder(secret).build());
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Source.fromString(response.getResponseBody());
    }

    @Nullable
    Source deleteCustomerSource(@Nullable Context context, @NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String secret, @Nullable LoggingResponseListener listener) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (context != null) {
            Map<String, Object> loggingParamsMap = LoggingUtils.getDeleteSourceParams(context, productUsageTokens, publicKey);
            RequestOptions loggingOptions = RequestOptions.builder(publicKey).build();
            this.logApiCall(loggingParamsMap, loggingOptions, listener);
        }
        StripeResponse response = this.getStripeResponse(DELETE, this.getDeleteCustomerSourceUrl(customerId, sourceId), paramsMap, RequestOptions.builder(secret).build());
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Source.fromString(response.getResponseBody());
    }

    @Nullable
    Customer setDefaultCustomerSource(@Nullable Context context, @NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String sourceType, @NonNull String secret, @Nullable LoggingResponseListener listener) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("default_source", sourceId);
        if (context != null) {
            RequestOptions loggingOptions = RequestOptions.builder(publicKey).build();
            Map<String, Object> loggingParameters = LoggingUtils.getEventLoggingParams(context.getApplicationContext(), productUsageTokens, sourceType, null, publicKey, "default_source");
            this.logApiCall(loggingParameters, loggingOptions, listener);
        }
        StripeResponse response = this.getStripeResponse(POST, this.getRetrieveCustomerUrl(customerId), paramsMap, RequestOptions.builder(secret).build());
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @Nullable
    Customer setCustomerShippingInfo(@Nullable Context context, @NonNull String customerId, @NonNull String publicKey, @NonNull List<String> productUsageTokens, @NonNull ShippingInformation shippingInformation, @NonNull String secret, @Nullable LoggingResponseListener listener) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("shipping", shippingInformation.toMap());
        if (context != null) {
            RequestOptions loggingOptions = RequestOptions.builder(publicKey).build();
            Map<String, Object> loggingParameters = LoggingUtils.getEventLoggingParams(context.getApplicationContext(), productUsageTokens, null, null, publicKey, "set_shipping_info");
            this.logApiCall(loggingParameters, loggingOptions, listener);
        }
        StripeResponse response = this.getStripeResponse(POST, this.getRetrieveCustomerUrl(customerId), paramsMap, RequestOptions.builder(secret).build());
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @Nullable
    Customer retrieveCustomer(@NonNull String customerId, @NonNull String secret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        StripeResponse response = this.getStripeResponse(GET, this.getRetrieveCustomerUrl(customerId), null, RequestOptions.builder(secret).build());
        this.convertErrorsToExceptionsAndThrowIfNecessary(response);
        return Customer.fromString(response.getResponseBody());
    }

    @NonNull
    String createQuery(@Nullable Map<String, Object> params) throws UnsupportedEncodingException, InvalidRequestException {
        StringBuilder queryStringBuffer = new StringBuilder();
        List<Parameter> flatParams = this.flattenParams(params);
        for (Parameter flatParam : flatParams) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(this.urlEncodePair(flatParam.key, flatParam.value));
        }
        return queryStringBuffer.toString();
    }

    @NonNull
    Map<String, String> getHeaders(@Nullable RequestOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", CHARSET);
        headers.put("Accept", "application/json");
        headers.put("User-Agent", String.format(Locale.ROOT, "Stripe/v1 AndroidBindings/%s", "8.7.0"));
        if (options != null) {
            headers.put("Authorization", String.format(Locale.ENGLISH, "Bearer %s", options.getPublishableApiKey()));
        }
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        String systemPropertyName = "java.version";
        propertyMap.put("java.version", System.getProperty("java.version"));
        propertyMap.put("os.name", "android");
        propertyMap.put("os.version", String.valueOf(Build.VERSION.SDK_INT));
        propertyMap.put("bindings.version", "8.7.0");
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Stripe");
        JSONObject headerMappingObject = new JSONObject(propertyMap);
        headers.put("X-Stripe-Client-User-Agent", headerMappingObject.toString());
        headers.put("Stripe-Version", this.mApiVersion.getCode());
        if (options != null && options.getStripeAccount() != null) {
            headers.put("Stripe-Account", options.getStripeAccount());
        }
        if (options != null && options.getIdempotencyKey() != null) {
            headers.put("Idempotency-Key", options.getIdempotencyKey());
        }
        return headers;
    }

    @VisibleForTesting
    String getTokensUrl() {
        return String.format(Locale.ENGLISH, "%s/v1/%s", LIVE_API_BASE, TOKENS);
    }

    @VisibleForTesting
    String getSourcesUrl() {
        return String.format(Locale.ENGLISH, "%s/v1/%s", LIVE_API_BASE, SOURCES);
    }

    @VisibleForTesting
    String getPaymentMethodsUrl() {
        return String.format(Locale.ENGLISH, "%s/v1/%s", LIVE_API_BASE, PAYMENT_METHODS);
    }

    @NonNull
    private String createPaymentIntentUrl() {
        return String.format(Locale.ENGLISH, "%s/v1/payment_intents", LIVE_API_BASE);
    }

    @NonNull
    private String retrievePaymentIntentUrl(@NonNull String paymentIntentId) {
        return String.format(Locale.ENGLISH, "%s/v1/payment_intents/%s", LIVE_API_BASE, paymentIntentId);
    }

    @NonNull
    private String confirmPaymentIntentUrl(@NonNull String paymentIntentId) {
        return String.format(Locale.ENGLISH, "%s/v1/payment_intents/%s/confirm", LIVE_API_BASE, paymentIntentId);
    }

    @VisibleForTesting
    private String getCustomersUrl() {
        return String.format(Locale.ENGLISH, "%s/v1/%s", LIVE_API_BASE, CUSTOMERS);
    }

    @VisibleForTesting
    String getAddCustomerSourceUrl(@NonNull String customerId) {
        return String.format(Locale.ENGLISH, "%s/%s", this.getRetrieveCustomerUrl(customerId), SOURCES);
    }

    @VisibleForTesting
    String getDeleteCustomerSourceUrl(@NonNull String customerId, @NonNull String sourceId) {
        return String.format(Locale.ENGLISH, "%s/%s", this.getAddCustomerSourceUrl(customerId), sourceId);
    }

    @VisibleForTesting
    String getRetrieveCustomerUrl(@NonNull String customerId) {
        return String.format(Locale.ENGLISH, "%s/%s", this.getCustomersUrl(), customerId);
    }

    @VisibleForTesting
    String getRetrieveSourceApiUrl(@NonNull String sourceId) {
        return String.format(Locale.ENGLISH, "%s/%s", this.getSourcesUrl(), sourceId);
    }

    @VisibleForTesting
    String getRetrieveTokenApiUrl(@NonNull String tokenId) {
        return String.format(Locale.ROOT, "%s/%s", this.getTokensUrl(), tokenId);
    }

    private void convertErrorsToExceptionsAndThrowIfNecessary(@NonNull StripeResponse response) throws InvalidRequestException, APIException, AuthenticationException, CardException {
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        Map<String, List<String>> headers = response.getResponseHeaders();
        List<String> requestIdList = headers == null ? null : headers.get("Request-Id");
        String requestId = requestIdList != null && requestIdList.size() > 0 ? requestIdList.get(0) : null;
        if (rCode < 200 || rCode >= 300) {
            this.handleAPIError(rBody, rCode, requestId);
        }
    }

    @Nullable
    private JSONObject mapToJsonObject(@Nullable Map<String, ?> mapObject) {
        if (mapObject == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        for (String key : mapObject.keySet()) {
            Object value = mapObject.get(key);
            if (value == null) continue;
            try {
                if (value instanceof Map) {
                    try {
                        Map mapValue = (Map)value;
                        jsonObject.put(key, (Object)this.mapToJsonObject(mapValue));
                    }
                    catch (ClassCastException classCastException) {}
                    continue;
                }
                if (value instanceof List) {
                    jsonObject.put(key, (Object)this.listToJsonArray((List)value));
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    jsonObject.put(key, value);
                    continue;
                }
                jsonObject.put(key, (Object)value.toString());
            }
            catch (JSONException jSONException) {}
        }
        return jsonObject;
    }

    @Nullable
    private JSONArray listToJsonArray(@Nullable List<?> values) {
        if (values == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (Object object : values) {
            if (object instanceof Map) {
                Map mapObject = (Map)object;
                jsonArray.put((Object)this.mapToJsonObject(mapObject));
                continue;
            }
            if (object instanceof List) {
                jsonArray.put((Object)this.listToJsonArray((List)object));
                continue;
            }
            if (object instanceof Number || object instanceof Boolean) {
                jsonArray.put(object);
                continue;
            }
            jsonArray.put((Object)object.toString());
        }
        return jsonArray;
    }

    private void attachPseudoCookie(@NonNull HttpURLConnection connection, @NonNull RequestOptions options) {
        if (options.getGuid() != null && !TextUtils.isEmpty((CharSequence)options.getGuid())) {
            connection.setRequestProperty("Cookie", "m=" + options.getGuid());
        }
    }

    @NonNull
    private HttpURLConnection createDeleteConnection(@NonNull String url, @NonNull RequestOptions options) throws IOException {
        HttpURLConnection conn = this.createStripeConnection(url, options);
        conn.setRequestMethod(DELETE);
        return conn;
    }

    @NonNull
    private HttpURLConnection createGetConnection(@NonNull String url, @NonNull String query, @NonNull RequestOptions options) throws IOException {
        HttpURLConnection conn = this.createStripeConnection(this.formatURL(url, query), options);
        conn.setRequestMethod(GET);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private HttpURLConnection createPostConnection(@NonNull String url, @Nullable Map<String, Object> params, @NonNull RequestOptions options) throws IOException, InvalidRequestException {
        HttpURLConnection conn = this.createStripeConnection(url, options);
        conn.setDoOutput(true);
        conn.setRequestMethod(POST);
        conn.setRequestProperty("Content-Type", this.getContentType(options));
        try (OutputStream output = null;){
            output = conn.getOutputStream();
            output.write(this.getOutputBytes(params, options));
        }
        return conn;
    }

    @NonNull
    private HttpURLConnection createStripeConnection(@NonNull String url, @NonNull RequestOptions options) throws IOException {
        URL stripeURL = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)stripeURL.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(80000);
        conn.setUseCaches(false);
        if (this.urlNeedsHeaderData(url)) {
            for (Map.Entry<String, String> header : this.getHeaders(options).entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        if (this.urlNeedsPseudoCookie(url)) {
            this.attachPseudoCookie(conn, options);
        }
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(SSL_SOCKET_FACTORY);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAndForgetApiCall(@NonNull Map<String, Object> paramMap, @NonNull String url, @NonNull String method, @NonNull RequestOptions options, @Nullable LoggingResponseListener listener) {
        String originalDNSCacheTTL = null;
        boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        try {
            StripeResponse response = this.getStripeResponse(method, url, paramMap, options);
            if (listener != null) {
                listener.onLoggingResponse(response);
            }
        }
        catch (StripeException stripeException) {
            if (listener != null) {
                listener.onStripeException(stripeException);
            }
        }
        finally {
            if (allowedToSetTTL) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
    }

    @NonNull
    private List<Parameter> flattenParams(@Nullable Map<String, Object> params) throws InvalidRequestException {
        return this.flattenParamsMap(params, null);
    }

    @NonNull
    private List<Parameter> flattenParamsList(@NonNull List<?> params, @NonNull String keyPrefix) throws InvalidRequestException {
        LinkedList<Parameter> flatParams = new LinkedList<Parameter>();
        if (params.isEmpty()) {
            flatParams.add(new Parameter(keyPrefix, ""));
        } else {
            String newPrefix = String.format(Locale.ROOT, "%s[]", keyPrefix);
            for (Object param : params) {
                flatParams.addAll(this.flattenParamsValue(param, newPrefix));
            }
        }
        return flatParams;
    }

    @NonNull
    private List<Parameter> flattenParamsMap(@Nullable Map<String, Object> params, @Nullable String keyPrefix) throws InvalidRequestException {
        LinkedList<Parameter> flatParams = new LinkedList<Parameter>();
        if (params == null) {
            return flatParams;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String newPrefix = keyPrefix != null ? String.format(Locale.ROOT, "%s[%s]", keyPrefix, key) : key;
            flatParams.addAll(this.flattenParamsValue(value, newPrefix));
        }
        return flatParams;
    }

    @NonNull
    private List<Parameter> flattenParamsValue(@NonNull Object value, @Nullable String keyPrefix) throws InvalidRequestException {
        List<Parameter> flatParams;
        if (value instanceof Map) {
            flatParams = this.flattenParamsMap((Map)value, keyPrefix);
        } else if (value instanceof List) {
            flatParams = this.flattenParamsList((List)value, keyPrefix);
        } else {
            if ("".equals(value)) {
                throw new InvalidRequestException("You cannot set '" + keyPrefix + "' to an empty string. We interpret empty strings as null in requests. You may set '" + keyPrefix + "' to null to delete the property.", keyPrefix, null, 0, null, null, null, null);
            }
            if (value == null) {
                flatParams = new LinkedList<Parameter>();
                flatParams.add(new Parameter(keyPrefix, ""));
            } else {
                flatParams = new LinkedList<Parameter>();
                flatParams.add(new Parameter(keyPrefix, value.toString()));
            }
        }
        return flatParams;
    }

    @NonNull
    private String formatURL(@NonNull String url, @Nullable String query) {
        if (query == null || query.isEmpty()) {
            return url;
        }
        String separator = url.contains("?") ? "&" : "?";
        return String.format(Locale.ROOT, "%s%s%s", url, separator, query);
    }

    @NonNull
    private String getContentType(@NonNull RequestOptions options) {
        if ("json_data".equals(options.getRequestType())) {
            return String.format(Locale.ROOT, "application/json; charset=%s", CHARSET);
        }
        return String.format(Locale.ROOT, "application/x-www-form-urlencoded;charset=%s", CHARSET);
    }

    @NonNull
    private byte[] getOutputBytes(@Nullable Map<String, Object> params, @NonNull RequestOptions options) throws InvalidRequestException {
        try {
            if ("json_data".equals(options.getRequestType())) {
                JSONObject jsonData = this.mapToJsonObject(params);
                if (jsonData == null) {
                    throw new InvalidRequestException("Unable to create JSON data from parameters. Please contact support@stripe.com for assistance.", null, null, 0, null, null, null, null);
                }
                return jsonData.toString().getBytes(CHARSET);
            }
            return this.createQuery(params).getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@stripe.com for assistance.", null, null, 0, null, null, null, e);
        }
    }

    @Nullable
    private String getResponseBody(@NonNull InputStream responseStream) throws IOException {
        Scanner scanner = new Scanner(responseStream, CHARSET).useDelimiter("\\A");
        String rBody = scanner.hasNext() ? scanner.next() : null;
        responseStream.close();
        return rBody;
    }

    @NonNull
    private StripeResponse getStripeResponse(String method, @NonNull String url, @Nullable Map<String, Object> params, @NonNull RequestOptions options) throws InvalidRequestException, APIConnectionException {
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case "GET": {
                    conn = this.createGetConnection(url, this.createQuery(params), options);
                    break;
                }
                case "POST": {
                    conn = this.createPostConnection(url, params, options);
                    break;
                }
                case "DELETE": {
                    conn = this.createDeleteConnection(url, options);
                    break;
                }
                default: {
                    throw new APIConnectionException(String.format(Locale.ENGLISH, "Unrecognized HTTP method %s. This indicates a bug in the Stripe bindings. Please contact support@stripe.com for assistance.", method));
                }
            }
            int rCode = conn.getResponseCode();
            String rBody = rCode >= 200 && rCode < 300 ? this.getResponseBody(conn.getInputStream()) : this.getResponseBody(conn.getErrorStream());
            StripeResponse stripeResponse = new StripeResponse(rCode, rBody, conn.getHeaderFields());
            return stripeResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format(Locale.ENGLISH, "IOException during API request to Stripe (%s): %s Please check your internet connection and try again. If this problem persists, you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", this.getTokensUrl(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void handleAPIError(@Nullable String responseBody, int responseCode, @Nullable String requestId) throws InvalidRequestException, AuthenticationException, CardException, APIException {
        StripeError stripeError = ErrorParser.parseError(responseBody);
        switch (responseCode) {
            case 400: 
            case 404: {
                throw new InvalidRequestException(stripeError.message, stripeError.param, requestId, responseCode, stripeError.code, stripeError.declineCode, stripeError, null);
            }
            case 401: {
                throw new AuthenticationException(stripeError.message, requestId, (Integer)responseCode, stripeError);
            }
            case 402: {
                throw new CardException(stripeError.message, requestId, stripeError.code, stripeError.param, stripeError.declineCode, stripeError.charge, responseCode, stripeError);
            }
            case 403: {
                throw new PermissionException(stripeError.message, requestId, (Integer)responseCode, stripeError);
            }
            case 429: {
                throw new RateLimitException(stripeError.message, stripeError.param, requestId, (Integer)responseCode, stripeError);
            }
        }
        throw new APIException(stripeError.message, requestId, responseCode, stripeError, null);
    }

    @NonNull
    private StripeResponse requestData(String method, @NonNull String url, @NonNull Map<String, Object> params, @NonNull RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String originalDNSCacheTTL = null;
        boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        String apiKey = options.getPublishableApiKey();
        if (StripeTextUtils.isBlank(apiKey)) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'Stripe.apiKey = <API-KEY>'. You can generate API keys from the Stripe web interface. See https://stripe.com/api for details or email support@stripe.com if you have questions.", null, (Integer)0, null);
        }
        StripeResponse response = this.getStripeResponse(method, url, params, options);
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        Map<String, List<String>> headers = response.getResponseHeaders();
        List<String> requestIdList = headers == null ? null : headers.get("Request-Id");
        String requestId = requestIdList != null && requestIdList.size() > 0 ? requestIdList.get(0) : null;
        if (rCode < 200 || rCode >= 300) {
            this.handleAPIError(rBody, rCode, requestId);
        }
        if (allowedToSetTTL) {
            if (originalDNSCacheTTL == null) {
                Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
            } else {
                Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
            }
        }
        return response;
    }

    @Nullable
    private Token requestToken(String url, Map<String, Object> params, @NonNull RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        StripeResponse response = this.requestData(POST, url, params, options);
        return Token.fromString(response.getResponseBody());
    }

    private void setTelemetryData(@NonNull Context context, @Nullable LoggingResponseListener listener) {
        Map<String, Object> telemetry = TelemetryClientUtil.createTelemetryMap(context);
        StripeNetworkUtils.removeNullAndEmptyParams(telemetry);
        if (listener != null && !listener.shouldLogTest()) {
            return;
        }
        RequestOptions options = RequestOptions.builder(null, "json_data").setGuid(TelemetryClientUtil.getHashedId(context)).build();
        this.fireAndForgetApiCall(telemetry, LOGGING_ENDPOINT, POST, options, listener);
    }

    private boolean urlNeedsHeaderData(@NonNull String url) {
        return url.startsWith(LIVE_API_BASE) || url.startsWith(LIVE_LOGGING_BASE);
    }

    private boolean urlNeedsPseudoCookie(@NonNull String url) {
        return url.startsWith(LOGGING_ENDPOINT);
    }

    @NonNull
    private String urlEncodePair(@NonNull String k, @NonNull String v) throws UnsupportedEncodingException {
        return String.format(Locale.ROOT, "%s=%s", this.urlEncode(k), this.urlEncode(v));
    }

    @Nullable
    private String urlEncode(@Nullable String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET);
    }

    private final class Parameter {
        @NonNull
        private final String key;
        @NonNull
        private final String value;

        Parameter(@NonNull String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    static interface StripeResponseListener {
        public void onStripeResponse(@NonNull StripeResponse var1);
    }

    static interface LoggingResponseListener {
        public boolean shouldLogTest();

        public void onLoggingResponse(StripeResponse var1);

        public void onStripeException(StripeException var1);
    }
}

