/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.Card;
import com.stripe.android.model.Source;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class SourceParams {
    private static final String API_PARAM_AMOUNT = "amount";
    private static final String API_PARAM_CURRENCY = "currency";
    private static final String API_PARAM_METADATA = "metadata";
    private static final String API_PARAM_OWNER = "owner";
    private static final String API_PARAM_REDIRECT = "redirect";
    private static final String API_PARAM_TYPE = "type";
    private static final String API_PARAM_TOKEN = "token";
    private static final String API_PARAM_USAGE = "usage";
    private static final String API_PARAM_CLIENT_SECRET = "client_secret";
    private static final String FIELD_ADDRESS = "address";
    private static final String FIELD_BANK = "bank";
    private static final String FIELD_CARD = "card";
    private static final String FIELD_CITY = "city";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_CVC = "cvc";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_EXP_MONTH = "exp_month";
    private static final String FIELD_EXP_YEAR = "exp_year";
    private static final String FIELD_IBAN = "iban";
    private static final String FIELD_LINE_1 = "line1";
    private static final String FIELD_LINE_2 = "line2";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_POSTAL_CODE = "postal_code";
    private static final String FIELD_RETURN_URL = "return_url";
    private static final String FIELD_STATE = "state";
    private static final String FIELD_STATEMENT_DESCRIPTOR = "statement_descriptor";
    private static final String FIELD_PREFERRED_LANGUAGE = "preferred_language";
    private static final String VISA_CHECKOUT = "visa_checkout";
    private static final String CALL_ID = "callid";
    private static final String MASTERPASS = "masterpass";
    private static final String TRANSACTION_ID = "transaction_id";
    private static final String CART_ID = "cart_id";
    @IntRange(from=0L)
    private Long mAmount;
    private Map<String, Object> mApiParameterMap;
    private String mCurrency;
    @Nullable
    private String mTypeRaw;
    private Map<String, Object> mOwner;
    private Map<String, String> mMetaData;
    private Map<String, Object> mRedirect;
    private Map<String, Object> mExtraParams;
    private String mToken;
    @Nullable
    private String mUsage;
    private String mType;

    private SourceParams() {
    }

    @NonNull
    public static SourceParams createP24Params(@IntRange(from=0L) long amount, @NonNull String currency, @Nullable String name, @NonNull String email, @NonNull String returnUrl) {
        SourceParams params = new SourceParams().setAmount(amount).setType("p24").setCurrency(currency).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        HashMap<String, Object> ownerMap = new HashMap<String, Object>();
        ((AbstractMap)ownerMap).put(FIELD_NAME, name);
        ((AbstractMap)ownerMap).put(FIELD_EMAIL, email);
        StripeNetworkUtils.removeNullAndEmptyParams(ownerMap);
        if (((AbstractMap)ownerMap).keySet().size() > 0) {
            params.setOwner(ownerMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createAlipayReusableParams(@NonNull String currency, @Nullable String name, @Nullable String email, @NonNull String returnUrl) {
        SourceParams params = new SourceParams().setType("alipay").setCurrency(currency).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl)).setUsage("reusable");
        HashMap<String, Object> ownerMap = new HashMap<String, Object>();
        ((AbstractMap)ownerMap).put(FIELD_NAME, name);
        ((AbstractMap)ownerMap).put(FIELD_EMAIL, email);
        StripeNetworkUtils.removeNullAndEmptyParams(ownerMap);
        if (((AbstractMap)ownerMap).keySet().size() > 0) {
            params.setOwner(ownerMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createAlipaySingleUseParams(@IntRange(from=0L) long amount, @NonNull String currency, @Nullable String name, @Nullable String email, @NonNull String returnUrl) {
        SourceParams params = new SourceParams().setType("alipay").setCurrency(currency).setAmount(amount).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        HashMap<String, Object> ownerMap = new HashMap<String, Object>();
        ((AbstractMap)ownerMap).put(FIELD_NAME, name);
        ((AbstractMap)ownerMap).put(FIELD_EMAIL, email);
        StripeNetworkUtils.removeNullAndEmptyParams(ownerMap);
        if (((AbstractMap)ownerMap).keySet().size() > 0) {
            params.setOwner(ownerMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createBancontactParams(@IntRange(from=0L) long amount, @NonNull String name, @NonNull String returnUrl, @Nullable String statementDescriptor, @Nullable String preferredLanguage) {
        SourceParams params = new SourceParams().setType("bancontact").setCurrency("eur").setAmount(amount).setOwner(SourceParams.createSimpleMap(FIELD_NAME, name)).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        if (statementDescriptor != null || preferredLanguage != null) {
            HashMap<String, Object> additionalParamsMap = new HashMap<String, Object>();
            ((AbstractMap)additionalParamsMap).put(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
            ((AbstractMap)additionalParamsMap).put(FIELD_PREFERRED_LANGUAGE, preferredLanguage);
            StripeNetworkUtils.removeNullAndEmptyParams(additionalParamsMap);
            params.setApiParameterMap(additionalParamsMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createCustomParams() {
        return new SourceParams();
    }

    @NonNull
    public static SourceParams createSourceFromTokenParams(String tokenId) {
        SourceParams sourceParams = SourceParams.createCustomParams();
        sourceParams.setType(FIELD_CARD);
        sourceParams.setToken(tokenId);
        return sourceParams;
    }

    @NonNull
    public static SourceParams createCardParams(@NonNull Card card) {
        Map<String, String> metadata;
        SourceParams params = new SourceParams().setType(FIELD_CARD);
        HashMap<String, Object> basicInfoMap = new HashMap<String, Object>();
        ((AbstractMap)basicInfoMap).put(FIELD_NUMBER, card.getNumber());
        ((AbstractMap)basicInfoMap).put(FIELD_EXP_MONTH, card.getExpMonth());
        ((AbstractMap)basicInfoMap).put(FIELD_EXP_YEAR, card.getExpYear());
        ((AbstractMap)basicInfoMap).put(FIELD_CVC, card.getCVC());
        StripeNetworkUtils.removeNullAndEmptyParams(basicInfoMap);
        params.setApiParameterMap(basicInfoMap);
        HashMap<String, Object> addressMap = new HashMap<String, Object>();
        addressMap.put(FIELD_LINE_1, card.getAddressLine1());
        addressMap.put(FIELD_LINE_2, card.getAddressLine2());
        addressMap.put(FIELD_CITY, card.getAddressCity());
        addressMap.put(FIELD_COUNTRY, card.getAddressCountry());
        addressMap.put(FIELD_STATE, card.getAddressState());
        addressMap.put(FIELD_POSTAL_CODE, card.getAddressZip());
        StripeNetworkUtils.removeNullAndEmptyParams(addressMap);
        HashMap<String, Object> ownerMap = new HashMap<String, Object>();
        ownerMap.put(FIELD_NAME, card.getName());
        if (addressMap.keySet().size() > 0) {
            ownerMap.put(FIELD_ADDRESS, addressMap);
        }
        StripeNetworkUtils.removeNullAndEmptyParams(ownerMap);
        if (ownerMap.keySet().size() > 0) {
            params.setOwner(ownerMap);
        }
        if ((metadata = card.getMetadata()) != null) {
            params.setMetaData(metadata);
        }
        return params;
    }

    @NonNull
    public static SourceParams createEPSParams(@IntRange(from=0L) long amount, @NonNull String name, @NonNull String returnUrl, @Nullable String statementDescriptor) {
        SourceParams params = new SourceParams().setType("eps").setCurrency("eur").setAmount(amount).setOwner(SourceParams.createSimpleMap(FIELD_NAME, name)).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        if (statementDescriptor != null) {
            Map<String, Object> additionalParamsMap = SourceParams.createSimpleMap(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
            params.setApiParameterMap(additionalParamsMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createGiropayParams(@IntRange(from=0L) long amount, @NonNull String name, @NonNull String returnUrl, @Nullable String statementDescriptor) {
        SourceParams params = new SourceParams().setType("giropay").setCurrency("eur").setAmount(amount).setOwner(SourceParams.createSimpleMap(FIELD_NAME, name)).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        if (statementDescriptor != null) {
            Map<String, Object> additionalParamsMap = SourceParams.createSimpleMap(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
            params.setApiParameterMap(additionalParamsMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createIdealParams(@IntRange(from=0L) long amount, @Nullable String name, @NonNull String returnUrl, @Nullable String statementDescriptor, @Nullable String bank) {
        SourceParams params = new SourceParams().setType("ideal").setCurrency("eur").setAmount(amount).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        if (name != null) {
            params.setOwner(SourceParams.createSimpleMap(FIELD_NAME, name));
        }
        HashMap<String, Object> additionalParamsMap = new HashMap<String, Object>();
        if (statementDescriptor != null) {
            additionalParamsMap.put(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
        }
        if (bank != null) {
            additionalParamsMap.put(FIELD_BANK, bank);
        }
        if (!additionalParamsMap.isEmpty()) {
            params.setApiParameterMap(additionalParamsMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createMultibancoParams(@IntRange(from=0L) long amount, @NonNull String returnUrl, @NonNull String email) {
        return new SourceParams().setType("multibanco").setCurrency("eur").setAmount(amount).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl)).setOwner(SourceParams.createSimpleMap(FIELD_EMAIL, email));
    }

    @NonNull
    public static SourceParams createSepaDebitParams(@NonNull String name, @NonNull String iban, @Nullable String addressLine1, @NonNull String city, @NonNull String postalCode, @NonNull @Size(value=2L) String country) {
        return SourceParams.createSepaDebitParams(name, iban, null, addressLine1, city, postalCode, country);
    }

    @NonNull
    public static SourceParams createSepaDebitParams(@NonNull String name, @NonNull String iban, @Nullable String email, @Nullable String addressLine1, @Nullable String city, @Nullable String postalCode, @Nullable @Size(value=2L) String country) {
        SourceParams params = new SourceParams().setType("sepa_debit").setCurrency("eur");
        HashMap<String, String> address = new HashMap<String, String>();
        ((AbstractMap)address).put(FIELD_LINE_1, addressLine1);
        ((AbstractMap)address).put(FIELD_CITY, city);
        ((AbstractMap)address).put(FIELD_POSTAL_CODE, postalCode);
        ((AbstractMap)address).put(FIELD_COUNTRY, country);
        HashMap<String, Object> ownerMap = new HashMap<String, Object>();
        ((AbstractMap)ownerMap).put(FIELD_NAME, name);
        ((AbstractMap)ownerMap).put(FIELD_EMAIL, email);
        ((AbstractMap)ownerMap).put(FIELD_ADDRESS, address);
        return params.setOwner(ownerMap).setApiParameterMap(SourceParams.createSimpleMap(FIELD_IBAN, iban));
    }

    @NonNull
    public static SourceParams createSofortParams(@IntRange(from=0L) long amount, @NonNull String returnUrl, @NonNull @Size(value=2L) String country, @Nullable String statementDescriptor) {
        SourceParams params = new SourceParams().setType("sofort").setCurrency("eur").setAmount(amount).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        Map<String, Object> sofortMap = SourceParams.createSimpleMap(FIELD_COUNTRY, country);
        if (statementDescriptor != null) {
            sofortMap.put(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
        }
        params.setApiParameterMap(sofortMap);
        return params;
    }

    @NonNull
    public static SourceParams createThreeDSecureParams(@IntRange(from=0L) long amount, @NonNull String currency, @NonNull String returnUrl, @NonNull String cardID) {
        SourceParams params = new SourceParams().setType("three_d_secure").setCurrency(currency).setAmount(amount).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        params.setApiParameterMap(SourceParams.createSimpleMap(FIELD_CARD, cardID));
        return params;
    }

    @NonNull
    public static SourceParams createVisaCheckoutParams(@NonNull String callId) {
        return new SourceParams().setType(FIELD_CARD).setApiParameterMap(SourceParams.createSimpleMap(VISA_CHECKOUT, SourceParams.createSimpleMap(CALL_ID, callId)));
    }

    @NonNull
    public static SourceParams createMasterpassParams(@NonNull String transactionId, @NonNull String cartID) {
        Map<String, Object> map = SourceParams.createSimpleMap(TRANSACTION_ID, transactionId);
        map.put(CART_ID, cartID);
        return new SourceParams().setType(FIELD_CARD).setApiParameterMap(SourceParams.createSimpleMap(MASTERPASS, map));
    }

    @NonNull
    public static Map<String, Object> createRetrieveSourceParams(@NonNull @Size(min=1L) String clientSecret) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(API_PARAM_CLIENT_SECRET, clientSecret);
        return params;
    }

    @Nullable
    public Long getAmount() {
        return this.mAmount;
    }

    @Nullable
    public Map<String, Object> getApiParameterMap() {
        return this.mApiParameterMap;
    }

    @Nullable
    public String getCurrency() {
        return this.mCurrency;
    }

    @Nullable
    public Map<String, Object> getOwner() {
        return this.mOwner;
    }

    @Nullable
    public Map<String, Object> getRedirect() {
        return this.mRedirect;
    }

    @NonNull
    public String getType() {
        return this.mType;
    }

    @Nullable
    public String getTypeRaw() {
        return this.mTypeRaw;
    }

    @Nullable
    public String getUsage() {
        return this.mUsage;
    }

    public Map<String, String> getMetaData() {
        return this.mMetaData;
    }

    public SourceParams setAmount(long amount) {
        this.mAmount = amount;
        return this;
    }

    public SourceParams setApiParameterMap(@NonNull Map<String, Object> apiParameterMap) {
        this.mApiParameterMap = apiParameterMap;
        return this;
    }

    public SourceParams setCurrency(String currency) {
        this.mCurrency = currency;
        return this;
    }

    public SourceParams setOwner(Map<String, Object> owner) {
        this.mOwner = owner;
        return this;
    }

    public SourceParams setRedirect(Map<String, Object> redirect) {
        this.mRedirect = redirect;
        return this;
    }

    public SourceParams setExtraParams(Map<String, Object> extraParams) {
        this.mExtraParams = extraParams;
        return this;
    }

    public SourceParams setReturnUrl(@NonNull @Size(min=1L) String returnUrl) {
        if (this.mRedirect == null) {
            this.setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        } else {
            this.mRedirect.put(FIELD_RETURN_URL, returnUrl);
        }
        return this;
    }

    public SourceParams setType(String type) {
        this.mType = type;
        this.mTypeRaw = type;
        return this;
    }

    public SourceParams setTypeRaw(@NonNull String typeRaw) {
        this.mType = Source.asSourceType(typeRaw);
        this.mTypeRaw = typeRaw;
        return this;
    }

    public SourceParams setMetaData(@NonNull Map<String, String> metaData) {
        this.mMetaData = metaData;
        return this;
    }

    public SourceParams setToken(@NonNull String token) {
        this.mToken = token;
        return this;
    }

    public SourceParams setUsage(@NonNull String usage) {
        this.mUsage = usage;
        return this;
    }

    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> networkReadyMap = new HashMap<String, Object>();
        ((AbstractMap)networkReadyMap).put(API_PARAM_TYPE, this.mTypeRaw);
        ((AbstractMap)networkReadyMap).put(this.mTypeRaw, this.mApiParameterMap);
        ((AbstractMap)networkReadyMap).put(API_PARAM_AMOUNT, this.mAmount);
        ((AbstractMap)networkReadyMap).put(API_PARAM_CURRENCY, this.mCurrency);
        ((AbstractMap)networkReadyMap).put(API_PARAM_OWNER, this.mOwner);
        ((AbstractMap)networkReadyMap).put(API_PARAM_REDIRECT, this.mRedirect);
        ((AbstractMap)networkReadyMap).put(API_PARAM_METADATA, this.mMetaData);
        ((AbstractMap)networkReadyMap).put(API_PARAM_TOKEN, this.mToken);
        ((AbstractMap)networkReadyMap).put(API_PARAM_USAGE, this.mUsage);
        if (this.mExtraParams != null) {
            ((AbstractMap)networkReadyMap).putAll(this.mExtraParams);
        }
        StripeNetworkUtils.removeNullAndEmptyParams(networkReadyMap);
        return networkReadyMap;
    }

    @NonNull
    private static Map<String, Object> createSimpleMap(@NonNull String key, @NonNull Object value) {
        HashMap<String, Object> simpleMap = new HashMap<String, Object>();
        simpleMap.put(key, value);
        return simpleMap;
    }

    @NonNull
    private static Map<String, Object> createSimpleMap(@NonNull String key1, @NonNull Object value1, @NonNull String key2, @NonNull Object value2) {
        HashMap<String, Object> simpleMap = new HashMap<String, Object>();
        simpleMap.put(key1, value1);
        simpleMap.put(key2, value2);
        return simpleMap;
    }
}

