/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.utils.ObjectUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class StripeSourceTypeModel
extends StripeJsonModel {
    @NonNull
    private final Map<String, Object> mAdditionalFields;
    private static final String NULL = "null";

    StripeSourceTypeModel(@NonNull BaseBuilder builder) {
        this.mAdditionalFields = builder.mAdditionalFields != null ? builder.mAdditionalFields : new HashMap();
    }

    @NonNull
    public Map<String, Object> getAdditionalFields() {
        return this.mAdditionalFields;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        return new HashMap<String, Object>(this.mAdditionalFields);
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeSourceTypeModel.putAdditionalFieldsIntoJsonObject(jsonObject, this.mAdditionalFields);
        return jsonObject;
    }

    @Nullable
    static Map<String, Object> jsonObjectToMapWithoutKeys(@Nullable JSONObject jsonObject, @Nullable Set<String> omitKeys) {
        if (jsonObject == null) {
            return null;
        }
        HashSet keysToOmit = omitKeys == null ? new HashSet() : omitKeys;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keyIterator = jsonObject.keys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object value = jsonObject.opt(key);
            if (NULL.equals(value) || value == null || keysToOmit.contains(key)) continue;
            map.put(key, value);
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    static void putAdditionalFieldsIntoJsonObject(@Nullable JSONObject jsonObject, @Nullable Map<String, Object> additionalFields) {
        if (jsonObject == null || additionalFields == null || additionalFields.isEmpty()) {
            return;
        }
        for (String key : additionalFields.keySet()) {
            try {
                if (additionalFields.get(key) == null) continue;
                jsonObject.put(key, additionalFields.get(key));
            }
            catch (JSONException jSONException) {}
        }
    }

    static void putAdditionalFieldsIntoMap(@Nullable Map<String, Object> map, @Nullable Map<String, Object> additionalFields) {
        if (map == null || additionalFields == null || additionalFields.isEmpty()) {
            return;
        }
        map.putAll(additionalFields);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof StripeSourceTypeModel && this.typedEquals((StripeSourceTypeModel)obj);
    }

    @CallSuper
    boolean typedEquals(@NonNull StripeSourceTypeModel model) {
        return ObjectUtils.equals(this.mAdditionalFields, model.mAdditionalFields);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mAdditionalFields);
    }

    static abstract class BaseBuilder {
        @Nullable
        private Map<String, Object> mAdditionalFields;

        BaseBuilder() {
        }

        @NonNull
        BaseBuilder setAdditionalFields(@NonNull Map<String, Object> additionalFields) {
            this.mAdditionalFields = additionalFields;
            return this;
        }
    }
}

