/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.utils.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceReceiver
extends StripeJsonModel {
    private static final String FIELD_ADDRESS = "address";
    private static final String FIELD_AMOUNT_CHARGED = "amount_charged";
    private static final String FIELD_AMOUNT_RECEIVED = "amount_received";
    private static final String FIELD_AMOUNT_RETURNED = "amount_returned";
    @Nullable
    private String mAddress;
    private long mAmountCharged;
    private long mAmountReceived;
    private long mAmountReturned;

    private SourceReceiver(@Nullable String address, long amountCharged, long amountReceived, long amountReturned) {
        this.mAddress = address;
        this.mAmountCharged = amountCharged;
        this.mAmountReceived = amountReceived;
        this.mAmountReturned = amountReturned;
    }

    @Nullable
    public String getAddress() {
        return this.mAddress;
    }

    public void setAddress(@Nullable String address) {
        this.mAddress = address;
    }

    public long getAmountCharged() {
        return this.mAmountCharged;
    }

    public void setAmountCharged(long amountCharged) {
        this.mAmountCharged = amountCharged;
    }

    public long getAmountReceived() {
        return this.mAmountReceived;
    }

    public void setAmountReceived(long amountReceived) {
        this.mAmountReceived = amountReceived;
    }

    public long getAmountReturned() {
        return this.mAmountReturned;
    }

    public void setAmountReturned(long amountReturned) {
        this.mAmountReturned = amountReturned;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!StripeTextUtils.isBlank(this.mAddress)) {
            map.put(FIELD_ADDRESS, this.mAddress);
        }
        map.put(FIELD_ADDRESS, this.mAddress);
        map.put(FIELD_AMOUNT_CHARGED, this.mAmountCharged);
        map.put(FIELD_AMOUNT_RECEIVED, this.mAmountReceived);
        map.put(FIELD_AMOUNT_RETURNED, this.mAmountReturned);
        return map;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_ADDRESS, this.mAddress);
        try {
            jsonObject.put(FIELD_AMOUNT_CHARGED, this.mAmountCharged);
            jsonObject.put(FIELD_AMOUNT_RECEIVED, this.mAmountReceived);
            jsonObject.put(FIELD_AMOUNT_RETURNED, this.mAmountReturned);
        }
        catch (JSONException jsonException) {
            return jsonObject;
        }
        return jsonObject;
    }

    @Nullable
    public static SourceReceiver fromString(@Nullable String jsonString) {
        try {
            return SourceReceiver.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static SourceReceiver fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return new SourceReceiver(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS), jsonObject.optLong(FIELD_AMOUNT_CHARGED), jsonObject.optLong(FIELD_AMOUNT_RECEIVED), jsonObject.optLong(FIELD_AMOUNT_RETURNED));
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SourceReceiver && this.typedEquals((SourceReceiver)obj);
    }

    private boolean typedEquals(@NonNull SourceReceiver sourceReceiver) {
        return ObjectUtils.equals(this.mAddress, sourceReceiver.mAddress) && this.mAmountCharged == sourceReceiver.mAmountCharged && this.mAmountReceived == sourceReceiver.mAmountReceived && this.mAmountReturned == sourceReceiver.mAmountReturned;
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mAddress, this.mAmountCharged, this.mAmountReceived, this.mAmountReturned);
    }
}

