/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.model.Address;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.wallets.Wallet;
import com.stripe.android.model.wallets.WalletFactory;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentMethod
extends StripeJsonModel {
    private static final String FIELD_ID = "id";
    private static final String FIELD_BILLING_DETAILS = "billing_details";
    private static final String FIELD_CARD = "card";
    private static final String FIELD_CARD_PRESENT = "card_present";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_CUSTOMER = "customer";
    private static final String FIELD_IDEAL = "ideal";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_METADATA = "metadata";
    private static final String FIELD_TYPE = "type";
    @Nullable
    public final String id;
    @Nullable
    public final Long created;
    public final boolean liveMode;
    @Nullable
    public final String type;
    @Nullable
    public final BillingDetails billingDetails;
    @Nullable
    public final Card card;
    @Nullable
    public final CardPresent cardPresent;
    @Nullable
    public final Ideal ideal;
    @Nullable
    public final String customerId;
    @Nullable
    public final Map<String, String> metadata;

    private PaymentMethod(@NonNull Builder builder) {
        this.id = builder.mId;
        this.liveMode = builder.mLiveMode;
        this.type = builder.mType;
        this.created = builder.mCreated;
        this.billingDetails = builder.mBillingDetails;
        this.customerId = builder.mCustomerId;
        this.card = builder.mCard;
        this.cardPresent = builder.mCardPresent;
        this.ideal = builder.mIdeal;
        this.metadata = builder.mMetadata;
    }

    public boolean isValid() {
        return this.type != null;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> paymentMethod = new HashMap<String, Object>();
        ((AbstractMap)paymentMethod).put(FIELD_ID, this.id);
        ((AbstractMap)paymentMethod).put(FIELD_CREATED, this.created);
        ((AbstractMap)paymentMethod).put(FIELD_CUSTOMER, this.customerId);
        ((AbstractMap)paymentMethod).put(FIELD_LIVEMODE, this.liveMode);
        ((AbstractMap)paymentMethod).put(FIELD_TYPE, this.type);
        ((AbstractMap)paymentMethod).put(FIELD_BILLING_DETAILS, this.billingDetails != null ? this.billingDetails.toMap() : null);
        ((AbstractMap)paymentMethod).put(FIELD_CARD, this.card != null ? this.card.toMap() : null);
        ((AbstractMap)paymentMethod).put(FIELD_CARD_PRESENT, this.cardPresent != null ? this.cardPresent.toMap() : null);
        ((AbstractMap)paymentMethod).put(FIELD_IDEAL, this.ideal != null ? this.ideal.toMap() : null);
        ((AbstractMap)paymentMethod).put(FIELD_METADATA, this.metadata);
        return paymentMethod;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject paymentMethod = new JSONObject();
        try {
            paymentMethod.put(FIELD_ID, (Object)this.id);
            paymentMethod.put(FIELD_CREATED, (Object)this.created);
            paymentMethod.put(FIELD_CUSTOMER, (Object)this.customerId);
            paymentMethod.put(FIELD_LIVEMODE, this.liveMode);
            paymentMethod.put(FIELD_METADATA, (Object)(this.metadata != null ? new JSONObject(this.metadata) : null));
            paymentMethod.put(FIELD_TYPE, (Object)this.type);
            paymentMethod.put(FIELD_BILLING_DETAILS, this.billingDetails != null ? this.billingDetails.toJson() : null);
            paymentMethod.put(FIELD_CARD, this.card != null ? this.card.toJson() : null);
            paymentMethod.put(FIELD_CARD_PRESENT, this.cardPresent != null ? this.cardPresent.toJson() : null);
            paymentMethod.put(FIELD_IDEAL, this.ideal != null ? this.ideal.toJson() : null);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return paymentMethod;
    }

    @Nullable
    public static PaymentMethod fromString(@Nullable String jsonString) {
        try {
            return PaymentMethod.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static PaymentMethod fromJson(@Nullable JSONObject paymentMethod) {
        if (paymentMethod == null) {
            return null;
        }
        String type = StripeJsonUtils.optString(paymentMethod, FIELD_TYPE);
        Builder builder = new Builder().setId(StripeJsonUtils.optString(paymentMethod, FIELD_ID)).setType(type).setCreated(StripeJsonUtils.optLong(paymentMethod, FIELD_CREATED)).setBillingDetails(BillingDetails.fromJson(paymentMethod.optJSONObject(FIELD_BILLING_DETAILS))).setCustomerId(StripeJsonUtils.optString(paymentMethod, FIELD_CUSTOMER)).setLiveMode(Boolean.TRUE.equals(paymentMethod.optBoolean(FIELD_LIVEMODE))).setMetadata(StripeJsonUtils.optHash(paymentMethod, FIELD_METADATA));
        if (FIELD_CARD.equals(type)) {
            builder.setCard(Card.fromJson(paymentMethod.optJSONObject(FIELD_CARD)));
        } else if (FIELD_CARD_PRESENT.equals(type)) {
            builder.setCardPresent(CardPresent.EMPTY);
        } else if (FIELD_IDEAL.equals(type)) {
            builder.setIdeal(Ideal.fromJson(paymentMethod.optJSONObject(FIELD_IDEAL)));
        }
        return builder.build();
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof PaymentMethod && this.typedEquals((PaymentMethod)obj);
    }

    private boolean typedEquals(@NonNull PaymentMethod paymentMethod) {
        return ObjectUtils.equals(this.id, paymentMethod.id) && ObjectUtils.equals(this.created, paymentMethod.created) && this.liveMode == paymentMethod.liveMode && ObjectUtils.equals(this.type, paymentMethod.type) && ObjectUtils.equals(this.billingDetails, paymentMethod.billingDetails) && ObjectUtils.equals(this.card, paymentMethod.card) && ObjectUtils.equals(this.cardPresent, paymentMethod.cardPresent) && ObjectUtils.equals(this.ideal, paymentMethod.ideal) && ObjectUtils.equals(this.customerId, paymentMethod.customerId);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.id, this.created, this.liveMode, this.type, this.billingDetails, this.card, this.cardPresent, this.ideal, this.customerId);
    }

    public static final class Ideal
    extends StripeJsonModel {
        private static final String FIELD_BANK = "bank";
        private static final String FIELD_BIC = "bic";
        @Nullable
        public final String bank;
        @Nullable
        public final String bankIdentifierCode;

        private Ideal(@NonNull Builder builder) {
            this.bank = builder.mBank;
            this.bankIdentifierCode = builder.mBankIdentifierCode;
        }

        @Override
        @NonNull
        public Map<String, Object> toMap() {
            HashMap<String, Object> ideal = new HashMap<String, Object>();
            ((AbstractMap)ideal).put(FIELD_BANK, this.bank);
            ((AbstractMap)ideal).put(FIELD_BIC, this.bankIdentifierCode);
            return ideal;
        }

        @Override
        @NonNull
        public JSONObject toJson() {
            JSONObject ideal = new JSONObject();
            try {
                ideal.put(FIELD_BANK, (Object)this.bank);
                ideal.put(FIELD_BIC, (Object)this.bankIdentifierCode);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return ideal;
        }

        @Nullable
        public static Ideal fromJson(@Nullable JSONObject ideal) {
            if (ideal == null) {
                return null;
            }
            return new Builder().setBank(StripeJsonUtils.optString(ideal, FIELD_BANK)).setBankIdentifierCode(StripeJsonUtils.optString(ideal, FIELD_BIC)).build();
        }

        public int hashCode() {
            return ObjectUtils.hash(this.bank, this.bankIdentifierCode);
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Ideal && this.typedEquals((Ideal)obj);
        }

        private boolean typedEquals(@NonNull Ideal obj) {
            return ObjectUtils.equals(this.bank, obj.bank) && ObjectUtils.equals(this.bankIdentifierCode, obj.bankIdentifierCode);
        }

        public static final class Builder {
            private String mBank;
            private String mBankIdentifierCode;

            @NonNull
            public Builder setBank(@Nullable String bank) {
                this.mBank = bank;
                return this;
            }

            @NonNull
            public Builder setBankIdentifierCode(@Nullable String bankIdentifierCode) {
                this.mBankIdentifierCode = bankIdentifierCode;
                return this;
            }

            @NonNull
            public Ideal build() {
                return new Ideal(this);
            }
        }
    }

    public static final class CardPresent
    extends StripeJsonModel {
        public static final CardPresent EMPTY = new CardPresent();

        private CardPresent() {
        }

        @Override
        @NonNull
        public Map<String, Object> toMap() {
            return new HashMap<String, Object>();
        }

        @Override
        @NonNull
        public JSONObject toJson() {
            return new JSONObject();
        }
    }

    public static final class Card
    extends StripeJsonModel {
        private static final String FIELD_BRAND = "brand";
        private static final String FIELD_CHECKS = "checks";
        private static final String FIELD_COUNTRY = "country";
        private static final String FIELD_EXP_MONTH = "exp_month";
        private static final String FIELD_EXP_YEAR = "exp_year";
        private static final String FIELD_FUNDING = "funding";
        private static final String FIELD_LAST4 = "last4";
        private static final String FIELD_THREE_D_SECURE_USAGE = "three_d_secure_usage";
        private static final String FIELD_WALLET = "wallet";
        @Nullable
        public final String brand;
        @Nullable
        public final Checks checks;
        @Nullable
        public final String country;
        @Nullable
        public final Integer expiryMonth;
        @Nullable
        public final Integer expiryYear;
        @Nullable
        public final String funding;
        @Nullable
        public final String last4;
        @Nullable
        public final ThreeDSecureUsage threeDSecureUsage;
        @Nullable
        public final Wallet wallet;

        private Card(@NonNull Builder builder) {
            this.brand = builder.mBrand;
            this.checks = builder.checks;
            this.country = builder.mCountry;
            this.expiryMonth = builder.mExpiryMonth;
            this.expiryYear = builder.mExpiryYear;
            this.funding = builder.mFunding;
            this.last4 = builder.mLast4;
            this.threeDSecureUsage = builder.mThreeDSecureUsage;
            this.wallet = builder.mWallet;
        }

        @Override
        @NonNull
        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ((AbstractMap)map).put(FIELD_BRAND, this.brand);
            ((AbstractMap)map).put(FIELD_CHECKS, this.checks != null ? this.checks.toMap() : null);
            ((AbstractMap)map).put(FIELD_COUNTRY, this.country);
            ((AbstractMap)map).put(FIELD_EXP_MONTH, this.expiryMonth);
            ((AbstractMap)map).put(FIELD_EXP_YEAR, this.expiryYear);
            ((AbstractMap)map).put(FIELD_FUNDING, this.funding);
            ((AbstractMap)map).put(FIELD_LAST4, this.last4);
            ((AbstractMap)map).put(FIELD_THREE_D_SECURE_USAGE, this.threeDSecureUsage != null ? this.threeDSecureUsage.toMap() : null);
            ((AbstractMap)map).put(FIELD_WALLET, this.wallet);
            return map;
        }

        @Override
        @NonNull
        public JSONObject toJson() {
            JSONObject json = new JSONObject();
            try {
                json.put(FIELD_BRAND, (Object)this.brand);
                json.put(FIELD_CHECKS, this.checks != null ? this.checks.toJson() : null);
                json.put(FIELD_COUNTRY, (Object)this.country);
                json.put(FIELD_EXP_MONTH, (Object)this.expiryMonth);
                json.put(FIELD_EXP_YEAR, (Object)this.expiryYear);
                json.put(FIELD_FUNDING, (Object)this.funding);
                json.put(FIELD_LAST4, (Object)this.last4);
                json.put(FIELD_THREE_D_SECURE_USAGE, this.threeDSecureUsage != null ? this.threeDSecureUsage.toJson() : null);
                json.put(FIELD_WALLET, (Object)this.wallet);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return json;
        }

        @Nullable
        public static Card fromJson(@Nullable JSONObject cardJson) {
            if (cardJson == null) {
                return null;
            }
            return new Builder().setBrand(StripeJsonUtils.optString(cardJson, FIELD_BRAND)).setChecks(Checks.fromJson(cardJson.optJSONObject(FIELD_CHECKS))).setCountry(StripeJsonUtils.optString(cardJson, FIELD_COUNTRY)).setExpiryMonth(StripeJsonUtils.optInteger(cardJson, FIELD_EXP_MONTH)).setExpiryYear(StripeJsonUtils.optInteger(cardJson, FIELD_EXP_YEAR)).setFunding(StripeJsonUtils.optString(cardJson, FIELD_FUNDING)).setLast4(StripeJsonUtils.optString(cardJson, FIELD_LAST4)).setThreeDSecureUsage(ThreeDSecureUsage.fromJson(cardJson.optJSONObject(FIELD_THREE_D_SECURE_USAGE))).setWallet(new WalletFactory().create(cardJson.optJSONObject(FIELD_WALLET))).build();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Card && this.typedEquals((Card)obj);
        }

        private boolean typedEquals(@NonNull Card card) {
            return ObjectUtils.equals(this.brand, card.brand) && ObjectUtils.equals(this.checks, card.checks) && ObjectUtils.equals(this.country, card.country) && ObjectUtils.equals(this.expiryMonth, card.expiryMonth) && ObjectUtils.equals(this.expiryYear, card.expiryYear) && ObjectUtils.equals(this.funding, card.funding) && ObjectUtils.equals(this.last4, card.last4) && ObjectUtils.equals(this.threeDSecureUsage, card.threeDSecureUsage) && ObjectUtils.equals(this.wallet, card.wallet);
        }

        public int hashCode() {
            return ObjectUtils.hash(this.brand, this.checks, this.country, this.expiryMonth, this.expiryYear, this.funding, this.last4, this.threeDSecureUsage, this.wallet);
        }

        public static final class ThreeDSecureUsage
        extends StripeJsonModel {
            private static final String FIELD_IS_SUPPORTED = "supported";
            public final boolean isSupported;

            private ThreeDSecureUsage(@NonNull Builder builder) {
                this.isSupported = builder.mIsSupported;
            }

            @Override
            @NonNull
            public Map<String, Object> toMap() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(FIELD_IS_SUPPORTED, this.isSupported);
                return map;
            }

            @Override
            @NonNull
            public JSONObject toJson() {
                JSONObject json = new JSONObject();
                try {
                    json.put(FIELD_IS_SUPPORTED, this.isSupported);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return json;
            }

            @Nullable
            public static ThreeDSecureUsage fromJson(@Nullable JSONObject threeDSecureUsage) {
                if (threeDSecureUsage == null) {
                    return null;
                }
                return new Builder().setSupported(Boolean.TRUE.equals(StripeJsonUtils.optBoolean(threeDSecureUsage, FIELD_IS_SUPPORTED))).build();
            }

            public int hashCode() {
                return ObjectUtils.hash(this.isSupported);
            }

            public boolean equals(@Nullable Object obj) {
                return this == obj || obj instanceof ThreeDSecureUsage && this.typedEquals((ThreeDSecureUsage)obj);
            }

            private boolean typedEquals(@NonNull ThreeDSecureUsage threeDSecureUsage) {
                return this.isSupported == threeDSecureUsage.isSupported;
            }

            public static final class Builder {
                private boolean mIsSupported;

                @NonNull
                public Builder setSupported(boolean supported) {
                    this.mIsSupported = supported;
                    return this;
                }

                @NonNull
                public ThreeDSecureUsage build() {
                    return new ThreeDSecureUsage(this);
                }
            }
        }

        public static final class Checks
        extends StripeJsonModel {
            private static final String FIELD_ADDRESS_LINE1_CHECK = "address_line1_check";
            private static final String FIELD_ADDRESS_POSTAL_CODE_CHECK = "address_postal_code_check";
            private static final String FIELD_CVC_CHECK = "cvc_check";
            @Nullable
            public final String addressLine1Check;
            @Nullable
            public final String addressPostalCodeCheck;
            @Nullable
            public final String cvcCheck;

            private Checks(@NonNull Builder builder) {
                this.addressLine1Check = builder.addressLine1Check;
                this.addressPostalCodeCheck = builder.addressPostalCodeCheck;
                this.cvcCheck = builder.cvcCheck;
            }

            @Override
            @NonNull
            public Map<String, Object> toMap() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                ((AbstractMap)map).put(FIELD_ADDRESS_LINE1_CHECK, this.addressLine1Check);
                ((AbstractMap)map).put(FIELD_ADDRESS_POSTAL_CODE_CHECK, this.addressPostalCodeCheck);
                ((AbstractMap)map).put(FIELD_CVC_CHECK, this.cvcCheck);
                return map;
            }

            @Override
            @NonNull
            public JSONObject toJson() {
                JSONObject json = new JSONObject();
                try {
                    json.put(FIELD_ADDRESS_LINE1_CHECK, (Object)this.addressLine1Check);
                    json.put(FIELD_ADDRESS_POSTAL_CODE_CHECK, (Object)this.addressPostalCodeCheck);
                    json.put(FIELD_CVC_CHECK, (Object)this.cvcCheck);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return json;
            }

            @Nullable
            public static Checks fromJson(@Nullable JSONObject checksJson) {
                if (checksJson == null) {
                    return null;
                }
                return new Builder().setAddressLine1Check(StripeJsonUtils.optString(checksJson, FIELD_ADDRESS_LINE1_CHECK)).setAddressPostalCodeCheck(StripeJsonUtils.optString(checksJson, FIELD_ADDRESS_POSTAL_CODE_CHECK)).setCvcCheck(StripeJsonUtils.optString(checksJson, FIELD_CVC_CHECK)).build();
            }

            public boolean equals(Object obj) {
                return this == obj || obj instanceof Checks && this.typedEquals((Checks)obj);
            }

            private boolean typedEquals(@NonNull Checks checks) {
                return ObjectUtils.equals(this.addressLine1Check, checks.addressLine1Check) && ObjectUtils.equals(this.addressPostalCodeCheck, checks.addressPostalCodeCheck) && ObjectUtils.equals(this.cvcCheck, checks.cvcCheck);
            }

            public int hashCode() {
                return ObjectUtils.hash(this.addressLine1Check, this.addressPostalCodeCheck, this.cvcCheck);
            }

            public static final class Builder {
                @Nullable
                private String addressLine1Check;
                @Nullable
                private String addressPostalCodeCheck;
                @Nullable
                private String cvcCheck;

                @NonNull
                public Builder setAddressLine1Check(@Nullable String addressLine1Check) {
                    this.addressLine1Check = addressLine1Check;
                    return this;
                }

                @NonNull
                public Builder setAddressPostalCodeCheck(@Nullable String addressPostalCodeCheck) {
                    this.addressPostalCodeCheck = addressPostalCodeCheck;
                    return this;
                }

                @NonNull
                public Builder setCvcCheck(@Nullable String cvcCheck) {
                    this.cvcCheck = cvcCheck;
                    return this;
                }

                @NonNull
                public Checks build() {
                    return new Checks(this);
                }
            }
        }

        public static final class Builder {
            private String mBrand;
            private Checks checks;
            private String mCountry;
            private Integer mExpiryMonth;
            private Integer mExpiryYear;
            private String mFunding;
            private String mLast4;
            private ThreeDSecureUsage mThreeDSecureUsage;
            private Wallet mWallet;

            @NonNull
            public Builder setBrand(@Nullable String brand) {
                this.mBrand = brand;
                return this;
            }

            @NonNull
            public Builder setChecks(@Nullable Checks checks) {
                this.checks = checks;
                return this;
            }

            @NonNull
            public Builder setCountry(@Nullable String country) {
                this.mCountry = country;
                return this;
            }

            @NonNull
            public Builder setExpiryMonth(@Nullable Integer expiryMonth) {
                this.mExpiryMonth = expiryMonth;
                return this;
            }

            @NonNull
            public Builder setExpiryYear(@Nullable Integer expiryYear) {
                this.mExpiryYear = expiryYear;
                return this;
            }

            @NonNull
            public Builder setFunding(@Nullable String funding) {
                this.mFunding = funding;
                return this;
            }

            @NonNull
            public Builder setLast4(@Nullable String last4) {
                this.mLast4 = last4;
                return this;
            }

            @NonNull
            public Builder setThreeDSecureUsage(@Nullable ThreeDSecureUsage threeDSecureUsage) {
                this.mThreeDSecureUsage = threeDSecureUsage;
                return this;
            }

            @NonNull
            public Builder setWallet(@Nullable Wallet wallet) {
                this.mWallet = wallet;
                return this;
            }

            @NonNull
            public Card build() {
                return new Card(this);
            }
        }
    }

    public static final class BillingDetails
    extends StripeJsonModel {
        private static final String FIELD_ADDRESS = "address";
        private static final String FIELD_EMAIL = "email";
        private static final String FIELD_NAME = "name";
        private static final String FIELD_PHONE = "phone";
        @NonNull
        public final Address address;
        public final String email;
        public final String name;
        public final String phone;

        private BillingDetails(@NonNull Builder builder) {
            this.address = builder.mAddress;
            this.email = builder.mEmail;
            this.name = builder.mName;
            this.phone = builder.mPhone;
        }

        @Override
        @NonNull
        public Map<String, Object> toMap() {
            HashMap<String, Object> billingDetails = new HashMap<String, Object>();
            billingDetails.put(FIELD_ADDRESS, this.address.toMap());
            billingDetails.put(FIELD_EMAIL, this.email);
            billingDetails.put(FIELD_NAME, this.name);
            billingDetails.put(FIELD_PHONE, this.phone);
            return billingDetails;
        }

        @Override
        @NonNull
        public JSONObject toJson() {
            JSONObject billingDetails = new JSONObject();
            try {
                billingDetails.put(FIELD_ADDRESS, (Object)this.address.toJson());
                billingDetails.put(FIELD_EMAIL, (Object)this.email);
                billingDetails.put(FIELD_NAME, (Object)this.name);
                billingDetails.put(FIELD_PHONE, (Object)this.phone);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return billingDetails;
        }

        @Nullable
        public static BillingDetails fromJson(@Nullable JSONObject billingDetails) {
            if (billingDetails == null) {
                return null;
            }
            return new Builder().setAddress(Address.fromJson(billingDetails.optJSONObject(FIELD_ADDRESS))).setEmail(StripeJsonUtils.optString(billingDetails, FIELD_EMAIL)).setName(StripeJsonUtils.optString(billingDetails, FIELD_NAME)).setPhone(StripeJsonUtils.optString(billingDetails, FIELD_PHONE)).build();
        }

        public int hashCode() {
            return ObjectUtils.hash(this.address, this.email, this.name, this.phone);
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof BillingDetails && this.typedEquals((BillingDetails)obj);
        }

        private boolean typedEquals(@NonNull BillingDetails obj) {
            return ObjectUtils.equals(this.address, obj.address) && ObjectUtils.equals(this.email, obj.email) && ObjectUtils.equals(this.name, obj.name) && ObjectUtils.equals(this.phone, obj.phone);
        }

        public static final class Builder {
            private Address mAddress;
            private String mEmail;
            private String mName;
            private String mPhone;

            @NonNull
            public Builder setAddress(@Nullable Address address) {
                this.mAddress = address;
                return this;
            }

            @NonNull
            public Builder setEmail(@Nullable String email) {
                this.mEmail = email;
                return this;
            }

            @NonNull
            public Builder setName(@Nullable String name) {
                this.mName = name;
                return this;
            }

            @NonNull
            public Builder setPhone(@Nullable String phone) {
                this.mPhone = phone;
                return this;
            }

            @NonNull
            public BillingDetails build() {
                return new BillingDetails(this);
            }
        }
    }

    public static final class Builder {
        private String mId;
        private Long mCreated;
        private boolean mLiveMode;
        private String mType;
        private BillingDetails mBillingDetails;
        private Map<String, String> mMetadata;
        private Card mCard;
        private CardPresent mCardPresent;
        private Ideal mIdeal;
        private String mCustomerId;

        @NonNull
        public Builder setId(@Nullable String id2) {
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setCreated(@Nullable Long created) {
            this.mCreated = created;
            return this;
        }

        @NonNull
        public Builder setLiveMode(boolean liveMode) {
            this.mLiveMode = liveMode;
            return this;
        }

        @NonNull
        public Builder setMetadata(@Nullable Map<String, String> metadata) {
            this.mMetadata = metadata;
            return this;
        }

        @NonNull
        public Builder setType(@Nullable String type) {
            this.mType = type;
            return this;
        }

        @NonNull
        public Builder setBillingDetails(@Nullable BillingDetails billingDetails) {
            this.mBillingDetails = billingDetails;
            return this;
        }

        @NonNull
        public Builder setCard(@Nullable Card card) {
            this.mCard = card;
            return this;
        }

        @NonNull
        public Builder setCardPresent(@Nullable CardPresent cardPresent) {
            this.mCardPresent = cardPresent;
            return this;
        }

        @NonNull
        public Builder setCustomerId(@Nullable String customerId) {
            this.mCustomerId = customerId;
            return this;
        }

        @NonNull
        public Builder setIdeal(@Nullable Ideal ideal) {
            this.mIdeal = ideal;
            return this;
        }

        @NonNull
        public PaymentMethod build() {
            return new PaymentMethod(this);
        }
    }
}

