/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.CustomerSource;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Customer
extends StripeJsonModel {
    private static final String FIELD_ID = "id";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_DEFAULT_SOURCE = "default_source";
    private static final String FIELD_SHIPPING = "shipping";
    private static final String FIELD_SOURCES = "sources";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_HAS_MORE = "has_more";
    private static final String FIELD_TOTAL_COUNT = "total_count";
    private static final String FIELD_URL = "url";
    private static final String VALUE_LIST = "list";
    private static final String VALUE_CUSTOMER = "customer";
    private static final String VALUE_APPLE_PAY = "apple_pay";
    @Nullable
    private final String mId;
    @Nullable
    private final String mDefaultSource;
    @Nullable
    private final ShippingInformation mShippingInformation;
    @NonNull
    private final List<CustomerSource> mSources;
    @Nullable
    private final Boolean mHasMore;
    @Nullable
    private final Integer mTotalCount;
    @Nullable
    private final String mUrl;

    private Customer(@Nullable String id2, @Nullable String defaultSource, @Nullable ShippingInformation shippingInformation, @NonNull List<CustomerSource> sources, @Nullable Boolean hasMore, @Nullable Integer totalCount, @Nullable String url) {
        this.mId = id2;
        this.mDefaultSource = defaultSource;
        this.mShippingInformation = shippingInformation;
        this.mSources = sources;
        this.mHasMore = hasMore;
        this.mTotalCount = totalCount;
        this.mUrl = url;
    }

    public String getId() {
        return this.mId;
    }

    public String getDefaultSource() {
        return this.mDefaultSource;
    }

    public ShippingInformation getShippingInformation() {
        return this.mShippingInformation;
    }

    @NonNull
    public List<CustomerSource> getSources() {
        return this.mSources;
    }

    public Boolean getHasMore() {
        return this.mHasMore;
    }

    public Integer getTotalCount() {
        return this.mTotalCount;
    }

    public String getUrl() {
        return this.mUrl;
    }

    @Nullable
    public CustomerSource getSourceById(@NonNull String sourceId) {
        for (CustomerSource source : this.mSources) {
            if (!sourceId.equals(source.getId())) continue;
            return source;
        }
        return null;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_ID, this.mId);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_OBJECT, VALUE_CUSTOMER);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_DEFAULT_SOURCE, this.mDefaultSource);
        StripeJsonModel.putStripeJsonModelIfNotNull(jsonObject, FIELD_SHIPPING, this.mShippingInformation);
        JSONObject sourcesObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(sourcesObject, FIELD_OBJECT, VALUE_LIST);
        StripeJsonUtils.putBooleanIfNotNull(sourcesObject, FIELD_HAS_MORE, this.mHasMore);
        StripeJsonUtils.putIntegerIfNotNull(sourcesObject, FIELD_TOTAL_COUNT, this.mTotalCount);
        Customer.putStripeJsonModelListIfNotNull(sourcesObject, FIELD_DATA, this.mSources);
        StripeJsonUtils.putStringIfNotNull(sourcesObject, FIELD_URL, this.mUrl);
        StripeJsonUtils.putObjectIfNotNull(jsonObject, FIELD_SOURCES, sourcesObject);
        return jsonObject;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ((AbstractMap)map).put(FIELD_ID, this.mId);
        ((AbstractMap)map).put(FIELD_OBJECT, VALUE_CUSTOMER);
        ((AbstractMap)map).put(FIELD_DEFAULT_SOURCE, this.mDefaultSource);
        StripeJsonModel.putStripeJsonModelMapIfNotNull(map, FIELD_SHIPPING, this.mShippingInformation);
        HashMap<String, Object> sourcesObject = new HashMap<String, Object>();
        ((AbstractMap)sourcesObject).put(FIELD_HAS_MORE, this.mHasMore);
        ((AbstractMap)sourcesObject).put(FIELD_TOTAL_COUNT, this.mTotalCount);
        ((AbstractMap)sourcesObject).put(FIELD_OBJECT, VALUE_LIST);
        ((AbstractMap)sourcesObject).put(FIELD_URL, this.mUrl);
        StripeJsonModel.putStripeJsonModelListIfNotNull(sourcesObject, FIELD_DATA, this.mSources);
        StripeNetworkUtils.removeNullAndEmptyParams(sourcesObject);
        ((AbstractMap)map).put(FIELD_SOURCES, sourcesObject);
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }

    @Nullable
    public static Customer fromString(@Nullable String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            return Customer.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static Customer fromJson(@NonNull JSONObject jsonObject) {
        String url;
        Integer totalCount;
        Boolean hasMore;
        String objectType = StripeJsonUtils.optString(jsonObject, FIELD_OBJECT);
        if (!VALUE_CUSTOMER.equals(objectType)) {
            return null;
        }
        String id2 = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        String defaultSource = StripeJsonUtils.optString(jsonObject, FIELD_DEFAULT_SOURCE);
        ShippingInformation shippingInformation = ShippingInformation.fromJson(jsonObject.optJSONObject(FIELD_SHIPPING));
        JSONObject sourcesJson = jsonObject.optJSONObject(FIELD_SOURCES);
        ArrayList<CustomerSource> sources = new ArrayList<CustomerSource>();
        if (sourcesJson != null && VALUE_LIST.equals(StripeJsonUtils.optString(sourcesJson, FIELD_OBJECT))) {
            hasMore = StripeJsonUtils.optBoolean(sourcesJson, FIELD_HAS_MORE);
            totalCount = StripeJsonUtils.optInteger(sourcesJson, FIELD_TOTAL_COUNT);
            url = StripeJsonUtils.optString(sourcesJson, FIELD_URL);
            JSONArray dataArray = sourcesJson.optJSONArray(FIELD_DATA);
            for (int i = 0; i < dataArray.length(); ++i) {
                try {
                    JSONObject customerSourceObject = dataArray.getJSONObject(i);
                    CustomerSource sourceData = CustomerSource.fromJson(customerSourceObject);
                    if (sourceData == null || VALUE_APPLE_PAY.equals(sourceData.getTokenizationMethod())) continue;
                    sources.add(sourceData);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        } else {
            hasMore = null;
            totalCount = null;
            url = null;
        }
        return new Customer(id2, defaultSource, shippingInformation, sources, hasMore, totalCount, url);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Customer && this.typedEquals((Customer)obj);
    }

    private boolean typedEquals(@NonNull Customer customer) {
        return ObjectUtils.equals(this.mId, customer.mId) && ObjectUtils.equals(this.mDefaultSource, customer.mDefaultSource) && ObjectUtils.equals(this.mShippingInformation, customer.mShippingInformation) && ObjectUtils.equals(this.mSources, customer.mSources) && ObjectUtils.equals(this.mHasMore, customer.mHasMore) && ObjectUtils.equals(this.mTotalCount, customer.mTotalCount) && ObjectUtils.equals(this.mUrl, customer.mUrl);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mId, this.mDefaultSource, this.mShippingInformation, this.mSources, this.mHasMore, this.mTotalCount, this.mUrl);
    }
}

