/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentCompletionProvider;
import com.stripe.android.PaymentResultListener;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.PaymentSessionData;
import com.stripe.android.StripeError;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.model.Customer;
import com.stripe.android.view.PaymentFlowActivity;
import com.stripe.android.view.PaymentMethodsActivity;

public class PaymentSession {
    public static final String TOKEN_PAYMENT_SESSION = "PaymentSession";
    public static final String EXTRA_PAYMENT_SESSION_ACTIVE = "payment_session_active";
    static final int PAYMENT_SHIPPING_DETAILS_REQUEST = 3004;
    static final int PAYMENT_METHOD_REQUEST = 3003;
    public static final String PAYMENT_SESSION_DATA_KEY = "payment_session_data";
    public static final String PAYMENT_SESSION_CONFIG = "payment_session_config";
    @NonNull
    private Activity mHostActivity;
    @NonNull
    private PaymentSessionData mPaymentSessionData;
    @Nullable
    private PaymentSessionListener mPaymentSessionListener;
    @NonNull
    private PaymentSessionConfig mPaymentSessionConfig;

    public PaymentSession(@NonNull Activity hostActivity) {
        this.mHostActivity = hostActivity;
        this.mPaymentSessionData = new PaymentSessionData();
    }

    public void completePayment(@NonNull PaymentCompletionProvider provider) {
        provider.completePayment(this.mPaymentSessionData, new PaymentResultListener(){

            @Override
            public void onPaymentResult(@NonNull String paymentResult) {
                PaymentSession.this.mPaymentSessionData.setPaymentResult(paymentResult);
                CustomerSession.getInstance().resetUsageTokens();
                if (PaymentSession.this.mPaymentSessionListener != null) {
                    PaymentSession.this.mPaymentSessionListener.onPaymentSessionDataChanged(PaymentSession.this.mPaymentSessionData);
                }
            }
        });
    }

    public boolean handlePaymentData(int requestCode, int resultCode, @NonNull Intent data) {
        if (resultCode == 0) {
            this.fetchCustomer();
            return false;
        }
        if (resultCode == -1) {
            switch (requestCode) {
                case 3003: {
                    this.fetchCustomer();
                    return true;
                }
                case 3004: {
                    PaymentSessionData paymentSessionData = (PaymentSessionData)data.getParcelableExtra(PAYMENT_SESSION_DATA_KEY);
                    this.updateIsPaymentReadyToCharge(this.mPaymentSessionConfig, paymentSessionData);
                    this.mPaymentSessionData = paymentSessionData;
                    this.mPaymentSessionListener.onPaymentSessionDataChanged(paymentSessionData);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean updateIsPaymentReadyToCharge(PaymentSessionConfig paymentSessionConfig, PaymentSessionData paymentSessionData) {
        if (StripeTextUtils.isBlank(paymentSessionData.getSelectedPaymentMethodId()) || paymentSessionConfig.isShippingInfoRequired() && paymentSessionData.getShippingInformation() == null || paymentSessionConfig.isShippingMethodRequired() && paymentSessionData.getShippingMethod() == null) {
            paymentSessionData.setPaymentReadyToCharge(false);
            return false;
        }
        paymentSessionData.setPaymentReadyToCharge(true);
        return true;
    }

    public boolean init(@NonNull PaymentSessionListener listener, @NonNull PaymentSessionConfig paymentSessionConfig) {
        return this.init(listener, paymentSessionConfig, null);
    }

    public boolean init(@NonNull PaymentSessionListener listener, @NonNull PaymentSessionConfig paymentSessionConfig, @Nullable Bundle savedInstanceState) {
        PaymentSessionData data;
        try {
            if (savedInstanceState == null) {
                CustomerSession.getInstance().resetUsageTokens();
            }
            CustomerSession.getInstance().addProductUsageTokenIfValid(TOKEN_PAYMENT_SESSION);
        }
        catch (IllegalStateException illegalState) {
            this.mPaymentSessionListener = null;
            return false;
        }
        this.mPaymentSessionListener = listener;
        if (savedInstanceState != null && (data = (PaymentSessionData)savedInstanceState.getParcelable(PAYMENT_SESSION_DATA_KEY)) != null) {
            this.mPaymentSessionData = data;
        }
        this.mPaymentSessionConfig = paymentSessionConfig;
        this.fetchCustomer();
        return true;
    }

    public void presentPaymentMethodSelection() {
        Intent paymentMethodsIntent = PaymentMethodsActivity.newIntent((Context)this.mHostActivity);
        paymentMethodsIntent.putExtra(EXTRA_PAYMENT_SESSION_ACTIVE, true);
        this.mHostActivity.startActivityForResult(paymentMethodsIntent, 3003);
    }

    public void savePaymentSessionInstanceState(@NonNull Bundle outState) {
        outState.putParcelable(PAYMENT_SESSION_DATA_KEY, (Parcelable)this.mPaymentSessionData);
    }

    public void setCartTotal(@IntRange(from=0L) long cartTotal) {
        this.mPaymentSessionData.setCartTotal(cartTotal);
    }

    public void presentShippingFlow() {
        Intent intent = new Intent((Context)this.mHostActivity, PaymentFlowActivity.class);
        intent.putExtra(PAYMENT_SESSION_CONFIG, (Parcelable)this.mPaymentSessionConfig);
        intent.putExtra(PAYMENT_SESSION_DATA_KEY, (Parcelable)this.mPaymentSessionData);
        intent.putExtra(EXTRA_PAYMENT_SESSION_ACTIVE, true);
        this.mHostActivity.startActivityForResult(intent, 3004);
    }

    public PaymentSessionData getPaymentSessionData() {
        return this.mPaymentSessionData;
    }

    public void onDestroy() {
        this.mPaymentSessionListener = null;
    }

    private void fetchCustomer() {
        if (this.mPaymentSessionListener != null) {
            this.mPaymentSessionListener.onCommunicatingStateChanged(true);
        }
        CustomerSession.getInstance().retrieveCurrentCustomer(new CustomerSession.CustomerRetrievalListener(){

            @Override
            public void onCustomerRetrieved(@NonNull Customer customer) {
                String paymentId = customer.getDefaultSource();
                PaymentSession.this.mPaymentSessionData.setSelectedPaymentMethodId(paymentId);
                PaymentSession.this.updateIsPaymentReadyToCharge(PaymentSession.this.mPaymentSessionConfig, PaymentSession.this.mPaymentSessionData);
                if (PaymentSession.this.mPaymentSessionListener != null) {
                    PaymentSession.this.mPaymentSessionListener.onPaymentSessionDataChanged(PaymentSession.this.mPaymentSessionData);
                    PaymentSession.this.mPaymentSessionListener.onCommunicatingStateChanged(false);
                }
            }

            @Override
            public void onError(int httpCode, @Nullable String errorMessage, @Nullable StripeError stripeError) {
                if (PaymentSession.this.mPaymentSessionListener != null) {
                    PaymentSession.this.mPaymentSessionListener.onError(httpCode, errorMessage);
                    PaymentSession.this.mPaymentSessionListener.onCommunicatingStateChanged(false);
                }
            }
        });
    }

    public static interface PaymentSessionListener {
        public void onCommunicatingStateChanged(boolean var1);

        public void onError(int var1, @Nullable String var2);

        public void onPaymentSessionDataChanged(@NonNull PaymentSessionData var1);
    }
}

