/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.utils.ObjectUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class AbstractEphemeralKey
extends StripeJsonModel
implements Parcelable {
    static final String FIELD_CREATED = "created";
    static final String FIELD_EXPIRES = "expires";
    static final String FIELD_SECRET = "secret";
    static final String FIELD_LIVEMODE = "livemode";
    static final String FIELD_OBJECT = "object";
    static final String FIELD_ID = "id";
    static final String FIELD_ASSOCIATED_OBJECTS = "associated_objects";
    static final String FIELD_TYPE = "type";
    static final String NULL = "null";
    @NonNull
    final String mObjectId;
    private final long mCreated;
    private final long mExpires;
    @NonNull
    private final String mId;
    private final boolean mLiveMode;
    @NonNull
    private final String mObject;
    @NonNull
    private final String mSecret;
    @NonNull
    private final String mType;

    AbstractEphemeralKey(@NonNull Parcel in) {
        this.mCreated = in.readLong();
        this.mObjectId = in.readString();
        this.mExpires = in.readLong();
        this.mId = in.readString();
        this.mLiveMode = in.readInt() == 1;
        this.mObject = in.readString();
        this.mSecret = in.readString();
        this.mType = in.readString();
    }

    AbstractEphemeralKey(long created, @NonNull String objectId, long expires, @NonNull String id, boolean liveMode, @NonNull String object, @NonNull String secret, @NonNull String type) {
        this.mCreated = created;
        this.mObjectId = objectId;
        this.mExpires = expires;
        this.mId = id;
        this.mLiveMode = liveMode;
        this.mObject = object;
        this.mSecret = secret;
        this.mType = type;
    }

    AbstractEphemeralKey(@Nullable JSONObject jsonObject) throws JSONException {
        this.mCreated = jsonObject.getLong(FIELD_CREATED);
        this.mExpires = jsonObject.getLong(FIELD_EXPIRES);
        this.mId = jsonObject.getString(FIELD_ID);
        this.mLiveMode = jsonObject.getBoolean(FIELD_LIVEMODE);
        this.mObject = jsonObject.getString(FIELD_OBJECT);
        this.mSecret = jsonObject.getString(FIELD_SECRET);
        JSONArray associatedObjectArray = jsonObject.getJSONArray(FIELD_ASSOCIATED_OBJECTS);
        JSONObject typeObject = associatedObjectArray.getJSONObject(0);
        this.mType = typeObject.getString(FIELD_TYPE);
        this.mObjectId = typeObject.getString(FIELD_ID);
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONArray associatedObjectsArray = new JSONArray();
        JSONObject associatedObject = new JSONObject();
        try {
            jsonObject.put(FIELD_CREATED, this.mCreated);
            jsonObject.put(FIELD_EXPIRES, this.mExpires);
            jsonObject.put(FIELD_OBJECT, (Object)this.mObject);
            jsonObject.put(FIELD_ID, (Object)this.mId);
            jsonObject.put(FIELD_SECRET, (Object)this.mSecret);
            jsonObject.put(FIELD_LIVEMODE, this.mLiveMode);
            associatedObject.put(FIELD_TYPE, (Object)this.mType);
            associatedObject.put(FIELD_ID, (Object)this.mObjectId);
            associatedObjectsArray.put((Object)associatedObject);
            jsonObject.put(FIELD_ASSOCIATED_OBJECTS, (Object)associatedObjectsArray);
        }
        catch (JSONException impossible) {
            throw new IllegalArgumentException("JSONObject creation exception thrown.");
        }
        return jsonObject;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ((AbstractMap)map).put(FIELD_CREATED, this.mCreated);
        ((AbstractMap)map).put(FIELD_EXPIRES, this.mExpires);
        ((AbstractMap)map).put(FIELD_OBJECT, this.mObject);
        ((AbstractMap)map).put(FIELD_ID, this.mId);
        ((AbstractMap)map).put(FIELD_SECRET, this.mSecret);
        ((AbstractMap)map).put(FIELD_LIVEMODE, this.mLiveMode);
        ArrayList associatedObjectsList = new ArrayList();
        HashMap<String, String> associatedObjectMap = new HashMap<String, String>();
        associatedObjectMap.put(FIELD_ID, this.mObjectId);
        associatedObjectMap.put(FIELD_TYPE, this.mType);
        associatedObjectsList.add(associatedObjectMap);
        ((AbstractMap)map).put(FIELD_ASSOCIATED_OBJECTS, associatedObjectsList);
        return map;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mCreated);
        out.writeString(this.mObjectId);
        out.writeLong(this.mExpires);
        out.writeString(this.mId);
        out.writeInt(this.mLiveMode ? 1 : 0);
        out.writeString(this.mObject);
        out.writeString(this.mSecret);
        out.writeString(this.mType);
    }

    long getCreated() {
        return this.mCreated;
    }

    long getExpires() {
        return this.mExpires;
    }

    @NonNull
    String getId() {
        return this.mId;
    }

    boolean isLiveMode() {
        return this.mLiveMode;
    }

    @NonNull
    String getObject() {
        return this.mObject;
    }

    @NonNull
    String getSecret() {
        return this.mSecret;
    }

    @NonNull
    String getType() {
        return this.mType;
    }

    @Nullable
    protected static <TEphemeralKey extends AbstractEphemeralKey> TEphemeralKey fromString(@Nullable String rawJson, Class ephemeralKeyClass) throws JSONException {
        if (rawJson == null) {
            throw new IllegalArgumentException("Attempted to instantiate " + ephemeralKeyClass.getSimpleName() + " with null raw key");
        }
        JSONObject object = new JSONObject(rawJson);
        return AbstractEphemeralKey.fromJson(object, ephemeralKeyClass);
    }

    @NonNull
    protected static <TEphemeralKey extends AbstractEphemeralKey> TEphemeralKey fromJson(@Nullable JSONObject jsonObject, Class ephemeralKeyClass) {
        if (jsonObject == null) {
            throw new IllegalArgumentException("Exception instantiating " + ephemeralKeyClass.getSimpleName() + " null JSON");
        }
        try {
            return (TEphemeralKey)((AbstractEphemeralKey)ephemeralKeyClass.getConstructor(JSONObject.class).newInstance(jsonObject));
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Exception instantiating " + ephemeralKeyClass.getSimpleName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Exception instantiating " + ephemeralKeyClass.getSimpleName(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                throw new IllegalArgumentException("Improperly formatted JSON for ephemeral key " + ephemeralKeyClass.getSimpleName() + " - " + e.getTargetException().getMessage(), e.getTargetException());
            }
            throw new IllegalArgumentException("Improperly formatted JSON for ephemeral key " + ephemeralKeyClass.getSimpleName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + ephemeralKeyClass.getSimpleName() + " does not have an accessible (JSONObject) constructor", e);
        }
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof AbstractEphemeralKey && this.typedEquals((AbstractEphemeralKey)obj);
    }

    private boolean typedEquals(@NonNull AbstractEphemeralKey ephemeralKey) {
        return ObjectUtils.equals(this.mObjectId, ephemeralKey.mObjectId) && this.mCreated == ephemeralKey.mCreated && this.mExpires == ephemeralKey.mExpires && ObjectUtils.equals(this.mId, ephemeralKey.mId) && this.mLiveMode == ephemeralKey.mLiveMode && ObjectUtils.equals(this.mObject, ephemeralKey.mObject) && ObjectUtils.equals(this.mSecret, ephemeralKey.mSecret) && ObjectUtils.equals(this.mType, ephemeralKey.mType);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mObjectId, this.mCreated, this.mExpires, this.mId, this.mLiveMode, this.mObject, this.mSecret, this.mType);
    }
}

