/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;

public class ClassUtils {
    private ClassUtils() {
    }

    @Nullable
    public static Object getInternalObject(@NonNull Class clazz, @NonNull Set<String> whitelist, @NonNull Object obj) {
        Field field = ClassUtils.findField(clazz, whitelist);
        if (field == null) {
            return null;
        }
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Field findField(@NonNull Class clazz, @NonNull Collection<String> whitelist) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!whitelist.contains(field.getName())) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    @Nullable
    public static Method findMethod(@NonNull Class clazz, @NonNull Collection<String> whitelist) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!whitelist.contains(method.getName())) continue;
            return method;
        }
        return null;
    }
}

