/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceRedirect
extends StripeJsonModel {
    public static final String PENDING = "pending";
    public static final String SUCCEEDED = "succeeded";
    public static final String FAILED = "failed";
    static final String FIELD_RETURN_URL = "return_url";
    static final String FIELD_STATUS = "status";
    static final String FIELD_URL = "url";
    private String mReturnUrl;
    private String mStatus;
    private String mUrl;

    SourceRedirect(String returnUrl, String status, String url) {
        this.mReturnUrl = returnUrl;
        this.mStatus = status;
        this.mUrl = url;
    }

    public String getReturnUrl() {
        return this.mReturnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.mReturnUrl = returnUrl;
    }

    public String getStatus() {
        return this.mStatus;
    }

    public void setStatus(String status) {
        this.mStatus = status;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(FIELD_RETURN_URL, this.mReturnUrl);
        hashMap.put(FIELD_STATUS, this.mStatus);
        hashMap.put(FIELD_URL, this.mUrl);
        StripeNetworkUtils.removeNullAndEmptyParams(hashMap);
        return hashMap;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_RETURN_URL, this.mReturnUrl);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_STATUS, this.mStatus);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_URL, this.mUrl);
        return jsonObject;
    }

    @Nullable
    public static SourceRedirect fromString(@Nullable String jsonString) {
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            return SourceRedirect.fromJson(jsonObject);
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static SourceRedirect fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String returnUrl = StripeJsonUtils.optString(jsonObject, FIELD_RETURN_URL);
        String status = SourceRedirect.asStatus(StripeJsonUtils.optString(jsonObject, FIELD_STATUS));
        String url = StripeJsonUtils.optString(jsonObject, FIELD_URL);
        return new SourceRedirect(returnUrl, status, url);
    }

    @Nullable
    private static String asStatus(@Nullable String stringStatus) {
        if (PENDING.equals(stringStatus)) {
            return PENDING;
        }
        if (SUCCEEDED.equals(stringStatus)) {
            return SUCCEEDED;
        }
        if (FAILED.equals(stringStatus)) {
            return FAILED;
        }
        return null;
    }
}

