/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceCodeVerification
extends StripeJsonModel {
    static final String PENDING = "pending";
    static final String SUCCEEDED = "succeeded";
    static final String FAILED = "failed";
    private static final String FIELD_ATTEMPTS_REMAINING = "attempts_remaining";
    private static final String FIELD_STATUS = "status";
    private static final int INVALID_ATTEMPTS_REMAINING = -1;
    private int mAttemptsRemaining;
    private String mStatus;

    SourceCodeVerification(int attemptsRemaining, String status) {
        this.mAttemptsRemaining = attemptsRemaining;
        this.mStatus = status;
    }

    public int getAttemptsRemaining() {
        return this.mAttemptsRemaining;
    }

    void setAttemptsRemaining(int attemptsRemaining) {
        this.mAttemptsRemaining = attemptsRemaining;
    }

    public String getStatus() {
        return this.mStatus;
    }

    void setStatus(String status) {
        this.mStatus = status;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(FIELD_ATTEMPTS_REMAINING, this.mAttemptsRemaining);
        if (this.mStatus != null) {
            hashMap.put(FIELD_STATUS, this.mStatus);
        }
        return hashMap;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(FIELD_ATTEMPTS_REMAINING, this.mAttemptsRemaining);
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_STATUS, this.mStatus);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    @Nullable
    public static SourceCodeVerification fromString(@Nullable String jsonString) {
        try {
            return SourceCodeVerification.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static SourceCodeVerification fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return new SourceCodeVerification(jsonObject.optInt(FIELD_ATTEMPTS_REMAINING, -1), SourceCodeVerification.asStatus(StripeJsonUtils.optString(jsonObject, FIELD_STATUS)));
    }

    @Nullable
    private static String asStatus(@Nullable String stringStatus) {
        if (PENDING.equals(stringStatus)) {
            return PENDING;
        }
        if (SUCCEEDED.equals(stringStatus)) {
            return SUCCEEDED;
        }
        if (FAILED.equals(stringStatus)) {
            return FAILED;
        }
        return null;
    }
}

