/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.exception;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public abstract class StripeException
extends Exception {
    protected static final long serialVersionUID = 1L;
    @Nullable
    private final String requestId;
    @Nullable
    private final Integer statusCode;

    public StripeException(@Nullable String message, @Nullable String requestId, @Nullable Integer statusCode) {
        this(message, requestId, statusCode, null);
    }

    public StripeException(@Nullable String message, @Nullable String requestId, @Nullable Integer statusCode, @Nullable Throwable e) {
        super(message, e);
        this.statusCode = statusCode;
        this.requestId = requestId;
    }

    @Nullable
    public String getRequestId() {
        return this.requestId;
    }

    @Nullable
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Override
    @NonNull
    public String toString() {
        String reqIdStr = this.requestId != null ? "; request-id: " + this.requestId : "";
        return super.toString() + reqIdStr;
    }
}

