/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.os.AsyncTask;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.LoggingUtils;
import com.stripe.android.RequestOptions;
import com.stripe.android.SourceCallback;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.TokenCallback;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.AccountParams;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentIntentParams;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.model.Token;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class Stripe {
    private final SourceCreator mSourceCreator = new SourceCreator(){

        @Override
        public void create(@NonNull SourceParams sourceParams, @NonNull String publishableKey, @Nullable String stripeAccount, @Nullable Executor executor, @NonNull SourceCallback sourceCallback) {
            Stripe.this.executeTask(executor, (AsyncTask<Void, Void, ResponseWrapper>)new CreateSourceTask(Stripe.this.mContext, sourceParams, publishableKey, stripeAccount, sourceCallback));
        }
    };
    @VisibleForTesting
    TokenCreator mTokenCreator = new TokenCreator(){

        @Override
        public void create(@NonNull Map<String, Object> tokenParams, @NonNull String publishableKey, @Nullable String stripeAccount, @NonNull String tokenType, @Nullable Executor executor, @NonNull TokenCallback callback) {
            Stripe.this.executeTask(executor, (AsyncTask<Void, Void, ResponseWrapper>)new CreateTokenTask(Stripe.this.mContext, tokenParams, publishableKey, stripeAccount, tokenType, callback, Stripe.this.mLoggingResponseListener));
        }
    };
    @NonNull
    private final Context mContext;
    @Nullable
    private StripeApiHandler.LoggingResponseListener mLoggingResponseListener;
    private String mDefaultPublishableKey;
    private String mStripeAccount;

    public Stripe(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
    }

    public Stripe(@NonNull Context context, String publishableKey) {
        this.mContext = context.getApplicationContext();
        this.setDefaultPublishableKey(publishableKey);
    }

    public void createBankAccountToken(@NonNull BankAccount bankAccount, @NonNull TokenCallback callback) {
        this.createBankAccountToken(bankAccount, this.mDefaultPublishableKey, null, callback);
    }

    public void createBankAccountToken(@NonNull BankAccount bankAccount, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        if (bankAccount == null) {
            throw new RuntimeException("Required parameter: 'bankAccount' is requred to create a token");
        }
        this.createTokenFromParams(StripeNetworkUtils.hashMapFromBankAccount(this.mContext, bankAccount), publishableKey, "bank_account", executor, callback);
    }

    public void createPiiToken(@NonNull String personalId, @NonNull TokenCallback callback) {
        this.createPiiToken(personalId, this.mDefaultPublishableKey, null, callback);
    }

    public void createPiiToken(@NonNull String personalId, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        this.createTokenFromParams(StripeNetworkUtils.hashMapFromPersonalId(this.mContext, personalId), publishableKey, "pii", executor, callback);
    }

    public Token createBankAccountTokenSynchronous(BankAccount bankAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createBankAccountTokenSynchronous(bankAccount, this.mDefaultPublishableKey);
    }

    public Token createBankAccountTokenSynchronous(BankAccount bankAccount, String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.validateKey(publishableKey);
        RequestOptions requestOptions = RequestOptions.builder(publishableKey, this.mStripeAccount, "source").build();
        return StripeApiHandler.createToken(this.mContext, StripeNetworkUtils.hashMapFromBankAccount(this.mContext, bankAccount), requestOptions, "bank_account", this.mLoggingResponseListener);
    }

    public void createSource(@NonNull SourceParams sourceParams, @NonNull SourceCallback callback) {
        this.createSource(sourceParams, callback, null, null);
    }

    public void createSource(@NonNull SourceParams sourceParams, @NonNull SourceCallback callback, @Nullable String publishableKey, @Nullable Executor executor) {
        String apiKey;
        String string2 = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return;
        }
        this.mSourceCreator.create(sourceParams, apiKey, this.mStripeAccount, executor, callback);
    }

    public void createToken(@NonNull Card card, @NonNull TokenCallback callback) {
        this.createToken(card, this.mDefaultPublishableKey, callback);
    }

    public void createToken(@NonNull Card card, @NonNull String publishableKey, @NonNull TokenCallback callback) {
        this.createToken(card, publishableKey, null, callback);
    }

    public void createToken(@NonNull Card card, @NonNull Executor executor, @NonNull TokenCallback callback) {
        this.createToken(card, this.mDefaultPublishableKey, executor, callback);
    }

    public void createToken(@NonNull Card card, @NonNull @Size(min=1L) String publishableKey, @Nullable Executor executor, @NonNull TokenCallback callback) {
        if (card == null) {
            throw new RuntimeException("Required Parameter: 'card' is required to create a token");
        }
        this.createTokenFromParams(StripeNetworkUtils.hashMapFromCard(this.mContext, card), publishableKey, "card", executor, callback);
    }

    @Nullable
    public Source createSourceSynchronous(@NonNull SourceParams params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.createSourceSynchronous(params, null);
    }

    public Source createSourceSynchronous(@NonNull SourceParams params, @Nullable String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String apiKey;
        String string2 = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return null;
        }
        return StripeApiHandler.createSource(null, this.mContext, params, apiKey, this.mStripeAccount, this.mLoggingResponseListener);
    }

    public PaymentIntent retrievePaymentIntentSynchronous(@NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return StripeApiHandler.retrievePaymentIntent(null, this.mContext, paymentIntentParams, publishableKey, this.mStripeAccount, this.mLoggingResponseListener);
    }

    public PaymentIntent confirmPaymentIntentSynchronous(@NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return StripeApiHandler.confirmPaymentIntent(null, this.mContext, paymentIntentParams, publishableKey, this.mStripeAccount, this.mLoggingResponseListener);
    }

    public Token createTokenSynchronous(Card card) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createTokenSynchronous(card, this.mDefaultPublishableKey);
    }

    public Token createTokenSynchronous(Card card, String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.validateKey(publishableKey);
        RequestOptions requestOptions = RequestOptions.builder(publishableKey, this.mStripeAccount, "source").build();
        return StripeApiHandler.createToken(this.mContext, StripeNetworkUtils.hashMapFromCard(this.mContext, card), requestOptions, "card", this.mLoggingResponseListener);
    }

    public Token createPiiTokenSynchronous(@NonNull String personalId) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createPiiTokenSynchronous(personalId, this.mDefaultPublishableKey);
    }

    public Token createPiiTokenSynchronous(@NonNull String personalId, String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.validateKey(publishableKey);
        RequestOptions requestOptions = RequestOptions.builder(publishableKey, this.mStripeAccount, "source").build();
        return StripeApiHandler.createToken(this.mContext, StripeNetworkUtils.hashMapFromPersonalId(this.mContext, personalId), requestOptions, "pii", this.mLoggingResponseListener);
    }

    public Token createAccountTokenSynchronous(@NonNull AccountParams accountParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.createAccountTokenSynchronous(accountParams, this.mDefaultPublishableKey);
    }

    public Token createAccountTokenSynchronous(@NonNull AccountParams accountParams, @Nullable String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String apiKey;
        String string2 = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return null;
        }
        this.validateKey(publishableKey);
        RequestOptions requestOptions = RequestOptions.builder(publishableKey, this.mStripeAccount, "source").build();
        try {
            return StripeApiHandler.createToken(this.mContext, accountParams.toParamMap(), requestOptions, "account", this.mLoggingResponseListener);
        }
        catch (CardException cardException) {
            return null;
        }
    }

    public void logEventSynchronous(@NonNull List<String> productUsageTokens, @NonNull StripePaymentSource paymentSource) {
        Map<String, Object> loggingMap;
        RequestOptions.RequestOptionsBuilder builder = RequestOptions.builder(this.mDefaultPublishableKey);
        if (this.mStripeAccount != null) {
            builder.setStripeAccount(this.mStripeAccount);
        }
        RequestOptions options = builder.build();
        if (paymentSource instanceof Token) {
            Token token = (Token)paymentSource;
            loggingMap = LoggingUtils.getTokenCreationParams(this.mContext, productUsageTokens, this.mDefaultPublishableKey, token.getType());
        } else {
            Source source = (Source)paymentSource;
            loggingMap = LoggingUtils.getSourceCreationParams(this.mContext, productUsageTokens, this.mDefaultPublishableKey, source.getType());
        }
        StripeApiHandler.logApiCall(loggingMap, options, this.mLoggingResponseListener);
    }

    public Source retrieveSourceSynchronous(@NonNull @Size(min=1L) String sourceId, @NonNull @Size(min=1L) String clientSecret) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.retrieveSourceSynchronous(sourceId, clientSecret, null);
    }

    public Source retrieveSourceSynchronous(@NonNull @Size(min=1L) String sourceId, @NonNull @Size(min=1L) String clientSecret, @Nullable String publishableKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String apiKey;
        String string2 = apiKey = publishableKey == null ? this.mDefaultPublishableKey : publishableKey;
        if (apiKey == null) {
            return null;
        }
        return StripeApiHandler.retrieveSource(sourceId, clientSecret, apiKey, this.mStripeAccount);
    }

    public void setDefaultPublishableKey(@NonNull @Size(min=1L) String publishableKey) {
        this.validateKey(publishableKey);
        this.mDefaultPublishableKey = publishableKey;
    }

    public void setStripeAccount(@NonNull @Size(min=1L) String stripeAccount) {
        this.mStripeAccount = stripeAccount;
    }

    @VisibleForTesting
    void setLoggingResponseListener(StripeApiHandler.LoggingResponseListener listener) {
        this.mLoggingResponseListener = listener;
    }

    private void createTokenFromParams(@NonNull Map<String, Object> tokenParams, @NonNull @Size(min=1L) String publishableKey, @NonNull String tokenType, @Nullable Executor executor, @NonNull TokenCallback callback) {
        if (callback == null) {
            throw new RuntimeException("Required Parameter: 'callback' is required to use the created token and handle errors");
        }
        this.validateKey(publishableKey);
        this.mTokenCreator.create(tokenParams, publishableKey, this.mStripeAccount, tokenType, executor, callback);
    }

    private void validateKey(@NonNull @Size(min=1L) String publishableKey) {
        if (publishableKey == null || publishableKey.length() == 0) {
            throw new IllegalArgumentException("Invalid Publishable Key: You must use a valid publishable key to create a token.  For more info, see https://stripe.com/docs/stripe.js.");
        }
        if (publishableKey.startsWith("sk_")) {
            throw new IllegalArgumentException("Invalid Publishable Key: You are using a secret key to create a token, instead of the publishable one. For more info, see https://stripe.com/docs/stripe.js");
        }
    }

    private void executeTask(Executor executor, AsyncTask<Void, Void, ResponseWrapper> task) {
        if (executor != null) {
            task.executeOnExecutor(executor, (Object[])new Void[0]);
        } else {
            task.execute((Object[])new Void[0]);
        }
    }

    private static class CreateTokenTask
    extends AsyncTask<Void, Void, ResponseWrapper> {
        @NonNull
        private final WeakReference<Context> mContextRef;
        @NonNull
        private final Map<String, Object> mTokenParams;
        @NonNull
        private final String mPublishableKey;
        @Nullable
        private final String mStripeAccount;
        @NonNull
        private final String mTokenType;
        @NonNull
        private final WeakReference<TokenCallback> mCallbackRef;
        @Nullable
        private final StripeApiHandler.LoggingResponseListener mLoggingResponseListener;

        CreateTokenTask(@NonNull Context context, @NonNull Map<String, Object> tokenParams, @NonNull String publishableKey, @Nullable String stripeAccount, @NonNull String tokenType, @Nullable TokenCallback callback, @Nullable StripeApiHandler.LoggingResponseListener loggingResponseListener) {
            this.mContextRef = new WeakReference<Context>(context);
            this.mTokenParams = tokenParams;
            this.mPublishableKey = publishableKey;
            this.mStripeAccount = stripeAccount;
            this.mTokenType = tokenType;
            this.mLoggingResponseListener = loggingResponseListener;
            this.mCallbackRef = new WeakReference<TokenCallback>(callback);
        }

        protected ResponseWrapper doInBackground(Void ... params) {
            try {
                RequestOptions requestOptions = RequestOptions.builder(this.mPublishableKey, this.mStripeAccount, "source").build();
                Token token = StripeApiHandler.createToken((Context)this.mContextRef.get(), this.mTokenParams, requestOptions, this.mTokenType, this.mLoggingResponseListener);
                return new ResponseWrapper(token);
            }
            catch (StripeException e) {
                return new ResponseWrapper(e);
            }
        }

        protected void onPostExecute(@NonNull ResponseWrapper result) {
            this.tokenTaskPostExecution(result);
        }

        private void tokenTaskPostExecution(@NonNull ResponseWrapper result) {
            TokenCallback callback = (TokenCallback)this.mCallbackRef.get();
            if (callback != null) {
                if (result.token != null) {
                    callback.onSuccess(result.token);
                } else if (result.error != null) {
                    callback.onError(result.error);
                } else {
                    callback.onError(new RuntimeException("Somehow got neither a token response or an error response"));
                }
            }
        }
    }

    private static class CreateSourceTask
    extends AsyncTask<Void, Void, ResponseWrapper> {
        @NonNull
        private final WeakReference<Context> mContextRef;
        @NonNull
        private final SourceParams mSourceParams;
        @NonNull
        private final String mPublishableKey;
        @Nullable
        private final String mStripeAccount;
        @NonNull
        private final WeakReference<SourceCallback> mSourceCallbackRef;

        CreateSourceTask(@NonNull Context context, @NonNull SourceParams sourceParams, @NonNull String publishableKey, @Nullable String stripeAccount, @NonNull SourceCallback sourceCallback) {
            this.mContextRef = new WeakReference<Context>(context);
            this.mSourceParams = sourceParams;
            this.mPublishableKey = publishableKey;
            this.mStripeAccount = stripeAccount;
            this.mSourceCallbackRef = new WeakReference<SourceCallback>(sourceCallback);
        }

        protected ResponseWrapper doInBackground(Void ... params) {
            try {
                Source source = StripeApiHandler.createSource(null, (Context)this.mContextRef.get(), this.mSourceParams, this.mPublishableKey, this.mStripeAccount, null);
                return new ResponseWrapper(source);
            }
            catch (StripeException stripeException) {
                return new ResponseWrapper(stripeException);
            }
        }

        protected void onPostExecute(ResponseWrapper responseWrapper) {
            SourceCallback sourceCallback = (SourceCallback)this.mSourceCallbackRef.get();
            if (sourceCallback != null) {
                if (responseWrapper.source != null) {
                    sourceCallback.onSuccess(responseWrapper.source);
                } else if (responseWrapper.error != null) {
                    sourceCallback.onError(responseWrapper.error);
                }
            }
        }
    }

    @VisibleForTesting
    static interface TokenCreator {
        public void create(Map<String, Object> var1, String var2, String var3, @NonNull String var4, Executor var5, TokenCallback var6);
    }

    static interface SourceCreator {
        public void create(@NonNull SourceParams var1, @NonNull String var2, @Nullable String var3, @Nullable Executor var4, @NonNull SourceCallback var5);
    }

    private static class ResponseWrapper {
        final Source source;
        final Token token;
        final Exception error;

        private ResponseWrapper(Token token) {
            this.token = token;
            this.source = null;
            this.error = null;
        }

        private ResponseWrapper(Source source) {
            this.source = source;
            this.error = null;
            this.token = null;
        }

        private ResponseWrapper(Exception error) {
            this.error = error;
            this.source = null;
            this.token = null;
        }
    }
}

