/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.TextInputLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.stripe.android.CardUtils;
import com.stripe.android.R;
import com.stripe.android.model.Card;
import com.stripe.android.view.BackUpFieldDeleteListener;
import com.stripe.android.view.CardInputListener;
import com.stripe.android.view.CardNumberEditText;
import com.stripe.android.view.ErrorListener;
import com.stripe.android.view.ExpiryDateEditText;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.ViewUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CardMultilineWidget
extends LinearLayout {
    static final String CARD_MULTILINE_TOKEN = "CardMultilineView";
    static final long CARD_NUMBER_HINT_DELAY = 120L;
    static final long COMMON_HINT_DELAY = 90L;
    @Nullable
    private CardInputListener mCardInputListener;
    private CardNumberEditText mCardNumberEditText;
    private ExpiryDateEditText mExpiryDateEditText;
    private StripeEditText mCvcEditText;
    private StripeEditText mPostalCodeEditText;
    private TextInputLayout mCardNumberTextInputLayout;
    private TextInputLayout mExpiryTextInputLayout;
    private TextInputLayout mCvcTextInputLayout;
    private TextInputLayout mPostalInputLayout;
    private boolean mIsEnabled;
    private boolean mShouldShowPostalCode;
    private boolean mHasAdjustedDrawable;
    private String mCardBrand;
    @ColorInt
    private int mTintColorInt;

    public CardMultilineWidget(Context context) {
        super(context);
        this.initView(null);
    }

    public CardMultilineWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(attrs);
    }

    public CardMultilineWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(attrs);
    }

    @VisibleForTesting
    CardMultilineWidget(Context context, boolean shouldShowPostalCode) {
        super(context);
        this.mShouldShowPostalCode = shouldShowPostalCode;
        this.initView(null);
    }

    public void clear() {
        this.mCardNumberEditText.setText("");
        this.mExpiryDateEditText.setText("");
        this.mCvcEditText.setText("");
        this.mPostalCodeEditText.setText("");
        this.mCardNumberEditText.setShouldShowError(false);
        this.mExpiryDateEditText.setShouldShowError(false);
        this.mCvcEditText.setShouldShowError(false);
        this.mPostalCodeEditText.setShouldShowError(false);
        this.updateBrand("Unknown");
    }

    public void setCardInputListener(@Nullable CardInputListener cardInputListener) {
        this.mCardInputListener = cardInputListener;
    }

    @Nullable
    public Card getCard() {
        if (this.validateAllFields()) {
            String cardNumber = this.mCardNumberEditText.getCardNumber();
            int[] cardDate = this.mExpiryDateEditText.getValidDateFields();
            String cvcValue = this.mCvcEditText.getText().toString();
            Card card = new Card(cardNumber, cardDate[0], cardDate[1], cvcValue);
            if (this.mShouldShowPostalCode) {
                card.setAddressZip(this.mPostalCodeEditText.getText().toString());
            }
            return card.addLoggingToken(CARD_MULTILINE_TOKEN);
        }
        return null;
    }

    public boolean validateAllFields() {
        boolean postalCodeIsValidOrGone;
        boolean cardNumberIsValid = CardUtils.isValidCardNumber(this.mCardNumberEditText.getCardNumber());
        boolean expiryIsValid = this.mExpiryDateEditText.getValidDateFields() != null && this.mExpiryDateEditText.isDateValid();
        boolean cvcIsValid = this.isCvcLengthValid();
        this.mCardNumberEditText.setShouldShowError(!cardNumberIsValid);
        this.mExpiryDateEditText.setShouldShowError(!expiryIsValid);
        this.mCvcEditText.setShouldShowError(!cvcIsValid);
        if (this.mShouldShowPostalCode) {
            postalCodeIsValidOrGone = CardMultilineWidget.isPostalCodeMaximalLength(true, this.mPostalCodeEditText.getText().toString());
            this.mPostalCodeEditText.setShouldShowError(!postalCodeIsValidOrGone);
        } else {
            postalCodeIsValidOrGone = true;
        }
        return cardNumberIsValid && expiryIsValid && cvcIsValid && postalCodeIsValidOrGone;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.updateBrand(this.mCardBrand);
        }
    }

    public void setShouldShowPostalCode(boolean shouldShowPostalCode) {
        this.mShouldShowPostalCode = shouldShowPostalCode;
        this.adjustViewForPostalCodeAttribute();
    }

    public void setCardNumber(@Nullable String cardNumber) {
        this.mCardNumberEditText.setText(cardNumber);
    }

    public boolean validateCardNumber() {
        boolean cardNumberIsValid = CardUtils.isValidCardNumber(this.mCardNumberEditText.getCardNumber());
        this.mCardNumberEditText.setShouldShowError(!cardNumberIsValid);
        return cardNumberIsValid;
    }

    public void setCardNumberTextWatcher(TextWatcher cardNumberTextWatcher) {
        this.mCardNumberEditText.addTextChangedListener(cardNumberTextWatcher);
    }

    public void setExpiryDateTextWatcher(TextWatcher expiryDateTextWatcher) {
        this.mExpiryDateEditText.addTextChangedListener(expiryDateTextWatcher);
    }

    public void setCvcNumberTextWatcher(TextWatcher cvcNumberTextWatcher) {
        this.mCvcEditText.addTextChangedListener(cvcNumberTextWatcher);
    }

    public void setPostalCodeTextWatcher(TextWatcher postalCodeTextWatcher) {
        this.mPostalCodeEditText.addTextChangedListener(postalCodeTextWatcher);
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mExpiryTextInputLayout.setEnabled(enabled);
        this.mCardNumberTextInputLayout.setEnabled(enabled);
        this.mCvcTextInputLayout.setEnabled(enabled);
        this.mPostalInputLayout.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    void adjustViewForPostalCodeAttribute() {
        int expiryLabel = this.mShouldShowPostalCode ? R.string.expiry_label_short : R.string.acc_label_expiry_date;
        this.mExpiryTextInputLayout.setHint((CharSequence)this.getResources().getString(expiryLabel));
        int focusForward = this.mShouldShowPostalCode ? R.id.et_add_source_postal_ml : -1;
        this.mCvcEditText.setNextFocusForwardId(focusForward);
        this.mCvcEditText.setNextFocusDownId(focusForward);
        int visibility = this.mShouldShowPostalCode ? 0 : 8;
        this.mPostalInputLayout.setVisibility(visibility);
        int marginPixels = this.mShouldShowPostalCode ? this.getResources().getDimensionPixelSize(R.dimen.add_card_expiry_middle_margin) : 0;
        LinearLayout.LayoutParams linearParams = (LinearLayout.LayoutParams)this.mCvcTextInputLayout.getLayoutParams();
        linearParams.setMargins(0, 0, marginPixels, 0);
        if (Build.VERSION.SDK_INT >= 17) {
            linearParams.setMarginEnd(marginPixels);
        }
        this.mCvcTextInputLayout.setLayoutParams((ViewGroup.LayoutParams)linearParams);
    }

    static boolean isPostalCodeMaximalLength(boolean isZip, @Nullable String text) {
        return isZip && text != null && text.length() == 5;
    }

    private boolean isCvcLengthValid() {
        int cvcLength = this.mCvcEditText.getText().toString().trim().length();
        if (TextUtils.equals((CharSequence)"American Express", (CharSequence)this.mCardBrand) && cvcLength == 4) {
            return true;
        }
        return cvcLength == 3;
    }

    private void checkAttributeSet(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.CardMultilineWidget, 0, 0);
            try {
                this.mShouldShowPostalCode = a.getBoolean(R.styleable.CardMultilineWidget_shouldShowPostalCode, false);
            }
            finally {
                a.recycle();
            }
        }
    }

    private void flipToCvcIconIfNotFinished() {
        if (ViewUtils.isCvcMaximalLength(this.mCardBrand, this.mCvcEditText.getText().toString())) {
            return;
        }
        int resourceId = "American Express".equals(this.mCardBrand) ? R.drawable.ic_cvc_amex : R.drawable.ic_cvc;
        this.updateDrawable(resourceId, true);
    }

    @StringRes
    private int getCvcHelperText() {
        return "American Express".equals(this.mCardBrand) ? R.string.cvc_multiline_helper_amex : R.string.cvc_multiline_helper;
    }

    private int getDynamicBufferInPixels() {
        float pixelsToAdjust = this.getResources().getDimension(R.dimen.card_icon_multiline_padding_bottom);
        BigDecimal bigDecimal = new BigDecimal(pixelsToAdjust);
        BigDecimal pixels = bigDecimal.setScale(0, RoundingMode.HALF_DOWN);
        return pixels.intValue();
    }

    private void initView(AttributeSet attrs) {
        this.setOrientation(1);
        CardMultilineWidget.inflate((Context)this.getContext(), (int)R.layout.card_multiline_widget, (ViewGroup)this);
        this.mCardNumberEditText = (CardNumberEditText)this.findViewById(R.id.et_add_source_card_number_ml);
        this.mExpiryDateEditText = (ExpiryDateEditText)this.findViewById(R.id.et_add_source_expiry_ml);
        this.mCvcEditText = (StripeEditText)this.findViewById(R.id.et_add_source_cvc_ml);
        this.mPostalCodeEditText = (StripeEditText)this.findViewById(R.id.et_add_source_postal_ml);
        this.mTintColorInt = this.mCardNumberEditText.getHintTextColors().getDefaultColor();
        this.mCardBrand = "Unknown";
        this.checkAttributeSet(attrs);
        this.mCardNumberTextInputLayout = (TextInputLayout)this.findViewById(R.id.tl_add_source_card_number_ml);
        this.mExpiryTextInputLayout = (TextInputLayout)this.findViewById(R.id.tl_add_source_expiry_ml);
        this.mCvcTextInputLayout = (TextInputLayout)this.findViewById(R.id.tl_add_source_cvc_ml);
        this.mPostalInputLayout = (TextInputLayout)this.findViewById(R.id.tl_add_source_postal_ml);
        if (this.mShouldShowPostalCode) {
            this.mExpiryTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.expiry_label_short));
        }
        this.initTextInputLayoutErrorHandlers(this.mCardNumberTextInputLayout, this.mExpiryTextInputLayout, this.mCvcTextInputLayout, this.mPostalInputLayout);
        this.initErrorMessages();
        this.initFocusChangeListeners();
        this.initDeleteEmptyListeners();
        this.mCardNumberEditText.setCardBrandChangeListener(new CardNumberEditText.CardBrandChangeListener(){

            @Override
            public void onCardBrandChanged(@NonNull String brand) {
                CardMultilineWidget.this.updateBrand(brand);
            }
        });
        this.mCardNumberEditText.setCardNumberCompleteListener(new CardNumberEditText.CardNumberCompleteListener(){

            @Override
            public void onCardNumberComplete() {
                CardMultilineWidget.this.mExpiryDateEditText.requestFocus();
                if (CardMultilineWidget.this.mCardInputListener != null) {
                    CardMultilineWidget.this.mCardInputListener.onCardComplete();
                }
            }
        });
        this.mExpiryDateEditText.setExpiryDateEditListener(new ExpiryDateEditText.ExpiryDateEditListener(){

            @Override
            public void onExpiryDateComplete() {
                CardMultilineWidget.this.mCvcEditText.requestFocus();
                if (CardMultilineWidget.this.mCardInputListener != null) {
                    CardMultilineWidget.this.mCardInputListener.onExpirationComplete();
                }
            }
        });
        this.mCvcEditText.setAfterTextChangedListener(new StripeEditText.AfterTextChangedListener(){

            @Override
            public void onTextChanged(String text) {
                if (ViewUtils.isCvcMaximalLength(CardMultilineWidget.this.mCardBrand, text)) {
                    CardMultilineWidget.this.updateBrand(CardMultilineWidget.this.mCardBrand);
                    if (CardMultilineWidget.this.mShouldShowPostalCode) {
                        CardMultilineWidget.this.mPostalCodeEditText.requestFocus();
                    }
                    if (CardMultilineWidget.this.mCardInputListener != null) {
                        CardMultilineWidget.this.mCardInputListener.onCvcComplete();
                    }
                } else {
                    CardMultilineWidget.this.flipToCvcIconIfNotFinished();
                }
                CardMultilineWidget.this.mCvcEditText.setShouldShowError(false);
            }
        });
        this.adjustViewForPostalCodeAttribute();
        this.mPostalCodeEditText.setAfterTextChangedListener(new StripeEditText.AfterTextChangedListener(){

            @Override
            public void onTextChanged(String text) {
                if (CardMultilineWidget.isPostalCodeMaximalLength(true, text) && CardMultilineWidget.this.mCardInputListener != null) {
                    CardMultilineWidget.this.mCardInputListener.onPostalCodeComplete();
                }
                CardMultilineWidget.this.mPostalCodeEditText.setShouldShowError(false);
            }
        });
        this.mCardNumberEditText.updateLengthFilter();
        this.updateBrand("Unknown");
        this.setEnabled(true);
    }

    private void initDeleteEmptyListeners() {
        this.mExpiryDateEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.mCardNumberEditText));
        this.mCvcEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.mExpiryDateEditText));
        if (this.mPostalCodeEditText == null) {
            return;
        }
        this.mPostalCodeEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.mCvcEditText));
    }

    private void initErrorMessages() {
        this.mCardNumberEditText.setErrorMessage(this.getContext().getString(R.string.invalid_card_number));
        this.mExpiryDateEditText.setErrorMessage(this.getContext().getString(R.string.invalid_expiry_year));
        this.mCvcEditText.setErrorMessage(this.getContext().getString(R.string.invalid_cvc));
        this.mPostalCodeEditText.setErrorMessage(this.getContext().getString(R.string.invalid_zip));
    }

    private void initFocusChangeListeners() {
        this.mCardNumberEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    CardMultilineWidget.this.mCardNumberEditText.setHintDelayed(R.string.card_number_hint, 120L);
                    if (CardMultilineWidget.this.mCardInputListener != null) {
                        CardMultilineWidget.this.mCardInputListener.onFocusChange("focus_card");
                    }
                } else {
                    CardMultilineWidget.this.mCardNumberEditText.setHint("");
                }
            }
        });
        this.mExpiryDateEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    CardMultilineWidget.this.mExpiryDateEditText.setHintDelayed(R.string.expiry_date_hint, 90L);
                    if (CardMultilineWidget.this.mCardInputListener != null) {
                        CardMultilineWidget.this.mCardInputListener.onFocusChange("focus_expiry");
                    }
                } else {
                    CardMultilineWidget.this.mExpiryDateEditText.setHint("");
                }
            }
        });
        this.mCvcEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    CardMultilineWidget.this.flipToCvcIconIfNotFinished();
                    int helperText = CardMultilineWidget.this.getCvcHelperText();
                    CardMultilineWidget.this.mCvcEditText.setHintDelayed(helperText, 90L);
                    if (CardMultilineWidget.this.mCardInputListener != null) {
                        CardMultilineWidget.this.mCardInputListener.onFocusChange("focus_cvc");
                    }
                } else {
                    CardMultilineWidget.this.updateBrand(CardMultilineWidget.this.mCardBrand);
                    CardMultilineWidget.this.mCvcEditText.setHint("");
                }
            }
        });
        if (this.mPostalCodeEditText == null) {
            return;
        }
        this.mPostalCodeEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!CardMultilineWidget.this.mShouldShowPostalCode) {
                    return;
                }
                if (hasFocus) {
                    CardMultilineWidget.this.mPostalCodeEditText.setHintDelayed(R.string.zip_helper, 90L);
                    if (CardMultilineWidget.this.mCardInputListener != null) {
                        CardMultilineWidget.this.mCardInputListener.onFocusChange("focus_postal");
                    }
                } else {
                    CardMultilineWidget.this.mPostalCodeEditText.setHint("");
                }
            }
        });
    }

    private void initTextInputLayoutErrorHandlers(TextInputLayout cardInputLayout, TextInputLayout expiryInputLayout, TextInputLayout cvcTextInputLayout, TextInputLayout postalInputLayout) {
        this.mCardNumberEditText.setErrorMessageListener(new ErrorListener(cardInputLayout));
        this.mExpiryDateEditText.setErrorMessageListener(new ErrorListener(expiryInputLayout));
        this.mCvcEditText.setErrorMessageListener(new ErrorListener(cvcTextInputLayout));
        if (this.mPostalCodeEditText == null) {
            return;
        }
        this.mPostalCodeEditText.setErrorMessageListener(new ErrorListener(postalInputLayout));
    }

    private void updateBrand(@NonNull String brand) {
        this.mCardBrand = brand;
        this.updateCvc(this.mCardBrand);
        this.updateDrawable(Card.BRAND_RESOURCE_MAP.get(brand), "Unknown".equals(brand));
    }

    private void updateCvc(@NonNull String brand) {
        if ("American Express".equals(brand)) {
            this.mCvcEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(4)});
            this.mCvcTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.cvc_amex_hint));
        } else {
            this.mCvcEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(3)});
            this.mCvcTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.cvc_number_hint));
        }
    }

    private void updateDrawable(@DrawableRes int iconResourceId, boolean needsTint) {
        Drawable icon = ContextCompat.getDrawable((Context)this.getContext(), (int)iconResourceId);
        Drawable[] drawables = this.mCardNumberEditText.getCompoundDrawables();
        Drawable original = drawables[0];
        if (original == null) {
            return;
        }
        Rect copyBounds = new Rect();
        original.copyBounds(copyBounds);
        int iconPadding = this.mCardNumberEditText.getCompoundDrawablePadding();
        if (!this.mHasAdjustedDrawable) {
            copyBounds.top -= this.getDynamicBufferInPixels();
            copyBounds.bottom -= this.getDynamicBufferInPixels();
            this.mHasAdjustedDrawable = true;
        }
        icon.setBounds(copyBounds);
        Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
        if (needsTint) {
            DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)this.mTintColorInt);
        }
        this.mCardNumberEditText.setCompoundDrawablePadding(iconPadding);
        this.mCardNumberEditText.setCompoundDrawables(compatIcon, null, null, null);
    }
}

