/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeSourceTypeModel;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceSepaDebitData
extends StripeSourceTypeModel {
    private static final String FIELD_BANK_CODE = "bank_code";
    private static final String FIELD_BRANCH_CODE = "branch_code";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_FINGERPRINT = "fingerprint";
    private static final String FIELD_LAST4 = "last4";
    private static final String FIELD_MANDATE_REFERENCE = "mandate_reference";
    private static final String FIELD_MANDATE_URL = "mandate_url";
    private String mBankCode;
    private String mBranchCode;
    private String mCountry;
    private String mFingerPrint;
    private String mLast4;
    private String mMandateReference;
    private String mMandateUrl;

    private SourceSepaDebitData() {
        this.addStandardFields(FIELD_BANK_CODE, FIELD_BRANCH_CODE, FIELD_COUNTRY, FIELD_FINGERPRINT, FIELD_LAST4, FIELD_MANDATE_REFERENCE, FIELD_MANDATE_URL);
    }

    @Nullable
    public static SourceSepaDebitData fromJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        SourceSepaDebitData sepaData = new SourceSepaDebitData();
        sepaData.setBankCode(StripeJsonUtils.optString(jsonObject, FIELD_BANK_CODE)).setBranchCode(StripeJsonUtils.optString(jsonObject, FIELD_BRANCH_CODE)).setCountry(StripeJsonUtils.optString(jsonObject, FIELD_COUNTRY)).setFingerPrint(StripeJsonUtils.optString(jsonObject, FIELD_FINGERPRINT)).setLast4(StripeJsonUtils.optString(jsonObject, FIELD_LAST4)).setMandateReference(StripeJsonUtils.optString(jsonObject, FIELD_MANDATE_REFERENCE)).setMandateUrl(StripeJsonUtils.optString(jsonObject, FIELD_MANDATE_URL));
        Map<String, Object> nonStandardFields = SourceSepaDebitData.jsonObjectToMapWithoutKeys(jsonObject, sepaData.mStandardFields);
        if (nonStandardFields != null) {
            sepaData.setAdditionalFields(nonStandardFields);
        }
        return sepaData;
    }

    public String getBankCode() {
        return this.mBankCode;
    }

    public String getBranchCode() {
        return this.mBranchCode;
    }

    public String getCountry() {
        return this.mCountry;
    }

    public String getFingerPrint() {
        return this.mFingerPrint;
    }

    public String getLast4() {
        return this.mLast4;
    }

    public String getMandateReference() {
        return this.mMandateReference;
    }

    public String getMandateUrl() {
        return this.mMandateUrl;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_BANK_CODE, this.mBankCode);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_BRANCH_CODE, this.mBranchCode);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_COUNTRY, this.mCountry);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_FINGERPRINT, this.mFingerPrint);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_LAST4, this.mLast4);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_MANDATE_REFERENCE, this.mMandateReference);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_MANDATE_URL, this.mMandateUrl);
        SourceSepaDebitData.putAdditionalFieldsIntoJsonObject(jsonObject, this.mAdditionalFields);
        return jsonObject;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put(FIELD_BANK_CODE, this.mBankCode);
        objectMap.put(FIELD_BRANCH_CODE, this.mBranchCode);
        objectMap.put(FIELD_COUNTRY, this.mCountry);
        objectMap.put(FIELD_FINGERPRINT, this.mFingerPrint);
        objectMap.put(FIELD_LAST4, this.mLast4);
        objectMap.put(FIELD_MANDATE_REFERENCE, this.mMandateReference);
        objectMap.put(FIELD_MANDATE_URL, this.mMandateUrl);
        SourceSepaDebitData.putAdditionalFieldsIntoMap(objectMap, this.mAdditionalFields);
        StripeNetworkUtils.removeNullAndEmptyParams(objectMap);
        return objectMap;
    }

    @Nullable
    @VisibleForTesting
    static SourceSepaDebitData fromString(String jsonString) {
        try {
            return SourceSepaDebitData.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException badJson) {
            return null;
        }
    }

    private SourceSepaDebitData setBankCode(String bankCode) {
        this.mBankCode = bankCode;
        return this;
    }

    private SourceSepaDebitData setBranchCode(String branchCode) {
        this.mBranchCode = branchCode;
        return this;
    }

    private SourceSepaDebitData setCountry(String country) {
        this.mCountry = country;
        return this;
    }

    private SourceSepaDebitData setFingerPrint(String fingerPrint) {
        this.mFingerPrint = fingerPrint;
        return this;
    }

    private SourceSepaDebitData setLast4(String last4) {
        this.mLast4 = last4;
        return this;
    }

    private SourceSepaDebitData setMandateReference(String mandateReference) {
        this.mMandateReference = mandateReference;
        return this;
    }

    private SourceSepaDebitData setMandateUrl(String mandateUrl) {
        this.mMandateUrl = mandateUrl;
        return this;
    }
}

