/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import com.stripe.android.R;
import com.stripe.android.view.CountryAdapter;
import com.stripe.android.view.CountryUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CountryAutoCompleteTextView
extends FrameLayout {
    private AutoCompleteTextView mCountryAutocomplete;
    private Map<String, String> mCountryNameToCode;
    private String mCountrySelected;
    private CountryChangeListener mCountryChangeListener;

    public CountryAutoCompleteTextView(Context context) {
        super(context);
        this.initView();
    }

    public CountryAutoCompleteTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public CountryAutoCompleteTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    String getSelectedCountryCode() {
        return this.mCountrySelected;
    }

    void setCountrySelected(String countryCode) {
        Locale locale = new Locale("", countryCode);
        this.updateUIForCountryEntered(locale.getDisplayCountry());
    }

    void setCountryChangeListener(CountryChangeListener countryChangeListener) {
        this.mCountryChangeListener = countryChangeListener;
    }

    private void initView() {
        CountryAutoCompleteTextView.inflate((Context)this.getContext(), (int)R.layout.country_autocomplete_textview, (ViewGroup)this);
        this.mCountryAutocomplete = (AutoCompleteTextView)this.findViewById(R.id.autocomplete_country_cat);
        this.mCountryNameToCode = CountryUtils.getCountryNameToCodeMap();
        CountryAdapter countryAdapter = new CountryAdapter(this.getContext(), new ArrayList<String>(this.mCountryNameToCode.keySet()));
        this.mCountryAutocomplete.setThreshold(0);
        this.mCountryAutocomplete.setAdapter((ListAdapter)countryAdapter);
        this.mCountryAutocomplete.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                String countryEntered = CountryAutoCompleteTextView.this.mCountryAutocomplete.getText().toString();
                CountryAutoCompleteTextView.this.updateUIForCountryEntered(countryEntered);
            }
        });
        String defaultCountryEntered = (String)countryAdapter.getItem(0);
        this.updateUIForCountryEntered(defaultCountryEntered);
        this.mCountryAutocomplete.setText((CharSequence)defaultCountryEntered);
        this.mCountryAutocomplete.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean focused) {
                String countryEntered = CountryAutoCompleteTextView.this.mCountryAutocomplete.getText().toString();
                if (focused) {
                    CountryAutoCompleteTextView.this.mCountryAutocomplete.showDropDown();
                } else {
                    CountryAutoCompleteTextView.this.updateUIForCountryEntered(countryEntered);
                }
            }
        });
    }

    @VisibleForTesting
    void updateUIForCountryEntered(String displayCountryEntered) {
        String countryCodeEntered = this.mCountryNameToCode.get(displayCountryEntered);
        if (countryCodeEntered != null) {
            if (this.mCountrySelected == null || !this.mCountrySelected.equals(countryCodeEntered)) {
                this.mCountrySelected = countryCodeEntered;
                if (this.mCountryChangeListener != null) {
                    this.mCountryChangeListener.onCountryChanged(this.mCountrySelected);
                }
            }
            this.mCountryAutocomplete.setText((CharSequence)displayCountryEntered);
        } else {
            String displayCountry = new Locale("", this.mCountrySelected).getDisplayCountry();
            this.mCountryAutocomplete.setText((CharSequence)displayCountry);
        }
    }

    static interface CountryChangeListener {
        public void onCountryChanged(String var1);
    }
}

