/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.ShippingMethodView;
import java.util.ArrayList;
import java.util.List;

class ShippingMethodAdapter
extends RecyclerView.Adapter<ViewHolder> {
    @NonNull
    private List<ShippingMethod> mShippingMethods = new ArrayList<ShippingMethod>();
    @NonNull
    private int mSelectedIndex = 0;

    ShippingMethodAdapter() {
    }

    public int getItemCount() {
        return this.mShippingMethods.size();
    }

    public long getItemId(int position) {
        return super.getItemId(position);
    }

    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        ShippingMethodView shippingMethodView = new ShippingMethodView(viewGroup.getContext());
        return new ViewHolder(shippingMethodView);
    }

    public void onBindViewHolder(ViewHolder holder, int i) {
        holder.setShippingMethod(this.mShippingMethods.get(i));
        holder.setIndex(i);
        holder.setUIAsSelected(i == this.mSelectedIndex);
    }

    ShippingMethod getSelectedShippingMethod() {
        return this.mShippingMethods.get(this.mSelectedIndex);
    }

    void setShippingMethods(List<ShippingMethod> shippingMethods, ShippingMethod defaultShippingMethod) {
        if (shippingMethods != null) {
            this.mShippingMethods = shippingMethods;
        }
        this.mSelectedIndex = defaultShippingMethod == null ? 0 : this.mShippingMethods.indexOf(defaultShippingMethod);
        this.notifyDataSetChanged();
    }

    void setSelectedIndex(int selectedIndex) {
        this.mSelectedIndex = selectedIndex;
        this.notifyDataSetChanged();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        ShippingMethodView shippingMethodView;
        int index;

        ViewHolder(ShippingMethodView shippingMethodView) {
            super((View)shippingMethodView);
            this.shippingMethodView = shippingMethodView;
            shippingMethodView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ShippingMethodAdapter.this.setSelectedIndex(ViewHolder.this.index);
                }
            });
        }

        void setShippingMethod(ShippingMethod shippingMethod) {
            this.shippingMethodView.setShippingMethod(shippingMethod);
        }

        void setUIAsSelected(boolean selected) {
            this.shippingMethodView.setSelected(selected);
        }

        void setIndex(int index) {
            this.index = index;
        }
    }
}

