/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.stripe.android.CardUtils;
import com.stripe.android.R;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.model.ModelUtils;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripePaymentSource;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Card
extends StripeJsonModel
implements StripePaymentSource {
    public static final String AMERICAN_EXPRESS = "American Express";
    public static final String DISCOVER = "Discover";
    public static final String JCB = "JCB";
    public static final String DINERS_CLUB = "Diners Club";
    public static final String VISA = "Visa";
    public static final String MASTERCARD = "MasterCard";
    public static final String UNKNOWN = "Unknown";
    public static final int CVC_LENGTH_AMERICAN_EXPRESS = 4;
    public static final int CVC_LENGTH_COMMON = 3;
    public static final String FUNDING_CREDIT = "credit";
    public static final String FUNDING_DEBIT = "debit";
    public static final String FUNDING_PREPAID = "prepaid";
    public static final String FUNDING_UNKNOWN = "unknown";
    public static final Map<String, Integer> BRAND_RESOURCE_MAP = new HashMap<String, Integer>(){
        {
            this.put(Card.AMERICAN_EXPRESS, R.drawable.ic_amex);
            this.put(Card.DINERS_CLUB, R.drawable.ic_diners);
            this.put(Card.DISCOVER, R.drawable.ic_discover);
            this.put(Card.JCB, R.drawable.ic_jcb);
            this.put(Card.MASTERCARD, R.drawable.ic_mastercard);
            this.put(Card.VISA, R.drawable.ic_visa);
            this.put(Card.UNKNOWN, R.drawable.ic_unknown);
        }
    };
    public static final String[] PREFIXES_AMERICAN_EXPRESS = new String[]{"34", "37"};
    public static final String[] PREFIXES_DISCOVER = new String[]{"60", "62", "64", "65"};
    public static final String[] PREFIXES_JCB = new String[]{"35"};
    public static final String[] PREFIXES_DINERS_CLUB = new String[]{"300", "301", "302", "303", "304", "305", "309", "36", "38", "39"};
    public static final String[] PREFIXES_VISA = new String[]{"4"};
    public static final String[] PREFIXES_MASTERCARD = new String[]{"2221", "2222", "2223", "2224", "2225", "2226", "2227", "2228", "2229", "223", "224", "225", "226", "227", "228", "229", "23", "24", "25", "26", "270", "271", "2720", "50", "51", "52", "53", "54", "55"};
    public static final int MAX_LENGTH_STANDARD = 16;
    public static final int MAX_LENGTH_AMERICAN_EXPRESS = 15;
    public static final int MAX_LENGTH_DINERS_CLUB = 14;
    static final String VALUE_CARD = "card";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_ADDRESS_CITY = "address_city";
    private static final String FIELD_ADDRESS_COUNTRY = "address_country";
    private static final String FIELD_ADDRESS_LINE1 = "address_line1";
    private static final String FIELD_ADDRESS_LINE1_CHECK = "address_line1_check";
    private static final String FIELD_ADDRESS_LINE2 = "address_line2";
    private static final String FIELD_ADDRESS_STATE = "address_state";
    private static final String FIELD_ADDRESS_ZIP = "address_zip";
    private static final String FIELD_ADDRESS_ZIP_CHECK = "address_zip_check";
    private static final String FIELD_BRAND = "brand";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_CUSTOMER = "customer";
    private static final String FIELD_CVC_CHECK = "cvc_check";
    private static final String FIELD_EXP_MONTH = "exp_month";
    private static final String FIELD_EXP_YEAR = "exp_year";
    private static final String FIELD_FINGERPRINT = "fingerprint";
    private static final String FIELD_FUNDING = "funding";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_LAST4 = "last4";
    private static final String FIELD_ID = "id";
    private String number;
    private String cvc;
    private Integer expMonth;
    private Integer expYear;
    private String name;
    private String addressLine1;
    private String addressLine1Check;
    private String addressLine2;
    private String addressCity;
    private String addressState;
    private String addressZip;
    private String addressZipCheck;
    private String addressCountry;
    @Size(value=4L)
    private String last4;
    private String brand;
    private String funding;
    private String fingerprint;
    private String country;
    private String currency;
    private String customerId;
    private String cvcCheck;
    private String id;
    @NonNull
    private List<String> loggingTokens = new ArrayList<String>();

    @Nullable
    public static String asCardBrand(@Nullable String possibleCardType) {
        if (possibleCardType == null || TextUtils.isEmpty((CharSequence)possibleCardType.trim())) {
            return null;
        }
        if (AMERICAN_EXPRESS.equalsIgnoreCase(possibleCardType)) {
            return AMERICAN_EXPRESS;
        }
        if (MASTERCARD.equalsIgnoreCase(possibleCardType)) {
            return MASTERCARD;
        }
        if (DINERS_CLUB.equalsIgnoreCase(possibleCardType)) {
            return DINERS_CLUB;
        }
        if (DISCOVER.equalsIgnoreCase(possibleCardType)) {
            return DISCOVER;
        }
        if (JCB.equalsIgnoreCase(possibleCardType)) {
            return JCB;
        }
        if (VISA.equalsIgnoreCase(possibleCardType)) {
            return VISA;
        }
        return UNKNOWN;
    }

    @Nullable
    public static String asFundingType(@Nullable String possibleFundingType) {
        if (possibleFundingType == null || TextUtils.isEmpty((CharSequence)possibleFundingType.trim())) {
            return null;
        }
        if (FUNDING_CREDIT.equalsIgnoreCase(possibleFundingType)) {
            return FUNDING_CREDIT;
        }
        if (FUNDING_DEBIT.equalsIgnoreCase(possibleFundingType)) {
            return FUNDING_DEBIT;
        }
        if (FUNDING_PREPAID.equalsIgnoreCase(possibleFundingType)) {
            return FUNDING_PREPAID;
        }
        return FUNDING_UNKNOWN;
    }

    @Nullable
    public static Card fromString(String jsonString) {
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            return Card.fromJson(jsonObject);
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static Card fromJson(JSONObject jsonObject) {
        if (jsonObject == null || !VALUE_CARD.equals(jsonObject.optString(FIELD_OBJECT))) {
            return null;
        }
        Integer expMonth = StripeJsonUtils.optInteger(jsonObject, FIELD_EXP_MONTH);
        Integer expYear = StripeJsonUtils.optInteger(jsonObject, FIELD_EXP_YEAR);
        if (expMonth != null && (expMonth < 1 || expMonth > 12)) {
            expMonth = null;
        }
        if (expYear != null && expYear < 0) {
            expYear = null;
        }
        Builder builder = new Builder(null, expMonth, expYear, null);
        builder.addressCity(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_CITY));
        builder.addressLine1(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_LINE1));
        builder.addressLine1Check(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_LINE1_CHECK));
        builder.addressLine2(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_LINE2));
        builder.addressCountry(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_COUNTRY));
        builder.addressState(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_STATE));
        builder.addressZip(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_ZIP));
        builder.addressZipCheck(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS_ZIP_CHECK));
        builder.brand(Card.asCardBrand(StripeJsonUtils.optString(jsonObject, FIELD_BRAND)));
        builder.country(StripeJsonUtils.optCountryCode(jsonObject, FIELD_COUNTRY));
        builder.customer(StripeJsonUtils.optString(jsonObject, FIELD_CUSTOMER));
        builder.currency(StripeJsonUtils.optCurrency(jsonObject, FIELD_CURRENCY));
        builder.cvcCheck(StripeJsonUtils.optString(jsonObject, FIELD_CVC_CHECK));
        builder.funding(Card.asFundingType(StripeJsonUtils.optString(jsonObject, FIELD_FUNDING)));
        builder.fingerprint(StripeJsonUtils.optString(jsonObject, FIELD_FINGERPRINT));
        builder.id(StripeJsonUtils.optString(jsonObject, FIELD_ID));
        builder.last4(StripeJsonUtils.optString(jsonObject, FIELD_LAST4));
        builder.name(StripeJsonUtils.optString(jsonObject, FIELD_NAME));
        return builder.build();
    }

    public Card(String number, Integer expMonth, Integer expYear, String cvc, String name, String addressLine1, String addressLine2, String addressCity, String addressState, String addressZip, String addressCountry, String brand, @Size(value=4L) String last4, String fingerprint, String funding, String country, String currency, String id) {
        this.number = StripeTextUtils.nullIfBlank(this.normalizeCardNumber(number));
        this.expMonth = expMonth;
        this.expYear = expYear;
        this.cvc = StripeTextUtils.nullIfBlank(cvc);
        this.name = StripeTextUtils.nullIfBlank(name);
        this.addressLine1 = StripeTextUtils.nullIfBlank(addressLine1);
        this.addressLine2 = StripeTextUtils.nullIfBlank(addressLine2);
        this.addressCity = StripeTextUtils.nullIfBlank(addressCity);
        this.addressState = StripeTextUtils.nullIfBlank(addressState);
        this.addressZip = StripeTextUtils.nullIfBlank(addressZip);
        this.addressCountry = StripeTextUtils.nullIfBlank(addressCountry);
        this.brand = Card.asCardBrand(brand) == null ? this.getBrand() : brand;
        this.last4 = StripeTextUtils.nullIfBlank(last4) == null ? this.getLast4() : last4;
        this.fingerprint = StripeTextUtils.nullIfBlank(fingerprint);
        this.funding = Card.asFundingType(funding);
        this.country = StripeTextUtils.nullIfBlank(country);
        this.currency = StripeTextUtils.nullIfBlank(currency);
        this.id = StripeTextUtils.nullIfBlank(id);
    }

    public Card(String number, Integer expMonth, Integer expYear, String cvc, String name, String addressLine1, String addressLine2, String addressCity, String addressState, String addressZip, String addressCountry, String currency) {
        this(number, expMonth, expYear, cvc, name, addressLine1, addressLine2, addressCity, addressState, addressZip, addressCountry, null, null, null, null, null, currency, null);
    }

    public Card(String number, Integer expMonth, Integer expYear, String cvc) {
        this(number, expMonth, expYear, cvc, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public boolean validateCard() {
        return this.validateCard(Calendar.getInstance());
    }

    public boolean validateNumber() {
        return CardUtils.isValidCardNumber(this.number);
    }

    public boolean validateExpiryDate() {
        return this.validateExpiryDate(Calendar.getInstance());
    }

    public boolean validateCVC() {
        if (StripeTextUtils.isBlank(this.cvc)) {
            return false;
        }
        String cvcValue = this.cvc.trim();
        String updatedType = this.getBrand();
        boolean validLength = updatedType == null && cvcValue.length() >= 3 && cvcValue.length() <= 4 || AMERICAN_EXPRESS.equals(updatedType) && cvcValue.length() == 4 || cvcValue.length() == 3;
        return ModelUtils.isWholePositiveNumber(cvcValue) && validLength;
    }

    public boolean validateExpMonth() {
        return this.expMonth != null && this.expMonth >= 1 && this.expMonth <= 12;
    }

    boolean validateExpYear(Calendar now) {
        return this.expYear != null && !ModelUtils.hasYearPassed(this.expYear, now);
    }

    public String getNumber() {
        return this.number;
    }

    @NonNull
    public List<String> getLoggingTokens() {
        return this.loggingTokens;
    }

    @NonNull
    public Card addLoggingToken(@NonNull String loggingToken) {
        this.loggingTokens.add(loggingToken);
        return this;
    }

    @Deprecated
    public void setNumber(String number) {
        this.number = number;
        this.brand = null;
        this.last4 = null;
    }

    public String getCVC() {
        return this.cvc;
    }

    @Deprecated
    public void setCVC(String cvc) {
        this.cvc = cvc;
    }

    @Nullable
    @IntRange(from=1L, to=12L)
    public Integer getExpMonth() {
        return this.expMonth;
    }

    @Deprecated
    public void setExpMonth(@Nullable @IntRange(from=1L, to=12L) Integer expMonth) {
        this.expMonth = expMonth;
    }

    public Integer getExpYear() {
        return this.expYear;
    }

    @Deprecated
    public void setExpYear(Integer expYear) {
        this.expYear = expYear;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getAddressCity() {
        return this.addressCity;
    }

    public void setAddressCity(String addressCity) {
        this.addressCity = addressCity;
    }

    public String getAddressZip() {
        return this.addressZip;
    }

    public void setAddressZip(String addressZip) {
        this.addressZip = addressZip;
    }

    public String getAddressState() {
        return this.addressState;
    }

    public void setAddressState(String addressState) {
        this.addressState = addressState;
    }

    public String getAddressCountry() {
        return this.addressCountry;
    }

    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getLast4() {
        if (!StripeTextUtils.isBlank(this.last4)) {
            return this.last4;
        }
        if (this.number != null && this.number.length() > 4) {
            this.last4 = this.number.substring(this.number.length() - 4, this.number.length());
            return this.last4;
        }
        return null;
    }

    @Deprecated
    public String getType() {
        return this.getBrand();
    }

    public String getBrand() {
        if (StripeTextUtils.isBlank(this.brand) && !StripeTextUtils.isBlank(this.number)) {
            this.brand = CardUtils.getPossibleCardType(this.number);
        }
        return this.brand;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    @Nullable
    public String getFunding() {
        return this.funding;
    }

    public String getCountry() {
        return this.country;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAddressLine1Check() {
        return this.addressLine1Check;
    }

    @Nullable
    public String getAddressZipCheck() {
        return this.addressZipCheck;
    }

    @Nullable
    public String getCustomerId() {
        return this.customerId;
    }

    @Nullable
    public String getCvcCheck() {
        return this.cvcCheck;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(object, FIELD_NAME, this.name);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_ADDRESS_CITY, this.addressCity);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_ADDRESS_COUNTRY, this.addressCountry);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_ADDRESS_LINE1, this.addressLine1);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_ADDRESS_LINE1_CHECK, this.addressLine1Check);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_ADDRESS_LINE2, this.addressLine2);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_ADDRESS_STATE, this.addressState);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_ADDRESS_ZIP, this.addressZip);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_ADDRESS_ZIP_CHECK, this.addressZipCheck);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_BRAND, this.brand);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_CURRENCY, this.currency);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_COUNTRY, this.country);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_CUSTOMER, this.customerId);
        StripeJsonUtils.putIntegerIfNotNull(object, FIELD_EXP_MONTH, this.expMonth);
        StripeJsonUtils.putIntegerIfNotNull(object, FIELD_EXP_YEAR, this.expYear);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_FINGERPRINT, this.fingerprint);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_FUNDING, this.funding);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_CVC_CHECK, this.cvcCheck);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_LAST4, this.last4);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_ID, this.id);
        StripeJsonUtils.putStringIfNotNull(object, FIELD_OBJECT, VALUE_CARD);
        return object;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FIELD_NAME, this.name);
        map.put(FIELD_ADDRESS_CITY, this.addressCity);
        map.put(FIELD_ADDRESS_COUNTRY, this.addressCountry);
        map.put(FIELD_ADDRESS_LINE1, this.addressLine1);
        map.put(FIELD_ADDRESS_LINE1_CHECK, this.addressLine1Check);
        map.put(FIELD_ADDRESS_LINE2, this.addressLine2);
        map.put(FIELD_ADDRESS_STATE, this.addressState);
        map.put(FIELD_ADDRESS_ZIP, this.addressZip);
        map.put(FIELD_ADDRESS_ZIP_CHECK, this.addressZipCheck);
        map.put(FIELD_BRAND, this.brand);
        map.put(FIELD_CURRENCY, this.currency);
        map.put(FIELD_COUNTRY, this.country);
        map.put(FIELD_CUSTOMER, this.customerId);
        map.put(FIELD_CVC_CHECK, this.cvcCheck);
        map.put(FIELD_EXP_MONTH, this.expMonth);
        map.put(FIELD_EXP_YEAR, this.expYear);
        map.put(FIELD_FINGERPRINT, this.fingerprint);
        map.put(FIELD_FUNDING, this.funding);
        map.put(FIELD_ID, this.id);
        map.put(FIELD_LAST4, this.last4);
        map.put(FIELD_OBJECT, VALUE_CARD);
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }

    boolean validateCard(Calendar now) {
        if (this.cvc == null) {
            return this.validateNumber() && this.validateExpiryDate(now);
        }
        return this.validateNumber() && this.validateExpiryDate(now) && this.validateCVC();
    }

    boolean validateExpiryDate(Calendar now) {
        if (!this.validateExpMonth()) {
            return false;
        }
        if (!this.validateExpYear(now)) {
            return false;
        }
        return !ModelUtils.hasMonthPassed(this.expYear, this.expMonth, now);
    }

    private Card(Builder builder) {
        this.number = StripeTextUtils.nullIfBlank(this.normalizeCardNumber(builder.number));
        this.expMonth = builder.expMonth;
        this.expYear = builder.expYear;
        this.cvc = StripeTextUtils.nullIfBlank(builder.cvc);
        this.name = StripeTextUtils.nullIfBlank(builder.name);
        this.addressLine1 = StripeTextUtils.nullIfBlank(builder.addressLine1);
        this.addressLine1Check = StripeTextUtils.nullIfBlank(builder.addressLine1Check);
        this.addressLine2 = StripeTextUtils.nullIfBlank(builder.addressLine2);
        this.addressCity = StripeTextUtils.nullIfBlank(builder.addressCity);
        this.addressState = StripeTextUtils.nullIfBlank(builder.addressState);
        this.addressZip = StripeTextUtils.nullIfBlank(builder.addressZip);
        this.addressZipCheck = StripeTextUtils.nullIfBlank(builder.addressZipCheck);
        this.addressCountry = StripeTextUtils.nullIfBlank(builder.addressCountry);
        this.last4 = StripeTextUtils.nullIfBlank(builder.last4) == null ? this.getLast4() : builder.last4;
        this.brand = Card.asCardBrand(builder.brand) == null ? this.getBrand() : builder.brand;
        this.fingerprint = StripeTextUtils.nullIfBlank(builder.fingerprint);
        this.funding = Card.asFundingType(builder.funding);
        this.country = StripeTextUtils.nullIfBlank(builder.country);
        this.currency = StripeTextUtils.nullIfBlank(builder.currency);
        this.customerId = StripeTextUtils.nullIfBlank(builder.customer);
        this.cvcCheck = StripeTextUtils.nullIfBlank(builder.cvcCheck);
        this.id = StripeTextUtils.nullIfBlank(builder.id);
    }

    private String normalizeCardNumber(String number) {
        if (number == null) {
            return null;
        }
        return number.trim().replaceAll("\\s+|-", "");
    }

    public static class Builder {
        private final String number;
        private final String cvc;
        private final Integer expMonth;
        private final Integer expYear;
        private String name;
        private String addressLine1;
        private String addressLine1Check;
        private String addressLine2;
        private String addressCity;
        private String addressState;
        private String addressZip;
        private String addressZipCheck;
        private String addressCountry;
        private String brand;
        private String funding;
        @Size(value=4L)
        private String last4;
        private String fingerprint;
        private String country;
        private String currency;
        private String customer;
        private String cvcCheck;
        private String id;

        public Builder(String number, @IntRange(from=1L, to=12L) Integer expMonth, @IntRange(from=0L) Integer expYear, String cvc) {
            this.number = number;
            this.expMonth = expMonth;
            this.expYear = expYear;
            this.cvc = cvc;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addressLine1(String address) {
            this.addressLine1 = address;
            return this;
        }

        public Builder addressLine1Check(String addressLine1Check) {
            this.addressLine1Check = addressLine1Check;
            return this;
        }

        public Builder addressLine2(String address) {
            this.addressLine2 = address;
            return this;
        }

        public Builder addressCity(String city) {
            this.addressCity = city;
            return this;
        }

        public Builder addressState(String state) {
            this.addressState = state;
            return this;
        }

        public Builder addressZip(String zip) {
            this.addressZip = zip;
            return this;
        }

        public Builder addressZipCheck(String zipCheck) {
            this.addressZipCheck = zipCheck;
            return this;
        }

        public Builder addressCountry(String country) {
            this.addressCountry = country;
            return this;
        }

        public Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder funding(String funding) {
            this.funding = funding;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder customer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder cvcCheck(String cvcCheck) {
            this.cvcCheck = cvcCheck;
            return this;
        }

        public Builder last4(String last4) {
            this.last4 = last4;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Card build() {
            return new Card(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FundingType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CardBrand {
    }
}

