/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.SourceCardData;
import com.stripe.android.model.SourceCodeVerification;
import com.stripe.android.model.SourceOwner;
import com.stripe.android.model.SourceReceiver;
import com.stripe.android.model.SourceRedirect;
import com.stripe.android.model.SourceSepaDebitData;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.model.StripeSourceTypeModel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class Source
extends StripeJsonModel
implements StripePaymentSource {
    static final String VALUE_SOURCE = "source";
    public static final String BITCOIN = "bitcoin";
    public static final String CARD = "card";
    public static final String THREE_D_SECURE = "three_d_secure";
    public static final String GIROPAY = "giropay";
    public static final String SEPA_DEBIT = "sepa_debit";
    public static final String IDEAL = "ideal";
    public static final String SOFORT = "sofort";
    public static final String BANCONTACT = "bancontact";
    public static final String UNKNOWN = "unknown";
    public static final Set<String> MODELED_TYPES = new HashSet<String>();
    public static final String PENDING = "pending";
    public static final String CHARGEABLE = "chargeable";
    public static final String CONSUMED = "consumed";
    public static final String CANCELED = "canceled";
    public static final String FAILED = "failed";
    public static final String REUSABLE = "reusable";
    public static final String SINGLE_USE = "single_use";
    public static final String REDIRECT = "redirect";
    public static final String RECEIVER = "receiver";
    public static final String CODE_VERIFICATION = "code_verification";
    public static final String NONE = "none";
    static final String EURO = "eur";
    static final String USD = "usd";
    static final String FIELD_ID = "id";
    static final String FIELD_OBJECT = "object";
    static final String FIELD_AMOUNT = "amount";
    static final String FIELD_CLIENT_SECRET = "client_secret";
    static final String FIELD_CODE_VERIFICATION = "code_verification";
    static final String FIELD_CREATED = "created";
    static final String FIELD_CURRENCY = "currency";
    static final String FIELD_FLOW = "flow";
    static final String FIELD_LIVEMODE = "livemode";
    static final String FIELD_METADATA = "metadata";
    static final String FIELD_OWNER = "owner";
    static final String FIELD_RECEIVER = "receiver";
    static final String FIELD_REDIRECT = "redirect";
    static final String FIELD_STATUS = "status";
    static final String FIELD_TYPE = "type";
    static final String FIELD_USAGE = "usage";
    private String mId;
    private Long mAmount;
    private String mClientSecret;
    private SourceCodeVerification mCodeVerification;
    private Long mCreated;
    private String mCurrency;
    private String mTypeRaw;
    private String mFlow;
    private Boolean mLiveMode;
    private Map<String, String> mMetaData;
    private SourceOwner mOwner;
    private SourceReceiver mReceiver;
    private SourceRedirect mRedirect;
    private String mStatus;
    private Map<String, Object> mSourceTypeData;
    private StripeSourceTypeModel mSourceTypeModel;
    private String mType;
    private String mUsage;

    Source(String id, Long amount, String clientSecret, SourceCodeVerification codeVerification, Long created, String currency, String flow, Boolean liveMode, Map<String, String> metaData, SourceOwner owner, SourceReceiver receiver, SourceRedirect redirect, String status, Map<String, Object> sourceTypeData, StripeSourceTypeModel sourceTypeModel, String type, String rawType, String usage) {
        this.mId = id;
        this.mAmount = amount;
        this.mClientSecret = clientSecret;
        this.mCodeVerification = codeVerification;
        this.mCreated = created;
        this.mCurrency = currency;
        this.mFlow = flow;
        this.mLiveMode = liveMode;
        this.mMetaData = metaData;
        this.mOwner = owner;
        this.mReceiver = receiver;
        this.mRedirect = redirect;
        this.mStatus = status;
        this.mSourceTypeData = sourceTypeData;
        this.mSourceTypeModel = sourceTypeModel;
        this.mType = type;
        this.mTypeRaw = rawType;
        this.mUsage = usage;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    public Long getAmount() {
        return this.mAmount;
    }

    public String getClientSecret() {
        return this.mClientSecret;
    }

    public SourceCodeVerification getCodeVerification() {
        return this.mCodeVerification;
    }

    public Long getCreated() {
        return this.mCreated;
    }

    public String getCurrency() {
        return this.mCurrency;
    }

    public String getFlow() {
        return this.mFlow;
    }

    public Boolean isLiveMode() {
        return this.mLiveMode;
    }

    public Map<String, String> getMetaData() {
        return this.mMetaData;
    }

    public SourceOwner getOwner() {
        return this.mOwner;
    }

    public SourceReceiver getReceiver() {
        return this.mReceiver;
    }

    public SourceRedirect getRedirect() {
        return this.mRedirect;
    }

    public String getStatus() {
        return this.mStatus;
    }

    public Map<String, Object> getSourceTypeData() {
        return this.mSourceTypeData;
    }

    public StripeSourceTypeModel getSourceTypeModel() {
        return this.mSourceTypeModel;
    }

    public String getType() {
        return this.mType;
    }

    public String getTypeRaw() {
        return this.mTypeRaw;
    }

    public String getUsage() {
        return this.mUsage;
    }

    public void setId(String id) {
        this.mId = id;
    }

    public void setAmount(long amount) {
        this.mAmount = amount;
    }

    public void setClientSecret(String clientSecret) {
        this.mClientSecret = clientSecret;
    }

    public void setCodeVerification(SourceCodeVerification codeVerification) {
        this.mCodeVerification = codeVerification;
    }

    public void setCreated(long created) {
        this.mCreated = created;
    }

    public void setCurrency(String currency) {
        this.mCurrency = currency;
    }

    public void setFlow(String flow) {
        this.mFlow = flow;
    }

    public void setLiveMode(boolean liveMode) {
        this.mLiveMode = liveMode;
    }

    public void setMetaData(Map<String, String> metaData) {
        this.mMetaData = metaData;
    }

    public void setOwner(SourceOwner owner) {
        this.mOwner = owner;
    }

    public void setReceiver(SourceReceiver receiver) {
        this.mReceiver = receiver;
    }

    public void setRedirect(SourceRedirect redirect) {
        this.mRedirect = redirect;
    }

    public void setStatus(String status) {
        this.mStatus = status;
    }

    public void setSourceTypeData(Map<String, Object> sourceTypeData) {
        this.mSourceTypeData = sourceTypeData;
    }

    public void setTypeRaw(@NonNull @Size(min=1L) String typeRaw) {
        this.mTypeRaw = typeRaw;
        this.setType(UNKNOWN);
    }

    public void setType(String type) {
        this.mType = type;
    }

    public void setUsage(String usage) {
        this.mUsage = usage;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(FIELD_ID, this.mId);
        hashMap.put(FIELD_AMOUNT, this.mAmount);
        hashMap.put(FIELD_CLIENT_SECRET, this.mClientSecret);
        Source.putStripeJsonModelMapIfNotNull(hashMap, "code_verification", this.mCodeVerification);
        hashMap.put(FIELD_CREATED, this.mCreated);
        hashMap.put(FIELD_CURRENCY, this.mCurrency);
        hashMap.put(FIELD_FLOW, this.mFlow);
        hashMap.put(FIELD_LIVEMODE, this.mLiveMode);
        hashMap.put(FIELD_METADATA, this.mMetaData);
        Source.putStripeJsonModelMapIfNotNull(hashMap, FIELD_OWNER, this.mOwner);
        Source.putStripeJsonModelMapIfNotNull(hashMap, "receiver", this.mReceiver);
        Source.putStripeJsonModelMapIfNotNull(hashMap, "redirect", this.mRedirect);
        hashMap.put(this.mTypeRaw, this.mSourceTypeData);
        hashMap.put(FIELD_STATUS, this.mStatus);
        hashMap.put(FIELD_TYPE, this.mTypeRaw);
        hashMap.put(FIELD_USAGE, this.mUsage);
        StripeNetworkUtils.removeNullAndEmptyParams(hashMap);
        return hashMap;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            JSONObject sourceTypeJsonObject;
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_ID, this.mId);
            jsonObject.put(FIELD_OBJECT, (Object)VALUE_SOURCE);
            jsonObject.put(FIELD_AMOUNT, (Object)this.mAmount);
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_CLIENT_SECRET, this.mClientSecret);
            Source.putStripeJsonModelIfNotNull(jsonObject, "code_verification", this.mCodeVerification);
            jsonObject.put(FIELD_CREATED, (Object)this.mCreated);
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_CURRENCY, this.mCurrency);
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_FLOW, this.mFlow);
            jsonObject.put(FIELD_LIVEMODE, (Object)this.mLiveMode);
            JSONObject metaDataObject = StripeJsonUtils.mapToJsonObject(this.mMetaData);
            if (metaDataObject != null) {
                jsonObject.put(FIELD_METADATA, (Object)metaDataObject);
            }
            if ((sourceTypeJsonObject = StripeJsonUtils.mapToJsonObject(this.mSourceTypeData)) != null) {
                jsonObject.put(this.mTypeRaw, (Object)sourceTypeJsonObject);
            }
            Source.putStripeJsonModelIfNotNull(jsonObject, FIELD_OWNER, this.mOwner);
            Source.putStripeJsonModelIfNotNull(jsonObject, "receiver", this.mReceiver);
            Source.putStripeJsonModelIfNotNull(jsonObject, "redirect", this.mRedirect);
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_STATUS, this.mStatus);
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_TYPE, this.mTypeRaw);
            StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_USAGE, this.mUsage);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    @Nullable
    public static Source fromString(@Nullable String jsonString) {
        try {
            return Source.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static Source fromJson(@Nullable JSONObject jsonObject) {
        String type;
        if (jsonObject == null || !VALUE_SOURCE.equals(jsonObject.optString(FIELD_OBJECT))) {
            return null;
        }
        String id = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        Long amount = StripeJsonUtils.optLong(jsonObject, FIELD_AMOUNT);
        String clientSecret = StripeJsonUtils.optString(jsonObject, FIELD_CLIENT_SECRET);
        SourceCodeVerification codeVerification = Source.optStripeJsonModel(jsonObject, "code_verification", SourceCodeVerification.class);
        Long created = StripeJsonUtils.optLong(jsonObject, FIELD_CREATED);
        String currency = StripeJsonUtils.optString(jsonObject, FIELD_CURRENCY);
        String flow = Source.asSourceFlow(StripeJsonUtils.optString(jsonObject, FIELD_FLOW));
        Boolean liveMode = jsonObject.optBoolean(FIELD_LIVEMODE);
        Map<String, String> metadata = StripeJsonUtils.jsonObjectToStringMap(jsonObject.optJSONObject(FIELD_METADATA));
        SourceOwner owner = Source.optStripeJsonModel(jsonObject, FIELD_OWNER, SourceOwner.class);
        SourceReceiver receiver = Source.optStripeJsonModel(jsonObject, "receiver", SourceReceiver.class);
        SourceRedirect redirect = Source.optStripeJsonModel(jsonObject, "redirect", SourceRedirect.class);
        String status = Source.asSourceStatus(StripeJsonUtils.optString(jsonObject, FIELD_STATUS));
        String typeRaw = StripeJsonUtils.optString(jsonObject, FIELD_TYPE);
        if (typeRaw == null) {
            typeRaw = UNKNOWN;
        }
        if ((type = Source.asSourceType(typeRaw)) == null) {
            type = UNKNOWN;
        }
        Map<String, Object> sourceTypeData = StripeJsonUtils.jsonObjectToMap(jsonObject.optJSONObject(typeRaw));
        StripeSourceTypeModel sourceTypeModel = MODELED_TYPES.contains(typeRaw) ? Source.optStripeJsonModel(jsonObject, typeRaw, StripeSourceTypeModel.class) : null;
        String usage = Source.asUsage(StripeJsonUtils.optString(jsonObject, FIELD_USAGE));
        return new Source(id, amount, clientSecret, codeVerification, created, currency, flow, liveMode, metadata, owner, receiver, redirect, status, sourceTypeData, sourceTypeModel, type, typeRaw, usage);
    }

    @Nullable
    static <T extends StripeJsonModel> T optStripeJsonModel(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String key, Class<T> type) {
        if (!jsonObject.has(key)) {
            return null;
        }
        switch (key) {
            case "code_verification": {
                return (T)((StripeJsonModel)type.cast(SourceCodeVerification.fromJson(jsonObject.optJSONObject("code_verification"))));
            }
            case "owner": {
                return (T)((StripeJsonModel)type.cast(SourceOwner.fromJson(jsonObject.optJSONObject(FIELD_OWNER))));
            }
            case "receiver": {
                return (T)((StripeJsonModel)type.cast(SourceReceiver.fromJson(jsonObject.optJSONObject("receiver"))));
            }
            case "redirect": {
                return (T)((StripeJsonModel)type.cast(SourceRedirect.fromJson(jsonObject.optJSONObject("redirect"))));
            }
            case "card": {
                return (T)((StripeJsonModel)type.cast(SourceCardData.fromJson(jsonObject.optJSONObject(CARD))));
            }
            case "sepa_debit": {
                return (T)((StripeJsonModel)type.cast(SourceSepaDebitData.fromJson(jsonObject.optJSONObject(SEPA_DEBIT))));
            }
        }
        return null;
    }

    @Nullable
    static String asSourceStatus(@Nullable String sourceStatus) {
        if (PENDING.equals(sourceStatus)) {
            return PENDING;
        }
        if (CHARGEABLE.equals(sourceStatus)) {
            return CHARGEABLE;
        }
        if (CONSUMED.equals(sourceStatus)) {
            return CONSUMED;
        }
        if (CANCELED.equals(sourceStatus)) {
            return CANCELED;
        }
        if (FAILED.equals(sourceStatus)) {
            return FAILED;
        }
        return null;
    }

    @Nullable
    static String asSourceType(@Nullable String sourceType) {
        if (BITCOIN.equals(sourceType)) {
            return BITCOIN;
        }
        if (CARD.equals(sourceType)) {
            return CARD;
        }
        if (THREE_D_SECURE.equals(sourceType)) {
            return THREE_D_SECURE;
        }
        if (GIROPAY.equals(sourceType)) {
            return GIROPAY;
        }
        if (SEPA_DEBIT.equals(sourceType)) {
            return SEPA_DEBIT;
        }
        if (IDEAL.equals(sourceType)) {
            return IDEAL;
        }
        if (SOFORT.equals(sourceType)) {
            return SOFORT;
        }
        if (BANCONTACT.equals(sourceType)) {
            return BANCONTACT;
        }
        if (UNKNOWN.equals(sourceType)) {
            return UNKNOWN;
        }
        return null;
    }

    @Nullable
    static String asUsage(@Nullable String usage) {
        if (REUSABLE.equals(usage)) {
            return REUSABLE;
        }
        if (SINGLE_USE.equals(usage)) {
            return SINGLE_USE;
        }
        return null;
    }

    @Nullable
    static String asSourceFlow(@Nullable String sourceFlow) {
        if ("redirect".equals(sourceFlow)) {
            return "redirect";
        }
        if ("receiver".equals(sourceFlow)) {
            return "receiver";
        }
        if ("code_verification".equals(sourceFlow)) {
            return "code_verification";
        }
        if (NONE.equals(sourceFlow)) {
            return NONE;
        }
        return null;
    }

    static {
        MODELED_TYPES.add(CARD);
        MODELED_TYPES.add(SEPA_DEBIT);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceFlow {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Usage {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceType {
    }
}

