/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.model.StripeJsonModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EphemeralKey
extends StripeJsonModel
implements Parcelable {
    static final String FIELD_CREATED = "created";
    static final String FIELD_EXPIRES = "expires";
    static final String FIELD_SECRET = "secret";
    static final String FIELD_LIVEMODE = "livemode";
    static final String FIELD_OBJECT = "object";
    static final String FIELD_ID = "id";
    static final String FIELD_ASSOCIATED_OBJECTS = "associated_objects";
    static final String FIELD_TYPE = "type";
    static final String NULL = "null";
    private long mCreated;
    @NonNull
    private String mCustomerId;
    private long mExpires;
    @NonNull
    private String mId;
    private boolean mLiveMode;
    @NonNull
    private String mObject;
    @NonNull
    private String mSecret;
    @NonNull
    private String mType;
    static final Parcelable.Creator<EphemeralKey> CREATOR = new Parcelable.Creator<EphemeralKey>(){

        public EphemeralKey createFromParcel(Parcel in) {
            return new EphemeralKey(in);
        }

        public EphemeralKey[] newArray(int size) {
            return new EphemeralKey[size];
        }
    };

    private EphemeralKey(Parcel in) {
        this.mCreated = in.readLong();
        this.mCustomerId = in.readString();
        this.mExpires = in.readLong();
        this.mId = in.readString();
        this.mLiveMode = in.readInt() == 1;
        this.mObject = in.readString();
        this.mSecret = in.readString();
        this.mType = in.readString();
    }

    private EphemeralKey(long created, @NonNull String customerId, long expires, @NonNull String id, boolean liveMode, @NonNull String object, @NonNull String secret, @NonNull String type) {
        this.mCreated = created;
        this.mCustomerId = customerId;
        this.mExpires = expires;
        this.mId = id;
        this.mLiveMode = liveMode;
        this.mObject = object;
        this.mSecret = secret;
        this.mType = type;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONArray associatedObjectsArray = new JSONArray();
        JSONObject associatedObject = new JSONObject();
        try {
            jsonObject.put(FIELD_CREATED, this.mCreated);
            jsonObject.put(FIELD_EXPIRES, this.mExpires);
            jsonObject.put(FIELD_OBJECT, (Object)this.mObject);
            jsonObject.put(FIELD_ID, (Object)this.mId);
            jsonObject.put(FIELD_SECRET, (Object)this.mSecret);
            jsonObject.put(FIELD_LIVEMODE, this.mLiveMode);
            associatedObject.put(FIELD_TYPE, (Object)this.mType);
            associatedObject.put(FIELD_ID, (Object)this.mCustomerId);
            associatedObjectsArray.put((Object)associatedObject);
            jsonObject.put(FIELD_ASSOCIATED_OBJECTS, (Object)associatedObjectsArray);
        }
        catch (JSONException impossible) {
            throw new IllegalArgumentException("JSONObject creation exception thrown.");
        }
        return jsonObject;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FIELD_CREATED, this.mCreated);
        map.put(FIELD_EXPIRES, this.mExpires);
        map.put(FIELD_OBJECT, this.mObject);
        map.put(FIELD_ID, this.mId);
        map.put(FIELD_SECRET, this.mSecret);
        map.put(FIELD_LIVEMODE, this.mLiveMode);
        ArrayList associatedObjectsList = new ArrayList();
        HashMap<String, String> associatedObjectMap = new HashMap<String, String>();
        associatedObjectMap.put(FIELD_ID, this.mCustomerId);
        associatedObjectMap.put(FIELD_TYPE, this.mType);
        associatedObjectsList.add(associatedObjectMap);
        map.put(FIELD_ASSOCIATED_OBJECTS, associatedObjectsList);
        return map;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mCreated);
        out.writeString(this.mCustomerId);
        out.writeLong(this.mExpires);
        out.writeString(this.mId);
        out.writeInt(this.mLiveMode ? 1 : 0);
        out.writeString(this.mObject);
        out.writeString(this.mSecret);
        out.writeString(this.mType);
    }

    long getCreated() {
        return this.mCreated;
    }

    @NonNull
    String getCustomerId() {
        return this.mCustomerId;
    }

    long getExpires() {
        return this.mExpires;
    }

    @VisibleForTesting
    void setExpires(long value) {
        this.mExpires = value;
    }

    @NonNull
    String getId() {
        return this.mId;
    }

    boolean isLiveMode() {
        return this.mLiveMode;
    }

    @NonNull
    String getObject() {
        return this.mObject;
    }

    @NonNull
    String getSecret() {
        return this.mSecret;
    }

    @NonNull
    String getType() {
        return this.mType;
    }

    @Nullable
    static EphemeralKey fromString(@Nullable String rawJson) {
        if (rawJson == null) {
            return null;
        }
        try {
            JSONObject object = new JSONObject(rawJson);
            return EphemeralKey.fromJson(object);
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    static EphemeralKey fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        try {
            long created = jsonObject.getLong(FIELD_CREATED);
            long expires = jsonObject.getLong(FIELD_EXPIRES);
            String id = jsonObject.getString(FIELD_ID);
            boolean liveMode = jsonObject.getBoolean(FIELD_LIVEMODE);
            String object = jsonObject.getString(FIELD_OBJECT);
            String secret = jsonObject.getString(FIELD_SECRET);
            JSONArray associatedObjectArray = jsonObject.getJSONArray(FIELD_ASSOCIATED_OBJECTS);
            JSONObject typeObject = associatedObjectArray.getJSONObject(0);
            String type = typeObject.getString(FIELD_TYPE);
            String customerId = typeObject.getString(FIELD_ID);
            return new EphemeralKey(created, customerId, expires, id, liveMode, object, secret, type);
        }
        catch (JSONException ignored) {
            return null;
        }
    }
}

