/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.net;

import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Source;
import com.stripe.android.net.PollingParameters;
import com.stripe.android.net.PollingResponse;
import com.stripe.android.net.SourceRetriever;
import com.stripe.android.net.StripeApiHandler;

@Deprecated
class PollingSyncNetworkHandler {
    @NonNull
    private final String mSourceId;
    @NonNull
    private final String mClientSecret;
    @NonNull
    private final String mPublishableKey;
    @NonNull
    private final PollingParameters mPollingParameters;
    @NonNull
    private SourceRetriever mSourceRetriever;
    @NonNull
    private TimeRetriever mTimeRetriever;
    private long mTimeOutMs;

    PollingSyncNetworkHandler(@NonNull String sourceId, @NonNull String clientSecret, @NonNull String publishableKey, @Nullable Integer timeOutMs, @Nullable SourceRetriever sourceRetriever, @Nullable TimeRetriever timeRetriever, @NonNull PollingParameters pollingParameters) {
        this.mSourceId = sourceId;
        this.mClientSecret = clientSecret;
        this.mPublishableKey = publishableKey;
        this.mPollingParameters = pollingParameters;
        this.mTimeOutMs = timeOutMs == null ? this.mPollingParameters.getDefaultTimeoutMs() : Math.min(timeOutMs.longValue(), this.mPollingParameters.getMaxTimeoutMs());
        this.mSourceRetriever = sourceRetriever == null ? PollingSyncNetworkHandler.generateSourceRetriever() : sourceRetriever;
        this.mTimeRetriever = timeRetriever == null ? PollingSyncNetworkHandler.generateTimeRetriever() : timeRetriever;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    PollingResponse pollForSourceUpdate() {
        long timeWaited;
        Source source = null;
        int errorCount = 0;
        long delayMs = this.mPollingParameters.getInitialDelayMs();
        long startTime = this.mTimeRetriever.getCurrentTimeInMillis();
        while ((timeWaited = this.mTimeRetriever.getCurrentTimeInMillis() - startTime) <= this.mTimeOutMs) {
            try {
                source = this.mSourceRetriever.retrieveSource(this.mSourceId, this.mClientSecret, this.mPublishableKey);
                delayMs = this.mPollingParameters.getInitialDelayMs();
                errorCount = 0;
            }
            catch (StripeException stripeEx) {
                if (++errorCount >= this.mPollingParameters.getMaxRetryCount()) {
                    return new PollingResponse(source, stripeEx);
                }
                delayMs = Math.min(delayMs * (long)this.mPollingParameters.getPollingMultiplier(), this.mPollingParameters.getMaxDelayMs());
            }
            if (source != null) {
                switch (source.getStatus()) {
                    case "chargeable": {
                        return new PollingResponse(source, true, false);
                    }
                    case "consumed": {
                        return new PollingResponse(source, true, false);
                    }
                    case "canceled": {
                        return new PollingResponse(source, false, false);
                    }
                    case "failed": {
                        return new PollingResponse(source, false, false);
                    }
                }
            }
            try {
                Object object = this;
                synchronized (object) {
                    this.wait(delayMs);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (source == null || "pending".equals(source.getStatus())) continue;
        }
        return new PollingResponse(source, false, true);
    }

    @VisibleForTesting
    long getTimeOutMs() {
        return this.mTimeOutMs;
    }

    @NonNull
    private static SourceRetriever generateSourceRetriever() {
        return new SourceRetriever(){

            @Override
            public Source retrieveSource(@NonNull String sourceId, @NonNull String clientSecret, @NonNull String publishableKey) throws StripeException {
                return StripeApiHandler.retrieveSource(sourceId, clientSecret, publishableKey);
            }
        };
    }

    @NonNull
    private static TimeRetriever generateTimeRetriever() {
        return new TimeRetriever(){

            @Override
            public long getCurrentTimeInMillis() {
                return SystemClock.uptimeMillis();
            }
        };
    }

    static interface TimeRetriever {
        public long getCurrentTimeInMillis();
    }
}

