/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.util.StripeJsonUtils;
import com.stripe.android.util.StripeTextUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SourceReceiver
extends StripeJsonModel {
    private static final String FIELD_ADDRESS = "address";
    private static final String FIELD_AMOUNT_CHARGED = "amount_charged";
    private static final String FIELD_AMOUNT_RECEIVED = "amount_received";
    private static final String FIELD_AMOUNT_RETURNED = "amount_returned";
    private String mAddress;
    private long mAmountCharged;
    private long mAmountReceived;
    private long mAmountReturned;

    SourceReceiver(String address, long amountCharged, long amountReceived, long amountReturned) {
        this.mAddress = address;
        this.mAmountCharged = amountCharged;
        this.mAmountReceived = amountReceived;
        this.mAmountReturned = amountReturned;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public void setAddress(String address) {
        this.mAddress = address;
    }

    public long getAmountCharged() {
        return this.mAmountCharged;
    }

    public void setAmountCharged(long amountCharged) {
        this.mAmountCharged = amountCharged;
    }

    public long getAmountReceived() {
        return this.mAmountReceived;
    }

    public void setAmountReceived(long amountReceived) {
        this.mAmountReceived = amountReceived;
    }

    public long getAmountReturned() {
        return this.mAmountReturned;
    }

    public void setAmountReturned(long amountReturned) {
        this.mAmountReturned = amountReturned;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (!StripeTextUtils.isBlank(this.mAddress)) {
            hashMap.put(FIELD_ADDRESS, this.mAddress);
        }
        hashMap.put(FIELD_ADDRESS, this.mAddress);
        hashMap.put(FIELD_AMOUNT_CHARGED, this.mAmountCharged);
        hashMap.put(FIELD_AMOUNT_RECEIVED, this.mAmountReceived);
        hashMap.put(FIELD_AMOUNT_RETURNED, this.mAmountReturned);
        return hashMap;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_ADDRESS, this.mAddress);
        try {
            jsonObject.put(FIELD_AMOUNT_CHARGED, this.mAmountCharged);
            jsonObject.put(FIELD_AMOUNT_RECEIVED, this.mAmountReceived);
            jsonObject.put(FIELD_AMOUNT_RETURNED, this.mAmountReturned);
        }
        catch (JSONException jsonException) {
            return jsonObject;
        }
        return jsonObject;
    }

    @Nullable
    public static SourceReceiver fromString(@Nullable String jsonString) {
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            return SourceReceiver.fromJson(jsonObject);
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static SourceReceiver fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String address = StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS);
        return new SourceReceiver(address, jsonObject.optLong(FIELD_AMOUNT_CHARGED), jsonObject.optLong(FIELD_AMOUNT_RECEIVED), jsonObject.optLong(FIELD_AMOUNT_RETURNED));
    }
}

