/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BankAccount {
    public static final String TYPE_COMPANY = "company";
    public static final String TYPE_INDIVIDUAL = "individual";
    @Nullable
    private String mAccountHolderName;
    @Nullable
    private String mAccountHolderType;
    @Nullable
    private String mAccountNumber;
    @Nullable
    private String mBankName;
    @Nullable
    @Size(value=2L)
    private String mCountryCode;
    @Nullable
    @Size(value=3L)
    private String mCurrency;
    @Nullable
    private String mFingerprint;
    @Nullable
    private String mLast4;
    @Nullable
    private String mRoutingNumber;

    public BankAccount(@NonNull String accountNumber, @NonNull @Size(value=2L) String countryCode, @NonNull @Size(value=3L) String currency, @NonNull String routingNumber) {
        this.mAccountNumber = accountNumber;
        this.mCountryCode = countryCode;
        this.mCurrency = currency;
        this.mRoutingNumber = routingNumber;
    }

    public BankAccount(@Nullable String accountHolderName, @Nullable String accountHolderType, @Nullable String bankName, @Nullable @Size(value=2L) String countryCode, @Nullable @Size(value=3L) String currency, @Nullable String fingerprint, @Nullable String last4, @Nullable String routingNumber) {
        this.mAccountHolderName = accountHolderName;
        this.mAccountHolderType = accountHolderType;
        this.mBankName = bankName;
        this.mCountryCode = countryCode;
        this.mCurrency = currency;
        this.mFingerprint = fingerprint;
        this.mLast4 = last4;
        this.mRoutingNumber = routingNumber;
    }

    @Nullable
    public String getAccountNumber() {
        return this.mAccountNumber;
    }

    @Nullable
    public String getAccountHolderName() {
        return this.mAccountHolderName;
    }

    @NonNull
    public BankAccount setAccountHolderName(String accountHolderName) {
        this.mAccountHolderName = accountHolderName;
        return this;
    }

    @Nullable
    public String getAccountHolderType() {
        return this.mAccountHolderType;
    }

    @NonNull
    public BankAccount setAccountHolderType(String accountHolderType) {
        this.mAccountHolderType = accountHolderType;
        return this;
    }

    @Nullable
    public String getBankName() {
        return this.mBankName;
    }

    @Nullable
    @Size(value=2L)
    public String getCountryCode() {
        return this.mCountryCode;
    }

    @Nullable
    @Size(value=3L)
    public String getCurrency() {
        return this.mCurrency;
    }

    @Nullable
    public String getFingerprint() {
        return this.mFingerprint;
    }

    @Nullable
    public String getLast4() {
        return this.mLast4;
    }

    @Nullable
    public String getRoutingNumber() {
        return this.mRoutingNumber;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BankAccountType {
    }
}

