/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import com.stripe.android.R;

public class StripeEditText
extends AppCompatEditText {
    @Nullable
    private DeleteEmptyListener mDeleteEmptyListener;
    @Nullable
    private ColorStateList mCachedColorStateList;
    private boolean mShouldShowError;
    @ColorRes
    private int mDefaultErrorColorResId;
    @ColorInt
    private int mErrorColor;

    public StripeEditText(Context context) {
        super(context);
        this.initView();
    }

    public StripeEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public StripeEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return new SoftDeleteInputConnection(super.onCreateInputConnection(outAttrs), true);
    }

    public void setDeleteEmptyListener(DeleteEmptyListener deleteEmptyListener) {
        this.mDeleteEmptyListener = deleteEmptyListener;
    }

    public void setShouldShowError(boolean shouldShowError) {
        this.mShouldShowError = shouldShowError;
        if (this.mShouldShowError) {
            this.setTextColor(this.mErrorColor);
        } else {
            this.setTextColor(this.mCachedColorStateList);
        }
        this.refreshDrawableState();
    }

    @Nullable
    public ColorStateList getCachedColorStateList() {
        return this.mCachedColorStateList;
    }

    public boolean getShouldShowError() {
        return this.mShouldShowError;
    }

    @ColorInt
    public int getDefaultErrorColorInt() {
        this.determineDefaultErrorColor();
        int errorColor = Build.VERSION.SDK_INT >= 23 ? this.getResources().getColor(this.mDefaultErrorColorResId, null) : this.getResources().getColor(this.mDefaultErrorColorResId);
        return errorColor;
    }

    public void setErrorColor(@ColorInt int errorColor) {
        this.mErrorColor = errorColor;
    }

    static boolean isColorDark(@ColorInt int color2) {
        double luminescence = 0.299 * (double)Color.red((int)color2) + 0.587 * (double)Color.green((int)color2) + 0.114 * (double)Color.blue((int)color2);
        double luminescencePercentage = luminescence / 255.0;
        return !(luminescencePercentage > 0.5);
    }

    private void initView() {
        this.listenForDeleteEmpty();
        this.determineDefaultErrorColor();
        this.mCachedColorStateList = this.getTextColors();
    }

    private void determineDefaultErrorColor() {
        this.mCachedColorStateList = this.getTextColors();
        int color2 = this.mCachedColorStateList.getDefaultColor();
        this.mDefaultErrorColorResId = StripeEditText.isColorDark(color2) ? R.color.error_text_light_theme : R.color.error_text_dark_theme;
    }

    private void listenForDeleteEmpty() {
        this.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 67 && event.getAction() == 0 && StripeEditText.this.mDeleteEmptyListener != null && StripeEditText.this.length() == 0) {
                    StripeEditText.this.mDeleteEmptyListener.onDeleteEmpty();
                }
                return false;
            }
        });
    }

    private class SoftDeleteInputConnection
    extends InputConnectionWrapper {
        public SoftDeleteInputConnection(InputConnection target, boolean mutable) {
            super(target, mutable);
        }

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            if (this.getTextBeforeCursor(1, 0).length() == 0 && StripeEditText.this.mDeleteEmptyListener != null) {
                StripeEditText.this.mDeleteEmptyListener.onDeleteEmpty();
            }
            return super.deleteSurroundingText(beforeLength, afterLength);
        }
    }

    public static interface DeleteEmptyListener {
        public void onDeleteEmpty();
    }
}

