/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import com.stripe.android.util.CardUtils;
import com.stripe.android.util.StripeTextUtils;
import com.stripe.android.view.StripeEditText;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CardNumberEditText
extends StripeEditText {
    private static final int MAX_LENGTH_COMMON = 19;
    private static final int MAX_LENGTH_AMEX_DINERS = 17;
    private static final Integer[] SPACES_ARRAY_COMMON = new Integer[]{4, 9, 14};
    private static final Set<Integer> SPACE_SET_COMMON = new HashSet<Integer>(Arrays.asList(SPACES_ARRAY_COMMON));
    private static final Integer[] SPACES_ARRAY_AMEX = new Integer[]{4, 11};
    private static final Set<Integer> SPACE_SET_AMEX = new HashSet<Integer>(Arrays.asList(SPACES_ARRAY_AMEX));
    @VisibleForTesting
    String mCardBrand = "Unknown";
    private CardBrandChangeListener mCardBrandChangeListener;
    private CardNumberCompleteListener mCardNumberCompleteListener;
    private int mLengthMax = 19;
    private boolean mIgnoreChanges = false;
    private boolean mIsCardNumberValid = false;

    public CardNumberEditText(Context context) {
        super(context);
        this.listenForTextChanges();
    }

    public CardNumberEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.listenForTextChanges();
    }

    public CardNumberEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.listenForTextChanges();
    }

    @NonNull
    public String getCardBrand() {
        return this.mCardBrand;
    }

    @Nullable
    public String getCardNumber() {
        return this.mIsCardNumberValid ? StripeTextUtils.removeSpacesAndHyphens(this.getText().toString()) : null;
    }

    public int getLengthMax() {
        return this.mLengthMax;
    }

    public boolean isCardNumberValid() {
        return this.mIsCardNumberValid;
    }

    void setCardNumberCompleteListener(@NonNull CardNumberCompleteListener listener) {
        this.mCardNumberCompleteListener = listener;
    }

    void setCardBrandChangeListener(@NonNull CardBrandChangeListener listener) {
        this.mCardBrandChangeListener = listener;
        this.mCardBrandChangeListener.onCardBrandChanged(this.mCardBrand);
    }

    @VisibleForTesting
    int updateSelectionIndex(int newLength, int editActionStart, int editActionAddition) {
        int gapsJumped = 0;
        Set<Integer> gapSet = "American Express".equals(this.mCardBrand) ? SPACE_SET_AMEX : SPACE_SET_COMMON;
        boolean skipBack = false;
        for (Integer gap : gapSet) {
            if (editActionStart <= gap && editActionStart + editActionAddition > gap) {
                ++gapsJumped;
            }
            if (editActionAddition != 0 || editActionStart != gap + 1) continue;
            skipBack = true;
        }
        int newPosition = editActionStart + editActionAddition + gapsJumped;
        if (skipBack && newPosition > 0) {
            --newPosition;
        }
        return newPosition <= newLength ? newPosition : newLength;
    }

    private void listenForTextChanges() {
        this.addTextChangedListener(new TextWatcher(){
            int latestChangeStart;
            int latestInsertionSize;

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (!CardNumberEditText.this.mIgnoreChanges) {
                    this.latestChangeStart = start;
                    this.latestInsertionSize = after;
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (CardNumberEditText.this.mIgnoreChanges) {
                    return;
                }
                if (start < 4) {
                    CardNumberEditText.this.updateCardBrandFromNumber(s.toString());
                }
                if (start > 16) {
                    return;
                }
                String spacelessNumber = StripeTextUtils.removeSpacesAndHyphens(s.toString());
                if (spacelessNumber == null) {
                    return;
                }
                String[] cardParts = CardUtils.separateCardNumberGroups(spacelessNumber, CardNumberEditText.this.mCardBrand);
                StringBuilder formattedNumberBuilder = new StringBuilder();
                for (int i = 0; i < cardParts.length && cardParts[i] != null; ++i) {
                    if (i != 0) {
                        formattedNumberBuilder.append(' ');
                    }
                    formattedNumberBuilder.append(cardParts[i]);
                }
                String formattedNumber = formattedNumberBuilder.toString();
                int cursorPosition = CardNumberEditText.this.updateSelectionIndex(formattedNumber.length(), this.latestChangeStart, this.latestInsertionSize);
                CardNumberEditText.this.mIgnoreChanges = true;
                CardNumberEditText.this.setText(formattedNumber);
                CardNumberEditText.this.setSelection(cursorPosition);
                CardNumberEditText.this.mIgnoreChanges = false;
            }

            public void afterTextChanged(Editable s) {
                if (s.length() == CardNumberEditText.this.mLengthMax) {
                    boolean before = CardNumberEditText.this.mIsCardNumberValid;
                    CardNumberEditText.this.mIsCardNumberValid = CardUtils.isValidCardNumber(s.toString());
                    CardNumberEditText.this.setShouldShowError(!CardNumberEditText.this.mIsCardNumberValid);
                    if (!before && CardNumberEditText.this.mIsCardNumberValid && CardNumberEditText.this.mCardNumberCompleteListener != null) {
                        CardNumberEditText.this.mCardNumberCompleteListener.onCardNumberComplete();
                    }
                } else {
                    CardNumberEditText.this.mIsCardNumberValid = false;
                    CardNumberEditText.this.setShouldShowError(false);
                }
            }
        });
    }

    private void updateCardBrand(@NonNull String brand) {
        if (this.mCardBrand.equals(brand)) {
            return;
        }
        this.mCardBrand = brand;
        if (this.mCardBrandChangeListener != null) {
            this.mCardBrandChangeListener.onCardBrandChanged(this.mCardBrand);
        }
        int oldLength = this.mLengthMax;
        this.mLengthMax = CardNumberEditText.getLengthForBrand(this.mCardBrand);
        if (oldLength == this.mLengthMax) {
            return;
        }
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.mLengthMax)});
    }

    private void updateCardBrandFromNumber(String partialNumber) {
        this.updateCardBrand(CardUtils.getPossibleCardType(partialNumber));
    }

    private static int getLengthForBrand(String cardBrand) {
        if ("American Express".equals(cardBrand) || "Diners Club".equals(cardBrand)) {
            return 17;
        }
        return 19;
    }

    static interface CardBrandChangeListener {
        public void onCardBrandChanged(@NonNull String var1);
    }

    static interface CardNumberCompleteListener {
        public void onCardNumberComplete();
    }
}

