/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.net;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Source;
import com.stripe.android.net.PollingParameters;
import com.stripe.android.net.PollingResponse;
import com.stripe.android.net.PollingResponseHandler;
import com.stripe.android.net.SourceRetriever;
import com.stripe.android.net.StripeApiHandler;

class PollingNetworkHandler {
    private static final int SUCCESS = 1;
    private static final int PENDING = 2;
    private static final int FAILURE = 3;
    private static final int ERROR = -1;
    private static final int EXPIRED = -2;
    private final String mClientSecret;
    private final String mPublishableKey;
    private final String mSourceId;
    private final long mTimeoutMs;
    private final boolean mIsInSingleThreadMode;
    private final PollingParameters mPollingParameters;
    private Handler mNetworkHandler;
    private Handler mUiHandler;
    @Nullable
    private Source mLatestRetrievedSource;
    private int mRetryCount;
    @NonNull
    private SourceRetriever mSourceRetriever;
    private final Runnable pollRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Message message = null;
            try {
                Source source = PollingNetworkHandler.this.mSourceRetriever.retrieveSource(PollingNetworkHandler.this.mSourceId, PollingNetworkHandler.this.mClientSecret, PollingNetworkHandler.this.mPublishableKey);
                PollingNetworkHandler.this.mLatestRetrievedSource = source;
                if (source.getStatus() != null) {
                    switch (source.getStatus()) {
                        case "pending": {
                            message = PollingNetworkHandler.this.mUiHandler.obtainMessage(2);
                            break;
                        }
                        case "chargeable": {
                            message = PollingNetworkHandler.this.mUiHandler.obtainMessage(1, (Object)source);
                            break;
                        }
                        case "consumed": {
                            message = PollingNetworkHandler.this.mUiHandler.obtainMessage(1, (Object)source);
                            break;
                        }
                        case "canceled": {
                            message = PollingNetworkHandler.this.mUiHandler.obtainMessage(3, (Object)source);
                            break;
                        }
                        case "failed": {
                            message = PollingNetworkHandler.this.mUiHandler.obtainMessage(3, (Object)source);
                        }
                    }
                }
                if (message == null) return;
            }
            catch (StripeException stripeEx) {
                try {
                    message = PollingNetworkHandler.this.mUiHandler.obtainMessage(-1, (Object)stripeEx);
                    if (message == null) return;
                }
                catch (Throwable throwable) {
                    if (message == null) throw throwable;
                    PollingNetworkHandler.this.mUiHandler.sendMessage(message);
                    throw throwable;
                }
                PollingNetworkHandler.this.mUiHandler.sendMessage(message);
                return;
            }
            PollingNetworkHandler.this.mUiHandler.sendMessage(message);
            return;
        }
    };

    PollingNetworkHandler(@NonNull String sourceId, @NonNull String clientSecret, @NonNull String publishableKey, final @NonNull PollingResponseHandler callback, @Nullable Integer timeOutMs, @Nullable SourceRetriever sourceRetriever, @NonNull PollingParameters pollingParameters) {
        this.mSourceId = sourceId;
        this.mClientSecret = clientSecret;
        this.mPublishableKey = publishableKey;
        this.mIsInSingleThreadMode = sourceRetriever != null;
        this.mPollingParameters = pollingParameters;
        this.mSourceRetriever = sourceRetriever == null ? new SourceRetriever(){

            @Override
            public Source retrieveSource(@NonNull String sourceId, @NonNull String clientSecret, @NonNull String publishableKey) throws StripeException {
                return StripeApiHandler.retrieveSource(sourceId, clientSecret, publishableKey);
            }
        } : sourceRetriever;
        this.mTimeoutMs = timeOutMs == null ? this.mPollingParameters.getDefaultTimeoutMs() : Math.min(timeOutMs.longValue(), this.mPollingParameters.getMaxTimeoutMs());
        this.mRetryCount = 0;
        this.mUiHandler = new Handler(Looper.getMainLooper()){
            int delayMs;
            boolean terminated;
            {
                super(x0);
                this.delayMs = PollingNetworkHandler.this.mPollingParameters.getInitialDelayMsInt();
                this.terminated = false;
            }

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (this.terminated) {
                    return;
                }
                switch (msg.what) {
                    case 1: {
                        this.terminated = true;
                        callback.onPollingResponse(new PollingResponse((Source)msg.obj, true, false));
                        this.removeCallbacksAndMessages(null);
                        break;
                    }
                    case 2: {
                        PollingNetworkHandler.this.mRetryCount = 0;
                        this.delayMs = PollingNetworkHandler.this.mPollingParameters.getInitialDelayMsInt();
                        PollingNetworkHandler.this.mNetworkHandler.sendEmptyMessage(this.delayMs);
                        break;
                    }
                    case 3: {
                        this.terminated = true;
                        callback.onPollingResponse(new PollingResponse((Source)msg.obj, false, false));
                        this.removeCallbacksAndMessages(null);
                        break;
                    }
                    case -2: {
                        this.terminated = true;
                        callback.onPollingResponse(new PollingResponse(PollingNetworkHandler.this.mLatestRetrievedSource, false, true));
                        this.removeCallbacksAndMessages(null);
                        break;
                    }
                    case -1: {
                        PollingNetworkHandler.this.mRetryCount++;
                        if (PollingNetworkHandler.this.mRetryCount >= PollingNetworkHandler.this.mPollingParameters.getMaxRetryCount()) {
                            this.terminated = true;
                            callback.onPollingResponse(new PollingResponse(PollingNetworkHandler.this.mLatestRetrievedSource, (StripeException)msg.obj));
                            this.removeCallbacksAndMessages(null);
                            break;
                        }
                        this.delayMs = Math.min(this.delayMs * PollingNetworkHandler.this.mPollingParameters.getPollingMultiplier(), (int)PollingNetworkHandler.this.mPollingParameters.getMaxDelayMs());
                        PollingNetworkHandler.this.mNetworkHandler.sendEmptyMessage(this.delayMs);
                        break;
                    }
                }
            }
        };
        HandlerThread handlerThread = null;
        if (!this.mIsInSingleThreadMode) {
            handlerThread = new HandlerThread("Network Handler Thread");
            handlerThread.start();
        }
        final Looper looper = this.mIsInSingleThreadMode ? Looper.getMainLooper() : handlerThread.getLooper();
        this.mNetworkHandler = new Handler(looper){
            boolean terminated;
            {
                super(x0);
                this.terminated = false;
            }

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (this.terminated) {
                    return;
                }
                if (msg.what >= 0) {
                    this.postDelayed(PollingNetworkHandler.this.pollRunnable, msg.what);
                } else {
                    this.terminated = true;
                    if (!PollingNetworkHandler.this.mIsInSingleThreadMode) {
                        looper.quit();
                    }
                    PollingNetworkHandler.this.mUiHandler.removeMessages(1);
                    PollingNetworkHandler.this.mUiHandler.removeMessages(2);
                    PollingNetworkHandler.this.mUiHandler.removeMessages(3);
                    this.removeCallbacks(PollingNetworkHandler.this.pollRunnable);
                }
            }
        };
    }

    @VisibleForTesting
    long getTimeoutMs() {
        return this.mTimeoutMs;
    }

    @VisibleForTesting
    int getRetryCount() {
        return this.mRetryCount;
    }

    @VisibleForTesting
    void setSourceRetriever(@NonNull SourceRetriever sourceRetriever) {
        this.mSourceRetriever = sourceRetriever;
    }

    void start() {
        this.mNetworkHandler.post(this.pollRunnable);
        this.mNetworkHandler.sendEmptyMessageDelayed(-2, this.mTimeoutMs);
        this.mUiHandler.sendEmptyMessageDelayed(-2, this.mTimeoutMs);
    }
}

