/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.net;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.PermissionException;
import com.stripe.android.exception.RateLimitException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Token;
import com.stripe.android.net.ErrorParser;
import com.stripe.android.net.RequestOptions;
import com.stripe.android.net.StripeResponse;
import com.stripe.android.net.StripeSSLSocketFactory;
import com.stripe.android.net.TokenParser;
import com.stripe.android.util.LoggingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class StripeApiHandler {
    public static final String LIVE_API_BASE = "https://api.stripe.com";
    public static final String LIVE_LOGGING_BASE = "https://q.stripe.com";
    public static final String CHARSET = "UTF-8";
    public static final String TOKENS = "tokens";
    public static final String MUID = "muid";
    public static final String GUID = "guid";
    static final String GET = "GET";
    static final String POST = "POST";
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    private static final SSLSocketFactory SSL_SOCKET_FACTORY = new StripeSSLSocketFactory();

    @Nullable
    public static Token createTokenOnServer(@NonNull Map<String, Object> cardParams, @NonNull RequestOptions options, @Nullable LoggingResponseListener listener) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (cardParams.containsKey("product_usage")) {
            try {
                List loggingTokens = (List)cardParams.get("product_usage");
                cardParams.remove("product_usage");
                StripeApiHandler.logTokenRequest(loggingTokens, options, listener);
            }
            catch (ClassCastException classCastEx) {
                cardParams.remove("product_usage");
            }
        }
        return StripeApiHandler.requestToken(POST, StripeApiHandler.getApiUrl(), cardParams, options);
    }

    @Nullable
    public static Token retrieveTokenFromServer(@NonNull RequestOptions options, @NonNull String tokenId) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        try {
            return StripeApiHandler.requestToken(GET, StripeApiHandler.getRetrieveTokenApiUrl(tokenId), null, options);
        }
        catch (CardException cardException) {
            throw new APIException(cardException.getMessage(), cardException.getRequestId(), cardException.getStatusCode(), cardException);
        }
    }

    static String createQuery(Map<String, Object> params) throws UnsupportedEncodingException, InvalidRequestException {
        StringBuilder queryStringBuffer = new StringBuilder();
        List<Parameter> flatParams = StripeApiHandler.flattenParams(params);
        Iterator<Parameter> it = flatParams.iterator();
        while (it.hasNext()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            Parameter param = it.next();
            queryStringBuffer.append(StripeApiHandler.urlEncodePair(param.key, param.value));
        }
        return queryStringBuffer.toString();
    }

    static Map<String, String> getHeaders(RequestOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String apiVersion = options.getApiVersion();
        headers.put("Accept-Charset", CHARSET);
        headers.put("Accept", "application/json");
        headers.put("User-Agent", String.format("Stripe/v1 AndroidBindings/%s", "3.0.1"));
        headers.put("Authorization", String.format("Bearer %s", options.getPublishableApiKey()));
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        String systemPropertyName = "java.version";
        propertyMap.put("java.version", System.getProperty("java.version"));
        propertyMap.put("os.name", "android");
        propertyMap.put("os.version", String.valueOf(Build.VERSION.SDK_INT));
        propertyMap.put("bindings.version", "3.0.1");
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Stripe");
        JSONObject headerMappingObject = new JSONObject(propertyMap);
        headers.put("X-Stripe-Client-User-Agent", headerMappingObject.toString());
        if (apiVersion != null) {
            headers.put("Stripe-Version", apiVersion);
        }
        if (options.getIdempotencyKey() != null) {
            headers.put("Idempotency-Key", options.getIdempotencyKey());
        }
        return headers;
    }

    @VisibleForTesting
    static String getApiUrl() {
        return String.format("%s/v1/%s", LIVE_API_BASE, TOKENS);
    }

    @VisibleForTesting
    static String getRetrieveTokenApiUrl(@NonNull String tokenId) {
        return String.format("%s/%s", StripeApiHandler.getApiUrl(), tokenId);
    }

    private static String formatURL(String url, String query) {
        if (query == null || query.isEmpty()) {
            return url;
        }
        String separator = url.contains("?") ? "&" : "?";
        return String.format("%s%s%s", url, separator, query);
    }

    private static HttpURLConnection createGetConnection(String url, String query, RequestOptions options) throws IOException {
        String getURL = StripeApiHandler.formatURL(url, query);
        HttpURLConnection conn = StripeApiHandler.createStripeConnection(getURL, options);
        conn.setRequestMethod(GET);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createPostConnection(String url, String query, RequestOptions options) throws IOException {
        HttpURLConnection conn = StripeApiHandler.createStripeConnection(url, options);
        conn.setDoOutput(true);
        conn.setRequestMethod(POST);
        conn.setRequestProperty("Content-Type", String.format("application/x-www-form-urlencoded;charset=%s", CHARSET));
        try (OutputStream output = null;){
            output = conn.getOutputStream();
            output.write(query.getBytes(CHARSET));
        }
        return conn;
    }

    private static HttpURLConnection createStripeConnection(String url, RequestOptions options) throws IOException {
        URL stripeURL = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)stripeURL.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(80000);
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : StripeApiHandler.getHeaders(options).entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(SSL_SOCKET_FACTORY);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logTokenRequest(@NonNull List<String> loggingTokens, @Nullable RequestOptions options, @Nullable LoggingResponseListener listener) {
        if (options == null) {
            return;
        }
        String apiKey = options.getPublishableApiKey();
        if (apiKey.trim().isEmpty()) {
            return;
        }
        String originalDNSCacheTTL = null;
        Boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        try {
            StripeResponse response = StripeApiHandler.getStripeResponse(GET, LIVE_LOGGING_BASE, LoggingUtils.getTokenCreationParams(loggingTokens, apiKey), options);
            if (listener != null) {
                listener.onLoggingResponse(response);
            }
        }
        catch (StripeException stripeException) {
            if (listener != null) {
                listener.onStripeException(stripeException);
            }
        }
        finally {
            if (allowedToSetTTL.booleanValue()) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Token requestToken(String method, String url, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (options == null) {
            return null;
        }
        String originalDNSCacheTTL = null;
        Boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        String apiKey = options.getPublishableApiKey();
        if (apiKey.trim().isEmpty()) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'Stripe.apiKey = <API-KEY>'. You can generate API keys from the Stripe web interface. See https://stripe.com/api for details or email support@stripe.com if you have questions.", null, 0);
        }
        try {
            List<String> requestIdList;
            StripeResponse response = StripeApiHandler.getStripeResponse(method, url, params, options);
            int rCode = response.getResponseCode();
            String rBody = response.getResponseBody();
            String requestId = null;
            Map<String, List<String>> headers = response.getResponseHeaders();
            List<String> list = requestIdList = headers == null ? null : headers.get("Request-Id");
            if (requestIdList != null && requestIdList.size() > 0) {
                requestId = requestIdList.get(0);
            }
            if (rCode < 200 || rCode >= 300) {
                StripeApiHandler.handleAPIError(rBody, rCode, requestId);
            }
            Token token = TokenParser.parseToken(rBody);
            return token;
        }
        catch (JSONException jsonException) {
            Token token = null;
            return token;
        }
        finally {
            if (allowedToSetTTL.booleanValue()) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
    }

    private static StripeResponse getStripeResponse(String method, String url, Map<String, Object> params, RequestOptions options) throws InvalidRequestException, APIConnectionException, APIException {
        String query;
        try {
            query = StripeApiHandler.createQuery(params);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@stripe.com for assistance.", null, null, 0, e);
        }
        return StripeApiHandler.makeURLConnectionRequest(method, url, query, options);
    }

    private static List<Parameter> flattenParams(Map<String, Object> params) throws InvalidRequestException {
        return StripeApiHandler.flattenParamsMap(params, null);
    }

    private static List<Parameter> flattenParamsList(List<Object> params, String keyPrefix) throws InvalidRequestException {
        LinkedList<Parameter> flatParams = new LinkedList<Parameter>();
        Iterator<Object> it = params.iterator();
        String newPrefix = String.format("%s[]", keyPrefix);
        if (params.isEmpty()) {
            flatParams.add(new Parameter(keyPrefix, ""));
        } else {
            while (it.hasNext()) {
                flatParams.addAll(StripeApiHandler.flattenParamsValue(it.next(), newPrefix));
            }
        }
        return flatParams;
    }

    private static List<Parameter> flattenParamsMap(Map<String, Object> params, String keyPrefix) throws InvalidRequestException {
        LinkedList<Parameter> flatParams = new LinkedList<Parameter>();
        if (params == null) {
            return flatParams;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String newPrefix = key;
            if (keyPrefix != null) {
                newPrefix = String.format("%s[%s]", keyPrefix, key);
            }
            flatParams.addAll(StripeApiHandler.flattenParamsValue(value, newPrefix));
        }
        return flatParams;
    }

    private static List<Parameter> flattenParamsValue(Object value, String keyPrefix) throws InvalidRequestException {
        List<Parameter> flatParams;
        if (value instanceof Map) {
            flatParams = StripeApiHandler.flattenParamsMap((Map)value, keyPrefix);
        } else if (value instanceof List) {
            flatParams = StripeApiHandler.flattenParamsList((List)value, keyPrefix);
        } else {
            if ("".equals(value)) {
                throw new InvalidRequestException("You cannot set '" + keyPrefix + "' to an empty string. We interpret empty strings as null in requests. You may set '" + keyPrefix + "' to null to delete the property.", keyPrefix, null, 0, null);
            }
            if (value == null) {
                flatParams = new LinkedList<Parameter>();
                flatParams.add(new Parameter(keyPrefix, ""));
            } else {
                flatParams = new LinkedList<Parameter>();
                flatParams.add(new Parameter(keyPrefix, value.toString()));
            }
        }
        return flatParams;
    }

    private static void handleAPIError(String rBody, int rCode, String requestId) throws InvalidRequestException, AuthenticationException, CardException, APIException {
        ErrorParser.StripeError stripeError = ErrorParser.parseError(rBody);
        switch (rCode) {
            case 400: {
                throw new InvalidRequestException(stripeError.message, stripeError.param, requestId, rCode, null);
            }
            case 404: {
                throw new InvalidRequestException(stripeError.message, stripeError.param, requestId, rCode, null);
            }
            case 401: {
                throw new AuthenticationException(stripeError.message, requestId, rCode);
            }
            case 402: {
                throw new CardException(stripeError.message, requestId, stripeError.code, stripeError.param, stripeError.decline_code, stripeError.charge, rCode, null);
            }
            case 403: {
                throw new PermissionException(stripeError.message, requestId, rCode);
            }
            case 429: {
                throw new RateLimitException(stripeError.message, stripeError.param, requestId, rCode, null);
            }
        }
        throw new APIException(stripeError.message, requestId, rCode, null);
    }

    private static String urlEncodePair(String k, String v) throws UnsupportedEncodingException {
        return String.format("%s=%s", StripeApiHandler.urlEncode(k), StripeApiHandler.urlEncode(v));
    }

    private static String urlEncode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET);
    }

    private static StripeResponse makeURLConnectionRequest(String method, String url, String query, RequestOptions options) throws APIConnectionException {
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case "GET": {
                    conn = StripeApiHandler.createGetConnection(url, query, options);
                    break;
                }
                case "POST": {
                    conn = StripeApiHandler.createPostConnection(url, query, options);
                    break;
                }
                default: {
                    throw new APIConnectionException(String.format("Unrecognized HTTP method %s. This indicates a bug in the Stripe bindings. Please contact support@stripe.com for assistance.", method));
                }
            }
            int rCode = conn.getResponseCode();
            String rBody = rCode >= 200 && rCode < 300 ? StripeApiHandler.getResponseBody(conn.getInputStream()) : StripeApiHandler.getResponseBody(conn.getErrorStream());
            Map<String, List<String>> headers = conn.getHeaderFields();
            StripeResponse stripeResponse = new StripeResponse(rCode, rBody, headers);
            return stripeResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("IOException during API request to Stripe (%s): %s Please check your internet connection and try again. If this problem persists, you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", StripeApiHandler.getApiUrl(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        String rBody = new Scanner(responseStream, CHARSET).useDelimiter("\\A").next();
        responseStream.close();
        return rBody;
    }

    private static final class Parameter {
        public final String key;
        public final String value;

        public Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static interface LoggingResponseListener {
        public void onLoggingResponse(StripeResponse var1);

        public void onStripeException(StripeException var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface RestMethod {
    }
}

