/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.util;

import android.support.annotation.NonNull;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.util.StripeTextUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StripeNetworkUtils {
    @NonNull
    public static Map<String, Object> hashMapFromCard(Card card) {
        HashMap<String, Object> tokenParams = new HashMap<String, Object>();
        HashMap<String, Object> cardParams = new HashMap<String, Object>();
        cardParams.put("number", StripeTextUtils.nullIfBlank(card.getNumber()));
        cardParams.put("cvc", StripeTextUtils.nullIfBlank(card.getCVC()));
        cardParams.put("exp_month", card.getExpMonth());
        cardParams.put("exp_year", card.getExpYear());
        cardParams.put("name", StripeTextUtils.nullIfBlank(card.getName()));
        cardParams.put("currency", StripeTextUtils.nullIfBlank(card.getCurrency()));
        cardParams.put("address_line1", StripeTextUtils.nullIfBlank(card.getAddressLine1()));
        cardParams.put("address_line2", StripeTextUtils.nullIfBlank(card.getAddressLine2()));
        cardParams.put("address_city", StripeTextUtils.nullIfBlank(card.getAddressCity()));
        cardParams.put("address_zip", StripeTextUtils.nullIfBlank(card.getAddressZip()));
        cardParams.put("address_state", StripeTextUtils.nullIfBlank(card.getAddressState()));
        cardParams.put("address_country", StripeTextUtils.nullIfBlank(card.getAddressCountry()));
        StripeNetworkUtils.removeNullParams(cardParams);
        tokenParams.put("card", cardParams);
        return tokenParams;
    }

    @NonNull
    public static Map<String, Object> hashMapFromBankAccount(@NonNull BankAccount bankAccount) {
        HashMap<String, Object> tokenParams = new HashMap<String, Object>();
        HashMap<String, Object> accountParams = new HashMap<String, Object>();
        accountParams.put("country", bankAccount.getCountryCode());
        accountParams.put("currency", bankAccount.getCurrency());
        accountParams.put("account_number", bankAccount.getAccountNumber());
        accountParams.put("routing_number", StripeTextUtils.nullIfBlank(bankAccount.getRoutingNumber()));
        accountParams.put("account_holder_name", StripeTextUtils.nullIfBlank(bankAccount.getAccountHolderName()));
        accountParams.put("account_holder_type", StripeTextUtils.nullIfBlank(bankAccount.getAccountHolderType()));
        StripeNetworkUtils.removeNullParams(accountParams);
        tokenParams.put("bank_account", accountParams);
        return tokenParams;
    }

    static void removeNullParams(Map<String, Object> mapToEdit) {
        for (String key : new HashSet<String>(mapToEdit.keySet())) {
            if (mapToEdit.get(key) != null) continue;
            mapToEdit.remove(key);
        }
    }
}

