/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Currency;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/stripe/android/PayWithGoogleUtils;", "", "()V", "getPriceString", "", "price", "", "currency", "Ljava/util/Currency;", "stripe_release"})
public final class PayWithGoogleUtils {
    @NotNull
    public static final PayWithGoogleUtils INSTANCE = new PayWithGoogleUtils();

    private PayWithGoogleUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String getPriceString(int price, @NotNull Currency currency) {
        int i;
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        int fractionDigits = currency.getDefaultFractionDigits();
        int totalLength = String.valueOf(price).length();
        StringBuilder builder = new StringBuilder();
        if (fractionDigits == 0) {
            int n = 0;
            if (n < totalLength) {
                do {
                    int i2 = n++;
                    builder.append('#');
                } while (n < totalLength);
            }
            DecimalFormat noDecimalCurrencyFormat = new DecimalFormat(builder.toString());
            noDecimalCurrencyFormat.setCurrency(currency);
            noDecimalCurrencyFormat.setGroupingUsed(false);
            String i2 = noDecimalCurrencyFormat.format((Object)price);
            Intrinsics.checkNotNullExpressionValue((Object)i2, (String)"noDecimalCurrencyFormat.format(price)");
            return i2;
        }
        int i2 = 0;
        int beforeDecimal = totalLength - fractionDigits;
        if (i2 < beforeDecimal) {
            do {
                i = i2++;
                builder.append('#');
            } while (i2 < beforeDecimal);
        }
        if (totalLength <= fractionDigits) {
            builder.append('0');
        }
        builder.append('.');
        i2 = 0;
        if (i2 < fractionDigits) {
            do {
                i = i2++;
                builder.append('0');
            } while (i2 < fractionDigits);
        }
        double d = 10.0;
        double d2 = fractionDigits;
        boolean bl = false;
        double modBreak = Math.pow(d, d2);
        double decimalPrice = (double)price / modBreak;
        DecimalFormatSymbols symbolOverride = new DecimalFormatSymbols();
        symbolOverride.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat(builder.toString(), symbolOverride);
        decimalFormat.setCurrency(currency);
        decimalFormat.setGroupingUsed(false);
        String string = decimalFormat.format(decimalPrice);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decimalFormat.format(decimalPrice)");
        return string;
    }
}

