/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.EphemeralKey;
import com.stripe.android.EphemeralKeyManager;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.EphemeralOperation;
import com.stripe.android.OperationIdFactory;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.Stripe;
import com.stripe.android.StripeError;
import com.stripe.android.StripeOperationIdFactory;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeRepository;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u000f\u0018\u0000 +2\u00020\u0001:\u0005*+,-.B7\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J \u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J!\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0011H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0013H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J&\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0011J.\u0010(\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0013R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006/"}, d2={"Lcom/stripe/android/IssuingCardPinService;", "", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "operationIdFactory", "Lcom/stripe/android/OperationIdFactory;", "stripeAccountId", "", "workContext", "Lkotlin/coroutines/CoroutineContext;", "(Lcom/stripe/android/EphemeralKeyProvider;Lcom/stripe/android/networking/StripeRepository;Lcom/stripe/android/OperationIdFactory;Ljava/lang/String;Lkotlin/coroutines/CoroutineContext;)V", "ephemeralKeyManager", "Lcom/stripe/android/EphemeralKeyManager;", "retrievalListeners", "", "Lcom/stripe/android/IssuingCardPinService$IssuingCardPinRetrievalListener;", "updateListeners", "Lcom/stripe/android/IssuingCardPinService$IssuingCardPinUpdateListener;", "fireRetrievePinRequest", "", "ephemeralKey", "Lcom/stripe/android/EphemeralKey;", "operation", "Lcom/stripe/android/EphemeralOperation$Issuing$RetrievePin;", "listener", "fireUpdatePinRequest", "Lcom/stripe/android/EphemeralOperation$Issuing$UpdatePin;", "logMissingListener", "onRetrievePinError", "throwable", "", "(Ljava/lang/Throwable;Lcom/stripe/android/IssuingCardPinService$IssuingCardPinRetrievalListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onUpdatePinError", "(Ljava/lang/Throwable;Lcom/stripe/android/IssuingCardPinService$IssuingCardPinUpdateListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrievePin", "cardId", "verificationId", "userOneTimeCode", "updatePin", "newPin", "CardPinActionError", "Companion", "IssuingCardPinRetrievalListener", "IssuingCardPinUpdateListener", "Listener", "stripe_release"})
public final class IssuingCardPinService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StripeRepository stripeRepository;
    @NotNull
    private final OperationIdFactory operationIdFactory;
    @Nullable
    private final String stripeAccountId;
    @NotNull
    private final CoroutineContext workContext;
    @NotNull
    private final Map<String, IssuingCardPinRetrievalListener> retrievalListeners;
    @NotNull
    private final Map<String, IssuingCardPinUpdateListener> updateListeners;
    @NotNull
    private final EphemeralKeyManager ephemeralKeyManager;
    private static final String TAG = IssuingCardPinService.class.getName();

    @VisibleForTesting
    public IssuingCardPinService(@NotNull EphemeralKeyProvider keyProvider, @NotNull StripeRepository stripeRepository, @NotNull OperationIdFactory operationIdFactory, @Nullable String stripeAccountId, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        Intrinsics.checkNotNullParameter((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)operationIdFactory, (String)"operationIdFactory");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this.stripeRepository = stripeRepository;
        this.operationIdFactory = operationIdFactory;
        this.stripeAccountId = stripeAccountId;
        this.workContext = workContext;
        boolean bl = false;
        this.retrievalListeners = new LinkedHashMap();
        bl = false;
        this.updateListeners = new LinkedHashMap();
        this.ephemeralKeyManager = new EphemeralKeyManager(keyProvider, new EphemeralKeyManager.KeyManagerListener(this){
            final /* synthetic */ IssuingCardPinService this$0;
            {
                this.this$0 = $receiver;
            }

            public void onKeyUpdate(@NotNull EphemeralKey ephemeralKey, @NotNull EphemeralOperation operation) {
                block6: {
                    Unit unit;
                    Unit unit2;
                    EphemeralOperation ephemeralOperation;
                    block5: {
                        Unit unit3;
                        Unit unit4;
                        Intrinsics.checkNotNullParameter((Object)ephemeralKey, (String)"ephemeralKey");
                        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                        ephemeralOperation = operation;
                        if (!(ephemeralOperation instanceof EphemeralOperation.Issuing.RetrievePin)) break block5;
                        IssuingCardPinRetrievalListener issuingCardPinRetrievalListener = (IssuingCardPinRetrievalListener)IssuingCardPinService.access$getRetrievalListeners$p(this.this$0).remove(operation.getId$stripe_release());
                        if (issuingCardPinRetrievalListener == null) {
                            unit4 = null;
                        } else {
                            IssuingCardPinRetrievalListener issuingCardPinRetrievalListener2 = issuingCardPinRetrievalListener;
                            IssuingCardPinService issuingCardPinService = this.this$0;
                            boolean bl = false;
                            boolean bl2 = false;
                            IssuingCardPinRetrievalListener listener = issuingCardPinRetrievalListener2;
                            boolean bl3 = false;
                            IssuingCardPinService.access$fireRetrievePinRequest(issuingCardPinService, ephemeralKey, (EphemeralOperation.Issuing.RetrievePin)operation, listener);
                            unit4 = unit3 = Unit.INSTANCE;
                        }
                        if (unit3 != null) break block6;
                        IssuingCardPinService.access$logMissingListener(this.this$0);
                        break block6;
                    }
                    if (!(ephemeralOperation instanceof EphemeralOperation.Issuing.UpdatePin)) break block6;
                    IssuingCardPinUpdateListener issuingCardPinUpdateListener = (IssuingCardPinUpdateListener)IssuingCardPinService.access$getUpdateListeners$p(this.this$0).remove(operation.getId$stripe_release());
                    if (issuingCardPinUpdateListener == null) {
                        unit2 = null;
                    } else {
                        IssuingCardPinUpdateListener issuingCardPinUpdateListener2 = issuingCardPinUpdateListener;
                        IssuingCardPinService issuingCardPinService = this.this$0;
                        boolean bl = false;
                        boolean bl4 = false;
                        IssuingCardPinUpdateListener listener = issuingCardPinUpdateListener2;
                        boolean bl5 = false;
                        IssuingCardPinService.access$fireUpdatePinRequest(issuingCardPinService, ephemeralKey, (EphemeralOperation.Issuing.UpdatePin)operation, listener);
                        unit2 = unit = Unit.INSTANCE;
                    }
                    if (unit == null) {
                        IssuingCardPinService.access$logMissingListener(this.this$0);
                    }
                }
            }

            public void onKeyError(@NotNull String operationId, int errorCode, @NotNull String errorMessage) {
                IssuingCardPinRetrievalListener retrievalListener;
                Intrinsics.checkNotNullParameter((Object)operationId, (String)"operationId");
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                IssuingCardPinUpdateListener updateListener = (IssuingCardPinUpdateListener)IssuingCardPinService.access$getUpdateListeners$p(this.this$0).remove(operationId);
                IssuingCardPinRetrievalListener issuingCardPinRetrievalListener = retrievalListener = (IssuingCardPinRetrievalListener)IssuingCardPinService.access$getRetrievalListeners$p(this.this$0).remove(operationId);
                if (issuingCardPinRetrievalListener == null) {
                    IssuingCardPinUpdateListener issuingCardPinUpdateListener = updateListener;
                    if (issuingCardPinUpdateListener != null) {
                        issuingCardPinUpdateListener.onError(CardPinActionError.EPHEMERAL_KEY_ERROR, errorMessage, null);
                    }
                } else {
                    issuingCardPinRetrievalListener.onError(CardPinActionError.EPHEMERAL_KEY_ERROR, errorMessage, null);
                }
            }
        }, this.operationIdFactory, true, null, 0L, 48, null);
    }

    public /* synthetic */ IssuingCardPinService(EphemeralKeyProvider ephemeralKeyProvider, StripeRepository stripeRepository, OperationIdFactory operationIdFactory, String string, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            operationIdFactory = new StripeOperationIdFactory();
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.INSTANCE.getIO();
        }
        this(ephemeralKeyProvider, stripeRepository, operationIdFactory, string, coroutineContext);
    }

    public final void retrievePin(@NotNull String cardId, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull IssuingCardPinRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)verificationId, (String)"verificationId");
        Intrinsics.checkNotNullParameter((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        String operationId = this.operationIdFactory.create();
        Map<String, IssuingCardPinRetrievalListener> map = this.retrievalListeners;
        boolean bl = false;
        map.put(operationId, listener);
        this.ephemeralKeyManager.retrieveEphemeralKey$stripe_release(new EphemeralOperation.Issuing.RetrievePin(cardId, verificationId, userOneTimeCode, operationId));
    }

    public final void updatePin(@NotNull String cardId, @NotNull String newPin, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull IssuingCardPinUpdateListener listener) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)newPin, (String)"newPin");
        Intrinsics.checkNotNullParameter((Object)verificationId, (String)"verificationId");
        Intrinsics.checkNotNullParameter((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        String operationId = this.operationIdFactory.create();
        Map<String, IssuingCardPinUpdateListener> map = this.updateListeners;
        boolean bl = false;
        map.put(operationId, listener);
        this.ephemeralKeyManager.retrieveEphemeralKey$stripe_release(new EphemeralOperation.Issuing.UpdatePin(cardId, newPin, verificationId, userOneTimeCode, operationId));
    }

    private final void fireRetrievePinRequest(EphemeralKey ephemeralKey, EphemeralOperation.Issuing.RetrievePin operation, IssuingCardPinRetrievalListener listener) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, operation, ephemeralKey, listener, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ IssuingCardPinService this$0;
            final /* synthetic */ EphemeralOperation.Issuing.RetrievePin $operation;
            final /* synthetic */ EphemeralKey $ephemeralKey;
            final /* synthetic */ IssuingCardPinRetrievalListener $listener;
            {
                this.this$0 = $receiver;
                this.$operation = $operation;
                this.$ephemeralKey = $ephemeralKey;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_4 /* !! */  = $this$launch = (CoroutineScope)this.L$0;
                        var4_5 = this.this$0;
                        var5_6 = this.$operation;
                        var6_7 = this.$ephemeralKey;
                        var7_8 = false;
                        var8_9 = Result.Companion;
                        var9_12 = var3_4 /* !! */ ;
                        $i$a$-runCatching-IssuingCardPinService$fireRetrievePinRequest$1$1 = false;
                        this.label = 1;
                        v0 = IssuingCardPinService.access$getStripeRepository$p((IssuingCardPinService)var4_5).retrieveIssuingCardPin(var5_6.getCardId(), var5_6.getVerificationId(), var5_6.getUserOneTimeCode(), new ApiRequest.Options(var6_7.getSecret(), IssuingCardPinService.access$getStripeAccountId$p((IssuingCardPinService)var4_5), null, 4, null), (Continuation<? super String>)this);
                        ** if (v0 != var15_2) goto lbl19
lbl18:
                        // 1 sources

                        return var15_2;
lbl19:
                        // 1 sources

                        ** GOTO lbl26
                    }
                    case 1: {
                        $i$a$-runCatching-IssuingCardPinService$fireRetrievePinRequest$1$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl26:
                            // 2 sources

                            var11_20 = v0;
                            var12_22 = false;
                            var13_23 = false;
                            if (var11_20 == null) {
                                $i$a$-requireNotNull-IssuingCardPinService$fireRetrievePinRequest$1$1$1 = false;
                                var13_24 = "Could not retrieve issuing card PIN.";
                                throw (Throwable)new IllegalArgumentException(var13_24.toString());
                            }
                            var9_12 = (String)var11_20;
                            $i$a$-runCatching-IssuingCardPinService$fireRetrievePinRequest$1$1 = false;
                            var8_9 = Result.constructor-impl((Object)var9_12);
                        }
                        catch (Throwable var9_13) {
                            $i$a$-runCatching-IssuingCardPinService$fireRetrievePinRequest$1$1 = Result.Companion;
                            var11_21 = false;
                            var8_9 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var9_13));
                        }
                        var3_4 /* !! */  = var8_9;
                        var4_5 = this.$listener;
                        var5_6 = this.this$0;
                        var6_7 = this.$listener;
                        var7_8 = false;
                        var8_10 = false;
                        var8_11 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                        if (var8_11 != null) break;
                        pin = (String)var3_4 /* !! */ ;
                        $i$a$-fold-IssuingCardPinService$fireRetrievePinRequest$1$2 = false;
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((IssuingCardPinRetrievalListener)var4_5, pin, null){
                            int label;
                            final /* synthetic */ IssuingCardPinRetrievalListener $listener;
                            final /* synthetic */ String $pin;
                            {
                                this.$listener = $listener;
                                this.$pin = $pin;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$listener.onIssuingCardPinRetrieved(this.$pin);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        if (v1 == var15_2) {
                            return var15_2;
                        }
                        ** GOTO lbl74
                    }
                    case 2: {
                        $i$a$-fold-IssuingCardPinService$fireRetrievePinRequest$1$2 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl74
                    }
                }
                it = var8_11;
                $i$a$-fold-IssuingCardPinService$fireRetrievePinRequest$1$3 = false;
                this.label = 3;
                v2 = IssuingCardPinService.access$onRetrievePinError((IssuingCardPinService)var5_6, it, (IssuingCardPinRetrievalListener)var6_7, (Continuation)this);
                if (v2 == var15_2) {
                    return var15_2;
                }
                ** GOTO lbl74
                {
                    case 3: {
                        $i$a$-fold-IssuingCardPinService$fireRetrievePinRequest$1$3 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl74:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object onRetrievePinError(Throwable throwable, IssuingCardPinRetrievalListener listener, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(throwable, listener, null){
            int label;
            final /* synthetic */ Throwable $throwable;
            final /* synthetic */ IssuingCardPinRetrievalListener $listener;
            {
                this.$throwable = $throwable;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string;
                        ResultKt.throwOnFailure((Object)object);
                        Throwable throwable = this.$throwable;
                        if (!(throwable instanceof InvalidRequestException)) {
                            this.$listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred while retrieving the PIN.", this.$throwable);
                            return Unit.INSTANCE;
                        }
                        StripeError stripeError = ((InvalidRequestException)this.$throwable).getStripeError();
                        String string2 = string = stripeError == null ? null : stripeError.getCode();
                        if (string != null) {
                            int n = -1;
                            switch (string.hashCode()) {
                                case -1309235419: {
                                    if (!string.equals("expired")) break;
                                    n = 1;
                                    break;
                                }
                                case 830217595: {
                                    if (!string.equals("too_many_attempts")) break;
                                    n = 2;
                                    break;
                                }
                                case 1888170818: {
                                    if (!string.equals("already_redeemed")) break;
                                    n = 3;
                                    break;
                                }
                                case -1266028985: {
                                    if (!string.equals("incorrect_code")) break;
                                    n = 4;
                                    break;
                                }
                            }
                            switch (n) {
                                case 1: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_EXPIRED, "The one-time code has expired", null);
                                    return Unit.INSTANCE;
                                }
                                case 4: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_INCORRECT, "The one-time code was incorrect.", null);
                                    return Unit.INSTANCE;
                                }
                                case 2: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_TOO_MANY_ATTEMPTS, "The verification challenge was attempted too many times.", null);
                                    return Unit.INSTANCE;
                                }
                                case 3: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_ALREADY_REDEEMED, "The verification challenge was already redeemed.", null);
                                    return Unit.INSTANCE;
                                }
                            }
                        }
                        this.$listener.onError(CardPinActionError.UNKNOWN_ERROR, "The call to retrieve the PIN failed, possibly an error with the verification.", this.$throwable);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void fireUpdatePinRequest(EphemeralKey ephemeralKey, EphemeralOperation.Issuing.UpdatePin operation, IssuingCardPinUpdateListener listener) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, operation, ephemeralKey, listener, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ IssuingCardPinService this$0;
            final /* synthetic */ EphemeralOperation.Issuing.UpdatePin $operation;
            final /* synthetic */ EphemeralKey $ephemeralKey;
            final /* synthetic */ IssuingCardPinUpdateListener $listener;
            {
                this.this$0 = $receiver;
                this.$operation = $operation;
                this.$ephemeralKey = $ephemeralKey;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_4 /* !! */  = $this$launch = (CoroutineScope)this.L$0;
                        var4_5 = this.this$0;
                        var5_6 = this.$operation;
                        var6_7 = this.$ephemeralKey;
                        var7_8 = false;
                        var8_9 = Result.Companion;
                        var9_12 = var3_4 /* !! */ ;
                        $i$a$-runCatching-IssuingCardPinService$fireUpdatePinRequest$1$1 = false;
                        this.label = 1;
                        v0 = IssuingCardPinService.access$getStripeRepository$p((IssuingCardPinService)var4_5).updateIssuingCardPin(var5_6.getCardId(), var5_6.getNewPin(), var5_6.getVerificationId(), var5_6.getUserOneTimeCode(), new ApiRequest.Options(var6_7.getSecret(), IssuingCardPinService.access$getStripeAccountId$p((IssuingCardPinService)var4_5), null, 4, null), (Continuation<? super Unit>)this);
                        ** if (v0 != var12_2) goto lbl19
lbl18:
                        // 1 sources

                        return var12_2;
lbl19:
                        // 1 sources

                        ** GOTO lbl26
                    }
                    case 1: {
                        $i$a$-runCatching-IssuingCardPinService$fireUpdatePinRequest$1$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl26:
                            // 2 sources

                            var9_12 = Unit.INSTANCE;
                            $i$a$-runCatching-IssuingCardPinService$fireUpdatePinRequest$1$1 = false;
                            var8_9 = Result.constructor-impl((Object)var9_12);
                        }
                        catch (Throwable var9_13) {
                            $i$a$-runCatching-IssuingCardPinService$fireUpdatePinRequest$1$1 = Result.Companion;
                            var11_20 = false;
                            var8_9 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var9_13));
                        }
                        var3_4 /* !! */  = var8_9;
                        var4_5 = this.$listener;
                        var5_6 = this.this$0;
                        var6_7 = this.$listener;
                        var7_8 = false;
                        var8_10 = false;
                        var8_11 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                        if (var8_11 != null) break;
                        var9_12 = (Unit)var3_4 /* !! */ ;
                        $i$a$-fold-IssuingCardPinService$fireUpdatePinRequest$1$2 = false;
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((IssuingCardPinUpdateListener)var4_5, null){
                            int label;
                            final /* synthetic */ IssuingCardPinUpdateListener $listener;
                            {
                                this.$listener = $listener;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$listener.onIssuingCardPinUpdated();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        if (v1 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl67
                    }
                    case 2: {
                        $i$a$-fold-IssuingCardPinService$fireUpdatePinRequest$1$2 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl67
                    }
                }
                it = var8_11;
                $i$a$-fold-IssuingCardPinService$fireUpdatePinRequest$1$3 = false;
                this.label = 3;
                v2 = IssuingCardPinService.access$onUpdatePinError((IssuingCardPinService)var5_6, it, (IssuingCardPinUpdateListener)var6_7, (Continuation)this);
                if (v2 == var12_2) {
                    return var12_2;
                }
                ** GOTO lbl67
                {
                    case 3: {
                        $i$a$-fold-IssuingCardPinService$fireUpdatePinRequest$1$3 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl67:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object onUpdatePinError(Throwable throwable, IssuingCardPinUpdateListener listener, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(throwable, listener, null){
            int label;
            final /* synthetic */ Throwable $throwable;
            final /* synthetic */ IssuingCardPinUpdateListener $listener;
            {
                this.$throwable = $throwable;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string;
                        ResultKt.throwOnFailure((Object)object);
                        Throwable throwable = this.$throwable;
                        if (!(throwable instanceof InvalidRequestException)) {
                            this.$listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred while updating the PIN.", this.$throwable);
                            return Unit.INSTANCE;
                        }
                        StripeError stripeError = ((InvalidRequestException)this.$throwable).getStripeError();
                        String string2 = string = stripeError == null ? null : stripeError.getCode();
                        if (string != null) {
                            int n = -1;
                            switch (string.hashCode()) {
                                case -1309235419: {
                                    if (!string.equals("expired")) break;
                                    n = 1;
                                    break;
                                }
                                case 830217595: {
                                    if (!string.equals("too_many_attempts")) break;
                                    n = 2;
                                    break;
                                }
                                case 1888170818: {
                                    if (!string.equals("already_redeemed")) break;
                                    n = 3;
                                    break;
                                }
                                case -1266028985: {
                                    if (!string.equals("incorrect_code")) break;
                                    n = 4;
                                    break;
                                }
                            }
                            switch (n) {
                                case 1: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_EXPIRED, "The one-time code has expired.", null);
                                    return Unit.INSTANCE;
                                }
                                case 4: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_INCORRECT, "The one-time code was incorrect.", null);
                                    return Unit.INSTANCE;
                                }
                                case 2: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_TOO_MANY_ATTEMPTS, "The verification challenge was attempted too many times.", null);
                                    return Unit.INSTANCE;
                                }
                                case 3: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_ALREADY_REDEEMED, "The verification challenge was already redeemed.", null);
                                    return Unit.INSTANCE;
                                }
                            }
                        }
                        this.$listener.onError(CardPinActionError.UNKNOWN_ERROR, "The call to update the PIN failed, possibly an error with the verification.", this.$throwable);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void logMissingListener() {
        Log.e((String)TAG, (String)Intrinsics.stringPlus((String)this.getClass().getName(), (Object)" was called without a listener"));
    }

    @JvmStatic
    @NotNull
    public static final IssuingCardPinService create(@NotNull Context context, @NotNull EphemeralKeyProvider keyProvider) {
        return Companion.create(context, keyProvider);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final IssuingCardPinService create(@NotNull Context context, @NotNull String publishableKey2, @Nullable String stripeAccountId, @NotNull EphemeralKeyProvider keyProvider) {
        return Companion.create(context, publishableKey2, stripeAccountId, keyProvider);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final IssuingCardPinService create(@NotNull Context context, @NotNull String publishableKey2, @NotNull EphemeralKeyProvider keyProvider) {
        return Companion.create(context, publishableKey2, keyProvider);
    }

    public static final /* synthetic */ StripeRepository access$getStripeRepository$p(IssuingCardPinService $this) {
        return $this.stripeRepository;
    }

    public static final /* synthetic */ String access$getStripeAccountId$p(IssuingCardPinService $this) {
        return $this.stripeAccountId;
    }

    public static final /* synthetic */ Object access$onRetrievePinError(IssuingCardPinService $this, Throwable throwable, IssuingCardPinRetrievalListener listener, Continuation $completion) {
        return $this.onRetrievePinError(throwable, listener, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$onUpdatePinError(IssuingCardPinService $this, Throwable throwable, IssuingCardPinUpdateListener listener, Continuation $completion) {
        return $this.onUpdatePinError(throwable, listener, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Map access$getRetrievalListeners$p(IssuingCardPinService $this) {
        return $this.retrievalListeners;
    }

    public static final /* synthetic */ void access$logMissingListener(IssuingCardPinService $this) {
        $this.logMissingListener();
    }

    public static final /* synthetic */ Map access$getUpdateListeners$p(IssuingCardPinService $this) {
        return $this.updateListeners;
    }

    public static final /* synthetic */ void access$fireRetrievePinRequest(IssuingCardPinService $this, EphemeralKey ephemeralKey, EphemeralOperation.Issuing.RetrievePin operation, IssuingCardPinRetrievalListener listener) {
        $this.fireRetrievePinRequest(ephemeralKey, operation, listener);
    }

    public static final /* synthetic */ void access$fireUpdatePinRequest(IssuingCardPinService $this, EphemeralKey ephemeralKey, EphemeralOperation.Issuing.UpdatePin operation, IssuingCardPinUpdateListener listener) {
        $this.fireUpdatePinRequest(ephemeralKey, operation, listener);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/IssuingCardPinService$CardPinActionError;", "", "(Ljava/lang/String;I)V", "UNKNOWN_ERROR", "EPHEMERAL_KEY_ERROR", "ONE_TIME_CODE_INCORRECT", "ONE_TIME_CODE_EXPIRED", "ONE_TIME_CODE_TOO_MANY_ATTEMPTS", "ONE_TIME_CODE_ALREADY_REDEEMED", "stripe_release"})
    public static final class CardPinActionError
    extends Enum<CardPinActionError> {
        public static final /* enum */ CardPinActionError UNKNOWN_ERROR = new CardPinActionError();
        public static final /* enum */ CardPinActionError EPHEMERAL_KEY_ERROR = new CardPinActionError();
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_INCORRECT = new CardPinActionError();
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_EXPIRED = new CardPinActionError();
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_TOO_MANY_ATTEMPTS = new CardPinActionError();
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_ALREADY_REDEEMED = new CardPinActionError();
        private static final /* synthetic */ CardPinActionError[] $VALUES;

        public static CardPinActionError[] values() {
            CardPinActionError[] cardPinActionErrorArray = $VALUES;
            return Arrays.copyOf(cardPinActionErrorArray, cardPinActionErrorArray.length);
        }

        public static CardPinActionError valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(CardPinActionError.class, value);
        }

        static {
            $VALUES = cardPinActionErrorArray = new CardPinActionError[]{CardPinActionError.UNKNOWN_ERROR, CardPinActionError.EPHEMERAL_KEY_ERROR, CardPinActionError.ONE_TIME_CODE_INCORRECT, CardPinActionError.ONE_TIME_CODE_EXPIRED, CardPinActionError.ONE_TIME_CODE_TOO_MANY_ATTEMPTS, CardPinActionError.ONE_TIME_CODE_ALREADY_REDEEMED};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/IssuingCardPinService$IssuingCardPinRetrievalListener;", "Lcom/stripe/android/IssuingCardPinService$Listener;", "onIssuingCardPinRetrieved", "", "pin", "", "stripe_release"})
    public static interface IssuingCardPinRetrievalListener
    extends Listener {
        public void onIssuingCardPinRetrieved(@NotNull String var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/IssuingCardPinService$IssuingCardPinUpdateListener;", "Lcom/stripe/android/IssuingCardPinService$Listener;", "onIssuingCardPinUpdated", "", "stripe_release"})
    public static interface IssuingCardPinUpdateListener
    extends Listener {
        public void onIssuingCardPinUpdated();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lcom/stripe/android/IssuingCardPinService$Listener;", "", "onError", "", "errorCode", "Lcom/stripe/android/IssuingCardPinService$CardPinActionError;", "errorMessage", "", "exception", "", "stripe_release"})
    public static interface Listener {
        public void onError(@NotNull CardPinActionError var1, @Nullable String var2, @Nullable Throwable var3);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/IssuingCardPinService$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "create", "Lcom/stripe/android/IssuingCardPinService;", "context", "Landroid/content/Context;", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "publishableKey", "stripeAccountId", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IssuingCardPinService create(@NotNull Context context, @NotNull EphemeralKeyProvider keyProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
            PaymentConfiguration config = PaymentConfiguration.Companion.getInstance(context);
            return this.create(context, config.getPublishableKey(), config.getStripeAccountId(), keyProvider);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final IssuingCardPinService create(@NotNull Context context, @NotNull String publishableKey2, @Nullable String stripeAccountId, @NotNull EphemeralKeyProvider keyProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
            return new IssuingCardPinService(keyProvider, new StripeApiRepository(context, publishableKey2, Stripe.Companion.getAppInfo(), null, null, null, null, null, null, null, null, null, null, 8184, null), new StripeOperationIdFactory(), stripeAccountId, null, 16, null);
        }

        public static /* synthetic */ IssuingCardPinService create$default(Companion companion, Context context, String string, String string2, EphemeralKeyProvider ephemeralKeyProvider, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.create(context, string, string2, ephemeralKeyProvider);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final IssuingCardPinService create(@NotNull Context context, @NotNull String publishableKey2, @NotNull EphemeralKeyProvider keyProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
            Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
            return com.stripe.android.IssuingCardPinService$Companion.create$default(this, context, publishableKey2, null, keyProvider, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

