/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.model;

import android.content.res.Resources;
import com.stripe.android.R;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.paymentsheet.model.PaymentOption;
import com.stripe.android.paymentsheet.model.PaymentOptionFactory$WhenMappings;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory;", "", "resources", "Landroid/content/res/Resources;", "(Landroid/content/res/Resources;)V", "create", "Lcom/stripe/android/paymentsheet/model/PaymentOption;", "selection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "createCardLabel", "", "last4", "getIcon", "", "brand", "Lcom/stripe/android/model/CardBrand;", "stripe_release"})
public final class PaymentOptionFactory {
    private final Resources resources;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final PaymentOption create(@NotNull PaymentSelection selection) {
        PaymentOption paymentOption;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        PaymentSelection paymentSelection = selection;
        if (Intrinsics.areEqual((Object)paymentSelection, (Object)PaymentSelection.GooglePay.INSTANCE)) {
            paymentOption = new PaymentOption(R.drawable.stripe_google_pay_mark, "Google Pay");
            return paymentOption;
        } else if (paymentSelection instanceof PaymentSelection.Saved) {
            PaymentMethod.Type type = ((PaymentSelection.Saved)selection).getPaymentMethod().type;
            if (type == null) return null;
            switch (PaymentOptionFactory$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    PaymentMethod.Card card = ((PaymentSelection.Saved)selection).getPaymentMethod().card;
                    if (card == null) return null;
                    PaymentMethod.Card card2 = card;
                    boolean bl = false;
                    boolean bl2 = false;
                    PaymentMethod.Card card3 = card2;
                    boolean bl3 = false;
                    paymentOption = new PaymentOption(this.getIcon(card3.brand), this.createCardLabel(card3.last4));
                    return paymentOption;
                }
                default: {
                    return null;
                }
            }
        } else {
            if (!(paymentSelection instanceof PaymentSelection.New.Card)) throw new NoWhenBranchMatchedException();
            CardBrand brand = ((PaymentSelection.New.Card)selection).getBrand();
            PaymentMethodCreateParams.Card card = ((PaymentSelection.New.Card)selection).getPaymentMethodCreateParams().getCard$stripe_release();
            paymentOption = new PaymentOption(this.getIcon(brand), this.createCardLabel(card != null ? card.getLast4$stripe_release() : null));
        }
        return paymentOption;
    }

    private final String createCardLabel(String last4) {
        String string2;
        boolean bl;
        String string3;
        String string4 = last4;
        if (string4 != null) {
            string3 = string4;
            bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            string2 = this.resources.getString(R.string.paymentsheet_payment_method_item_card_number, new Object[]{last4});
        } else {
            string2 = null;
        }
        string3 = string2;
        bl = false;
        String string5 = string3;
        if (string5 == null) {
            string5 = "";
        }
        return string5;
    }

    private final int getIcon(CardBrand brand) {
        int n;
        switch (PaymentOptionFactory$WhenMappings.$EnumSwitchMapping$1[brand.ordinal()]) {
            case 1: {
                n = R.drawable.stripe_ic_paymentsheet_card_visa;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_paymentsheet_card_amex;
                break;
            }
            case 3: {
                n = R.drawable.stripe_ic_paymentsheet_card_discover;
                break;
            }
            case 4: {
                n = R.drawable.stripe_ic_paymentsheet_card_jcb;
                break;
            }
            case 5: {
                n = R.drawable.stripe_ic_paymentsheet_card_dinersclub;
                break;
            }
            case 6: {
                n = R.drawable.stripe_ic_paymentsheet_card_mastercard;
                break;
            }
            case 7: {
                n = R.drawable.stripe_ic_paymentsheet_card_unionpay;
                break;
            }
            case 8: {
                n = R.drawable.stripe_ic_paymentsheet_card_unknown;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public PaymentOptionFactory(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        this.resources = resources;
    }
}

