/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.networking.RequestHeadersFactory;
import com.stripe.android.networking.StripeClientUserAgentHeaderFactory;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u000e2\u00020\u0001:\u0004\f\r\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004R\u001e\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory;", "", "()V", "extraHeaders", "", "", "getExtraHeaders", "()Ljava/util/Map;", "userAgent", "getUserAgent", "()Ljava/lang/String;", "create", "Analytics", "Api", "Companion", "Fingerprint", "Lcom/stripe/android/networking/RequestHeadersFactory$Api;", "Lcom/stripe/android/networking/RequestHeadersFactory$Fingerprint;", "Lcom/stripe/android/networking/RequestHeadersFactory$Analytics;", "stripe_release"})
public abstract class RequestHeadersFactory {
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";
    private static final String CHARSET;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Map<String, String> create() {
        return MapsKt.plus(this.getExtraHeaders(), (Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)HEADER_USER_AGENT, (Object)this.getUserAgent()), TuplesKt.to((Object)HEADER_ACCEPT_CHARSET, (Object)CHARSET)}));
    }

    @NotNull
    protected abstract String getUserAgent();

    @NotNull
    protected abstract Map<String, String> getExtraHeaders();

    private RequestHeadersFactory() {
    }

    static {
        Companion = new Companion(null);
        CHARSET = Charsets.UTF_8.name();
    }

    public /* synthetic */ RequestHeadersFactory(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory$Api;", "Lcom/stripe/android/networking/RequestHeadersFactory;", "options", "Lcom/stripe/android/networking/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/AppInfo;", "locale", "Ljava/util/Locale;", "systemPropertySupplier", "Lkotlin/Function1;", "", "apiVersion", "sdkVersion", "(Lcom/stripe/android/networking/ApiRequest$Options;Lcom/stripe/android/AppInfo;Ljava/util/Locale;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/lang/String;)V", "extraHeaders", "", "getExtraHeaders", "()Ljava/util/Map;", "languageTag", "getLanguageTag", "()Ljava/lang/String;", "stripeClientUserAgentHeaderFactory", "Lcom/stripe/android/networking/StripeClientUserAgentHeaderFactory;", "userAgent", "getUserAgent", "Companion", "stripe_release"})
    public static final class Api
    extends RequestHeadersFactory {
        private final StripeClientUserAgentHeaderFactory stripeClientUserAgentHeaderFactory;
        private final ApiRequest.Options options;
        private final AppInfo appInfo;
        private final Locale locale;
        private final String apiVersion;
        private final String sdkVersion;
        @Deprecated
        private static final Function1<String, String> DEFAULT_SYSTEM_PROPERTY_SUPPLIER;
        @NotNull
        private static final Companion Companion;

        private final String getLanguageTag() {
            String string2 = this.locale.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"locale.toString()");
            String string3 = StringsKt.replace$default((String)string2, (String)"_", (String)"-", (boolean)false, (int)4, null);
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            return !StringsKt.isBlank((CharSequence)charSequence) ? string3 : null;
        }

        @Override
        @NotNull
        protected String getUserAgent() {
            Object[] objectArray = new String[2];
            objectArray[0] = Companion.getUserAgent$stripe_release(this.sdkVersion);
            AppInfo appInfo = this.appInfo;
            objectArray[1] = appInfo != null ? appInfo.toUserAgent$stripe_release() : null;
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        protected Map<String, String> getExtraHeaders() {
            Map map;
            Map map2;
            Map map3;
            Map map4;
            String it;
            Map map5;
            boolean bl;
            boolean bl2;
            String string2;
            Map map6 = MapsKt.plus((Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Accept", (Object)"application/json"), TuplesKt.to((Object)"Stripe-Version", (Object)this.apiVersion), TuplesKt.to((Object)"Authorization", (Object)("Bearer " + this.options.getApiKey()))}), this.stripeClientUserAgentHeaderFactory.create(this.appInfo));
            String string3 = this.options.getStripeAccount$stripe_release();
            if (string3 != null) {
                string2 = string3;
                bl2 = false;
                bl = false;
                String string4 = string2;
                map5 = map6;
                boolean bl3 = false;
                map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Stripe-Account", (Object)it));
                map6 = map5;
                map3 = map4;
            } else {
                map3 = null;
            }
            string2 = map3;
            bl2 = false;
            Object object = string2;
            if (object == null) {
                object = MapsKt.emptyMap();
            }
            Map map7 = MapsKt.plus((Map)map6, (Map)object);
            String string5 = this.options.getIdempotencyKey$stripe_release();
            if (string5 != null) {
                string2 = string5;
                bl2 = false;
                bl = false;
                it = string2;
                map5 = map7;
                boolean bl4 = false;
                map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Idempotency-Key", (Object)it));
                map7 = map5;
                map2 = map4;
            } else {
                map2 = null;
            }
            string2 = map2;
            bl2 = false;
            Object object2 = string2;
            if (object2 == null) {
                object2 = MapsKt.emptyMap();
            }
            Map map8 = MapsKt.plus((Map)map7, (Map)object2);
            String string6 = this.getLanguageTag();
            if (string6 != null) {
                string2 = string6;
                bl2 = false;
                bl = false;
                it = string2;
                map5 = map8;
                boolean bl5 = false;
                map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Accept-Language", (Object)it));
                map8 = map5;
                map = map4;
            } else {
                map = null;
            }
            string2 = map;
            bl2 = false;
            Object object3 = string2;
            if (object3 == null) {
                object3 = MapsKt.emptyMap();
            }
            return MapsKt.plus((Map)map8, (Map)object3);
        }

        public Api(@NotNull ApiRequest.Options options, @Nullable AppInfo appInfo, @NotNull Locale locale, @NotNull Function1<? super String, String> systemPropertySupplier, @NotNull String apiVersion, @NotNull String sdkVersion) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter(systemPropertySupplier, (String)"systemPropertySupplier");
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
            super(null);
            this.options = options;
            this.appInfo = appInfo;
            this.locale = locale;
            this.apiVersion = apiVersion;
            this.sdkVersion = sdkVersion;
            this.stripeClientUserAgentHeaderFactory = new StripeClientUserAgentHeaderFactory(systemPropertySupplier);
        }

        public /* synthetic */ Api(ApiRequest.Options options, AppInfo appInfo, Locale locale, Function1 function1, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                appInfo = null;
            }
            if ((n & 4) != 0) {
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"Locale.getDefault()");
                locale = locale2;
            }
            if ((n & 8) != 0) {
                function1 = DEFAULT_SYSTEM_PROPERTY_SUPPLIER;
            }
            if ((n & 0x10) != 0) {
                string2 = ApiVersion.Companion.get$stripe_release().getCode$stripe_release();
            }
            if ((n & 0x20) != 0) {
                string3 = "AndroidBindings/16.4.3";
            }
            this(options, appInfo, locale, function1, string2, string3);
        }

        static {
            Companion = new Companion(null);
            DEFAULT_SYSTEM_PROPERTY_SUPPLIER = Companion.DEFAULT_SYSTEM_PROPERTY_SUPPLIER.1.INSTANCE;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory$Api$Companion;", "", "()V", "DEFAULT_SYSTEM_PROPERTY_SUPPLIER", "Lkotlin/Function1;", "", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory$Fingerprint;", "Lcom/stripe/android/networking/RequestHeadersFactory;", "guid", "", "(Ljava/lang/String;)V", "extraHeaders", "", "getExtraHeaders", "()Ljava/util/Map;", "userAgent", "getUserAgent", "()Ljava/lang/String;", "Companion", "stripe_release"})
    public static final class Fingerprint
    extends RequestHeadersFactory {
        @NotNull
        private final Map<String, String> extraHeaders;
        @NotNull
        private final String userAgent;
        @Deprecated
        private static final String HEADER_COOKIE = "Cookie";
        @NotNull
        private static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        protected Map<String, String> getExtraHeaders() {
            return this.extraHeaders;
        }

        @Override
        @NotNull
        protected String getUserAgent() {
            return this.userAgent;
        }

        public Fingerprint(@NotNull String guid) {
            Intrinsics.checkNotNullParameter((Object)guid, (String)"guid");
            super(null);
            this.extraHeaders = MapsKt.mapOf((Pair)TuplesKt.to((Object)HEADER_COOKIE, (Object)("m=" + guid)));
            this.userAgent = Companion.getUserAgent$stripe_release("AndroidBindings/16.4.3");
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory$Fingerprint$Companion;", "", "()V", "HEADER_COOKIE", "", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory$Analytics;", "Lcom/stripe/android/networking/RequestHeadersFactory;", "()V", "extraHeaders", "", "", "getExtraHeaders", "()Ljava/util/Map;", "userAgent", "getUserAgent", "()Ljava/lang/String;", "stripe_release"})
    public static final class Analytics
    extends RequestHeadersFactory {
        @NotNull
        private static final String userAgent;
        @NotNull
        private static final Map<String, String> extraHeaders;
        @NotNull
        public static final Analytics INSTANCE;

        @Override
        @NotNull
        protected String getUserAgent() {
            return userAgent;
        }

        @Override
        @NotNull
        protected Map<String, String> getExtraHeaders() {
            return extraHeaders;
        }

        private Analytics() {
            super(null);
        }

        static {
            Analytics analytics;
            INSTANCE = analytics = new Analytics();
            userAgent = Companion.getUserAgent$stripe_release("AndroidBindings/16.4.3");
            extraHeaders = MapsKt.emptyMap();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\nR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/networking/RequestHeadersFactory$Companion;", "", "()V", "CHARSET", "", "kotlin.jvm.PlatformType", "HEADER_ACCEPT_CHARSET", "HEADER_USER_AGENT", "getUserAgent", "sdkVersion", "getUserAgent$stripe_release", "stripe_release"})
    public static final class Companion {
        @NotNull
        public final String getUserAgent$stripe_release(@NotNull String sdkVersion) {
            Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
            return "Stripe/v1 " + sdkVersion;
        }

        public static /* synthetic */ String getUserAgent$stripe_release$default(Companion companion, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = "AndroidBindings/16.4.3";
            }
            return companion.getUserAgent$stripe_release(string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

