/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.core.os.ConfigurationCompat;
import com.google.android.material.R;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.R;
import com.stripe.android.view.Country;
import com.stripe.android.view.CountryAdapter;
import com.stripe.android.view.CountryAutoCompleteTextViewValidator;
import com.stripe.android.view.CountryTextInputLayout;
import com.stripe.android.view.CountryUtils;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0000\u0018\u0000 62\u00020\u0001:\u00016B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010$\u001a\u00020\u0015H\u0002J\b\u0010%\u001a\u00020\rH\u0002J\u001b\u0010&\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0000\u00a2\u0006\u0002\b*J\u0015\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020)H\u0000\u00a2\u0006\u0002\b-J\b\u0010.\u001a\u00020\u0015H\u0002J\u0015\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020)H\u0001\u00a2\u0006\u0002\b1J\u0010\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u0014H\u0002J\r\u00104\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b5R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u00020\r8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R&\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R5\u0010\u001c\u001a\u0004\u0018\u00010\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u00148F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\"\u0010#\u0012\u0004\b\u001d\u0010\u000f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00067"}, d2={"Lcom/stripe/android/view/CountryTextInputLayout;", "Lcom/google/android/material/textfield/TextInputLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "countryAdapter", "Lcom/stripe/android/view/CountryAdapter;", "countryAutoCompleteStyleRes", "countryAutocomplete", "Landroid/widget/AutoCompleteTextView;", "getCountryAutocomplete$stripe_release$annotations", "()V", "getCountryAutocomplete$stripe_release", "()Landroid/widget/AutoCompleteTextView;", "countryChangeCallback", "Lkotlin/Function1;", "Lcom/stripe/android/view/Country;", "", "getCountryChangeCallback$stripe_release", "()Lkotlin/jvm/functions/Function1;", "setCountryChangeCallback$stripe_release", "(Lkotlin/jvm/functions/Function1;)V", "itemLayoutRes", "<set-?>", "selectedCountry", "getSelectedCountry$annotations", "getSelectedCountry", "()Lcom/stripe/android/view/Country;", "setSelectedCountry", "(Lcom/stripe/android/view/Country;)V", "selectedCountry$delegate", "Lkotlin/properties/ReadWriteProperty;", "clearError", "initializeCountryAutoCompleteWithStyle", "setAllowedCountryCodes", "allowedCountryCodes", "", "", "setAllowedCountryCodes$stripe_release", "setCountrySelected", "countryCode", "setCountrySelected$stripe_release", "updateInitialCountry", "updateUiForCountryEntered", "displayCountryEntered", "updateUiForCountryEntered$stripe_release", "updatedSelectedCountryCode", "country", "validateCountry", "validateCountry$stripe_release", "Companion", "stripe_release"})
public final class CountryTextInputLayout
extends TextInputLayout {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @StyleRes
    private int countryAutoCompleteStyleRes;
    @LayoutRes
    private int itemLayoutRes;
    @NotNull
    private final AutoCompleteTextView countryAutocomplete;
    @Nullable
    private final ReadWriteProperty selectedCountry$delegate;
    private /* synthetic */ Function1<? super Country, Unit> countryChangeCallback;
    private CountryAdapter countryAdapter;
    @Deprecated
    public static final int INVALID_COUNTRY_AUTO_COMPLETE_STYLE = 0;
    @Deprecated
    private static final int DEFAULT_ITEM_LAYOUT;
    @NotNull
    private static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(CountryTextInputLayout.class, "selectedCountry", "getSelectedCountry()Lcom/stripe/android/view/Country;", 0))};
        Companion = new Companion(null);
        DEFAULT_ITEM_LAYOUT = R.layout.country_text_view;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCountryAutocomplete$stripe_release$annotations() {
    }

    @NotNull
    public final AutoCompleteTextView getCountryAutocomplete$stripe_release() {
        return this.countryAutocomplete;
    }

    @VisibleForTesting
    public static /* synthetic */ void getSelectedCountry$annotations() {
    }

    @Nullable
    public final Country getSelectedCountry() {
        return (Country)this.selectedCountry$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setSelectedCountry(@Nullable Country country) {
        this.selectedCountry$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)country);
    }

    @NotNull
    public final Function1<Country, Unit> getCountryChangeCallback$stripe_release() {
        return this.countryChangeCallback;
    }

    public final void setCountryChangeCallback$stripe_release(@NotNull Function1<? super Country, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.countryChangeCallback = function1;
    }

    private final AutoCompleteTextView initializeCountryAutoCompleteWithStyle() {
        AutoCompleteTextView autoCompleteTextView;
        switch (this.countryAutoCompleteStyleRes) {
            case 0: {
                autoCompleteTextView = new AutoCompleteTextView(this.getContext(), null, R.attr.autoCompleteTextViewStyle);
                break;
            }
            default: {
                autoCompleteTextView = new AutoCompleteTextView(this.getContext(), null, 0, this.countryAutoCompleteStyleRes);
            }
        }
        return autoCompleteTextView;
    }

    private final void updateInitialCountry() {
        Country initialCountry = this.countryAdapter.getFirstItem$stripe_release();
        this.countryAutocomplete.setText((CharSequence)initialCountry.getName());
        this.setSelectedCountry(initialCountry);
    }

    public final void setAllowedCountryCodes$stripe_release(@NotNull Set<String> allowedCountryCodes) {
        Intrinsics.checkNotNullParameter(allowedCountryCodes, (String)"allowedCountryCodes");
        boolean isUpdated = this.countryAdapter.updateUnfilteredCountries$stripe_release(allowedCountryCodes);
        if (isUpdated) {
            this.updateInitialCountry();
        }
    }

    public final void setCountrySelected$stripe_release(@NotNull String countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        this.updateUiForCountryEntered$stripe_release(CountryUtils.INSTANCE.getDisplayCountry(countryCode));
    }

    @VisibleForTesting
    public final void updateUiForCountryEntered$stripe_release(@NotNull String displayCountryEntered) {
        String string2;
        Country country;
        Intrinsics.checkNotNullParameter((Object)displayCountryEntered, (String)"displayCountryEntered");
        Country country2 = country = CountryUtils.INSTANCE.getCountryByName$stripe_release(displayCountryEntered);
        if (country2 != null) {
            Country country3 = country2;
            boolean bl = false;
            boolean bl2 = false;
            Country it = country3;
            boolean bl3 = false;
            this.updatedSelectedCountryCode(it);
            string2 = displayCountryEntered;
        } else {
            Country country4 = this.getSelectedCountry();
            string2 = country4 != null ? country4.getName() : null;
        }
        String displayCountry = string2;
        this.countryAutocomplete.setText((CharSequence)displayCountry);
    }

    private final void updatedSelectedCountryCode(Country country) {
        this.clearError();
        if (Intrinsics.areEqual((Object)this.getSelectedCountry(), (Object)country) ^ true) {
            this.setSelectedCountry(country);
        }
    }

    public final void validateCountry$stripe_release() {
        this.countryAutocomplete.performValidation();
    }

    private final void clearError() {
        this.setError(null);
        this.setErrorEnabled(false);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public CountryTextInputLayout(final @NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void attrs$iv;
        void $this$withStyledAttributes$iv;
        int[] initialValue$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.itemLayoutRes = DEFAULT_ITEM_LAYOUT;
        Delegates delegates = Delegates.INSTANCE;
        Object var5_5 = null;
        boolean $i$f$observable = false;
        this.selectedCountry$delegate = (ReadWriteProperty)new ObservableProperty<Country>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ CountryTextInputLayout this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = countryTextInputLayout;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                block0: {
                    void newCountryValue;
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    Country country = (Country)newValue;
                    Country country2 = (Country)oldValue;
                    KProperty $noName_0 = property;
                    boolean bl = false;
                    void v0 = newCountryValue;
                    if (v0 == null) break block0;
                    void var8_8 = v0;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    void it = var8_8;
                    boolean bl4 = false;
                    this.this$0.getCountryChangeCallback$stripe_release().invoke((Object)it);
                }
            }
        };
        this.countryChangeCallback = countryChangeCallback.1.INSTANCE;
        Context this_$iv = context;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.StripeCountryAutoCompleteTextInputLayout, (String)"R.styleable.StripeCountr\u2026toCompleteTextInputLayout");
        initialValue$iv = R.styleable.StripeCountryAutoCompleteTextInputLayout;
        int defStyleAttr$iv = 0;
        int defStyleRes$iv = 0;
        boolean $i$f$withStyledAttributes = false;
        TypedArray typedArray = $this$withStyledAttributes$iv.obtainStyledAttributes(attrs, (int[])attrs$iv, defStyleAttr$iv, defStyleRes$iv);
        boolean bl = false;
        boolean bl2 = false;
        TypedArray $this$withStyledAttributes = typedArray;
        boolean bl3 = false;
        this.countryAutoCompleteStyleRes = $this$withStyledAttributes.getResourceId(R.styleable.StripeCountryAutoCompleteTextInputLayout_countryAutoCompleteStyle, 0);
        this.itemLayoutRes = $this$withStyledAttributes.getResourceId(R.styleable.StripeCountryAutoCompleteTextInputLayout_countryItemLayout, DEFAULT_ITEM_LAYOUT);
        typedArray.recycle();
        this.countryAutocomplete = this.initializeCountryAutoCompleteWithStyle();
        this.addView((View)this.countryAutocomplete, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        Locale locale = ConfigurationCompat.getLocales((Configuration)resources.getConfiguration()).get(0);
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ConfigurationCompat.getL\u2026sources.configuration)[0]");
        this.countryAdapter = new CountryAdapter(context, CountryUtils.INSTANCE.getOrderedCountries$stripe_release(locale), this.itemLayoutRes, (Function1<? super ViewGroup, ? extends TextView>)((Function1)new Function1<ViewGroup, TextView>(){

            @NotNull
            public final TextView invoke(@NotNull ViewGroup it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                View view = LayoutInflater.from((Context)context).inflate(itemLayoutRes, it, false);
                if (view == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
                }
                return (TextView)view;
            }
        }));
        this.countryAutocomplete.setThreshold(0);
        this.countryAutocomplete.setAdapter((ListAdapter)this.countryAdapter);
        this.countryAutocomplete.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public final void onItemClick(AdapterView<?> $noName_0, View $noName_1, int position, long $noName_3) {
                this.updatedSelectedCountryCode(countryAdapter.getItem(position));
            }
        });
        this.countryAutocomplete.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public final void onFocusChange(View $noName_0, boolean focused) {
                if (focused) {
                    this.getCountryAutocomplete$stripe_release().showDropDown();
                } else {
                    String countryEntered = this.getCountryAutocomplete$stripe_release().getText().toString();
                    this.updateUiForCountryEntered$stripe_release(countryEntered);
                }
            }
        });
        this.setSelectedCountry(this.countryAdapter.getFirstItem$stripe_release());
        this.updateInitialCountry();
        String string2 = this.getResources().getString(R.string.address_country_invalid);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.st\u2026.address_country_invalid)");
        final String errorMessage = string2;
        this.countryAutocomplete.setValidator((AutoCompleteTextView.Validator)new CountryAutoCompleteTextViewValidator(this.countryAdapter, (Function1<? super Country, Unit>)((Function1)new Function1<Country, Unit>(){

            public final void invoke(@Nullable Country country) {
                this.setSelectedCountry(country);
                if (country != null) {
                    this.clearError();
                } else {
                    this.setError(errorMessage);
                    this.setErrorEnabled(true);
                }
            }
        })));
    }

    public /* synthetic */ CountryTextInputLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.textInputStyle;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CountryTextInputLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CountryTextInputLayout(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$setItemLayoutRes$p(CountryTextInputLayout $this, int n) {
        $this.itemLayoutRes = n;
    }

    public static final /* synthetic */ void access$setCountryAdapter$p(CountryTextInputLayout $this, CountryAdapter countryAdapter) {
        $this.countryAdapter = countryAdapter;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/view/CountryTextInputLayout$Companion;", "", "()V", "DEFAULT_ITEM_LAYOUT", "", "getDEFAULT_ITEM_LAYOUT", "()I", "INVALID_COUNTRY_AUTO_COMPLETE_STYLE", "stripe_release"})
    private static final class Companion {
        public final int getDEFAULT_ITEM_LAYOUT() {
            return DEFAULT_ITEM_LAYOUT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

