/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ \u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0007\u00a8\u0006\r"}, d2={"Lcom/stripe/android/view/PaymentUtils;", "", "()V", "formatPriceString", "", "amount", "", "currency", "Ljava/util/Currency;", "formatPriceString$stripe_release", "formatPriceStringUsingFree", "", "free", "stripe_release"})
public final class PaymentUtils {
    @NotNull
    public static final PaymentUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final String formatPriceStringUsingFree(long amount, @NotNull Currency currency, @NotNull String free) {
        DecimalFormatSymbols decimalFormatSymbols;
        NumberFormat currencyFormat;
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)free, (String)"free");
        if (amount == 0L) {
            return free;
        }
        NumberFormat numberFormat = currencyFormat = NumberFormat.getCurrencyInstance();
        if (numberFormat == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.text.DecimalFormat");
        }
        DecimalFormatSymbols decimalFormatSymbols2 = decimalFormatSymbols = ((DecimalFormat)numberFormat).getDecimalFormatSymbols();
        Intrinsics.checkNotNullExpressionValue((Object)decimalFormatSymbols2, (String)"decimalFormatSymbols");
        decimalFormatSymbols2.setCurrencySymbol(currency.getSymbol(Locale.getDefault()));
        ((DecimalFormat)currencyFormat).setDecimalFormatSymbols(decimalFormatSymbols);
        return INSTANCE.formatPriceString$stripe_release(amount, currency);
    }

    public final /* synthetic */ String formatPriceString$stripe_release(double amount, Currency currency) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        double d = 10.0;
        double d2 = currency.getDefaultFractionDigits();
        boolean bl = false;
        double majorUnitAmount = amount / Math.pow(d, d2);
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance();
        try {
            DecimalFormatSymbols decimalFormatSymbols;
            NumberFormat numberFormat = currencyFormat;
            if (numberFormat == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.text.DecimalFormat");
            }
            DecimalFormatSymbols decimalFormatSymbols2 = decimalFormatSymbols = ((DecimalFormat)numberFormat).getDecimalFormatSymbols();
            Intrinsics.checkNotNullExpressionValue((Object)decimalFormatSymbols2, (String)"decimalFormatSymbols");
            decimalFormatSymbols2.setCurrencySymbol(currency.getSymbol(Locale.getDefault()));
            ((DecimalFormat)currencyFormat).setDecimalFormatSymbols(decimalFormatSymbols);
            String string3 = currencyFormat.format(majorUnitAmount);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"currencyFormat.format(majorUnitAmount)");
            string2 = string3;
        }
        catch (ClassCastException e) {
            String string4 = currencyFormat.format(majorUnitAmount);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"currencyFormat.format(majorUnitAmount)");
            string2 = string4;
        }
        return string2;
    }

    private PaymentUtils() {
    }

    static {
        PaymentUtils paymentUtils;
        INSTANCE = paymentUtils = new PaymentUtils();
    }
}

