/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import androidx.annotation.ColorInt;
import androidx.appcompat.R;
import androidx.core.content.ContextCompat;
import com.google.android.material.textfield.TextInputEditText;
import com.stripe.android.R;
import com.stripe.android.view.StripeColorUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001:\u0004@ABCB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020-H\u0002J\b\u00103\u001a\u00020-H\u0002J\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020-2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020-2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010<\u001a\u00020-2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010=\u001a\u00020-2\b\b\u0001\u0010\u001a\u001a\u00020\u0007J\u0010\u0010>\u001a\u00020-2\b\u0010\u001c\u001a\u0004\u0018\u00010\nJ\u0010\u0010?\u001a\u00020-2\b\u0010 \u001a\u0004\u0018\u00010!R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\fR\u001a\u0010$\u001a\u00020%X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010&\"\u0004\b'\u0010(R$\u0010)\u001a\u00020%2\u0006\u0010)\u001a\u00020%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(\u00a8\u0006D"}, d2={"Lcom/stripe/android/view/StripeEditText;", "Lcom/google/android/material/textfield/TextInputEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "accessibilityText", "", "getAccessibilityText", "()Ljava/lang/String;", "afterTextChangedListener", "Lcom/stripe/android/view/StripeEditText$AfterTextChangedListener;", "<set-?>", "Landroid/content/res/ColorStateList;", "cachedColorStateList", "getCachedColorStateList", "()Landroid/content/res/ColorStateList;", "defaultErrorColor", "defaultErrorColorInt", "getDefaultErrorColorInt", "()I", "deleteEmptyListener", "Lcom/stripe/android/view/StripeEditText$DeleteEmptyListener;", "errorColor", "Ljava/lang/Integer;", "errorMessage", "getErrorMessage$stripe_release", "setErrorMessage$stripe_release", "(Ljava/lang/String;)V", "errorMessageListener", "Lcom/stripe/android/view/StripeEditText$ErrorMessageListener;", "fieldText", "getFieldText$stripe_release", "isLastKeyDelete", "", "()Z", "setLastKeyDelete", "(Z)V", "shouldShowError", "getShouldShowError", "setShouldShowError", "determineDefaultErrorColor", "", "isDeleteKey", "keyCode", "event", "Landroid/view/KeyEvent;", "listenForDeleteEmpty", "listenForTextChanges", "onCreateInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "onInitializeAccessibilityNodeInfo", "info", "Landroid/view/accessibility/AccessibilityNodeInfo;", "setAfterTextChangedListener", "setDeleteEmptyListener", "setErrorColor", "setErrorMessage", "setErrorMessageListener", "AfterTextChangedListener", "DeleteEmptyListener", "ErrorMessageListener", "SoftDeleteInputConnection", "stripe_release"})
public class StripeEditText
extends TextInputEditText {
    private boolean isLastKeyDelete;
    private AfterTextChangedListener afterTextChangedListener;
    private DeleteEmptyListener deleteEmptyListener;
    @Nullable
    private ColorStateList cachedColorStateList;
    private boolean shouldShowError;
    @Nullable
    private String errorMessage;
    @ColorInt
    private int defaultErrorColor;
    @ColorInt
    private Integer errorColor;
    private ErrorMessageListener errorMessageListener;
    @Nullable
    private final String accessibilityText;

    protected final boolean isLastKeyDelete() {
        return this.isLastKeyDelete;
    }

    protected final void setLastKeyDelete(boolean bl) {
        this.isLastKeyDelete = bl;
    }

    @Nullable
    public final ColorStateList getCachedColorStateList() {
        return this.cachedColorStateList;
    }

    public final boolean getShouldShowError() {
        return this.shouldShowError;
    }

    public final void setShouldShowError(boolean shouldShowError) {
        String string2 = this.errorMessage;
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            ErrorMessageListener errorMessageListener = this.errorMessageListener;
            if (errorMessageListener != null) {
                String string4 = it;
                boolean bl4 = false;
                boolean bl5 = false;
                String string5 = string4;
                ErrorMessageListener errorMessageListener2 = errorMessageListener;
                boolean bl6 = false;
                boolean bl7 = shouldShowError;
                errorMessageListener2.displayErrorMessage(bl7 ? string4 : null);
            }
        }
        if (this.shouldShowError != shouldShowError) {
            if (shouldShowError) {
                Integer n = this.errorColor;
                this.setTextColor(n != null ? n : this.defaultErrorColor);
            } else {
                this.setTextColor(this.cachedColorStateList);
            }
            this.refreshDrawableState();
        }
        this.shouldShowError = shouldShowError;
    }

    @Nullable
    public final String getErrorMessage$stripe_release() {
        return this.errorMessage;
    }

    public final void setErrorMessage$stripe_release(@Nullable String string2) {
        this.errorMessage = string2;
    }

    @NotNull
    public final String getFieldText$stripe_release() {
        Editable editable = this.getText();
        String string2 = editable != null ? editable.toString() : null;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        return string3;
    }

    @ColorInt
    public final int getDefaultErrorColorInt() {
        this.determineDefaultErrorColor();
        return this.defaultErrorColor;
    }

    @Nullable
    protected String getAccessibilityText() {
        return this.accessibilityText;
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NotNull EditorInfo outAttrs) {
        SoftDeleteInputConnection softDeleteInputConnection;
        InputConnection inputConnection;
        Intrinsics.checkNotNullParameter((Object)outAttrs, (String)"outAttrs");
        InputConnection inputConnection2 = inputConnection = super.onCreateInputConnection(outAttrs);
        if (inputConnection2 != null) {
            InputConnection inputConnection3 = inputConnection2;
            boolean bl = false;
            boolean bl2 = false;
            InputConnection it = inputConnection3;
            boolean bl3 = false;
            softDeleteInputConnection = new SoftDeleteInputConnection(it, true, this.deleteEmptyListener);
        } else {
            softDeleteInputConnection = null;
        }
        return (InputConnection)softDeleteInputConnection;
    }

    public final void setAfterTextChangedListener(@Nullable AfterTextChangedListener afterTextChangedListener) {
        this.afterTextChangedListener = afterTextChangedListener;
    }

    public final void setDeleteEmptyListener(@Nullable DeleteEmptyListener deleteEmptyListener) {
        this.deleteEmptyListener = deleteEmptyListener;
    }

    public final void setErrorMessageListener(@Nullable ErrorMessageListener errorMessageListener) {
        this.errorMessageListener = errorMessageListener;
    }

    public final void setErrorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public final void setErrorColor(@ColorInt int errorColor) {
        this.errorColor = errorColor;
    }

    public void onInitializeAccessibilityNodeInfo(@NotNull AccessibilityNodeInfo info) {
        String it;
        boolean bl;
        boolean bl2;
        String string2;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        super.onInitializeAccessibilityNodeInfo(info);
        info.setContentInvalid(this.shouldShowError);
        String string3 = this.getAccessibilityText();
        if (string3 != null) {
            string2 = string3;
            bl2 = false;
            bl = false;
            it = string2;
            boolean bl3 = false;
            info.setText((CharSequence)it);
        }
        string2 = this.errorMessage;
        bl2 = false;
        bl = false;
        it = string2;
        AccessibilityNodeInfo accessibilityNodeInfo = info;
        boolean bl4 = false;
        boolean bl5 = this.shouldShowError;
        accessibilityNodeInfo.setError((CharSequence)(bl5 ? string2 : null));
    }

    private final void determineDefaultErrorColor() {
        this.cachedColorStateList = this.getTextColors();
        Context context = this.getContext();
        ColorStateList colorStateList = this.getTextColors();
        Intrinsics.checkNotNullExpressionValue((Object)colorStateList, (String)"textColors");
        this.defaultErrorColor = ContextCompat.getColor((Context)context, (int)(StripeColorUtils.Companion.isColorDark(colorStateList.getDefaultColor()) ? R.color.stripe_error_text_light_theme : R.color.stripe_error_text_dark_theme));
    }

    private final void listenForTextChanges() {
        StripeEditText $this$doAfterTextChanged$iv = this;
        boolean $i$f$doAfterTextChanged = false;
        StripeEditText $this$addTextChangedListener$iv$iv = $this$doAfterTextChanged$iv;
        boolean $i$f$addTextChangedListener = false;
        TextWatcher textWatcher$iv$iv = new TextWatcher(this){
            final /* synthetic */ StripeEditText this$0;
            {
                this.this$0 = stripeEditText;
            }

            public void afterTextChanged(@Nullable Editable s) {
                block1: {
                    Editable editable = s;
                    boolean bl = false;
                    AfterTextChangedListener afterTextChangedListener = StripeEditText.access$getAfterTextChangedListener$p(this.this$0);
                    if (afterTextChangedListener == null) break block1;
                    Editable editable2 = editable;
                    String string2 = editable2 != null ? editable2.toString() : null;
                    boolean bl2 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        string3 = "";
                    }
                    afterTextChangedListener.onTextChanged(string3);
                }
            }

            public void beforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
                int n = after;
                int n2 = count;
                int n3 = start;
                CharSequence $noName_0 = text;
            }

            public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
                int n = count;
                int n2 = before;
                int n3 = start;
                CharSequence $noName_0 = text;
            }
        };
        $this$addTextChangedListener$iv$iv.addTextChangedListener(textWatcher$iv$iv);
    }

    private final void listenForDeleteEmpty() {
        this.setOnKeyListener(new View.OnKeyListener(this){
            final /* synthetic */ StripeEditText this$0;

            public final boolean onKey(View $noName_0, int keyCode, KeyEvent event) {
                block1: {
                    KeyEvent keyEvent = event;
                    Intrinsics.checkNotNullExpressionValue((Object)keyEvent, (String)"event");
                    this.this$0.setLastKeyDelete(StripeEditText.access$isDeleteKey(this.this$0, keyCode, keyEvent));
                    if (!this.this$0.isLastKeyDelete() || this.this$0.length() != 0) break block1;
                    DeleteEmptyListener deleteEmptyListener = StripeEditText.access$getDeleteEmptyListener$p(this.this$0);
                    if (deleteEmptyListener != null) {
                        deleteEmptyListener.onDeleteEmpty();
                    }
                }
                return false;
            }
            {
                this.this$0 = stripeEditText;
            }
        });
    }

    private final boolean isDeleteKey(int keyCode, KeyEvent event) {
        return keyCode == 67 && event.getAction() == 0;
    }

    @JvmOverloads
    public StripeEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.setMaxLines(1);
        this.listenForTextChanges();
        this.listenForDeleteEmpty();
        this.determineDefaultErrorColor();
        this.cachedColorStateList = this.getTextColors();
    }

    public /* synthetic */ StripeEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public StripeEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public StripeEditText(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ AfterTextChangedListener access$getAfterTextChangedListener$p(StripeEditText $this) {
        return $this.afterTextChangedListener;
    }

    public static final /* synthetic */ void access$setAfterTextChangedListener$p(StripeEditText $this, AfterTextChangedListener afterTextChangedListener) {
        $this.afterTextChangedListener = afterTextChangedListener;
    }

    public static final /* synthetic */ boolean access$isDeleteKey(StripeEditText $this, int keyCode, KeyEvent event) {
        return $this.isDeleteKey(keyCode, event);
    }

    public static final /* synthetic */ DeleteEmptyListener access$getDeleteEmptyListener$p(StripeEditText $this) {
        return $this.deleteEmptyListener;
    }

    public static final /* synthetic */ void access$setDeleteEmptyListener$p(StripeEditText $this, DeleteEmptyListener deleteEmptyListener) {
        $this.deleteEmptyListener = deleteEmptyListener;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/view/StripeEditText$DeleteEmptyListener;", "", "onDeleteEmpty", "", "stripe_release"})
    public static interface DeleteEmptyListener {
        public void onDeleteEmpty();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/StripeEditText$AfterTextChangedListener;", "", "onTextChanged", "", "text", "", "stripe_release"})
    public static interface AfterTextChangedListener {
        public void onTextChanged(@NotNull String var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/StripeEditText$ErrorMessageListener;", "", "displayErrorMessage", "", "message", "", "stripe_release"})
    public static interface ErrorMessageListener {
        public void displayErrorMessage(@Nullable String var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/view/StripeEditText$SoftDeleteInputConnection;", "Landroid/view/inputmethod/InputConnectionWrapper;", "target", "Landroid/view/inputmethod/InputConnection;", "mutable", "", "deleteEmptyListener", "Lcom/stripe/android/view/StripeEditText$DeleteEmptyListener;", "(Landroid/view/inputmethod/InputConnection;ZLcom/stripe/android/view/StripeEditText$DeleteEmptyListener;)V", "deleteSurroundingText", "beforeLength", "", "afterLength", "stripe_release"})
    private static final class SoftDeleteInputConnection
    extends InputConnectionWrapper {
        private final DeleteEmptyListener deleteEmptyListener;

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            block1: {
                CharSequence charSequence = this.getTextBeforeCursor(1, 0);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getTextBeforeCursor(1, 0)");
                CharSequence charSequence2 = charSequence;
                boolean bl = false;
                if (!(charSequence2.length() == 0)) break block1;
                DeleteEmptyListener deleteEmptyListener = this.deleteEmptyListener;
                if (deleteEmptyListener != null) {
                    deleteEmptyListener.onDeleteEmpty();
                }
            }
            return super.deleteSurroundingText(beforeLength, afterLength);
        }

        public SoftDeleteInputConnection(@NotNull InputConnection target, boolean mutable, @Nullable DeleteEmptyListener deleteEmptyListener) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            super(target, mutable);
            this.deleteEmptyListener = deleteEmptyListener;
        }
    }
}

