/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.StringRes;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.stripe.android.CustomerSession;
import com.stripe.android.R;
import com.stripe.android.StripeError;
import com.stripe.android.exception.APIException;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.CardDisplayTextFactory;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001.B2\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$H\u0002J\"\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0'0\u00050&H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020*2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\u00020*2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b-R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006/"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "customerSession", "Lkotlin/Result;", "Lcom/stripe/android/CustomerSession;", "selectedPaymentMethodId", "", "startedFromPaymentSession", "", "(Landroid/app/Application;Ljava/lang/Object;Ljava/lang/String;Z)V", "cardDisplayTextFactory", "Lcom/stripe/android/view/CardDisplayTextFactory;", "Ljava/lang/Object;", "productUsage", "", "getProductUsage$stripe_release", "()Ljava/util/Set;", "progressData", "Landroidx/lifecycle/MutableLiveData;", "getProgressData$stripe_release", "()Landroidx/lifecycle/MutableLiveData;", "resources", "Landroid/content/res/Resources;", "kotlin.jvm.PlatformType", "getSelectedPaymentMethodId$stripe_release", "()Ljava/lang/String;", "setSelectedPaymentMethodId$stripe_release", "(Ljava/lang/String;)V", "snackbarData", "getSnackbarData$stripe_release", "createSnackbarText", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "stringRes", "", "getPaymentMethods", "Landroidx/lifecycle/LiveData;", "", "getPaymentMethods$stripe_release", "onPaymentMethodAdded", "", "onPaymentMethodAdded$stripe_release", "onPaymentMethodRemoved", "onPaymentMethodRemoved$stripe_release", "Factory", "stripe_release"})
public final class PaymentMethodsViewModel
extends AndroidViewModel {
    private final Resources resources;
    private final CardDisplayTextFactory cardDisplayTextFactory;
    @NotNull
    private final Set<String> productUsage;
    @NotNull
    private final MutableLiveData<String> snackbarData;
    @NotNull
    private final MutableLiveData<Boolean> progressData;
    private final Object customerSession;
    @Nullable
    private String selectedPaymentMethodId;
    private final boolean startedFromPaymentSession;

    @NotNull
    public final Set<String> getProductUsage$stripe_release() {
        return this.productUsage;
    }

    @NotNull
    public final MutableLiveData<String> getSnackbarData$stripe_release() {
        return this.snackbarData;
    }

    @NotNull
    public final MutableLiveData<Boolean> getProgressData$stripe_release() {
        return this.progressData;
    }

    public final void onPaymentMethodAdded$stripe_release(@NotNull PaymentMethod paymentMethod) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
            String string2 = this.createSnackbarText(paymentMethod, R.string.added);
            if (string2 == null) break block0;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.snackbarData.setValue((Object)it);
            this.snackbarData.setValue(null);
        }
    }

    public final void onPaymentMethodRemoved$stripe_release(@NotNull PaymentMethod paymentMethod) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
            String string2 = this.createSnackbarText(paymentMethod, R.string.removed);
            if (string2 == null) break block0;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.snackbarData.setValue((Object)it);
            this.snackbarData.setValue(null);
        }
    }

    private final String createSnackbarText(PaymentMethod paymentMethod, @StringRes int stringRes) {
        String string2;
        PaymentMethod.Card card = paymentMethod.card;
        if (card != null) {
            PaymentMethod.Card card2 = card;
            boolean bl = false;
            boolean bl2 = false;
            PaymentMethod.Card paymentMethodId = card2;
            boolean bl3 = false;
            string2 = this.resources.getString(stringRes, new Object[]{this.cardDisplayTextFactory.createUnstyled$stripe_release(paymentMethodId)});
        } else {
            string2 = null;
        }
        return string2;
    }

    public final /* synthetic */ LiveData<Result<List<PaymentMethod>>> getPaymentMethods$stripe_release() {
        MutableLiveData resultData = new MutableLiveData();
        this.progressData.setValue((Object)true);
        Object object = this.customerSession;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            CustomerSession it = (CustomerSession)object;
            boolean bl3 = false;
            CustomerSession.getPaymentMethods$stripe_release$default(it, PaymentMethod.Type.Card, null, null, null, this.productUsage, new CustomerSession.PaymentMethodsRetrievalListener(this, resultData){
                final /* synthetic */ PaymentMethodsViewModel this$0;
                final /* synthetic */ MutableLiveData $resultData$inlined;
                {
                    this.this$0 = paymentMethodsViewModel;
                    this.$resultData$inlined = mutableLiveData;
                }

                public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> paymentMethods) {
                    Intrinsics.checkNotNullParameter(paymentMethods, (String)"paymentMethods");
                    Result.Companion companion = Result.Companion;
                    boolean bl = false;
                    this.$resultData$inlined.setValue((Object)Result.box-impl((Object)Result.constructor-impl(paymentMethods)));
                    this.this$0.getProgressData$stripe_release().setValue((Object)false);
                }

                public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                    Result.Companion companion = Result.Companion;
                    Throwable throwable = new APIException(stripeError, null, errorCode, errorMessage, null, 18, null);
                    boolean bl = false;
                    this.$resultData$inlined.setValue((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable))));
                    this.this$0.getProgressData$stripe_release().setValue((Object)false);
                }
            }, 14, null);
        } else {
            Throwable it = throwable;
            boolean bl4 = false;
            Result.Companion companion = Result.Companion;
            boolean bl5 = false;
            resultData.setValue((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it))));
            this.progressData.setValue((Object)false);
        }
        return (LiveData)resultData;
    }

    @Nullable
    public final String getSelectedPaymentMethodId$stripe_release() {
        return this.selectedPaymentMethodId;
    }

    public final void setSelectedPaymentMethodId$stripe_release(@Nullable String string2) {
        this.selectedPaymentMethodId = string2;
    }

    public PaymentMethodsViewModel(@NotNull Application application, @NotNull Object customerSession2, @Nullable String selectedPaymentMethodId, boolean startedFromPaymentSession2) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        this.customerSession = customerSession2;
        this.selectedPaymentMethodId = selectedPaymentMethodId;
        this.startedFromPaymentSession = startedFromPaymentSession2;
        this.resources = application.getResources();
        this.cardDisplayTextFactory = new CardDisplayTextFactory((Context)application);
        String string2 = "PaymentSession";
        boolean bl = false;
        boolean bl2 = false;
        String string3 = string2;
        int n = 0;
        Object[] objectArray2 = objectArray = new String[2];
        PaymentMethodsViewModel paymentMethodsViewModel = this;
        boolean bl3 = false;
        boolean bl4 = this.startedFromPaymentSession;
        objectArray[n] = bl4 ? string2 : null;
        objectArray2[1] = "PaymentMethodsActivity";
        paymentMethodsViewModel.productUsage = CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2));
        this.snackbarData = new MutableLiveData();
        this.progressData = new MutableLiveData();
    }

    public /* synthetic */ PaymentMethodsViewModel(Application application, Object object, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(application, object, string2, bl);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ'\u0010\r\u001a\u0002H\u000e\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "application", "Landroid/app/Application;", "customerSession", "Lkotlin/Result;", "Lcom/stripe/android/CustomerSession;", "initialPaymentMethodId", "", "startedFromPaymentSession", "", "(Landroid/app/Application;Ljava/lang/Object;Ljava/lang/String;Z)V", "Ljava/lang/Object;", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "stripe_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        private final Application application;
        private final Object customerSession;
        private final String initialPaymentMethodId;
        private final boolean startedFromPaymentSession;

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            return (T)((ViewModel)new PaymentMethodsViewModel(this.application, this.customerSession, this.initialPaymentMethodId, this.startedFromPaymentSession));
        }

        public Factory(@NotNull Application application, @NotNull Object customerSession2, @Nullable String initialPaymentMethodId, boolean startedFromPaymentSession2) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            this.application = application;
            this.customerSession = customerSession2;
            this.initialPaymentMethodId = initialPaymentMethodId;
            this.startedFromPaymentSession = startedFromPaymentSession2;
        }
    }
}

