/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import com.google.android.material.progressindicator.CircularProgressIndicator;
import com.stripe.android.R;
import com.stripe.android.databinding.PaymentSheetBuyButtonBinding;
import com.stripe.android.paymentsheet.CurrencyFormatter;
import com.stripe.android.paymentsheet.model.ViewState;
import com.stripe.android.paymentsheet.ui.PrimaryButton;
import com.stripe.android.paymentsheet.ui.PrimaryButtonAnimator;
import java.util.Currency;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0006\u0010!\u001a\u00020\u001eJ\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020#J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u001eH\u0002J\u000e\u0010(\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000b0\u000b0\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/stripe/android/paymentsheet/BuyButton;", "Lcom/stripe/android/paymentsheet/ui/PrimaryButton;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "_completedAnimation", "Landroidx/lifecycle/MutableLiveData;", "Lcom/stripe/android/paymentsheet/model/ViewState$Completed;", "animator", "Lcom/stripe/android/paymentsheet/ui/PrimaryButtonAnimator;", "completedAnimation", "Landroidx/lifecycle/LiveData;", "kotlin.jvm.PlatformType", "getCompletedAnimation$stripe_release", "()Landroidx/lifecycle/LiveData;", "confirmedIcon", "Landroid/widget/ImageView;", "currencyFormatter", "Lcom/stripe/android/paymentsheet/CurrencyFormatter;", "viewBinding", "Lcom/stripe/android/databinding/PaymentSheetBuyButtonBinding;", "getViewBinding$stripe_release", "()Lcom/stripe/android/databinding/PaymentSheetBuyButtonBinding;", "viewState", "Lcom/stripe/android/paymentsheet/model/ViewState;", "animateConfirmedIcon", "", "state", "onCompletedState", "onConfirmingState", "onReadyState", "Lcom/stripe/android/paymentsheet/model/ViewState$Ready;", "setEnabled", "enabled", "", "updateAlpha", "updateState", "stripe_release"})
public final class BuyButton
extends PrimaryButton {
    private final PrimaryButtonAnimator animator;
    @NotNull
    private final PaymentSheetBuyButtonBinding viewBinding;
    private final ImageView confirmedIcon;
    private final CurrencyFormatter currencyFormatter;
    private final MutableLiveData<ViewState.Completed> _completedAnimation;
    @NotNull
    private final LiveData<ViewState.Completed> completedAnimation;
    private ViewState viewState;

    @NotNull
    public final PaymentSheetBuyButtonBinding getViewBinding$stripe_release() {
        return this.viewBinding;
    }

    @NotNull
    public final LiveData<ViewState.Completed> getCompletedAnimation$stripe_release() {
        return this.completedAnimation;
    }

    public final void onReadyState(@NotNull ViewState.Ready state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        CircularProgressIndicator circularProgressIndicator = this.viewBinding.confirmingIcon;
        Intrinsics.checkNotNullExpressionValue((Object)circularProgressIndicator, (String)"viewBinding.confirmingIcon");
        boolean value$iv = false;
        View $this$isVisible$iv = (View)circularProgressIndicator;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        String string2 = state.getCurrencyCode();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase(locale)");
        Currency currency = Currency.getInstance(string5);
        TextView textView = this.viewBinding.label;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
        Resources resources = this.getResources();
        Object[] objectArray = new Object[1];
        long l = state.getAmount();
        Currency currency2 = currency;
        Intrinsics.checkNotNullExpressionValue((Object)currency2, (String)"currency");
        objectArray[0] = this.currencyFormatter.format(l, currency2);
        textView.setText((CharSequence)resources.getString(R.string.stripe_paymentsheet_pay_button_amount, objectArray));
    }

    public final void onConfirmingState() {
        ImageView imageView = this.viewBinding.lockIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"viewBinding.lockIcon");
        boolean value$iv = false;
        View $this$isVisible$iv = (View)imageView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        CircularProgressIndicator circularProgressIndicator = this.viewBinding.confirmingIcon;
        Intrinsics.checkNotNullExpressionValue((Object)circularProgressIndicator, (String)"viewBinding.confirmingIcon");
        value$iv = true;
        $this$isVisible$iv = (View)circularProgressIndicator;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        TextView textView = this.viewBinding.label;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
        textView.setText((CharSequence)this.getResources().getString(R.string.stripe_paymentsheet_pay_button_processing));
    }

    private final void onCompletedState(ViewState.Completed state) {
        this.setBackgroundResource(R.drawable.stripe_paymentsheet_buy_button_confirmed_background);
        TextView textView = this.viewBinding.label;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
        this.animator.fadeOut$stripe_release((View)textView);
        CircularProgressIndicator circularProgressIndicator = this.viewBinding.confirmingIcon;
        Intrinsics.checkNotNullExpressionValue((Object)circularProgressIndicator, (String)"viewBinding.confirmingIcon");
        this.animator.fadeOut$stripe_release((View)circularProgressIndicator);
        this.animateConfirmedIcon(state);
    }

    private final void animateConfirmedIcon(ViewState.Completed state) {
        this.animator.fadeIn$stripe_release((View)this.confirmedIcon, this.getWidth(), (Function0<Unit>)((Function0)new Function0<Unit>(this, state){
            final /* synthetic */ BuyButton this$0;
            final /* synthetic */ ViewState.Completed $state;

            public final void invoke() {
                BuyButton.access$get_completedAnimation$p(this.this$0).setValue((Object)this.$state);
            }
            {
                this.this$0 = buyButton;
                this.$state = completed;
                super(0);
            }
        }));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ImageView imageView = this.viewBinding.lockIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"viewBinding.lockIcon");
        View $this$isVisible$iv = (View)imageView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(enabled ? 0 : 8);
        this.updateAlpha();
    }

    public final void updateState(@NotNull ViewState viewState) {
        block1: {
            ViewState viewState2;
            block2: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)viewState, (String)"viewState");
                    this.viewState = viewState;
                    this.updateAlpha();
                    viewState2 = viewState;
                    if (!(viewState2 instanceof ViewState.Ready)) break block0;
                    this.onReadyState((ViewState.Ready)viewState);
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)viewState2, (Object)ViewState.Confirming.INSTANCE)) break block2;
                this.onConfirmingState();
                break block1;
            }
            if (!(viewState2 instanceof ViewState.Completed)) break block1;
            this.onCompletedState((ViewState.Completed)viewState);
        }
    }

    private final void updateAlpha() {
        if ((this.viewState == null || this.viewState instanceof ViewState.Ready) && !this.isEnabled()) {
            TextView textView = this.viewBinding.label;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
            textView.setAlpha(0.5f);
        } else {
            TextView textView = this.viewBinding.label;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
            textView.setAlpha(1.0f);
        }
    }

    @JvmOverloads
    public BuyButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.animator = new PrimaryButtonAnimator(context);
        PaymentSheetBuyButtonBinding paymentSheetBuyButtonBinding = PaymentSheetBuyButtonBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)paymentSheetBuyButtonBinding, (String)"PaymentSheetBuyButtonBin\u2026text),\n        this\n    )");
        this.viewBinding = paymentSheetBuyButtonBinding;
        ImageView imageView = this.viewBinding.confirmedIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"viewBinding.confirmedIcon");
        this.confirmedIcon = imageView;
        this.currencyFormatter = new CurrencyFormatter();
        this._completedAnimation = new MutableLiveData();
        LiveData $this$distinctUntilChanged$iv = (LiveData)this._completedAnimation;
        boolean $i$f$distinctUntilChanged = false;
        LiveData liveData = Transformations.distinctUntilChanged((LiveData)$this$distinctUntilChanged$iv);
        Intrinsics.checkNotNullExpressionValue((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        this.completedAnimation = liveData;
        this.setBackgroundResource(R.drawable.stripe_paymentsheet_buy_button_default_background);
        this.setClickable(true);
        this.setEnabled(false);
    }

    public /* synthetic */ BuyButton(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BuyButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BuyButton(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ MutableLiveData access$get_completedAnimation$p(BuyButton $this) {
        return $this._completedAnimation;
    }
}

