/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.app.Application;
import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.stripe.android.PaymentSessionPrefs;
import com.stripe.android.paymentsheet.DefaultGooglePayRepository;
import com.stripe.android.paymentsheet.DefaultPrefsRepository;
import com.stripe.android.paymentsheet.GooglePayRepository;
import com.stripe.android.paymentsheet.PaymentOptionsActivityStarter;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.PrefsRepository;
import com.stripe.android.paymentsheet.analytics.DefaultEventReporter;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.model.PaymentOptionViewState;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.ui.SheetMode;
import com.stripe.android.paymentsheet.viewmodels.SheetViewModel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u000f\u0010B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel;", "Lcom/stripe/android/paymentsheet/viewmodels/SheetViewModel;", "Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget;", "Lcom/stripe/android/paymentsheet/model/PaymentOptionViewState;", "args", "Lcom/stripe/android/paymentsheet/PaymentOptionsActivityStarter$Args;", "googlePayRepository", "Lcom/stripe/android/paymentsheet/GooglePayRepository;", "prefsRepository", "Lcom/stripe/android/paymentsheet/PrefsRepository;", "eventReporter", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "(Lcom/stripe/android/paymentsheet/PaymentOptionsActivityStarter$Args;Lcom/stripe/android/paymentsheet/GooglePayRepository;Lcom/stripe/android/paymentsheet/PrefsRepository;Lcom/stripe/android/paymentsheet/analytics/EventReporter;)V", "selectPaymentOption", "", "Factory", "TransitionTarget", "stripe_release"})
public final class PaymentOptionsViewModel
extends SheetViewModel<TransitionTarget, PaymentOptionViewState> {
    private final EventReporter eventReporter;

    public final void selectPaymentOption() {
        block0: {
            PaymentSelection paymentSelection = (PaymentSelection)this.getSelection$stripe_release().getValue();
            if (paymentSelection == null) break block0;
            PaymentSelection paymentSelection2 = paymentSelection;
            boolean bl = false;
            boolean bl2 = false;
            PaymentSelection paymentSelection3 = paymentSelection2;
            boolean bl3 = false;
            PaymentSelection paymentSelection4 = paymentSelection3;
            Intrinsics.checkNotNullExpressionValue((Object)paymentSelection4, (String)"paymentSelection");
            this.eventReporter.onSelectPaymentOption(paymentSelection4);
            this.getPrefsRepository().savePaymentSelection(paymentSelection3);
            this.get_viewState().setValue((Object)new PaymentOptionViewState.Completed(paymentSelection3));
        }
    }

    public PaymentOptionsViewModel(@NotNull PaymentOptionsActivityStarter.Args args2, @NotNull GooglePayRepository googlePayRepository, @NotNull PrefsRepository prefsRepository, @NotNull EventReporter eventReporter2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Intrinsics.checkNotNullParameter((Object)googlePayRepository, (String)"googlePayRepository");
        Intrinsics.checkNotNullParameter((Object)prefsRepository, (String)"prefsRepository");
        Intrinsics.checkNotNullParameter((Object)eventReporter2, (String)"eventReporter");
        PaymentSheet.Configuration configuration = args2.getConfig();
        super(args2.getConfig(), (configuration != null ? configuration.getGooglePay() : null) != null, googlePayRepository, prefsRepository, null, 16, null);
        this.eventReporter = eventReporter2;
        this.get_paymentIntent().setValue((Object)args2.getPaymentIntent());
        this.get_paymentMethods().setValue(args2.getPaymentMethods());
        this.get_processing().postValue((Object)false);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$TransitionTarget;", "", "sheetMode", "Lcom/stripe/android/paymentsheet/ui/SheetMode;", "(Ljava/lang/String;ILcom/stripe/android/paymentsheet/ui/SheetMode;)V", "getSheetMode", "()Lcom/stripe/android/paymentsheet/ui/SheetMode;", "SelectSavedPaymentMethod", "AddPaymentMethodFull", "AddPaymentMethodSheet", "stripe_release"})
    public static final class TransitionTarget
    extends Enum<TransitionTarget> {
        public static final /* enum */ TransitionTarget SelectSavedPaymentMethod;
        public static final /* enum */ TransitionTarget AddPaymentMethodFull;
        public static final /* enum */ TransitionTarget AddPaymentMethodSheet;
        private static final /* synthetic */ TransitionTarget[] $VALUES;
        @NotNull
        private final SheetMode sheetMode;

        static {
            TransitionTarget[] transitionTargetArray = new TransitionTarget[3];
            TransitionTarget[] transitionTargetArray2 = transitionTargetArray;
            transitionTargetArray[0] = SelectSavedPaymentMethod = new TransitionTarget(SheetMode.Wrapped);
            transitionTargetArray[1] = AddPaymentMethodFull = new TransitionTarget(SheetMode.Full);
            transitionTargetArray[2] = AddPaymentMethodSheet = new TransitionTarget(SheetMode.FullCollapsed);
            $VALUES = transitionTargetArray;
        }

        @NotNull
        public final SheetMode getSheetMode() {
            return this.sheetMode;
        }

        private TransitionTarget(SheetMode sheetMode) {
            this.sheetMode = sheetMode;
        }

        public static TransitionTarget[] values() {
            return (TransitionTarget[])$VALUES.clone();
        }

        public static TransitionTarget valueOf(String string2) {
            return Enum.valueOf(TransitionTarget.class, string2);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J'\u0010\b\u001a\u0002H\t\"\n\b\u0000\u0010\t*\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0016\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "applicationSupplier", "Lkotlin/Function0;", "Landroid/app/Application;", "starterArgsSupplier", "Lcom/stripe/android/paymentsheet/PaymentOptionsActivityStarter$Args;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "stripe_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        private final Function0<Application> applicationSupplier;
        private final Function0<PaymentOptionsActivityStarter.Args> starterArgsSupplier;

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            PrefsRepository prefsRepository;
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            PaymentOptionsActivityStarter.Args starterArgs2 = (PaymentOptionsActivityStarter.Args)this.starterArgsSupplier.invoke();
            Application application = (Application)this.applicationSupplier.invoke();
            Context context = (Context)application;
            Object object = starterArgs2.getConfig();
            if (object == null || (object = object.getGooglePay()) == null || (object = ((PaymentSheet.GooglePayConfiguration)object).getEnvironment()) == null) {
                object = PaymentSheet.GooglePayConfiguration.Environment.Test;
            }
            DefaultGooglePayRepository googlePayRepository = new DefaultGooglePayRepository(context, (PaymentSheet.GooglePayConfiguration.Environment)((Object)object), null, 4, null);
            Object object2 = starterArgs2.getConfig();
            if (object2 != null && (object2 = ((PaymentSheet.Configuration)object2).getCustomer()) != null) {
                Object object3 = object2;
                boolean bl = false;
                boolean bl2 = false;
                Object $dstr$id = object3;
                boolean bl3 = false;
                String id2 = ((PaymentSheet.CustomerConfiguration)$dstr$id).component1();
                prefsRepository = new DefaultPrefsRepository(id2, new PaymentSessionPrefs.Default((Context)application));
            } else {
                prefsRepository = new PrefsRepository.Noop();
            }
            PrefsRepository prefsRepository2 = prefsRepository;
            return (T)((Object)new PaymentOptionsViewModel(starterArgs2, googlePayRepository, prefsRepository2, new DefaultEventReporter(EventReporter.Mode.Custom, starterArgs2.getSessionId(), (Context)application, null, 8, null)));
        }

        public Factory(@NotNull Function0<? extends Application> applicationSupplier, @NotNull Function0<PaymentOptionsActivityStarter.Args> starterArgsSupplier) {
            Intrinsics.checkNotNullParameter(applicationSupplier, (String)"applicationSupplier");
            Intrinsics.checkNotNullParameter(starterArgsSupplier, (String)"starterArgsSupplier");
            this.applicationSupplier = applicationSupplier;
            this.starterArgsSupplier = starterArgsSupplier;
        }
    }
}

