/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Build;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.R;
import com.stripe.android.databinding.AddressWidgetBinding;
import com.stripe.android.model.Address;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.view.Country;
import com.stripe.android.view.CountryAutoCompleteTextView;
import com.stripe.android.view.CountryUtils;
import com.stripe.android.view.ErrorListener;
import com.stripe.android.view.PostalCodeValidator;
import com.stripe.android.view.StripeEditText;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001KB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020.H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0015H\u0002J\u0010\u00103\u001a\u0002012\u0006\u00102\u001a\u00020\u0015H\u0002J\u0010\u00104\u001a\u0002012\u0006\u00102\u001a\u00020\u0015H\u0002J\u0010\u00105\u001a\u00020.2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020.2\b\u0010#\u001a\u0004\u0018\u00010 J\b\u00109\u001a\u00020.H\u0002J\b\u0010:\u001a\u00020.H\u0002J\b\u0010;\u001a\u00020.H\u0002J\b\u0010<\u001a\u00020.H\u0002J\b\u0010=\u001a\u00020.H\u0002J\u0014\u0010>\u001a\u00020.2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00150@J\u0016\u0010A\u001a\u00020.2\u000e\u0010B\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014J\u0016\u0010C\u001a\u00020.2\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014J\b\u0010E\u001a\u00020.H\u0002J\u0010\u0010F\u001a\u00020.2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020.2\u0006\u0010G\u001a\u00020HH\u0002J\u0006\u0010J\u001a\u000201R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0013\u0010#\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u000e\u0010%\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010'\u001a\u00020(8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b)\u0010*\u00a8\u0006L"}, d2={"Lcom/stripe/android/view/ShippingInfoWidget;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "addressEditText", "Lcom/stripe/android/view/StripeEditText;", "addressEditText2", "addressLine1TextInputLayout", "Lcom/google/android/material/textfield/TextInputLayout;", "addressLine2TextInputLayout", "cityEditText", "cityTextInputLayout", "countryAutoCompleteTextView", "Lcom/stripe/android/view/CountryAutoCompleteTextView;", "hiddenShippingInfoFields", "", "", "nameEditText", "nameTextInputLayout", "optionalShippingInfoFields", "phoneNumberEditText", "phoneNumberTextInputLayout", "postalCodeEditText", "postalCodeTextInputLayout", "postalCodeValidator", "Lcom/stripe/android/view/PostalCodeValidator;", "rawShippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "getRawShippingInformation", "()Lcom/stripe/android/model/ShippingInformation;", "shippingInformation", "getShippingInformation", "stateEditText", "stateTextInputLayout", "viewBinding", "Lcom/stripe/android/databinding/AddressWidgetBinding;", "getViewBinding", "()Lcom/stripe/android/databinding/AddressWidgetBinding;", "viewBinding$delegate", "Lkotlin/Lazy;", "hideHiddenFields", "", "initView", "isFieldHidden", "", "field", "isFieldOptional", "isFieldRequired", "populateAddressFields", "address", "Lcom/stripe/android/model/Address;", "populateShippingInfo", "renderCanadianForm", "renderGreatBritainForm", "renderInternationalForm", "renderLabels", "renderUSForm", "setAllowedCountryCodes", "allowedCountryCodes", "", "setHiddenFields", "hiddenAddressFields", "setOptionalFields", "optionalAddressFields", "setupErrorHandling", "updateConfigForCountry", "country", "Lcom/stripe/android/view/Country;", "updatePostalCodeInputFilter", "validateAllFields", "CustomizableShippingField", "stripe_release"})
public final class ShippingInfoWidget
extends LinearLayout {
    private final Lazy viewBinding$delegate;
    private final PostalCodeValidator postalCodeValidator;
    private List<String> optionalShippingInfoFields;
    private List<String> hiddenShippingInfoFields;
    private final CountryAutoCompleteTextView countryAutoCompleteTextView;
    private final TextInputLayout addressLine1TextInputLayout;
    private final TextInputLayout addressLine2TextInputLayout;
    private final TextInputLayout cityTextInputLayout;
    private final TextInputLayout nameTextInputLayout;
    private final TextInputLayout postalCodeTextInputLayout;
    private final TextInputLayout stateTextInputLayout;
    private final TextInputLayout phoneNumberTextInputLayout;
    private final StripeEditText addressEditText;
    private final StripeEditText addressEditText2;
    private final StripeEditText cityEditText;
    private final StripeEditText nameEditText;
    private final StripeEditText postalCodeEditText;
    private final StripeEditText stateEditText;
    private final StripeEditText phoneNumberEditText;

    private final AddressWidgetBinding getViewBinding() {
        Lazy lazy = this.viewBinding$delegate;
        ShippingInfoWidget shippingInfoWidget = this;
        Object var3_3 = null;
        boolean bl = false;
        return (AddressWidgetBinding)lazy.getValue();
    }

    @Nullable
    public final ShippingInformation getShippingInformation() {
        return !this.validateAllFields() ? null : this.getRawShippingInformation();
    }

    private final ShippingInformation getRawShippingInformation() {
        Country country = this.countryAutoCompleteTextView.getSelectedCountry();
        return new ShippingInformation(new Address.Builder().setCity(this.cityEditText.getFieldText$stripe_release()).setCountry(country != null ? country.getCode() : null).setLine1(this.addressEditText.getFieldText$stripe_release()).setLine2(this.addressEditText2.getFieldText$stripe_release()).setPostalCode(this.postalCodeEditText.getFieldText$stripe_release()).setState(this.stateEditText.getFieldText$stripe_release()).build(), this.nameEditText.getFieldText$stripe_release(), this.phoneNumberEditText.getFieldText$stripe_release());
    }

    public final void setOptionalFields(@Nullable List<String> optionalAddressFields) {
        block1: {
            List list;
            Object object = optionalAddressFields;
            ShippingInfoWidget shippingInfoWidget = this;
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                object2 = CollectionsKt.emptyList();
            }
            shippingInfoWidget.optionalShippingInfoFields = list = object2;
            this.renderLabels();
            Country country = this.countryAutoCompleteTextView.getSelectedCountry();
            if (country == null) break block1;
            object = country;
            ShippingInfoWidget shippingInfoWidget2 = this;
            boolean bl2 = false;
            boolean bl3 = false;
            Object p1 = object;
            boolean bl4 = false;
            shippingInfoWidget2.updateConfigForCountry((Country)p1);
        }
    }

    public final void setHiddenFields(@Nullable List<String> hiddenAddressFields) {
        block1: {
            List list;
            Object object = hiddenAddressFields;
            ShippingInfoWidget shippingInfoWidget = this;
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                object2 = CollectionsKt.emptyList();
            }
            shippingInfoWidget.hiddenShippingInfoFields = list = object2;
            this.renderLabels();
            Country country = this.countryAutoCompleteTextView.getSelectedCountry();
            if (country == null) break block1;
            object = country;
            ShippingInfoWidget shippingInfoWidget2 = this;
            boolean bl2 = false;
            boolean bl3 = false;
            Object p1 = object;
            boolean bl4 = false;
            shippingInfoWidget2.updateConfigForCountry((Country)p1);
        }
    }

    public final void populateShippingInfo(@Nullable ShippingInformation shippingInformation) {
        if (shippingInformation == null) {
            return;
        }
        Address address = shippingInformation.getAddress();
        if (address != null) {
            Address address2 = address;
            ShippingInfoWidget shippingInfoWidget = this;
            boolean bl = false;
            boolean bl2 = false;
            Address p1 = address2;
            boolean bl3 = false;
            shippingInfoWidget.populateAddressFields(p1);
        }
        this.nameEditText.setText(shippingInformation.getName());
        this.phoneNumberEditText.setText(shippingInformation.getPhone());
    }

    private final void populateAddressFields(Address address) {
        this.cityEditText.setText(address.getCity());
        String string2 = address.getCountry();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String country = string3;
            boolean bl3 = false;
            CharSequence charSequence = country;
            boolean bl4 = false;
            if (charSequence.length() > 0) {
                this.countryAutoCompleteTextView.setCountrySelected$stripe_release(country);
            }
        }
        this.addressEditText.setText(address.getLine1());
        this.addressEditText2.setText(address.getLine2());
        this.postalCodeEditText.setText(address.getPostalCode());
        this.stateEditText.setText(address.getState());
    }

    public final void setAllowedCountryCodes(@NotNull Set<String> allowedCountryCodes) {
        Intrinsics.checkParameterIsNotNull(allowedCountryCodes, (String)"allowedCountryCodes");
        this.countryAutoCompleteTextView.setAllowedCountryCodes$stripe_release(allowedCountryCodes);
    }

    public final boolean validateAllFields() {
        Country selectedCountry;
        Object object = this.addressEditText.getText();
        if (object == null || (object = object.toString()) == null) {
            return false;
        }
        Object address = object;
        Object object2 = this.nameEditText.getText();
        if (object2 == null || (object2 = object2.toString()) == null) {
            return false;
        }
        Object name = object2;
        Object object3 = this.cityEditText.getText();
        if (object3 == null || (object3 = object3.toString()) == null) {
            return false;
        }
        Object city = object3;
        Object object4 = this.stateEditText.getText();
        if (object4 == null || (object4 = object4.toString()) == null) {
            return false;
        }
        Object state = object4;
        Object object5 = this.postalCodeEditText.getText();
        if (object5 == null || (object5 = object5.toString()) == null) {
            return false;
        }
        Object postalCode = object5;
        Object object6 = this.phoneNumberEditText.getText();
        if (object6 == null || (object6 = object6.toString()) == null) {
            return false;
        }
        Object phoneNumber = object6;
        this.countryAutoCompleteTextView.validateCountry$stripe_release();
        Country country = selectedCountry = this.countryAutoCompleteTextView.getSelectedCountry();
        boolean isPostalCodeValid = this.postalCodeValidator.isValid((String)postalCode, country != null ? country.getCode() : null, this.optionalShippingInfoFields, this.hiddenShippingInfoFields);
        this.postalCodeEditText.setShouldShowError(!isPostalCodeValid);
        CharSequence charSequence = (CharSequence)address;
        boolean bl = false;
        boolean requiredAddressLine1Empty = charSequence.length() == 0 && this.isFieldRequired("address_line_one");
        this.addressEditText.setShouldShowError(requiredAddressLine1Empty);
        CharSequence charSequence2 = (CharSequence)city;
        boolean bl2 = false;
        boolean requiredCityEmpty = charSequence2.length() == 0 && this.isFieldRequired("city");
        this.cityEditText.setShouldShowError(requiredCityEmpty);
        CharSequence charSequence3 = (CharSequence)name;
        boolean bl3 = false;
        boolean requiredNameEmpty = charSequence3.length() == 0;
        this.nameEditText.setShouldShowError(requiredNameEmpty);
        CharSequence charSequence4 = (CharSequence)state;
        boolean bl4 = false;
        boolean requiredStateEmpty = charSequence4.length() == 0 && this.isFieldRequired("state");
        this.stateEditText.setShouldShowError(requiredStateEmpty);
        CharSequence charSequence5 = (CharSequence)phoneNumber;
        boolean bl5 = false;
        boolean requiredPhoneNumberEmpty = charSequence5.length() == 0 && this.isFieldRequired("phone");
        this.phoneNumberEditText.setShouldShowError(requiredPhoneNumberEmpty);
        return isPostalCodeValid && !requiredAddressLine1Empty && !requiredCityEmpty && !requiredStateEmpty && !requiredNameEmpty && !requiredPhoneNumberEmpty && selectedCountry != null;
    }

    private final boolean isFieldRequired(String field) {
        return !this.isFieldOptional(field) && !this.isFieldHidden(field);
    }

    private final boolean isFieldOptional(String field) {
        return this.optionalShippingInfoFields.contains(field);
    }

    private final boolean isFieldHidden(String field) {
        return this.hiddenShippingInfoFields.contains(field);
    }

    private final void initView() {
        block0: {
            this.countryAutoCompleteTextView.setCountryChangeCallback$stripe_release((Function1<? super Country, Unit>)((Function1)new Function1<Country, Unit>(this){

                public final void invoke(@NotNull Country p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    ShippingInfoWidget.access$updateConfigForCountry((ShippingInfoWidget)((Object)this.receiver), p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(ShippingInfoWidget.class);
                }

                public final String getName() {
                    return "updateConfigForCountry";
                }

                public final String getSignature() {
                    return "updateConfigForCountry(Lcom/stripe/android/view/Country;)V";
                }
            }));
            this.phoneNumberEditText.addTextChangedListener((TextWatcher)new PhoneNumberFormattingTextWatcher());
            this.setupErrorHandling();
            this.renderLabels();
            Country country = this.countryAutoCompleteTextView.getSelectedCountry();
            if (country == null) break block0;
            Country country2 = country;
            ShippingInfoWidget shippingInfoWidget = this;
            boolean bl = false;
            boolean bl2 = false;
            Country p1 = country2;
            boolean bl3 = false;
            shippingInfoWidget.updateConfigForCountry(p1);
        }
    }

    private final void setupErrorHandling() {
        this.addressEditText.setErrorMessageListener(new ErrorListener(this.addressLine1TextInputLayout));
        this.cityEditText.setErrorMessageListener(new ErrorListener(this.cityTextInputLayout));
        this.nameEditText.setErrorMessageListener(new ErrorListener(this.nameTextInputLayout));
        this.postalCodeEditText.setErrorMessageListener(new ErrorListener(this.postalCodeTextInputLayout));
        this.stateEditText.setErrorMessageListener(new ErrorListener(this.stateTextInputLayout));
        this.phoneNumberEditText.setErrorMessageListener(new ErrorListener(this.phoneNumberTextInputLayout));
        this.addressEditText.setErrorMessage(this.getResources().getString(R.string.address_required));
        this.cityEditText.setErrorMessage(this.getResources().getString(R.string.address_city_required));
        this.nameEditText.setErrorMessage(this.getResources().getString(R.string.address_name_required));
        this.phoneNumberEditText.setErrorMessage(this.getResources().getString(R.string.address_phone_number_required));
    }

    private final void renderLabels() {
        this.nameTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_name));
        this.cityTextInputLayout.setHint(this.isFieldOptional("city") ? (CharSequence)this.getResources().getString(R.string.address_label_city_optional) : (CharSequence)this.getResources().getString(R.string.address_label_city));
        this.phoneNumberTextInputLayout.setHint(this.isFieldOptional("phone") ? (CharSequence)this.getResources().getString(R.string.address_label_phone_number_optional) : (CharSequence)this.getResources().getString(R.string.address_label_phone_number));
        this.hideHiddenFields();
    }

    private final void hideHiddenFields() {
        if (this.isFieldHidden("address_line_one")) {
            this.addressLine1TextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden("address_line_two")) {
            this.addressLine2TextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden("state")) {
            this.stateTextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden("city")) {
            this.cityTextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden("postal_code")) {
            this.postalCodeTextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden("phone")) {
            this.phoneNumberTextInputLayout.setVisibility(8);
        }
    }

    private final void updateConfigForCountry(Country country) {
        String string2 = country.getCode();
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        if (Intrinsics.areEqual((Object)string2, (Object)locale.getCountry())) {
            this.renderUSForm();
        } else {
            Locale locale2 = Locale.UK;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.UK");
            if (Intrinsics.areEqual((Object)string2, (Object)locale2.getCountry())) {
                this.renderGreatBritainForm();
            } else {
                Locale locale3 = Locale.CANADA;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.CANADA");
                if (Intrinsics.areEqual((Object)string2, (Object)locale3.getCountry())) {
                    this.renderCanadianForm();
                } else {
                    this.renderInternationalForm();
                }
            }
        }
        this.updatePostalCodeInputFilter(country);
        this.postalCodeTextInputLayout.setVisibility(CountryUtils.INSTANCE.doesCountryUsePostalCode$stripe_release(country.getCode()) && !this.isFieldHidden("postal_code") ? 0 : 8);
    }

    private final void updatePostalCodeInputFilter(Country country) {
        InputFilter[] inputFilterArray;
        String string2 = country.getCode();
        Locale locale = Locale.CANADA;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.CANADA");
        if (Intrinsics.areEqual((Object)string2, (Object)locale.getCountry())) {
            InputFilter[] inputFilterArray2 = new InputFilter[1];
            inputFilterArray = inputFilterArray2;
            inputFilterArray2[0] = (InputFilter)new InputFilter.AllCaps();
        } else {
            inputFilterArray = new InputFilter[]{};
        }
        this.postalCodeEditText.setFilters(inputFilterArray);
    }

    private final void renderUSForm() {
        this.addressLine1TextInputLayout.setHint(this.isFieldOptional("address_line_one") ? (CharSequence)this.getResources().getString(R.string.address_label_address_optional) : (CharSequence)this.getResources().getString(R.string.address_label_address));
        this.addressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_apt_optional));
        this.postalCodeTextInputLayout.setHint(this.isFieldOptional("postal_code") ? (CharSequence)this.getResources().getString(R.string.address_label_zip_code_optional) : (CharSequence)this.getResources().getString(R.string.address_label_zip_code));
        this.stateTextInputLayout.setHint(this.isFieldOptional("state") ? (CharSequence)this.getResources().getString(R.string.address_label_state_optional) : (CharSequence)this.getResources().getString(R.string.address_label_state));
        this.postalCodeEditText.setErrorMessage(this.getResources().getString(R.string.address_zip_invalid));
        this.stateEditText.setErrorMessage(this.getResources().getString(R.string.address_state_required));
    }

    private final void renderGreatBritainForm() {
        this.addressLine1TextInputLayout.setHint(this.isFieldOptional("address_line_one") ? (CharSequence)this.getResources().getString(R.string.address_label_address_line1_optional) : (CharSequence)this.getResources().getString(R.string.address_label_address_line1));
        this.addressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address_line2_optional));
        this.postalCodeTextInputLayout.setHint(this.isFieldOptional("postal_code") ? (CharSequence)this.getResources().getString(R.string.address_label_postcode_optional) : (CharSequence)this.getResources().getString(R.string.address_label_postcode));
        this.stateTextInputLayout.setHint(this.isFieldOptional("state") ? (CharSequence)this.getResources().getString(R.string.address_label_county_optional) : (CharSequence)this.getResources().getString(R.string.address_label_county));
        this.postalCodeEditText.setErrorMessage(this.getResources().getString(R.string.address_postcode_invalid));
        this.stateEditText.setErrorMessage(this.getResources().getString(R.string.address_county_required));
    }

    private final void renderCanadianForm() {
        this.addressLine1TextInputLayout.setHint(this.isFieldOptional("address_line_one") ? (CharSequence)this.getResources().getString(R.string.address_label_address_optional) : (CharSequence)this.getResources().getString(R.string.address_label_address));
        this.addressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_apt_optional));
        this.postalCodeTextInputLayout.setHint(this.isFieldOptional("postal_code") ? (CharSequence)this.getResources().getString(R.string.address_label_postal_code_optional) : (CharSequence)this.getResources().getString(R.string.address_label_postal_code));
        this.stateTextInputLayout.setHint(this.isFieldOptional("state") ? (CharSequence)this.getResources().getString(R.string.address_label_province_optional) : (CharSequence)this.getResources().getString(R.string.address_label_province));
        this.postalCodeEditText.setErrorMessage(this.getResources().getString(R.string.address_postal_code_invalid));
        this.stateEditText.setErrorMessage(this.getResources().getString(R.string.address_province_required));
    }

    private final void renderInternationalForm() {
        this.addressLine1TextInputLayout.setHint(this.isFieldOptional("address_line_one") ? (CharSequence)this.getResources().getString(R.string.address_label_address_line1_optional) : (CharSequence)this.getResources().getString(R.string.address_label_address_line1));
        this.addressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address_line2_optional));
        this.postalCodeTextInputLayout.setHint(this.isFieldOptional("postal_code") ? (CharSequence)this.getResources().getString(R.string.address_label_zip_postal_code_optional) : (CharSequence)this.getResources().getString(R.string.address_label_zip_postal_code));
        this.stateTextInputLayout.setHint(this.isFieldOptional("state") ? (CharSequence)this.getResources().getString(R.string.address_label_region_generic_optional) : (CharSequence)this.getResources().getString(R.string.address_label_region_generic));
        this.postalCodeEditText.setErrorMessage(this.getResources().getString(R.string.address_zip_postal_invalid));
        this.stateEditText.setErrorMessage(this.getResources().getString(R.string.address_region_generic_required));
    }

    @JvmOverloads
    public ShippingInfoWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.viewBinding$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AddressWidgetBinding>(this, context){
            final /* synthetic */ ShippingInfoWidget this$0;
            final /* synthetic */ Context $context;

            @NotNull
            public final AddressWidgetBinding invoke() {
                return AddressWidgetBinding.inflate(LayoutInflater.from((Context)this.$context), (ViewGroup)this.this$0);
            }
            {
                this.this$0 = shippingInfoWidget;
                this.$context = context;
                super(0);
            }
        }));
        this.postalCodeValidator = new PostalCodeValidator();
        this.optionalShippingInfoFields = CollectionsKt.emptyList();
        this.hiddenShippingInfoFields = CollectionsKt.emptyList();
        CountryAutoCompleteTextView countryAutoCompleteTextView = this.getViewBinding().countryAutocompleteAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)countryAutoCompleteTextView), (String)"viewBinding.countryAutocompleteAaw");
        this.countryAutoCompleteTextView = countryAutoCompleteTextView;
        TextInputLayout textInputLayout = this.getViewBinding().tlAddressLine1Aaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)textInputLayout, (String)"viewBinding.tlAddressLine1Aaw");
        this.addressLine1TextInputLayout = textInputLayout;
        TextInputLayout textInputLayout2 = this.getViewBinding().tlAddressLine2Aaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)textInputLayout2, (String)"viewBinding.tlAddressLine2Aaw");
        this.addressLine2TextInputLayout = textInputLayout2;
        TextInputLayout textInputLayout3 = this.getViewBinding().tlCityAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)textInputLayout3, (String)"viewBinding.tlCityAaw");
        this.cityTextInputLayout = textInputLayout3;
        TextInputLayout textInputLayout4 = this.getViewBinding().tlNameAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)textInputLayout4, (String)"viewBinding.tlNameAaw");
        this.nameTextInputLayout = textInputLayout4;
        TextInputLayout textInputLayout5 = this.getViewBinding().tlPostalCodeAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)textInputLayout5, (String)"viewBinding.tlPostalCodeAaw");
        this.postalCodeTextInputLayout = textInputLayout5;
        TextInputLayout textInputLayout6 = this.getViewBinding().tlStateAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)textInputLayout6, (String)"viewBinding.tlStateAaw");
        this.stateTextInputLayout = textInputLayout6;
        TextInputLayout textInputLayout7 = this.getViewBinding().tlPhoneNumberAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)textInputLayout7, (String)"viewBinding.tlPhoneNumberAaw");
        this.phoneNumberTextInputLayout = textInputLayout7;
        StripeEditText stripeEditText = this.getViewBinding().etAddressLineOneAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)stripeEditText), (String)"viewBinding.etAddressLineOneAaw");
        this.addressEditText = stripeEditText;
        StripeEditText stripeEditText2 = this.getViewBinding().etAddressLineTwoAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)stripeEditText2), (String)"viewBinding.etAddressLineTwoAaw");
        this.addressEditText2 = stripeEditText2;
        StripeEditText stripeEditText3 = this.getViewBinding().etCityAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)stripeEditText3), (String)"viewBinding.etCityAaw");
        this.cityEditText = stripeEditText3;
        StripeEditText stripeEditText4 = this.getViewBinding().etNameAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)stripeEditText4), (String)"viewBinding.etNameAaw");
        this.nameEditText = stripeEditText4;
        StripeEditText stripeEditText5 = this.getViewBinding().etPostalCodeAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)stripeEditText5), (String)"viewBinding.etPostalCodeAaw");
        this.postalCodeEditText = stripeEditText5;
        StripeEditText stripeEditText6 = this.getViewBinding().etStateAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)stripeEditText6), (String)"viewBinding.etStateAaw");
        this.stateEditText = stripeEditText6;
        StripeEditText stripeEditText7 = this.getViewBinding().etPhoneNumberAaw;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)stripeEditText7), (String)"viewBinding.etPhoneNumberAaw");
        this.phoneNumberEditText = stripeEditText7;
        this.setOrientation(1);
        if (Build.VERSION.SDK_INT >= 26) {
            this.nameEditText.setAutofillHints(new String[]{"name"});
            this.addressLine1TextInputLayout.setAutofillHints(new String[]{"postalAddress"});
            this.postalCodeEditText.setAutofillHints(new String[]{"postalCode"});
            this.phoneNumberEditText.setAutofillHints(new String[]{"phone"});
        }
        this.initView();
    }

    public /* synthetic */ ShippingInfoWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ShippingInfoWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ShippingInfoWidget(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$updateConfigForCountry(ShippingInfoWidget $this, Country country) {
        $this.updateConfigForCountry(country);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/view/ShippingInfoWidget$CustomizableShippingField;", "", "Companion", "stripe_release"})
    public static @interface CustomizableShippingField {
        public static final Companion Companion = Companion.$$INSTANCE;
        @NotNull
        public static final String ADDRESS_LINE_ONE_FIELD = "address_line_one";
        @NotNull
        public static final String ADDRESS_LINE_TWO_FIELD = "address_line_two";
        @NotNull
        public static final String CITY_FIELD = "city";
        @NotNull
        public static final String POSTAL_CODE_FIELD = "postal_code";
        @NotNull
        public static final String STATE_FIELD = "state";
        @NotNull
        public static final String PHONE_FIELD = "phone";

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/view/ShippingInfoWidget$CustomizableShippingField$Companion;", "", "()V", "ADDRESS_LINE_ONE_FIELD", "", "ADDRESS_LINE_TWO_FIELD", "CITY_FIELD", "PHONE_FIELD", "POSTAL_CODE_FIELD", "STATE_FIELD", "stripe_release"})
        public static final class Companion {
            @NotNull
            public static final String ADDRESS_LINE_ONE_FIELD = "address_line_one";
            @NotNull
            public static final String ADDRESS_LINE_TWO_FIELD = "address_line_two";
            @NotNull
            public static final String CITY_FIELD = "city";
            @NotNull
            public static final String POSTAL_CODE_FIELD = "postal_code";
            @NotNull
            public static final String STATE_FIELD = "state";
            @NotNull
            public static final String PHONE_FIELD = "phone";
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }
}

