/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Currency;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/stripe/android/PayWithGoogleUtils;", "", "()V", "getPriceString", "", "price", "", "currency", "Ljava/util/Currency;", "stripe_release"})
public final class PayWithGoogleUtils {
    public static final PayWithGoogleUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String getPriceString(int price, @NotNull Currency currency) {
        int i;
        Intrinsics.checkParameterIsNotNull((Object)currency, (String)"currency");
        int fractionDigits = currency.getDefaultFractionDigits();
        int totalLength = String.valueOf(price).length();
        StringBuilder builder = new StringBuilder();
        if (fractionDigits == 0) {
            int n = 0;
            int n2 = totalLength;
            while (n < n2) {
                void i2;
                builder.append('#');
                ++i2;
            }
            DecimalFormat noDecimalCurrencyFormat = new DecimalFormat(builder.toString());
            noDecimalCurrencyFormat.setCurrency(currency);
            noDecimalCurrencyFormat.setGroupingUsed(false);
            String string = noDecimalCurrencyFormat.format((Object)price);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"noDecimalCurrencyFormat.format(price)");
            return string;
        }
        int beforeDecimal = totalLength - fractionDigits;
        int n = 0;
        int n3 = beforeDecimal;
        while (n < n3) {
            builder.append('#');
            ++i;
        }
        if (totalLength <= fractionDigits) {
            builder.append('0');
        }
        builder.append('.');
        n3 = fractionDigits;
        for (i = 0; i < n3; ++i) {
            builder.append('0');
        }
        double d = 10.0;
        double d2 = fractionDigits;
        boolean bl = false;
        double modBreak = Math.pow(d, d2);
        double decimalPrice = (double)price / modBreak;
        DecimalFormatSymbols symbolOverride = new DecimalFormatSymbols();
        symbolOverride.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat(builder.toString(), symbolOverride);
        decimalFormat.setCurrency(currency);
        decimalFormat.setGroupingUsed(false);
        String string = decimalFormat.format(decimalPrice);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"decimalFormat.format(decimalPrice)");
        return string;
    }

    private PayWithGoogleUtils() {
    }

    static {
        PayWithGoogleUtils payWithGoogleUtils;
        INSTANCE = payWithGoogleUtils = new PayWithGoogleUtils();
    }
}

