/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.stripe.android.Logger;
import com.stripe.android.PaymentAuthWebViewStarter;
import com.stripe.android.R;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import com.stripe.android.view.PaymentAuthWebView;
import com.stripe.android.view.PaymentAuthWebViewActivityViewModel;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\bH\u0014J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/view/PaymentAuthWebViewActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "logger", "Lcom/stripe/android/Logger;", "viewModel", "Lcom/stripe/android/view/PaymentAuthWebViewActivityViewModel;", "cancelIntentSource", "", "customizeToolbar", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "stripe_release"})
public final class PaymentAuthWebViewActivity
extends AppCompatActivity {
    private Logger logger;
    private PaymentAuthWebViewActivityViewModel viewModel;
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PaymentAuthWebViewStarter.Args args2 = (PaymentAuthWebViewStarter.Args)this.getIntent().getParcelableExtra("extra_args");
        if (args2 == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        ViewModel viewModel2 = new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new PaymentAuthWebViewActivityViewModel.Factory(args2)).get(PaymentAuthWebViewActivityViewModel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewModel2, (String)"ViewModelProvider(\n     \u2026ityViewModel::class.java]");
        this.viewModel = (PaymentAuthWebViewActivityViewModel)viewModel2;
        Logger logger = this.logger = Logger.Companion.getInstance$stripe_release(args2.getEnableLogging());
        if (logger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger.debug("PaymentAuthWebViewActivity#onCreate()");
        LocalBroadcastManager.getInstance((Context)((Context)this)).sendBroadcast(new Intent().setAction("com.ul.sdk.HANDLE_CHALLENGE_ACTION"));
        this.setContentView(R.layout.payment_auth_web_view_layout);
        this.setSupportActionBar((Toolbar)this._$_findCachedViewById(R.id.payment_auth_web_view_toolbar));
        this.customizeToolbar();
        String clientSecret = args2.getClientSecret();
        Intent intent = new Intent();
        PaymentAuthWebViewActivityViewModel paymentAuthWebViewActivityViewModel = this.viewModel;
        if (paymentAuthWebViewActivityViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        this.setResult(-1, intent.putExtras(paymentAuthWebViewActivityViewModel.getPaymentResult$stripe_release().toBundle()));
        if (StringsKt.isBlank((CharSequence)clientSecret)) {
            Logger logger2 = this.logger;
            if (logger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger2.debug("PaymentAuthWebViewActivity#onCreate() - clientSecret is blank");
            this.finish();
            return;
        }
        Logger logger3 = this.logger;
        if (logger3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger3.debug("PaymentAuthWebViewActivity#onCreate() - PaymentAuthWebView init and loadUrl");
        PaymentAuthWebView paymentAuthWebView = (PaymentAuthWebView)this._$_findCachedViewById(R.id.auth_web_view);
        Activity activity = (Activity)this;
        Logger logger4 = this.logger;
        if (logger4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        ProgressBar progressBar = (ProgressBar)this._$_findCachedViewById(R.id.auth_web_view_progress_bar);
        Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"auth_web_view_progress_bar");
        paymentAuthWebView.init(activity, logger4, progressBar, clientSecret, args2.getReturnUrl());
        ((PaymentAuthWebView)this._$_findCachedViewById(R.id.auth_web_view)).loadUrl(args2.getUrl());
    }

    protected void onDestroy() {
        ((FrameLayout)this._$_findCachedViewById(R.id.auth_web_view_container)).removeAllViews();
        ((PaymentAuthWebView)this._$_findCachedViewById(R.id.auth_web_view)).destroy();
        super.onDestroy();
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)menu2, (String)"menu");
            Logger logger = this.logger;
            if (logger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger.debug("PaymentAuthWebViewActivity#onCreateOptionsMenu()");
            this.getMenuInflater().inflate(R.menu.payment_auth_web_view_menu, menu2);
            PaymentAuthWebViewActivityViewModel paymentAuthWebViewActivityViewModel = this.viewModel;
            if (paymentAuthWebViewActivityViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            }
            String string2 = paymentAuthWebViewActivityViewModel.getButtonText$stripe_release();
            if (string2 == null) break block3;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            Logger logger2 = this.logger;
            if (logger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger2.debug("PaymentAuthWebViewActivity#customizeToolbar() - updating close button text");
            MenuItem menuItem = menu2.findItem(R.id.action_close);
            Intrinsics.checkExpressionValueIsNotNull((Object)menuItem, (String)"menu.findItem(R.id.action_close)");
            menuItem.setTitle((CharSequence)it);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Logger logger = this.logger;
        if (logger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger.debug("PaymentAuthWebViewActivity#onOptionsItemSelected()");
        if (item.getItemId() == R.id.action_close) {
            this.cancelIntentSource();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        this.cancelIntentSource();
    }

    private final void cancelIntentSource() {
        PaymentAuthWebViewActivityViewModel paymentAuthWebViewActivityViewModel = this.viewModel;
        if (paymentAuthWebViewActivityViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        paymentAuthWebViewActivityViewModel.cancelIntentSource$stripe_release().observe((LifecycleOwner)this, (Observer)new Observer<Intent>(this){
            final /* synthetic */ PaymentAuthWebViewActivity this$0;

            public final void onChanged(Intent intent) {
                this.this$0.setResult(-1, intent);
                this.this$0.finish();
            }
            {
                this.this$0 = paymentAuthWebViewActivity;
            }
        });
    }

    private final void customizeToolbar() {
        block6: {
            boolean bl;
            boolean bl2;
            Object object;
            Logger logger = this.logger;
            if (logger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger.debug("PaymentAuthWebViewActivity#customizeToolbar()");
            PaymentAuthWebViewActivityViewModel paymentAuthWebViewActivityViewModel = this.viewModel;
            if (paymentAuthWebViewActivityViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            }
            PaymentAuthWebViewActivityViewModel.ToolbarTitleData toolbarTitleData = paymentAuthWebViewActivityViewModel.getToolbarTitle$stripe_release();
            if (toolbarTitleData != null) {
                object = toolbarTitleData;
                bl2 = false;
                bl = false;
                PaymentAuthWebViewActivityViewModel.ToolbarTitleData it = object;
                boolean bl3 = false;
                Logger logger2 = this.logger;
                if (logger2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                }
                logger2.debug("PaymentAuthWebViewActivity#customizeToolbar() - updating toolbar title");
                Toolbar toolbar = (Toolbar)this._$_findCachedViewById(R.id.payment_auth_web_view_toolbar);
                Intrinsics.checkExpressionValueIsNotNull((Object)toolbar, (String)"payment_auth_web_view_toolbar");
                toolbar.setTitle((CharSequence)CustomizeUtils.buildStyledText((Context)((Context)this), (String)it.getText$stripe_release(), (Customization)((Customization)it.getToolbarCustomization$stripe_release())));
            }
            PaymentAuthWebViewActivityViewModel paymentAuthWebViewActivityViewModel2 = this.viewModel;
            if (paymentAuthWebViewActivityViewModel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            }
            String string2 = paymentAuthWebViewActivityViewModel2.getToolbarBackgroundColor$stripe_release();
            if (string2 == null) break block6;
            object = string2;
            bl2 = false;
            bl = false;
            Object backgroundColor = object;
            boolean bl4 = false;
            Logger logger3 = this.logger;
            if (logger3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger3.debug("PaymentAuthWebViewActivity#customizeToolbar() - updating toolbar background color");
            int backgroundColorInt = Color.parseColor((String)backgroundColor);
            ((Toolbar)this._$_findCachedViewById(R.id.payment_auth_web_view_toolbar)).setBackgroundColor(backgroundColorInt);
            CustomizeUtils.setStatusBarColor((AppCompatActivity)this, (int)backgroundColorInt);
        }
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

