/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.IntRange;
import androidx.annotation.Size;
import com.stripe.android.CardUtils;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.model.Address;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.ModelUtils;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.model.TokenParams;
import com.stripe.android.model.TokenizationMethod;
import com.stripe.android.model.parsers.CardJsonParser;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b>\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0087\b\u0018\u0000 \u0080\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\u0005\u007f\u0080\u0001\u0081\u0001B\u0095\u0002\b\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e\u0012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u0012\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\"\u00a2\u0006\u0002\u0010#J\u000b\u0010D\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010F\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010G\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010I\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010J\u001a\u00020\u0015H\u00c6\u0003J\u000b\u0010K\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010L\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010M\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010N\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010O\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010P\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010Q\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010R\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0014\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eH\u00c0\u0003\u00a2\u0006\u0002\bTJ\u000b\u0010U\u001a\u0004\u0018\u00010 H\u00c6\u0003J\u0017\u0010V\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\"H\u00c6\u0003J\u0010\u0010W\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u00105J\u0010\u0010X\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u00105J\u000b\u0010Y\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010Z\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010[\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\\\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010]\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u00c8\u0002\u0010^\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00052\n\b\u0003\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\u0016\b\u0002\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\"H\u00c6\u0001\u00a2\u0006\u0002\u0010_J\u0016\u0010`\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010a0\"H\u0002J\t\u0010b\u001a\u00020\bH\u00d6\u0001J\u0013\u0010c\u001a\u00020d2\b\u0010e\u001a\u0004\u0018\u00010aH\u00d6\u0003J\t\u0010f\u001a\u00020\bH\u00d6\u0001J\u0006\u0010g\u001a\u00020hJ\u0014\u0010i\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020a0\"H\u0016J\u0006\u0010j\u001a\u00020kJ\u0006\u0010l\u001a\u00020mJ\t\u0010n\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010o\u001a\u00020dJ\u0006\u0010p\u001a\u00020dJ\u0015\u0010p\u001a\u00020d2\u0006\u0010q\u001a\u00020rH\u0000\u00a2\u0006\u0002\bsJ\u0006\u0010t\u001a\u00020dJ\u0015\u0010u\u001a\u00020d2\u0006\u0010q\u001a\u00020rH\u0000\u00a2\u0006\u0002\bvJ\u0006\u0010w\u001a\u00020dJ\u0015\u0010w\u001a\u00020d2\u0006\u0010q\u001a\u00020rH\u0000\u00a2\u0006\u0002\bxJ\u0006\u0010y\u001a\u00020dJ\u0019\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020\bH\u00d6\u0001R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010%R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010%R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010%R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010%R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010%R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010%R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010%R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010%R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010%R\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0007\u00a2\u0006\n\n\u0002\u00106\u001a\u0004\b4\u00105R\u0015\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u00106\u001a\u0004\b7\u00105R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010%R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010%R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010%R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010%R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u001f\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\"\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010%R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010%R\u0013\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010C\u00a8\u0006\u0082\u0001"}, d2={"Lcom/stripe/android/model/Card;", "Lcom/stripe/android/model/StripeModel;", "Lcom/stripe/android/model/StripePaymentSource;", "Lcom/stripe/android/model/TokenParams;", "number", "", "cvc", "expMonth", "", "expYear", "name", "addressLine1", "addressLine1Check", "addressLine2", "addressCity", "addressState", "addressZip", "addressZipCheck", "addressCountry", "last4", "brand", "Lcom/stripe/android/model/CardBrand;", "funding", "fingerprint", "country", "currency", "customerId", "cvcCheck", "id", "loggingTokens", "", "tokenizationMethod", "Lcom/stripe/android/model/TokenizationMethod;", "metadata", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/model/CardBrand;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lcom/stripe/android/model/TokenizationMethod;Ljava/util/Map;)V", "getAddressCity", "()Ljava/lang/String;", "getAddressCountry", "getAddressLine1", "getAddressLine1Check", "getAddressLine2", "getAddressState", "getAddressZip", "getAddressZipCheck", "getBrand", "()Lcom/stripe/android/model/CardBrand;", "getCountry", "getCurrency", "getCustomerId", "getCvc", "getCvcCheck", "getExpMonth", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getExpYear", "getFingerprint", "getFunding", "getId", "getLast4", "getLoggingTokens$stripe_release", "()Ljava/util/Set;", "getMetadata", "()Ljava/util/Map;", "getName", "getNumber", "getTokenizationMethod", "()Lcom/stripe/android/model/TokenizationMethod;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component23$stripe_release", "component24", "component25", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/model/CardBrand;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lcom/stripe/android/model/TokenizationMethod;Ljava/util/Map;)Lcom/stripe/android/model/Card;", "createCardParams", "", "describeContents", "equals", "", "other", "hashCode", "toBuilder", "Lcom/stripe/android/model/Card$Builder;", "toParamMap", "toPaymentMethodParamsCard", "Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "toPaymentMethodsParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "toString", "validateCVC", "validateCard", "now", "Ljava/util/Calendar;", "validateCard$stripe_release", "validateExpMonth", "validateExpYear", "validateExpYear$stripe_release", "validateExpiryDate", "validateExpiryDate$stripe_release", "validateNumber", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Builder", "Companion", "FundingType", "stripe_release"})
@Parcelize
public final class Card
extends TokenParams
implements StripeModel,
StripePaymentSource {
    @Nullable
    private final String number;
    @Nullable
    private final String cvc;
    @Nullable
    private final Integer expMonth;
    @Nullable
    private final Integer expYear;
    @Nullable
    private final String name;
    @Nullable
    private final String addressLine1;
    @Nullable
    private final String addressLine1Check;
    @Nullable
    private final String addressLine2;
    @Nullable
    private final String addressCity;
    @Nullable
    private final String addressState;
    @Nullable
    private final String addressZip;
    @Nullable
    private final String addressZipCheck;
    @Nullable
    private final String addressCountry;
    @Nullable
    private final String last4;
    @NotNull
    private final CardBrand brand;
    @Nullable
    private final String funding;
    @Nullable
    private final String fingerprint;
    @Nullable
    private final String country;
    @Nullable
    private final String currency;
    @Nullable
    private final String customerId;
    @Nullable
    private final String cvcCheck;
    @Nullable
    private final String id;
    @NotNull
    private final Set<String> loggingTokens;
    @Nullable
    private final TokenizationMethod tokenizationMethod;
    @Nullable
    private final Map<String, String> metadata;
    @NotNull
    public static final String OBJECT_TYPE = "card";
    public static final Companion Companion = new Companion(null);
    public static final Parcelable.Creator CREATOR = new Creator();

    @NotNull
    public final PaymentMethodCreateParams toPaymentMethodsParams() {
        String string = this.addressZip;
        Object object = this.addressCountry;
        String string2 = this.addressState;
        String string3 = this.addressCity;
        String string4 = this.addressLine2;
        String string5 = this.addressLine1;
        Address address = new Address(string3, (String)object, string5, string4, string, string2);
        string = null;
        object = address;
        string2 = null;
        string3 = this.name;
        return PaymentMethodCreateParams.Companion.create$default(PaymentMethodCreateParams.Companion, this.toPaymentMethodParamsCard(), new PaymentMethod.BillingDetails((Address)object, string2, string3, string, 10, null), null, 4, null);
    }

    @NotNull
    public final PaymentMethodCreateParams.Card toPaymentMethodParamsCard() {
        Set set = null;
        String string = null;
        Integer n = this.expYear;
        Integer n2 = this.expMonth;
        String string2 = this.cvc;
        return new PaymentMethodCreateParams.Card(this.number, n2, n, string2, string, set, 48, null);
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder(this.number, this.expMonth, this.expYear, this.cvc).name(this.name).addressLine1(this.addressLine1).addressLine1Check(this.addressLine1Check).addressLine2(this.addressLine2).addressCity(this.addressCity).addressState(this.addressState).addressZip(this.addressZip).addressZipCheck(this.addressZipCheck).addressCountry(this.addressCountry).brand(this.brand).fingerprint(this.fingerprint).funding(this.funding).country(this.country).currency(this.currency).customer(this.customerId).cvcCheck(this.cvcCheck).last4(this.last4).id(this.getId()).tokenizationMethod(this.tokenizationMethod).metadata(this.metadata).loggingTokens(this.loggingTokens);
    }

    public final boolean validateCard() {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        return this.validateCard$stripe_release(calendar);
    }

    public final boolean validateNumber() {
        return CardUtils.isValidCardNumber(this.number);
    }

    public final boolean validateExpiryDate() {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        return this.validateExpiryDate$stripe_release(calendar);
    }

    public final boolean validateCVC() {
        CharSequence charSequence = this.cvc;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        String string = this.cvc;
        bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String cvcValue = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        boolean validLength = this.brand.isValidCvc(this.cvc);
        return ModelUtils.INSTANCE.isWholePositiveNumber$stripe_release(cvcValue) && validLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean validateExpMonth() {
        Integer n = this.expMonth;
        if (n == null) return false;
        Integer n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        int expMonth = ((Number)n2).intValue();
        boolean bl3 = false;
        int n3 = expMonth;
        if (1 > n3) return false;
        if (12 < n3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean validateExpYear$stripe_release(@NotNull Calendar now) {
        Intrinsics.checkParameterIsNotNull((Object)now, (String)"now");
        Integer n = this.expYear;
        if (n == null) return false;
        Integer n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n2).intValue();
        boolean bl3 = false;
        if (ModelUtils.INSTANCE.hasYearPassed$stripe_release(it, now)) return false;
        return true;
    }

    public final boolean validateCard$stripe_release(@NotNull Calendar now) {
        Intrinsics.checkParameterIsNotNull((Object)now, (String)"now");
        return this.cvc == null ? this.validateNumber() && this.validateExpiryDate$stripe_release(now) : this.validateNumber() && this.validateExpiryDate$stripe_release(now) && this.validateCVC();
    }

    public final boolean validateExpiryDate$stripe_release(@NotNull Calendar now) {
        Intrinsics.checkParameterIsNotNull((Object)now, (String)"now");
        Integer expMonth = this.expMonth;
        if (expMonth == null || !this.validateExpMonth()) {
            return false;
        }
        return this.expYear == null || !this.validateExpYear$stripe_release(now) ? false : !ModelUtils.INSTANCE.hasMonthPassed$stripe_release(this.expYear, expMonth, now);
    }

    @Override
    @NotNull
    public Map<String, Object> toParamMap() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)OBJECT_TYPE, this.createCardParams()));
    }

    private final Map<String, Object> createCardParams() {
        Pair[] pairArray;
        String string = this.number;
        String string2 = "number";
        int n = 0;
        Pair[] pairArray2 = pairArray = new Pair[12];
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        boolean bl5 = false;
        String string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.cvc;
        string2 = "cvc";
        n = 1;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl6 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        Pair[] pairArray3 = pairArray2;
        pairArray2[2] = TuplesKt.to((Object)"exp_month", (Object)this.expMonth);
        pairArray3[3] = TuplesKt.to((Object)"exp_year", (Object)this.expYear);
        string = this.name;
        string2 = "name";
        n = 4;
        pairArray = pairArray3;
        pairArray2 = pairArray3;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl7 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.currency;
        string2 = "currency";
        n = 5;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl8 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.addressLine1;
        string2 = "address_line1";
        n = 6;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl9 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.addressLine2;
        string2 = "address_line2";
        n = 7;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl10 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.addressCity;
        string2 = "address_city";
        n = 8;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl11 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.addressZip;
        string2 = "address_zip";
        n = 9;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl12 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.addressState;
        string2 = "address_state";
        n = 10;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl13 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        string = this.addressCountry;
        string2 = "address_country";
        n = 11;
        pairArray = pairArray2;
        bl = false;
        bl2 = false;
        it = string;
        boolean bl14 = false;
        charSequence = it;
        bl4 = false;
        bl5 = false;
        string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
        pairArray[n] = TuplesKt.to((Object)string2, (Object)string3);
        return MapsKt.mapOf((Pair[])pairArray2);
    }

    @Nullable
    public final String getNumber() {
        return this.number;
    }

    @Nullable
    public final String getCvc() {
        return this.cvc;
    }

    @IntRange(from=1L, to=12L)
    @Nullable
    public final Integer getExpMonth() {
        return this.expMonth;
    }

    @Nullable
    public final Integer getExpYear() {
        return this.expYear;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getAddressLine1() {
        return this.addressLine1;
    }

    @Nullable
    public final String getAddressLine1Check() {
        return this.addressLine1Check;
    }

    @Nullable
    public final String getAddressLine2() {
        return this.addressLine2;
    }

    @Nullable
    public final String getAddressCity() {
        return this.addressCity;
    }

    @Nullable
    public final String getAddressState() {
        return this.addressState;
    }

    @Nullable
    public final String getAddressZip() {
        return this.addressZip;
    }

    @Nullable
    public final String getAddressZipCheck() {
        return this.addressZipCheck;
    }

    @Nullable
    public final String getAddressCountry() {
        return this.addressCountry;
    }

    @Nullable
    public final String getLast4() {
        return this.last4;
    }

    @NotNull
    public final CardBrand getBrand() {
        return this.brand;
    }

    @Nullable
    public final String getFunding() {
        return this.funding;
    }

    @Nullable
    public final String getFingerprint() {
        return this.fingerprint;
    }

    @Nullable
    public final String getCountry() {
        return this.country;
    }

    @Nullable
    public final String getCurrency() {
        return this.currency;
    }

    @Nullable
    public final String getCustomerId() {
        return this.customerId;
    }

    @Nullable
    public final String getCvcCheck() {
        return this.cvcCheck;
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @NotNull
    public final Set<String> getLoggingTokens$stripe_release() {
        return this.loggingTokens;
    }

    @Nullable
    public final TokenizationMethod getTokenizationMethod() {
        return this.tokenizationMethod;
    }

    @Nullable
    public final Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Card(@Nullable String number, @Nullable String cvc, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String name, @Nullable String addressLine1, @Nullable String addressLine1Check, @Nullable String addressLine2, @Nullable String addressCity, @Nullable String addressState, @Nullable String addressZip, @Nullable String addressZipCheck, @Nullable String addressCountry, @Size(value=4L) @Nullable String last4, @NotNull CardBrand brand, @Nullable String funding, @Nullable String fingerprint, @Nullable String country, @Nullable String currency, @Nullable String customerId, @Nullable String cvcCheck, @Nullable String id, @NotNull Set<String> loggingTokens, @Nullable TokenizationMethod tokenizationMethod, @Nullable Map<String, String> metadata) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)brand), (String)"brand");
        Intrinsics.checkParameterIsNotNull(loggingTokens, (String)"loggingTokens");
        super(OBJECT_TYPE, loggingTokens);
        this.number = number;
        this.cvc = cvc;
        this.expMonth = expMonth;
        this.expYear = expYear;
        this.name = name;
        this.addressLine1 = addressLine1;
        this.addressLine1Check = addressLine1Check;
        this.addressLine2 = addressLine2;
        this.addressCity = addressCity;
        this.addressState = addressState;
        this.addressZip = addressZip;
        this.addressZipCheck = addressZipCheck;
        this.addressCountry = addressCountry;
        this.last4 = last4;
        this.brand = brand;
        this.funding = funding;
        this.fingerprint = fingerprint;
        this.country = country;
        this.currency = currency;
        this.customerId = customerId;
        this.cvcCheck = cvcCheck;
        this.id = id;
        this.loggingTokens = loggingTokens;
        this.tokenizationMethod = tokenizationMethod;
        this.metadata = metadata;
    }

    public /* synthetic */ Card(String string, String string2, Integer n, Integer n2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, CardBrand cardBrand, String string13, String string14, String string15, String string16, String string17, String string18, String string19, Set set, TokenizationMethod tokenizationMethod, Map map, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x400000) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n3 & 0x800000) != 0) {
            tokenizationMethod = null;
        }
        this(string, string2, n, n2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, cardBrand, string13, string14, string15, string16, string17, string18, string19, set, tokenizationMethod, map);
    }

    @Nullable
    public final String component1() {
        return this.number;
    }

    @Nullable
    public final String component2() {
        return this.cvc;
    }

    @Nullable
    public final Integer component3() {
        return this.expMonth;
    }

    @Nullable
    public final Integer component4() {
        return this.expYear;
    }

    @Nullable
    public final String component5() {
        return this.name;
    }

    @Nullable
    public final String component6() {
        return this.addressLine1;
    }

    @Nullable
    public final String component7() {
        return this.addressLine1Check;
    }

    @Nullable
    public final String component8() {
        return this.addressLine2;
    }

    @Nullable
    public final String component9() {
        return this.addressCity;
    }

    @Nullable
    public final String component10() {
        return this.addressState;
    }

    @Nullable
    public final String component11() {
        return this.addressZip;
    }

    @Nullable
    public final String component12() {
        return this.addressZipCheck;
    }

    @Nullable
    public final String component13() {
        return this.addressCountry;
    }

    @Nullable
    public final String component14() {
        return this.last4;
    }

    @NotNull
    public final CardBrand component15() {
        return this.brand;
    }

    @Nullable
    public final String component16() {
        return this.funding;
    }

    @Nullable
    public final String component17() {
        return this.fingerprint;
    }

    @Nullable
    public final String component18() {
        return this.country;
    }

    @Nullable
    public final String component19() {
        return this.currency;
    }

    @Nullable
    public final String component20() {
        return this.customerId;
    }

    @Nullable
    public final String component21() {
        return this.cvcCheck;
    }

    @Nullable
    public final String component22() {
        return this.getId();
    }

    @NotNull
    public final Set<String> component23$stripe_release() {
        return this.loggingTokens;
    }

    @Nullable
    public final TokenizationMethod component24() {
        return this.tokenizationMethod;
    }

    @Nullable
    public final Map<String, String> component25() {
        return this.metadata;
    }

    @NotNull
    public final Card copy(@Nullable String number, @Nullable String cvc, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String name, @Nullable String addressLine1, @Nullable String addressLine1Check, @Nullable String addressLine2, @Nullable String addressCity, @Nullable String addressState, @Nullable String addressZip, @Nullable String addressZipCheck, @Nullable String addressCountry, @Size(value=4L) @Nullable String last4, @NotNull CardBrand brand, @Nullable String funding, @Nullable String fingerprint, @Nullable String country, @Nullable String currency, @Nullable String customerId, @Nullable String cvcCheck, @Nullable String id, @NotNull Set<String> loggingTokens, @Nullable TokenizationMethod tokenizationMethod, @Nullable Map<String, String> metadata) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)brand), (String)"brand");
        Intrinsics.checkParameterIsNotNull(loggingTokens, (String)"loggingTokens");
        return new Card(number, cvc, expMonth, expYear, name, addressLine1, addressLine1Check, addressLine2, addressCity, addressState, addressZip, addressZipCheck, addressCountry, last4, brand, funding, fingerprint, country, currency, customerId, cvcCheck, id, loggingTokens, tokenizationMethod, metadata);
    }

    public static /* synthetic */ Card copy$default(Card card, String string, String string2, Integer n, Integer n2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, CardBrand cardBrand, String string13, String string14, String string15, String string16, String string17, String string18, String string19, Set set, TokenizationMethod tokenizationMethod, Map map, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = card.number;
        }
        if ((n3 & 2) != 0) {
            string2 = card.cvc;
        }
        if ((n3 & 4) != 0) {
            n = card.expMonth;
        }
        if ((n3 & 8) != 0) {
            n2 = card.expYear;
        }
        if ((n3 & 0x10) != 0) {
            string3 = card.name;
        }
        if ((n3 & 0x20) != 0) {
            string4 = card.addressLine1;
        }
        if ((n3 & 0x40) != 0) {
            string5 = card.addressLine1Check;
        }
        if ((n3 & 0x80) != 0) {
            string6 = card.addressLine2;
        }
        if ((n3 & 0x100) != 0) {
            string7 = card.addressCity;
        }
        if ((n3 & 0x200) != 0) {
            string8 = card.addressState;
        }
        if ((n3 & 0x400) != 0) {
            string9 = card.addressZip;
        }
        if ((n3 & 0x800) != 0) {
            string10 = card.addressZipCheck;
        }
        if ((n3 & 0x1000) != 0) {
            string11 = card.addressCountry;
        }
        if ((n3 & 0x2000) != 0) {
            string12 = card.last4;
        }
        if ((n3 & 0x4000) != 0) {
            cardBrand = card.brand;
        }
        if ((n3 & 0x8000) != 0) {
            string13 = card.funding;
        }
        if ((n3 & 0x10000) != 0) {
            string14 = card.fingerprint;
        }
        if ((n3 & 0x20000) != 0) {
            string15 = card.country;
        }
        if ((n3 & 0x40000) != 0) {
            string16 = card.currency;
        }
        if ((n3 & 0x80000) != 0) {
            string17 = card.customerId;
        }
        if ((n3 & 0x100000) != 0) {
            string18 = card.cvcCheck;
        }
        if ((n3 & 0x200000) != 0) {
            string19 = card.getId();
        }
        if ((n3 & 0x400000) != 0) {
            set = card.loggingTokens;
        }
        if ((n3 & 0x800000) != 0) {
            tokenizationMethod = card.tokenizationMethod;
        }
        if ((n3 & 0x1000000) != 0) {
            map = card.metadata;
        }
        return card.copy(string, string2, n, n2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, cardBrand, string13, string14, string15, string16, string17, string18, string19, set, tokenizationMethod, map);
    }

    @NotNull
    public String toString() {
        return "Card(number=" + this.number + ", cvc=" + this.cvc + ", expMonth=" + this.expMonth + ", expYear=" + this.expYear + ", name=" + this.name + ", addressLine1=" + this.addressLine1 + ", addressLine1Check=" + this.addressLine1Check + ", addressLine2=" + this.addressLine2 + ", addressCity=" + this.addressCity + ", addressState=" + this.addressState + ", addressZip=" + this.addressZip + ", addressZipCheck=" + this.addressZipCheck + ", addressCountry=" + this.addressCountry + ", last4=" + this.last4 + ", brand=" + (Object)((Object)this.brand) + ", funding=" + this.funding + ", fingerprint=" + this.fingerprint + ", country=" + this.country + ", currency=" + this.currency + ", customerId=" + this.customerId + ", cvcCheck=" + this.cvcCheck + ", id=" + this.getId() + ", loggingTokens=" + this.loggingTokens + ", tokenizationMethod=" + (Object)((Object)this.tokenizationMethod) + ", metadata=" + this.metadata + ")";
    }

    @Override
    public int hashCode() {
        String string = this.number;
        String string2 = this.cvc;
        Integer n = this.expMonth;
        Integer n2 = this.expYear;
        String string3 = this.name;
        String string4 = this.addressLine1;
        String string5 = this.addressLine1Check;
        String string6 = this.addressLine2;
        String string7 = this.addressCity;
        String string8 = this.addressState;
        String string9 = this.addressZip;
        String string10 = this.addressZipCheck;
        String string11 = this.addressCountry;
        String string12 = this.last4;
        CardBrand cardBrand = this.brand;
        String string13 = this.funding;
        String string14 = this.fingerprint;
        String string15 = this.country;
        String string16 = this.currency;
        String string17 = this.customerId;
        String string18 = this.cvcCheck;
        String string19 = this.getId();
        Set<String> set = this.loggingTokens;
        TokenizationMethod tokenizationMethod = this.tokenizationMethod;
        Map<String, String> map = this.metadata;
        return ((((((((((((((((((((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (n != null ? ((Object)n).hashCode() : 0)) * 31 + (n2 != null ? ((Object)n2).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31 + (string7 != null ? string7.hashCode() : 0)) * 31 + (string8 != null ? string8.hashCode() : 0)) * 31 + (string9 != null ? string9.hashCode() : 0)) * 31 + (string10 != null ? string10.hashCode() : 0)) * 31 + (string11 != null ? string11.hashCode() : 0)) * 31 + (string12 != null ? string12.hashCode() : 0)) * 31 + (cardBrand != null ? ((Object)((Object)cardBrand)).hashCode() : 0)) * 31 + (string13 != null ? string13.hashCode() : 0)) * 31 + (string14 != null ? string14.hashCode() : 0)) * 31 + (string15 != null ? string15.hashCode() : 0)) * 31 + (string16 != null ? string16.hashCode() : 0)) * 31 + (string17 != null ? string17.hashCode() : 0)) * 31 + (string18 != null ? string18.hashCode() : 0)) * 31 + (string19 != null ? string19.hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (tokenizationMethod != null ? ((Object)((Object)tokenizationMethod)).hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Card)) break block3;
                Card card = (Card)object;
                if (!Intrinsics.areEqual((Object)this.number, (Object)card.number) || !Intrinsics.areEqual((Object)this.cvc, (Object)card.cvc) || !Intrinsics.areEqual((Object)this.expMonth, (Object)card.expMonth) || !Intrinsics.areEqual((Object)this.expYear, (Object)card.expYear) || !Intrinsics.areEqual((Object)this.name, (Object)card.name) || !Intrinsics.areEqual((Object)this.addressLine1, (Object)card.addressLine1) || !Intrinsics.areEqual((Object)this.addressLine1Check, (Object)card.addressLine1Check) || !Intrinsics.areEqual((Object)this.addressLine2, (Object)card.addressLine2) || !Intrinsics.areEqual((Object)this.addressCity, (Object)card.addressCity) || !Intrinsics.areEqual((Object)this.addressState, (Object)card.addressState) || !Intrinsics.areEqual((Object)this.addressZip, (Object)card.addressZip) || !Intrinsics.areEqual((Object)this.addressZipCheck, (Object)card.addressZipCheck) || !Intrinsics.areEqual((Object)this.addressCountry, (Object)card.addressCountry) || !Intrinsics.areEqual((Object)this.last4, (Object)card.last4) || !Intrinsics.areEqual((Object)((Object)this.brand), (Object)((Object)card.brand)) || !Intrinsics.areEqual((Object)this.funding, (Object)card.funding) || !Intrinsics.areEqual((Object)this.fingerprint, (Object)card.fingerprint) || !Intrinsics.areEqual((Object)this.country, (Object)card.country) || !Intrinsics.areEqual((Object)this.currency, (Object)card.currency) || !Intrinsics.areEqual((Object)this.customerId, (Object)card.customerId) || !Intrinsics.areEqual((Object)this.cvcCheck, (Object)card.cvcCheck) || !Intrinsics.areEqual((Object)this.getId(), (Object)card.getId()) || !Intrinsics.areEqual(this.loggingTokens, card.loggingTokens) || !Intrinsics.areEqual((Object)((Object)this.tokenizationMethod), (Object)((Object)card.tokenizationMethod)) || !Intrinsics.areEqual(this.metadata, card.metadata)) break block3;
            }
            return true;
        }
        return false;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
        parcel.writeString(this.number);
        parcel.writeString(this.cvc);
        Parcel parcel2 = parcel;
        Integer n = this.expMonth;
        if (n != null) {
            parcel.writeInt(1);
            parcel2.writeInt(n.intValue());
        } else {
            parcel2.writeInt(0);
        }
        Parcel parcel3 = parcel;
        Integer n2 = this.expYear;
        if (n2 != null) {
            parcel.writeInt(1);
            parcel3.writeInt(n2.intValue());
        } else {
            parcel3.writeInt(0);
        }
        parcel.writeString(this.name);
        parcel.writeString(this.addressLine1);
        parcel.writeString(this.addressLine1Check);
        parcel.writeString(this.addressLine2);
        parcel.writeString(this.addressCity);
        parcel.writeString(this.addressState);
        parcel.writeString(this.addressZip);
        parcel.writeString(this.addressZipCheck);
        parcel.writeString(this.addressCountry);
        parcel.writeString(this.last4);
        parcel.writeString(this.brand.name());
        parcel.writeString(this.funding);
        parcel.writeString(this.fingerprint);
        parcel.writeString(this.country);
        parcel.writeString(this.currency);
        parcel.writeString(this.customerId);
        parcel.writeString(this.cvcCheck);
        parcel.writeString(this.id);
        Set<String> set = this.loggingTokens;
        parcel.writeInt(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            iterator = iterator;
            parcel.writeString((String)iterator.next());
        }
        Parcel parcel4 = parcel;
        TokenizationMethod tokenizationMethod = this.tokenizationMethod;
        if (tokenizationMethod != null) {
            parcel.writeInt(1);
            parcel4.writeString(tokenizationMethod.name());
        } else {
            parcel4.writeInt(0);
        }
        Parcel parcel5 = parcel;
        Map<String, String> map = this.metadata;
        if (map != null) {
            parcel.writeInt(1);
            parcel5.writeInt(map.size());
            Iterator<Map.Entry<String, String>> iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                iterator2 = iterator2;
                Parcel parcel6 = parcel;
                Map.Entry<String, String> entry = iterator2.next();
                parcel6.writeString(entry.getKey());
                parcel6.writeString(entry.getValue());
            }
        } else {
            parcel5.writeInt(0);
        }
    }

    @JvmStatic
    @Nullable
    public static final String asFundingType(@Nullable String possibleFundingType) {
        return Companion.asFundingType(possibleFundingType);
    }

    @JvmStatic
    @Nullable
    public static final Card fromString(@NotNull String jsonString) {
        return Companion.fromString(jsonString);
    }

    @JvmStatic
    @Nullable
    public static final Card fromJson(@Nullable JSONObject jsonObject) {
        return Companion.fromJson(jsonObject);
    }

    @JvmStatic
    @NotNull
    public static final Card create(@Nullable String number, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String cvc) {
        return Companion.create(number, expMonth, expYear, cvc);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class Creator
    implements Parcelable.Creator {
        @NotNull
        public final Object[] newArray(int size) {
            return new Card[size];
        }

        @NotNull
        public final Object createFromParcel(@NotNull Parcel in) {
            LinkedHashMap<String, String> linkedHashMap;
            Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
            String string = in.readString();
            String string2 = in.readString();
            Integer n = in.readInt() != 0 ? Integer.valueOf(in.readInt()) : null;
            Integer n2 = in.readInt() != 0 ? Integer.valueOf(in.readInt()) : null;
            String string3 = in.readString();
            String string4 = in.readString();
            String string5 = in.readString();
            String string6 = in.readString();
            String string7 = in.readString();
            String string8 = in.readString();
            String string9 = in.readString();
            String string10 = in.readString();
            String string11 = in.readString();
            String string12 = in.readString();
            String string13 = in.readString();
            String string14 = in.readString();
            String string15 = in.readString();
            String string16 = in.readString();
            String string17 = in.readString();
            String string18 = in.readString();
            String string19 = in.readString();
            int n3 = in.readInt();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(n3);
            int n4 = n3;
            while (n4 != 0) {
                linkedHashSet.add(in.readString());
                linkedHashSet = linkedHashSet;
                n4 = n4 + -1;
            }
            TokenizationMethod tokenizationMethod = in.readInt() != 0 ? Enum.valueOf(TokenizationMethod.class, in.readString()) : null;
            if (in.readInt() != 0) {
                n3 = in.readInt();
                LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>(n3);
                int n5 = n3;
                while (n5 != 0) {
                    Parcel parcel = in;
                    linkedHashMap2.put(parcel.readString(), parcel.readString());
                    linkedHashMap2 = linkedHashMap2;
                    n5 = n5 + -1;
                }
                linkedHashMap = linkedHashMap2;
            } else {
                linkedHashMap = null;
            }
            return new Card(string, string2, n, n2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, Enum.valueOf(CardBrand.class, in.readString()), string13, string14, string15, string16, string17, string18, string19, linkedHashSet, tokenizationMethod, linkedHashMap);
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/model/Card$FundingType;", "", "Companion", "stripe_release"})
    public static @interface FundingType {
        public static final Companion Companion = Companion.$$INSTANCE;
        @NotNull
        public static final String CREDIT = "credit";
        @NotNull
        public static final String DEBIT = "debit";
        @NotNull
        public static final String PREPAID = "prepaid";
        @NotNull
        public static final String UNKNOWN = "unknown";

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/Card$FundingType$Companion;", "", "()V", "CREDIT", "", "DEBIT", "PREPAID", "UNKNOWN", "stripe_release"})
        public static final class Companion {
            @NotNull
            public static final String CREDIT = "credit";
            @NotNull
            public static final String DEBIT = "debit";
            @NotNull
            public static final String PREPAID = "prepaid";
            @NotNull
            public static final String UNKNOWN = "unknown";
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00002\b\u0010,\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000b\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\f\u001a\u00020\u00002\b\u0010-\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\r\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010-\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010.\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010/\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0011\u001a\u00020\u00002\b\u00100\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u00101\u001a\u00020\u0002H\u0016J\u0014\u00102\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u0010\u00103\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001f\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\"\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010\u0004J\u0010\u0010#\u001a\u00020\u00002\b\u0010#\u001a\u0004\u0018\u00010\u0004J\u0014\u0010$\u001a\u00020\u00002\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%J\u001c\u0010&\u001a\u00020\u00002\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010'J\u0010\u0010(\u001a\u00020\u00002\b\u0010(\u001a\u0004\u0018\u00010\u0004J\u0014\u00104\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010*\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u00010+R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001d\u0010\u001bR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0018R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/stripe/android/model/Card$Builder;", "Lcom/stripe/android/ObjectBuilder;", "Lcom/stripe/android/model/Card;", "number", "", "expMonth", "", "expYear", "cvc", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)V", "addressCity", "addressCountry", "addressLine1", "addressLine1Check", "addressLine2", "addressState", "addressZip", "addressZipCheck", "brand", "Lcom/stripe/android/model/CardBrand;", "country", "currency", "customerId", "getCvc$stripe_release", "()Ljava/lang/String;", "cvcCheck", "getExpMonth$stripe_release", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getExpYear$stripe_release", "fingerprint", "funding", "funding$annotations", "()V", "id", "last4", "loggingTokens", "", "metadata", "", "name", "getNumber$stripe_release", "tokenizationMethod", "Lcom/stripe/android/model/TokenizationMethod;", "city", "address", "state", "zip", "zipCheck", "build", "calculateLast4", "customer", "normalizeCardNumber", "stripe_release"})
    public static final class Builder
    implements ObjectBuilder<Card> {
        private String name;
        private String addressLine1;
        private String addressLine1Check;
        private String addressLine2;
        private String addressCity;
        private String addressState;
        private String addressZip;
        private String addressZipCheck;
        private String addressCountry;
        private CardBrand brand;
        private String funding;
        @Size(value=4L)
        private String last4;
        private String fingerprint;
        private String country;
        private String currency;
        private String customerId;
        private String cvcCheck;
        private String id;
        private TokenizationMethod tokenizationMethod;
        private Map<String, String> metadata;
        private Set<String> loggingTokens;
        @Nullable
        private final String number;
        @Nullable
        private final Integer expMonth;
        @Nullable
        private final Integer expYear;
        @Nullable
        private final String cvc;

        private static /* synthetic */ void funding$annotations() {
        }

        @NotNull
        public final Builder name(@Nullable String name) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.name = name;
            return builder;
        }

        @NotNull
        public final Builder addressLine1(@Nullable String address) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.addressLine1 = address;
            return builder;
        }

        @NotNull
        public final Builder addressLine1Check(@Nullable String addressLine1Check) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.addressLine1Check = addressLine1Check;
            return builder;
        }

        @NotNull
        public final Builder addressLine2(@Nullable String address) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.addressLine2 = address;
            return builder;
        }

        @NotNull
        public final Builder addressCity(@Nullable String city) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.addressCity = city;
            return builder;
        }

        @NotNull
        public final Builder addressState(@Nullable String state) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.addressState = state;
            return builder;
        }

        @NotNull
        public final Builder addressZip(@Nullable String zip) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.addressZip = zip;
            return builder;
        }

        @NotNull
        public final Builder addressZipCheck(@Nullable String zipCheck) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.addressZipCheck = zipCheck;
            return builder;
        }

        @NotNull
        public final Builder addressCountry(@Nullable String country) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.addressCountry = country;
            return builder;
        }

        @NotNull
        public final Builder brand(@Nullable CardBrand brand) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.brand = brand;
            return builder;
        }

        @NotNull
        public final Builder fingerprint(@Nullable String fingerprint) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.fingerprint = fingerprint;
            return $this$apply;
        }

        @NotNull
        public final Builder funding(@Nullable String funding) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.funding = funding;
            return builder;
        }

        @NotNull
        public final Builder country(@Nullable String country) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.country = country;
            return builder;
        }

        @NotNull
        public final Builder currency(@Nullable String currency) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.currency = currency;
            return builder;
        }

        @NotNull
        public final Builder customer(@Nullable String customerId) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.customerId = customerId;
            return builder;
        }

        @NotNull
        public final Builder cvcCheck(@Nullable String cvcCheck) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.cvcCheck = cvcCheck;
            return builder;
        }

        @NotNull
        public final Builder last4(@Nullable String last4) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.last4 = last4;
            return builder;
        }

        @NotNull
        public final Builder id(@Nullable String id) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.id = id;
            return builder;
        }

        @NotNull
        public final Builder tokenizationMethod(@Nullable TokenizationMethod tokenizationMethod) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.tokenizationMethod = tokenizationMethod;
            return builder;
        }

        @NotNull
        public final Builder metadata(@Nullable Map<String, String> metadata) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.metadata = metadata;
            return builder;
        }

        @NotNull
        public final Builder loggingTokens(@NotNull Set<String> loggingTokens) {
            Intrinsics.checkParameterIsNotNull(loggingTokens, (String)"loggingTokens");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.loggingTokens = loggingTokens;
            return builder;
        }

        @Override
        @NotNull
        public Card build() {
            Object object;
            String string = this.normalizeCardNumber(this.number);
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            boolean bl5 = false;
            String number = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
            Object object2 = this.last4;
            bl2 = false;
            boolean bl6 = false;
            String it2 = object2;
            boolean bl7 = false;
            CharSequence charSequence2 = it2;
            bl5 = false;
            boolean bl8 = false;
            Object object3 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            if (object3 == null) {
                object3 = this.calculateLast4(number);
            }
            String last4 = object3;
            object2 = this.cvc;
            Integer n = this.expYear;
            Integer n2 = this.expMonth;
            String string2 = number;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl9 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string3 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.name;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl10 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string4 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.addressLine1;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl11 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string5 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.addressLine1Check;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl12 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string6 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.addressLine2;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl13 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string7 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.addressCity;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl14 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string8 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.addressState;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl15 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string9 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.addressZip;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl16 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string10 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.addressZipCheck;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl17 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string11 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.addressCountry;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl18 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string12 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            CardBrand cardBrand = this.brand;
            if (cardBrand == null) {
                cardBrand = CardUtils.getPossibleCardType(number);
            }
            object2 = this.fingerprint;
            CardBrand cardBrand2 = cardBrand;
            String string13 = last4;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl19 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string14 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = Companion.asFundingType(this.funding);
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl20 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string15 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.country;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl21 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string16 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.currency;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl22 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string17 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.customerId;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl23 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string18 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.cvcCheck;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl24 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string19 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.id;
            bl2 = false;
            bl6 = false;
            it2 = object2;
            boolean bl25 = false;
            charSequence2 = it2;
            bl5 = false;
            bl8 = false;
            String string20 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? object2 : null;
            object2 = this.loggingTokens;
            Map<String, String> map = this.metadata;
            TokenizationMethod tokenizationMethod = this.tokenizationMethod;
            bl2 = false;
            Object object4 = object2;
            if (object4 == null) {
                object4 = SetsKt.emptySet();
            }
            object2 = object = object4;
            Map<String, String> map2 = map;
            TokenizationMethod tokenizationMethod2 = tokenizationMethod;
            String string21 = string20;
            String string22 = string19;
            charSequence2 = string18;
            String string23 = string17;
            String string24 = string16;
            String string25 = string15;
            String string26 = string14;
            CardBrand cardBrand3 = cardBrand2;
            String string27 = string13;
            String string28 = string12;
            String string29 = string11;
            String string30 = string10;
            String string31 = string9;
            String string32 = string8;
            String string33 = string7;
            String string34 = string6;
            String string35 = string5;
            String string36 = string4;
            String string37 = string3;
            Integer n3 = n;
            Integer n4 = n2;
            Map<String, String> map3 = map2;
            TokenizationMethod tokenizationMethod3 = tokenizationMethod2;
            Object object5 = object2;
            String string38 = string21;
            String string39 = string22;
            CharSequence charSequence3 = charSequence2;
            String string40 = string23;
            String string41 = string24;
            String string42 = string26;
            String string43 = string25;
            CardBrand cardBrand4 = cardBrand3;
            String string44 = string27;
            String string45 = string28;
            String string46 = string29;
            String string47 = string30;
            String string48 = string31;
            String string49 = string32;
            String string50 = string33;
            String string51 = string34;
            String string52 = string35;
            String string53 = string36;
            Integer n5 = n3;
            Integer n6 = n4;
            String string54 = string37;
            String string55 = string2;
            return new Card(string55, string54, n6, n5, string53, string52, string51, string50, string49, string48, string47, string46, string45, string44, cardBrand4, string43, string42, string41, string40, (String)charSequence3, string39, string38, (Set<String>)object5, tokenizationMethod3, map3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String normalizeCardNumber(String number) {
            String string = number;
            String string2 = string;
            if (string == null) return null;
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            string2 = string5;
            if (string5 == null) return null;
            CharSequence charSequence = string2;
            String string6 = "\\s+|-";
            boolean bl2 = false;
            string6 = new Regex(string6);
            String string7 = "";
            boolean bl3 = false;
            String string8 = string6.replace(charSequence, string7);
            return string8;
        }

        private final String calculateLast4(String number) {
            String string;
            if (number != null && number.length() > 4) {
                String string2 = number;
                int n = number.length() - 4;
                boolean bl = false;
                String string3 = string2.substring(n);
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = null;
            }
            return string;
        }

        @Nullable
        public final String getNumber$stripe_release() {
            return this.number;
        }

        @Nullable
        public final Integer getExpMonth$stripe_release() {
            return this.expMonth;
        }

        @Nullable
        public final Integer getExpYear$stripe_release() {
            return this.expYear;
        }

        @Nullable
        public final String getCvc$stripe_release() {
            return this.cvc;
        }

        public Builder(@Nullable String number, @IntRange(from=1L, to=12L) @Nullable Integer expMonth, @IntRange(from=0L) @Nullable Integer expYear, @Nullable String cvc) {
            this.number = number;
            this.expMonth = expMonth;
            this.expYear = expYear;
            this.cvc = cvc;
        }

        public /* synthetic */ Builder(String string, Integer n, Integer n2, String string2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                string = null;
            }
            if ((n3 & 2) != 0) {
                n = null;
            }
            if ((n3 & 4) != 0) {
                n2 = null;
            }
            if ((n3 & 8) != 0) {
                string2 = null;
            }
            this(string, n, n2, string2);
        }

        public Builder() {
            this(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0007J=\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/model/Card$Companion;", "", "()V", "OBJECT_TYPE", "", "asFundingType", "possibleFundingType", "create", "Lcom/stripe/android/model/Card;", "number", "expMonth", "", "expYear", "cvc", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)Lcom/stripe/android/model/Card;", "fromJson", "jsonObject", "Lorg/json/JSONObject;", "fromString", "jsonString", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final String asFundingType(@Nullable String possibleFundingType) {
            CharSequence charSequence = possibleFundingType;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            return StringsKt.equals((String)"credit", (String)possibleFundingType, (boolean)true) ? "credit" : (StringsKt.equals((String)"debit", (String)possibleFundingType, (boolean)true) ? "debit" : (StringsKt.equals((String)"prepaid", (String)possibleFundingType, (boolean)true) ? "prepaid" : "unknown"));
        }

        @JvmStatic
        @Nullable
        public final Card fromString(@NotNull String jsonString) {
            Card card;
            Intrinsics.checkParameterIsNotNull((Object)jsonString, (String)"jsonString");
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                card = this.fromJson(jsonObject);
            }
            catch (JSONException ignored) {
                card = null;
            }
            return card;
        }

        @JvmStatic
        @Nullable
        public final Card fromJson(@Nullable JSONObject jsonObject) {
            Card card;
            JSONObject jSONObject = jsonObject;
            if (jSONObject != null) {
                JSONObject jSONObject2 = jSONObject;
                boolean bl = false;
                boolean bl2 = false;
                JSONObject it = jSONObject2;
                boolean bl3 = false;
                card = new CardJsonParser().parse(it);
            } else {
                card = null;
            }
            return card;
        }

        @JvmStatic
        @NotNull
        public final Card create(@Nullable String number, @Nullable Integer expMonth, @Nullable Integer expYear, @Nullable String cvc) {
            return new Builder(number, expMonth, expYear, cvc).build();
        }

        public static /* synthetic */ Card create$default(Companion companion, String string, Integer n, Integer n2, String string2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = null;
            }
            if ((n3 & 2) != 0) {
                n = null;
            }
            if ((n3 & 4) != 0) {
                n2 = null;
            }
            if ((n3 & 8) != 0) {
                string2 = null;
            }
            return companion.create(string, n, n2, string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

