/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.AnalyticsDataFactory;
import com.stripe.android.AnalyticsEvent;
import com.stripe.android.AnalyticsRequest;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiRequestExecutor;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.FileUploadRequest;
import com.stripe.android.FingerprintRequestFactory;
import com.stripe.android.FireAndForgetRequestExecutor;
import com.stripe.android.Logger;
import com.stripe.android.Stripe3ds2AuthParams;
import com.stripe.android.StripeError;
import com.stripe.android.StripeErrorJsonParser;
import com.stripe.android.StripeFireAndForgetRequestExecutor;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.StripeRepository;
import com.stripe.android.StripeRequest;
import com.stripe.android.StripeResponse;
import com.stripe.android.UidParamsFactory;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.PermissionException;
import com.stripe.android.exception.RateLimitException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.Customer;
import com.stripe.android.model.FpxBankStatuses;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Stripe3ds2AuthResult;
import com.stripe.android.model.StripeFile;
import com.stripe.android.model.StripeFileParams;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.Token;
import com.stripe.android.model.parsers.CustomerJsonParser;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.PaymentIntentJsonParser;
import com.stripe.android.model.parsers.PaymentMethodJsonParser;
import com.stripe.android.model.parsers.SetupIntentJsonParser;
import com.stripe.android.model.parsers.SourceJsonParser;
import com.stripe.android.model.parsers.Stripe3ds2AuthResultJsonParser;
import com.stripe.android.model.parsers.StripeFileJsonParser;
import com.stripe.android.model.parsers.TokenJsonParser;
import java.io.IOException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u0091\u00012\u00020\u0001:\f\u0090\u0001\u0091\u0001\u0092\u0001\u0093\u0001\u0094\u0001\u0095\u0001Bu\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0017J@\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J8\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J.\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010+\u001a\u00020#2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020*0-H\u0016J\"\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00152\u0006\u0010+\u001a\u00020#H\u0016J\"\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00152\u0006\u0010+\u001a\u00020#H\u0016J\u001d\u00104\u001a\u0002052\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0001\u00a2\u0006\u0002\b6J&\u00104\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002050-H\u0016J\u001a\u00107\u001a\u0004\u0018\u00010/2\u0006\u00108\u001a\u0002092\u0006\u0010+\u001a\u00020#H\u0016J\u001a\u0010:\u001a\u0004\u0018\u0001022\u0006\u0010;\u001a\u00020<2\u0006\u0010+\u001a\u00020#H\u0016J\u001c\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150>2\u0006\u0010?\u001a\u00020\u0015H\u0002J\u0018\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010\"\u001a\u00020#H\u0016J\u001a\u0010D\u001a\u0004\u0018\u00010%2\u0006\u0010E\u001a\u00020F2\u0006\u0010+\u001a\u00020#H\u0016J\u001a\u0010G\u001a\u0004\u0018\u00010\u001b2\u0006\u0010H\u001a\u00020I2\u0006\u0010+\u001a\u00020#H\u0016J,\u0010J\u001a\u0004\u0018\u00010K2\u0010\u0010L\u001a\f\u0012\u0004\u0012\u00020\u0015\u0012\u0002\b\u00030>2\u0006\u0010+\u001a\u00020#2\u0006\u0010M\u001a\u00020\u0015H\u0016J8\u0010N\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J0\u0010O\u001a\u0004\u0018\u00010%2\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J\u0014\u0010P\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u00150QH\u0002J/\u0010R\u001a\u0004\u0018\u0001HS\"\b\b\u0000\u0010S*\u00020T2\u0006\u0010U\u001a\u00020V2\f\u0010W\u001a\b\u0012\u0004\u0012\u0002HS0XH\u0002\u00a2\u0006\u0002\u0010YJ\u0018\u0010Z\u001a\u00020(2\u0006\u0010[\u001a\u00020\\2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J)\u0010Z\u001a\u00020(2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020^0>2\u0006\u0010\u001d\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b_J\b\u0010`\u001a\u00020(H\u0002J\u0015\u0010a\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\bbJ\u0010\u0010c\u001a\u00020d2\u0006\u0010+\u001a\u00020#H\u0016J<\u0010e\u001a\b\u0012\u0004\u0012\u00020%0f2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010g\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010h\u001a\u00020(2\u0006\u0010i\u001a\u00020jH\u0002J\u0015\u0010k\u001a\u00020j2\u0006\u0010U\u001a\u00020VH\u0001\u00a2\u0006\u0002\blJ\u0015\u0010m\u001a\u00020j2\u0006\u0010n\u001a\u00020oH\u0001\u00a2\u0006\u0002\bpJ\u0010\u0010q\u001a\u00020(2\u0006\u0010r\u001a\u00020sH\u0002J,\u0010t\u001a\u0004\u0018\u00010K2\u0006\u0010u\u001a\u00020\u00152\u0010\u0010v\u001a\f\u0012\u0004\u0012\u00020\u0015\u0012\u0002\b\u00030>2\u0006\u0010+\u001a\u00020#H\u0002J\u001c\u0010w\u001a\u00020(2\u0012\u0010x\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u00150QH\u0002J\u001a\u0010y\u001a\u0004\u0018\u00010z2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J&\u0010{\u001a\u00020(2\u0006\u0010?\u001a\u00020\u00152\u0006\u0010+\u001a\u00020#2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020*0-H\u0016J)\u0010|\u001a\u00020\u00152\u0006\u0010}\u001a\u00020\u00152\u0006\u0010~\u001a\u00020\u00152\u0006\u0010\u007f\u001a\u00020\u00152\u0007\u0010\u0080\u0001\u001a\u00020\u0015H\u0016J\u001b\u0010\u0081\u0001\u001a\u0004\u0018\u00010/2\u0006\u0010?\u001a\u00020\u00152\u0006\u0010+\u001a\u00020#H\u0016J\u001b\u0010\u0082\u0001\u001a\u0004\u0018\u0001022\u0006\u0010?\u001a\u00020\u00152\u0006\u0010+\u001a\u00020#H\u0016J#\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u001b2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010?\u001a\u00020\u00152\u0006\u0010+\u001a\u00020#H\u0016J/\u0010\u0083\u0001\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010?\u001a\u00020\u00152\u0006\u0010+\u001a\u00020#2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0-H\u0016J;\u0010\u0084\u0001\u001a\u0004\u0018\u00010z2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f2\b\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u0010\"\u001a\u00020#H\u0016JA\u0010\u0087\u0001\u001a\u0004\u0018\u00010z2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0016J+\u0010\u0088\u0001\u001a\u00030\u0089\u00012\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0001\u00a2\u0006\u0003\b\u008d\u0001J3\u0010\u0088\u0001\u001a\u00020(2\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\r\u0010,\u001a\t\u0012\u0005\u0012\u00030\u0089\u00010-H\u0016J3\u0010\u008e\u0001\u001a\u00020(2\u0006\u0010}\u001a\u00020\u00152\u0007\u0010\u008f\u0001\u001a\u00020\u00152\u0006\u0010~\u001a\u00020\u00152\u0006\u0010\u007f\u001a\u00020\u00152\u0007\u0010\u0080\u0001\u001a\u00020\u0015H\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0096\u0001"}, d2={"Lcom/stripe/android/StripeApiRepository;", "Lcom/stripe/android/StripeRepository;", "context", "Landroid/content/Context;", "appInfo", "Lcom/stripe/android/AppInfo;", "logger", "Lcom/stripe/android/Logger;", "stripeApiRequestExecutor", "Lcom/stripe/android/ApiRequestExecutor;", "fireAndForgetRequestExecutor", "Lcom/stripe/android/FireAndForgetRequestExecutor;", "fingerprintRequestFactory", "Lcom/stripe/android/FingerprintRequestFactory;", "uidParamsFactory", "Lcom/stripe/android/UidParamsFactory;", "analyticsDataFactory", "Lcom/stripe/android/AnalyticsDataFactory;", "networkUtils", "Lcom/stripe/android/StripeNetworkUtils;", "apiVersion", "", "sdkVersion", "(Landroid/content/Context;Lcom/stripe/android/AppInfo;Lcom/stripe/android/Logger;Lcom/stripe/android/ApiRequestExecutor;Lcom/stripe/android/FireAndForgetRequestExecutor;Lcom/stripe/android/FingerprintRequestFactory;Lcom/stripe/android/UidParamsFactory;Lcom/stripe/android/AnalyticsDataFactory;Lcom/stripe/android/StripeNetworkUtils;Ljava/lang/String;Ljava/lang/String;)V", "apiRequestFactory", "Lcom/stripe/android/ApiRequest$Factory;", "addCustomerSource", "Lcom/stripe/android/model/Source;", "customerId", "publishableKey", "productUsageTokens", "", "sourceId", "sourceType", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "attachPaymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "paymentMethodId", "cancelIntent", "", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "options", "callback", "Lcom/stripe/android/ApiResultCallback;", "cancelPaymentIntentSource", "Lcom/stripe/android/model/PaymentIntent;", "paymentIntentId", "cancelSetupIntentSource", "Lcom/stripe/android/model/SetupIntent;", "setupIntentId", "complete3ds2Auth", "", "complete3ds2Auth$stripe_release", "confirmPaymentIntent", "confirmPaymentIntentParams", "Lcom/stripe/android/model/ConfirmPaymentIntentParams;", "confirmSetupIntent", "confirmSetupIntentParams", "Lcom/stripe/android/model/ConfirmSetupIntentParams;", "createClientSecretParam", "", "clientSecret", "createFile", "Lcom/stripe/android/model/StripeFile;", "fileParams", "Lcom/stripe/android/model/StripeFileParams;", "createPaymentMethod", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "createSource", "sourceParams", "Lcom/stripe/android/model/SourceParams;", "createToken", "Lcom/stripe/android/model/Token;", "tokenParams", "tokenType", "deleteCustomerSource", "detachPaymentMethod", "disableDnsCache", "Landroid/util/Pair;", "fetchStripeModel", "ModelType", "Lcom/stripe/android/model/StripeModel;", "apiRequest", "Lcom/stripe/android/ApiRequest;", "jsonParser", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "(Lcom/stripe/android/ApiRequest;Lcom/stripe/android/model/parsers/ModelJsonParser;)Lcom/stripe/android/model/StripeModel;", "fireAnalyticsRequest", "event", "Lcom/stripe/android/AnalyticsEvent;", "loggingMap", "", "fireAnalyticsRequest$stripe_release", "fireFingerprintRequest", "getDetachPaymentMethodUrl", "getDetachPaymentMethodUrl$stripe_release", "getFpxBankStatus", "Lcom/stripe/android/model/FpxBankStatuses;", "getPaymentMethods", "", "paymentMethodType", "handleApiError", "response", "Lcom/stripe/android/StripeResponse;", "makeApiRequest", "makeApiRequest$stripe_release", "makeFileUploadRequest", "fileUploadRequest", "Lcom/stripe/android/FileUploadRequest;", "makeFileUploadRequest$stripe_release", "makeFireAndForgetRequest", "request", "Lcom/stripe/android/StripeRequest;", "requestToken", "url", "params", "resetDnsCacheTtl", "dnsCacheData", "retrieveCustomer", "Lcom/stripe/android/model/Customer;", "retrieveIntent", "retrieveIssuingCardPin", "cardId", "verificationId", "userOneTimeCode", "ephemeralKeySecret", "retrievePaymentIntent", "retrieveSetupIntent", "retrieveSource", "setCustomerShippingInfo", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "setDefaultCustomerSource", "start3ds2Auth", "Lcom/stripe/android/model/Stripe3ds2AuthResult;", "authParams", "Lcom/stripe/android/Stripe3ds2AuthParams;", "stripeIntentId", "start3ds2Auth$stripe_release", "updateIssuingCardPin", "newPin", "CancelIntentTask", "Companion", "Complete3ds2AuthTask", "RetrieveIntentTask", "RetrieveSourceTask", "Start3ds2AuthTask", "stripe_release"})
public final class StripeApiRepository
implements StripeRepository {
    private final ApiRequest.Factory apiRequestFactory;
    private final AppInfo appInfo;
    private final Logger logger;
    private final ApiRequestExecutor stripeApiRequestExecutor;
    private final FireAndForgetRequestExecutor fireAndForgetRequestExecutor;
    private final FingerprintRequestFactory fingerprintRequestFactory;
    private final UidParamsFactory uidParamsFactory;
    private final AnalyticsDataFactory analyticsDataFactory;
    private final StripeNetworkUtils networkUtils;
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public PaymentIntent confirmPaymentIntent(@NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Map<String, ?> params = this.networkUtils.paramsWithUid$stripe_release(confirmPaymentIntentParams.toParamMap());
        String apiUrl = Companion.getConfirmPaymentIntentUrl$stripe_release(new PaymentIntent.ClientSecret(confirmPaymentIntentParams.getClientSecret()).getPaymentIntentId$stripe_release());
        try {
            this.fireFingerprintRequest();
            Object object = confirmPaymentIntentParams.getPaymentMethodCreateParams();
            if (object == null || (object = ((PaymentMethodCreateParams)object).getTypeCode()) == null) {
                SourceParams sourceParams = confirmPaymentIntentParams.getSourceParams();
                object = sourceParams != null ? sourceParams.getType() : null;
            }
            Object paymentMethodType2 = object;
            this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createPaymentIntentConfirmationParams$stripe_release(options.getApiKey(), (String)paymentMethodType2), options.getApiKey());
            return (PaymentIntent)this.fetchStripeModel(this.apiRequestFactory.createPost(apiUrl, options, params), new PaymentIntentJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public PaymentIntent retrievePaymentIntent(@NotNull String clientSecret, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        String paymentIntentId = new PaymentIntent.ClientSecret(clientSecret).getPaymentIntentId$stripe_release();
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createPaymentIntentRetrieveParams$stripe_release(options.getApiKey(), paymentIntentId), options.getApiKey());
        try {
            return (PaymentIntent)this.fetchStripeModel(this.apiRequestFactory.createGet(Companion.getRetrievePaymentIntentUrl$stripe_release(paymentIntentId), options, this.createClientSecretParam(clientSecret)), new PaymentIntentJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public PaymentIntent cancelPaymentIntentSource(@NotNull String paymentIntentId, @NotNull String sourceId, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)paymentIntentId, (String)"paymentIntentId");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest(AnalyticsEvent.PaymentIntentCancelSource, options.getApiKey());
        try {
            return (PaymentIntent)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getCancelPaymentIntentSourceUrl$stripe_release(paymentIntentId), options, MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId))), new PaymentIntentJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public SetupIntent confirmSetupIntent(@NotNull ConfirmSetupIntentParams confirmSetupIntentParams, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)confirmSetupIntentParams, (String)"confirmSetupIntentParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        String setupIntentId = new SetupIntent.ClientSecret(confirmSetupIntentParams.getClientSecret()).getSetupIntentId$stripe_release();
        this.fireFingerprintRequest();
        PaymentMethodCreateParams paymentMethodCreateParams = confirmSetupIntentParams.getPaymentMethodCreateParams$stripe_release();
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createSetupIntentConfirmationParams$stripe_release(options.getApiKey(), paymentMethodCreateParams != null ? paymentMethodCreateParams.getTypeCode() : null, setupIntentId), options.getApiKey());
        try {
            return (SetupIntent)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getConfirmSetupIntentUrl$stripe_release(setupIntentId), options, this.networkUtils.paramsWithUid$stripe_release(confirmSetupIntentParams.toParamMap())), new SetupIntentJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public SetupIntent retrieveSetupIntent(@NotNull String clientSecret, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        String setupIntentId = new SetupIntent.ClientSecret(clientSecret).getSetupIntentId$stripe_release();
        try {
            this.fireFingerprintRequest();
            this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createSetupIntentRetrieveParams$stripe_release(options.getApiKey(), setupIntentId), options.getApiKey());
            return (SetupIntent)this.fetchStripeModel(this.apiRequestFactory.createGet(Companion.getRetrieveSetupIntentUrl$stripe_release(setupIntentId), options, this.createClientSecretParam(clientSecret)), new SetupIntentJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public SetupIntent cancelSetupIntentSource(@NotNull String setupIntentId, @NotNull String sourceId, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)setupIntentId, (String)"setupIntentId");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest(AnalyticsEvent.SetupIntentCancelSource, options.getApiKey());
        try {
            return (SetupIntent)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getCancelSetupIntentSourceUrl$stripe_release(setupIntentId), options, MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId))), new SetupIntentJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    public void retrieveIntent(@NotNull String clientSecret, @NotNull ApiRequest.Options options, @NotNull ApiResultCallback<StripeIntent> callback) {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new RetrieveIntentTask(this, clientSecret, options, callback).execute$stripe_release();
    }

    @Override
    public void cancelIntent(@NotNull StripeIntent stripeIntent, @NotNull String sourceId, @NotNull ApiRequest.Options options, @NotNull ApiResultCallback<StripeIntent> callback) {
        Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new CancelIntentTask(this, stripeIntent, sourceId, options, callback).execute$stripe_release();
    }

    @Override
    @Nullable
    public Source createSource(@NotNull SourceParams sourceParams, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)sourceParams, (String)"sourceParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest$stripe_release(AnalyticsDataFactory.createSourceCreationParams$stripe_release$default(this.analyticsDataFactory, options.getApiKey(), sourceParams.getType(), null, 4, null), options.getApiKey());
        try {
            return (Source)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getSourcesUrl$stripe_release(), options, MapsKt.plus(sourceParams.toParamMap(), this.uidParamsFactory.createParams())), new SourceJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public Source retrieveSource(@NotNull String sourceId, @NotNull String clientSecret, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        String apiUrl = Companion.getRetrieveSourceApiUrl$stripe_release(sourceId);
        try {
            return (Source)this.fetchStripeModel(this.apiRequestFactory.createGet(apiUrl, options, SourceParams.Companion.createRetrieveSourceParams(clientSecret)), new SourceJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    public void retrieveSource(@NotNull String sourceId, @NotNull String clientSecret, @NotNull ApiRequest.Options options, @NotNull ApiResultCallback<Source> callback) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new RetrieveSourceTask(this, sourceId, clientSecret, options, callback).execute$stripe_release();
    }

    @Override
    @Nullable
    public PaymentMethod createPaymentMethod(@NotNull PaymentMethodCreateParams paymentMethodCreateParams, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodCreateParams, (String)"paymentMethodCreateParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.fireFingerprintRequest();
        try {
            PaymentMethod paymentMethod = (PaymentMethod)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getPaymentMethodsUrl$stripe_release(), options, MapsKt.plus(paymentMethodCreateParams.toParamMap(), this.uidParamsFactory.createParams())), new PaymentMethodJsonParser());
            PaymentMethod paymentMethod2 = paymentMethod;
            this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createPaymentMethodCreationParams$stripe_release(options.getApiKey(), paymentMethod2 != null ? paymentMethod2.id : null), options.getApiKey());
            return paymentMethod;
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public Token createToken(@NotNull Map<String, ?> tokenParams, @NotNull ApiRequest.Options options, @NotNull String tokenType) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull(tokenParams, (String)"tokenParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)tokenType, (String)"tokenType");
        try {
            this.fireFingerprintRequest();
            this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createTokenCreationParams$stripe_release((List)tokenParams.get("product_usage"), options.getApiKey(), tokenType), options.getApiKey());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this.requestToken(Companion.getTokensUrl$stripe_release(), MapsKt.minus(tokenParams, (Object)"product_usage"), options);
    }

    @Override
    @Nullable
    public Source addCustomerSource(@NotNull String customerId, @NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull String sourceId, @NotNull String sourceType, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)sourceType, (String)"sourceType");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createAddSourceParams$stripe_release((Collection<String>)productUsageTokens, publishableKey, sourceType), publishableKey);
        return (Source)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getAddCustomerSourceUrl$stripe_release(customerId), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId))), new SourceJsonParser());
    }

    @Override
    @Nullable
    public Source deleteCustomerSource(@NotNull String customerId, @NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createDeleteSourceParams$stripe_release((Collection<String>)productUsageTokens, publishableKey), publishableKey);
        return (Source)this.fetchStripeModel(this.apiRequestFactory.createDelete(Companion.getDeleteCustomerSourceUrl$stripe_release(customerId, sourceId), requestOptions), new SourceJsonParser());
    }

    @Override
    @Nullable
    public PaymentMethod attachPaymentMethod(@NotNull String customerId, @NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull String paymentMethodId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createAttachPaymentMethodParams$stripe_release((Collection<String>)productUsageTokens, publishableKey), publishableKey);
        return (PaymentMethod)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getAttachPaymentMethodUrl$stripe_release(paymentMethodId), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"customer", (Object)customerId))), new PaymentMethodJsonParser());
    }

    @Override
    @Nullable
    public PaymentMethod detachPaymentMethod(@NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull String paymentMethodId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createDetachPaymentMethodParams$stripe_release((Collection<String>)productUsageTokens, publishableKey), publishableKey);
        return (PaymentMethod)this.fetchStripeModel(ApiRequest.Factory.createPost$default(this.apiRequestFactory, this.getDetachPaymentMethodUrl$stripe_release(paymentMethodId), requestOptions, null, 4, null), new PaymentMethodJsonParser());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PaymentMethod> getPaymentMethods(@NotNull String customerId, @NotNull String paymentMethodType2, @NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodType2, (String)"paymentMethodType");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        StripeResponse response = this.makeApiRequest$stripe_release(this.apiRequestFactory.createGet(Companion.getPaymentMethodsUrl$stripe_release(), requestOptions, MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"customer", (Object)customerId), TuplesKt.to((Object)"type", (Object)paymentMethodType2)})));
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest$stripe_release(AnalyticsDataFactory.createParams$stripe_release$default(this.analyticsDataFactory, AnalyticsEvent.CustomerRetrievePaymentMethods, publishableKey, productUsageTokens, null, null, null, 56, null), publishableKey);
        try {
            void $this$mapNotNullTo$iv$iv;
            JSONArray jSONArray = response.getResponseJson$stripe_release().optJSONArray("data");
            if (jSONArray == null) {
                jSONArray = new JSONArray();
            }
            JSONArray data = jSONArray;
            Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)data.length());
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PaymentMethod paymentMethod;
                int element$iv$iv$iv;
                int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                int it = element$iv$iv;
                boolean bl2 = false;
                PaymentMethodJsonParser paymentMethodJsonParser = new PaymentMethodJsonParser();
                JSONObject jSONObject = data.optJSONObject(it);
                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"data.optJSONObject(it)");
                if (paymentMethodJsonParser.parse(jSONObject) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                PaymentMethod it$iv$iv = paymentMethod;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        catch (JSONException e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Customer setDefaultCustomerSource(@NotNull String customerId, @NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull String sourceId, @NotNull String sourceType, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)sourceType, (String)"sourceType");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest$stripe_release(AnalyticsDataFactory.createParams$stripe_release$default(this.analyticsDataFactory, AnalyticsEvent.CustomerSetDefaultSource, publishableKey, productUsageTokens, sourceType, null, null, 48, null), publishableKey);
        return (Customer)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getRetrieveCustomerUrl$stripe_release(customerId), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"default_source", (Object)sourceId))), new CustomerJsonParser());
    }

    @Override
    @Nullable
    public Customer setCustomerShippingInfo(@NotNull String customerId, @NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull ShippingInformation shippingInformation, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)shippingInformation, (String)"shippingInformation");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest$stripe_release(AnalyticsDataFactory.createParams$stripe_release$default(this.analyticsDataFactory, AnalyticsEvent.CustomerSetShippingInfo, publishableKey, productUsageTokens, null, null, null, 56, null), publishableKey);
        return (Customer)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getRetrieveCustomerUrl$stripe_release(customerId), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"shipping", shippingInformation.toParamMap()))), new CustomerJsonParser());
    }

    @Override
    @Nullable
    public Customer retrieveCustomer(@NotNull String customerId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest(AnalyticsEvent.CustomerRetrieve, requestOptions.getApiKey());
        return (Customer)this.fetchStripeModel(ApiRequest.Factory.createGet$default(this.apiRequestFactory, Companion.getRetrieveCustomerUrl$stripe_release(customerId), requestOptions, null, 4, null), new CustomerJsonParser());
    }

    @Override
    @NotNull
    public String retrieveIssuingCardPin(@NotNull String cardId, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull String ephemeralKeySecret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException, JSONException {
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
        Intrinsics.checkParameterIsNotNull((Object)verificationId, (String)"verificationId");
        Intrinsics.checkParameterIsNotNull((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkParameterIsNotNull((Object)ephemeralKeySecret, (String)"ephemeralKeySecret");
        this.fireAnalyticsRequest(AnalyticsEvent.IssuingRetrievePin, ephemeralKeySecret);
        StripeResponse response = this.makeApiRequest$stripe_release(this.apiRequestFactory.createGet(Companion.getIssuingCardPinUrl$stripe_release(cardId), new ApiRequest.Options(ephemeralKeySecret, null, null, 6, null), MapsKt.mapOf((Pair)TuplesKt.to((Object)"verification", (Object)StripeApiRepository.Companion.createVerificationParam(verificationId, userOneTimeCode)))));
        String string = response.getResponseJson$stripe_release().getString("pin");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.responseJson.getString(\"pin\")");
        return string;
    }

    @Override
    public void updateIssuingCardPin(@NotNull String cardId, @NotNull String newPin, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull String ephemeralKeySecret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
        Intrinsics.checkParameterIsNotNull((Object)newPin, (String)"newPin");
        Intrinsics.checkParameterIsNotNull((Object)verificationId, (String)"verificationId");
        Intrinsics.checkParameterIsNotNull((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkParameterIsNotNull((Object)ephemeralKeySecret, (String)"ephemeralKeySecret");
        this.fireAnalyticsRequest(AnalyticsEvent.IssuingUpdatePin, ephemeralKeySecret);
        this.makeApiRequest$stripe_release(this.apiRequestFactory.createPost(Companion.getIssuingCardPinUrl$stripe_release(cardId), new ApiRequest.Options(ephemeralKeySecret, null, null, 6, null), MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"verification", (Object)StripeApiRepository.Companion.createVerificationParam(verificationId, userOneTimeCode)), TuplesKt.to((Object)"pin", (Object)newPin)})));
    }

    @Override
    @NotNull
    public FpxBankStatuses getFpxBankStatus(@NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        StripeResponse response = this.makeApiRequest$stripe_release(this.apiRequestFactory.createGet(StripeApiRepository.Companion.getApiUrl("fpx/bank_statuses"), options, MapsKt.mapOf((Pair)TuplesKt.to((Object)"account_holder_type", (Object)"individual"))));
        return FpxBankStatuses.Companion.fromJson$stripe_release(response.getResponseJson$stripe_release());
    }

    @VisibleForTesting
    @NotNull
    public final Stripe3ds2AuthResult start3ds2Auth$stripe_release(@NotNull Stripe3ds2AuthParams authParams, @NotNull String stripeIntentId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, CardException, AuthenticationException, JSONException {
        Intrinsics.checkParameterIsNotNull((Object)authParams, (String)"authParams");
        Intrinsics.checkParameterIsNotNull((Object)stripeIntentId, (String)"stripeIntentId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createAuthParams$stripe_release(AnalyticsEvent.Auth3ds2Start, stripeIntentId, requestOptions.getApiKey()), requestOptions.getApiKey());
        StripeResponse response = this.makeApiRequest$stripe_release(this.apiRequestFactory.createPost(StripeApiRepository.Companion.getApiUrl("3ds2/authenticate"), requestOptions, authParams.toParamMap()));
        return new Stripe3ds2AuthResultJsonParser().parse(response.getResponseJson$stripe_release());
    }

    @Override
    public void start3ds2Auth(@NotNull Stripe3ds2AuthParams authParams, @NotNull String stripeIntentId, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<Stripe3ds2AuthResult> callback) {
        Intrinsics.checkParameterIsNotNull((Object)authParams, (String)"authParams");
        Intrinsics.checkParameterIsNotNull((Object)stripeIntentId, (String)"stripeIntentId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new Start3ds2AuthTask(this, authParams, stripeIntentId, requestOptions, callback).execute$stripe_release();
    }

    @VisibleForTesting
    public final boolean complete3ds2Auth$stripe_release(@NotNull String sourceId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, CardException, AuthenticationException {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        StripeResponse response = this.makeApiRequest$stripe_release(this.apiRequestFactory.createPost(StripeApiRepository.Companion.getApiUrl("3ds2/challenge_complete"), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId))));
        return response.isOk$stripe_release();
    }

    @Override
    public void complete3ds2Auth(@NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<Boolean> callback) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new Complete3ds2AuthTask(this, sourceId, requestOptions, callback).execute$stripe_release();
    }

    @Override
    @NotNull
    public StripeFile createFile(@NotNull StripeFileParams fileParams, @NotNull ApiRequest.Options requestOptions) {
        Intrinsics.checkParameterIsNotNull((Object)fileParams, (String)"fileParams");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        StripeResponse response = this.makeFileUploadRequest$stripe_release(new FileUploadRequest(fileParams, requestOptions, this.appInfo, null, null, 24, null));
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest(AnalyticsEvent.FileCreate, requestOptions.getApiKey());
        return new StripeFileJsonParser().parse(response.getResponseJson$stripe_release());
    }

    @VisibleForTesting
    @NotNull
    public final String getDetachPaymentMethodUrl$stripe_release(@NotNull String paymentMethodId) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        return StripeApiRepository.Companion.getApiUrl("payment_methods/%s/detach", paymentMethodId);
    }

    private final void handleApiError(StripeResponse response) throws InvalidRequestException, AuthenticationException, CardException, APIException {
        String requestId = response.getRequestId$stripe_release();
        int responseCode = response.getResponseCode$stripe_release();
        StripeError stripeError = new StripeErrorJsonParser().parse(response.getResponseJson$stripe_release());
        switch (responseCode) {
            case 400: 
            case 404: {
                throw (Throwable)new InvalidRequestException(stripeError, requestId, responseCode, null, null, null, 56, null);
            }
            case 401: {
                throw (Throwable)new AuthenticationException(stripeError, requestId);
            }
            case 402: {
                throw (Throwable)new CardException(stripeError, requestId);
            }
            case 403: {
                throw (Throwable)new PermissionException(stripeError, requestId);
            }
            case 429: {
                throw (Throwable)new RateLimitException(stripeError, requestId);
            }
        }
        throw (Throwable)new APIException(stripeError, requestId, responseCode, null, null, 24, null);
    }

    private final <ModelType extends StripeModel> ModelType fetchStripeModel(ApiRequest apiRequest, ModelJsonParser<? extends ModelType> jsonParser) {
        return jsonParser.parse(this.makeApiRequest$stripe_release(apiRequest).getResponseJson$stripe_release());
    }

    @VisibleForTesting
    @NotNull
    public final StripeResponse makeApiRequest$stripe_release(@NotNull ApiRequest apiRequest) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        StripeResponse stripeResponse;
        Intrinsics.checkParameterIsNotNull((Object)apiRequest, (String)"apiRequest");
        android.util.Pair<Boolean, String> dnsCacheData = this.disableDnsCache();
        try {
            stripeResponse = this.stripeApiRequestExecutor.execute(apiRequest);
        }
        catch (IOException ex) {
            throw (Throwable)APIConnectionException.Companion.create$stripe_release(ex, apiRequest.getBaseUrl());
        }
        StripeResponse response = stripeResponse;
        if (response.hasErrorCode$stripe_release()) {
            this.handleApiError(response);
        }
        this.resetDnsCacheTtl(dnsCacheData);
        return response;
    }

    @VisibleForTesting
    @NotNull
    public final StripeResponse makeFileUploadRequest$stripe_release(@NotNull FileUploadRequest fileUploadRequest) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        StripeResponse stripeResponse;
        Intrinsics.checkParameterIsNotNull((Object)fileUploadRequest, (String)"fileUploadRequest");
        android.util.Pair<Boolean, String> dnsCacheData = this.disableDnsCache();
        try {
            stripeResponse = this.stripeApiRequestExecutor.execute(fileUploadRequest);
        }
        catch (IOException ex) {
            throw (Throwable)APIConnectionException.Companion.create$stripe_release(ex, fileUploadRequest.getBaseUrl());
        }
        StripeResponse response = stripeResponse;
        if (response.hasErrorCode$stripe_release()) {
            this.handleApiError(response);
        }
        this.resetDnsCacheTtl(dnsCacheData);
        return response;
    }

    private final void makeFireAndForgetRequest(StripeRequest request) {
        this.fireAndForgetRequestExecutor.executeAsync(request);
    }

    private final android.util.Pair<Boolean, String> disableDnsCache() {
        android.util.Pair pair;
        try {
            String originalDNSCacheTtl = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
            android.util.Pair pair2 = android.util.Pair.create((Object)true, (Object)originalDNSCacheTtl);
            Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"Pair.create(true, originalDNSCacheTtl)");
            pair = pair2;
        }
        catch (SecurityException se) {
            android.util.Pair pair3 = android.util.Pair.create((Object)false, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)pair3, (String)"Pair.create(false, null)");
            pair = pair3;
        }
        return pair;
    }

    private final void resetDnsCacheTtl(android.util.Pair<Boolean, String> dnsCacheData) {
        Object object = dnsCacheData.first;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dnsCacheData.first");
        if (((Boolean)object).booleanValue()) {
            String string = (String)dnsCacheData.second;
            if (string == null) {
                string = "-1";
            }
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, string);
        }
    }

    private final Token requestToken(String url, Map<String, ?> params, ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Token)this.fetchStripeModel(this.apiRequestFactory.createPost(url, options, params), new TokenJsonParser());
    }

    private final void fireFingerprintRequest() {
        this.makeFireAndForgetRequest(this.fingerprintRequestFactory.create());
    }

    private final void fireAnalyticsRequest(AnalyticsEvent event, String publishableKey) {
        this.fireAnalyticsRequest$stripe_release(AnalyticsDataFactory.createParams$stripe_release$default(this.analyticsDataFactory, event, publishableKey, null, null, null, null, 60, null), publishableKey);
    }

    @VisibleForTesting
    public final void fireAnalyticsRequest$stripe_release(@NotNull Map<String, ? extends Object> loggingMap, @NotNull String publishableKey) {
        Intrinsics.checkParameterIsNotNull(loggingMap, (String)"loggingMap");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        this.makeFireAndForgetRequest(AnalyticsRequest.INSTANCE.create$stripe_release(loggingMap, new ApiRequest.Options(publishableKey, null, null, 6, null), this.appInfo));
    }

    private final Map<String, String> createClientSecretParam(String clientSecret) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"client_secret", (Object)clientSecret));
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull FireAndForgetRequestExecutor fireAndForgetRequestExecutor, @NotNull FingerprintRequestFactory fingerprintRequestFactory, @NotNull UidParamsFactory uidParamsFactory, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull StripeNetworkUtils networkUtils, @NotNull String apiVersion, @NotNull String sdkVersion) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)stripeApiRequestExecutor, (String)"stripeApiRequestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)fireAndForgetRequestExecutor, (String)"fireAndForgetRequestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)fingerprintRequestFactory, (String)"fingerprintRequestFactory");
        Intrinsics.checkParameterIsNotNull((Object)uidParamsFactory, (String)"uidParamsFactory");
        Intrinsics.checkParameterIsNotNull((Object)analyticsDataFactory, (String)"analyticsDataFactory");
        Intrinsics.checkParameterIsNotNull((Object)networkUtils, (String)"networkUtils");
        Intrinsics.checkParameterIsNotNull((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkParameterIsNotNull((Object)sdkVersion, (String)"sdkVersion");
        this.appInfo = appInfo;
        this.logger = logger;
        this.stripeApiRequestExecutor = stripeApiRequestExecutor;
        this.fireAndForgetRequestExecutor = fireAndForgetRequestExecutor;
        this.fingerprintRequestFactory = fingerprintRequestFactory;
        this.uidParamsFactory = uidParamsFactory;
        this.analyticsDataFactory = analyticsDataFactory;
        this.networkUtils = networkUtils;
        this.apiRequestFactory = new ApiRequest.Factory(this.appInfo, apiVersion, sdkVersion);
    }

    public /* synthetic */ StripeApiRepository(Context context, AppInfo appInfo, Logger logger, ApiRequestExecutor apiRequestExecutor, FireAndForgetRequestExecutor fireAndForgetRequestExecutor, FingerprintRequestFactory fingerprintRequestFactory, UidParamsFactory uidParamsFactory, AnalyticsDataFactory analyticsDataFactory, StripeNetworkUtils stripeNetworkUtils, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            appInfo = null;
        }
        if ((n & 4) != 0) {
            logger = Logger.Companion.noop$stripe_release();
        }
        if ((n & 8) != 0) {
            apiRequestExecutor = new ApiRequestExecutor.Default(logger);
        }
        if ((n & 0x10) != 0) {
            fireAndForgetRequestExecutor = new StripeFireAndForgetRequestExecutor(logger);
        }
        if ((n & 0x20) != 0) {
            fingerprintRequestFactory = new FingerprintRequestFactory(context);
        }
        if ((n & 0x40) != 0) {
            uidParamsFactory = UidParamsFactory.Companion.create$stripe_release(context);
        }
        if ((n & 0x80) != 0) {
            analyticsDataFactory = new AnalyticsDataFactory(context);
        }
        if ((n & 0x100) != 0) {
            stripeNetworkUtils = new StripeNetworkUtils(context);
        }
        if ((n & 0x200) != 0) {
            string = ApiVersion.Companion.get$stripe_release().getCode$stripe_release();
        }
        if ((n & 0x400) != 0) {
            string2 = "AndroidBindings/13.1.2";
        }
        this(context, appInfo, logger, apiRequestExecutor, fireAndForgetRequestExecutor, fingerprintRequestFactory, uidParamsFactory, analyticsDataFactory, stripeNetworkUtils, string, string2);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull FireAndForgetRequestExecutor fireAndForgetRequestExecutor, @NotNull FingerprintRequestFactory fingerprintRequestFactory, @NotNull UidParamsFactory uidParamsFactory, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull StripeNetworkUtils networkUtils, @NotNull String apiVersion) {
        this(context, appInfo, logger, stripeApiRequestExecutor, fireAndForgetRequestExecutor, fingerprintRequestFactory, uidParamsFactory, analyticsDataFactory, networkUtils, apiVersion, null, 1024, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull FireAndForgetRequestExecutor fireAndForgetRequestExecutor, @NotNull FingerprintRequestFactory fingerprintRequestFactory, @NotNull UidParamsFactory uidParamsFactory, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull StripeNetworkUtils networkUtils) {
        this(context, appInfo, logger, stripeApiRequestExecutor, fireAndForgetRequestExecutor, fingerprintRequestFactory, uidParamsFactory, analyticsDataFactory, networkUtils, null, null, 1536, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull FireAndForgetRequestExecutor fireAndForgetRequestExecutor, @NotNull FingerprintRequestFactory fingerprintRequestFactory, @NotNull UidParamsFactory uidParamsFactory, @NotNull AnalyticsDataFactory analyticsDataFactory) {
        this(context, appInfo, logger, stripeApiRequestExecutor, fireAndForgetRequestExecutor, fingerprintRequestFactory, uidParamsFactory, analyticsDataFactory, null, null, null, 1792, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull FireAndForgetRequestExecutor fireAndForgetRequestExecutor, @NotNull FingerprintRequestFactory fingerprintRequestFactory, @NotNull UidParamsFactory uidParamsFactory) {
        this(context, appInfo, logger, stripeApiRequestExecutor, fireAndForgetRequestExecutor, fingerprintRequestFactory, uidParamsFactory, null, null, null, null, 1920, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull FireAndForgetRequestExecutor fireAndForgetRequestExecutor, @NotNull FingerprintRequestFactory fingerprintRequestFactory) {
        this(context, appInfo, logger, stripeApiRequestExecutor, fireAndForgetRequestExecutor, fingerprintRequestFactory, null, null, null, null, null, 1984, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull FireAndForgetRequestExecutor fireAndForgetRequestExecutor) {
        this(context, appInfo, logger, stripeApiRequestExecutor, fireAndForgetRequestExecutor, null, null, null, null, null, null, 2016, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor) {
        this(context, appInfo, logger, stripeApiRequestExecutor, null, null, null, null, null, null, null, 2032, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo, @NotNull Logger logger) {
        this(context, appInfo, logger, null, null, null, null, null, null, null, null, 2040, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @Nullable AppInfo appInfo) {
        this(context, appInfo, null, null, null, null, null, null, null, null, null, 2044, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context) {
        this(context, null, null, null, null, null, null, null, null, null, null, 2046, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/StripeApiRepository$Start3ds2AuthTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Stripe3ds2AuthResult;", "stripeApiRepository", "Lcom/stripe/android/StripeApiRepository;", "params", "Lcom/stripe/android/Stripe3ds2AuthParams;", "stripeIntentId", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeApiRepository;Lcom/stripe/android/Stripe3ds2AuthParams;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class Start3ds2AuthTask
    extends ApiOperation<Stripe3ds2AuthResult> {
        private final StripeApiRepository stripeApiRepository;
        private final Stripe3ds2AuthParams params;
        private final String stripeIntentId;
        private final ApiRequest.Options requestOptions;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super Stripe3ds2AuthResult> $completion) throws StripeException, JSONException {
            return this.stripeApiRepository.start3ds2Auth$stripe_release(this.params, this.stripeIntentId, this.requestOptions);
        }

        public Start3ds2AuthTask(@NotNull StripeApiRepository stripeApiRepository, @NotNull Stripe3ds2AuthParams params, @NotNull String stripeIntentId, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<Stripe3ds2AuthResult> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeApiRepository, (String)"stripeApiRepository");
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            Intrinsics.checkParameterIsNotNull((Object)stripeIntentId, (String)"stripeIntentId");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(null, callback, 1, null);
            this.stripeApiRepository = stripeApiRepository;
            this.params = params;
            this.stripeIntentId = stripeIntentId;
            this.requestOptions = requestOptions;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/StripeApiRepository$Complete3ds2AuthTask;", "Lcom/stripe/android/ApiOperation;", "", "stripeApiRepository", "Lcom/stripe/android/StripeApiRepository;", "sourceId", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeApiRepository;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class Complete3ds2AuthTask
    extends ApiOperation<Boolean> {
        private final StripeApiRepository stripeApiRepository;
        private final String sourceId;
        private final ApiRequest.Options requestOptions;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super Boolean> $completion) throws StripeException {
            return Boxing.boxBoolean((boolean)this.stripeApiRepository.complete3ds2Auth$stripe_release(this.sourceId, this.requestOptions));
        }

        public Complete3ds2AuthTask(@NotNull StripeApiRepository stripeApiRepository, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<Boolean> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeApiRepository, (String)"stripeApiRepository");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(null, callback, 1, null);
            this.stripeApiRepository = stripeApiRepository;
            this.sourceId = sourceId;
            this.requestOptions = requestOptions;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/StripeApiRepository$RetrieveIntentTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/StripeIntent;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "clientSecret", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class RetrieveIntentTask
    extends ApiOperation<StripeIntent> {
        private final StripeRepository stripeRepository;
        private final String clientSecret;
        private final ApiRequest.Options requestOptions;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super StripeIntent> $completion) throws StripeException {
            return StringsKt.startsWith$default((String)this.clientSecret, (String)"pi_", (boolean)false, (int)2, null) ? (StripeIntent)this.stripeRepository.retrievePaymentIntent(this.clientSecret, this.requestOptions) : (StringsKt.startsWith$default((String)this.clientSecret, (String)"seti_", (boolean)false, (int)2, null) ? (StripeIntent)this.stripeRepository.retrieveSetupIntent(this.clientSecret, this.requestOptions) : null);
        }

        public RetrieveIntentTask(@NotNull StripeRepository stripeRepository, @NotNull String clientSecret, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<StripeIntent> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(null, callback, 1, null);
            this.stripeRepository = stripeRepository;
            this.clientSecret = clientSecret;
            this.requestOptions = requestOptions;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/StripeApiRepository$CancelIntentTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/StripeIntent;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "stripeIntent", "sourceId", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/StripeIntent;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class CancelIntentTask
    extends ApiOperation<StripeIntent> {
        private final StripeRepository stripeRepository;
        private final StripeIntent stripeIntent;
        private final String sourceId;
        private final ApiRequest.Options requestOptions;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super StripeIntent> $completion) throws StripeException {
            StripeIntent stripeIntent;
            StripeIntent stripeIntent2 = this.stripeIntent;
            if (stripeIntent2 instanceof PaymentIntent) {
                String string = this.stripeIntent.getId();
                StripeRepository stripeRepository = this.stripeRepository;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string2;
                stripeIntent = stripeRepository.cancelPaymentIntentSource(string3, this.sourceId, this.requestOptions);
            } else if (stripeIntent2 instanceof SetupIntent) {
                String string = this.stripeIntent.getId();
                StripeRepository stripeRepository = this.stripeRepository;
                boolean bl = false;
                String string4 = string;
                if (string4 == null) {
                    string4 = "";
                }
                String string5 = string4;
                stripeIntent = stripeRepository.cancelSetupIntentSource(string5, this.sourceId, this.requestOptions);
            } else {
                stripeIntent = null;
            }
            return stripeIntent;
        }

        public CancelIntentTask(@NotNull StripeRepository stripeRepository, @NotNull StripeIntent stripeIntent, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<StripeIntent> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(null, callback, 1, null);
            this.stripeRepository = stripeRepository;
            this.stripeIntent = stripeIntent;
            this.sourceId = sourceId;
            this.requestOptions = requestOptions;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/StripeApiRepository$RetrieveSourceTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Source;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "sourceId", "", "clientSecret", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class RetrieveSourceTask
    extends ApiOperation<Source> {
        private final StripeRepository stripeRepository;
        private final String sourceId;
        private final String clientSecret;
        private final ApiRequest.Options requestOptions;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super Source> $completion) throws StripeException {
            return this.stripeRepository.retrieveSource(this.sourceId, this.clientSecret, this.requestOptions);
        }

        public RetrieveSourceTask(@NotNull StripeRepository stripeRepository, @NotNull String sourceId, @NotNull String clientSecret, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<Source> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(null, callback, 1, null);
            this.stripeRepository = stripeRepository;
            this.sourceId = sourceId;
            this.clientSecret = clientSecret;
            this.requestOptions = requestOptions;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b \b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0015\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u0012J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J)\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b$J\u001d\u0010%\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b*J\u0015\u0010+\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b.J\u0015\u0010/\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b2J\u0015\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b5R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00066"}, d2={"Lcom/stripe/android/StripeApiRepository$Companion;", "", "()V", "DNS_CACHE_TTL_PROPERTY_NAME", "", "paymentMethodsUrl", "getPaymentMethodsUrl$stripe_release", "()Ljava/lang/String;", "sourcesUrl", "getSourcesUrl$stripe_release", "tokensUrl", "getTokensUrl$stripe_release", "createVerificationParam", "", "verificationId", "userOneTimeCode", "getAddCustomerSourceUrl", "customerId", "getAddCustomerSourceUrl$stripe_release", "getApiUrl", "path", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getAttachPaymentMethodUrl", "paymentMethodId", "getAttachPaymentMethodUrl$stripe_release", "getCancelPaymentIntentSourceUrl", "paymentIntentId", "getCancelPaymentIntentSourceUrl$stripe_release", "getCancelSetupIntentSourceUrl", "setupIntentId", "getCancelSetupIntentSourceUrl$stripe_release", "getConfirmPaymentIntentUrl", "getConfirmPaymentIntentUrl$stripe_release", "getConfirmSetupIntentUrl", "getConfirmSetupIntentUrl$stripe_release", "getDeleteCustomerSourceUrl", "sourceId", "getDeleteCustomerSourceUrl$stripe_release", "getIssuingCardPinUrl", "cardId", "getIssuingCardPinUrl$stripe_release", "getRetrieveCustomerUrl", "getRetrieveCustomerUrl$stripe_release", "getRetrievePaymentIntentUrl", "getRetrievePaymentIntentUrl$stripe_release", "getRetrieveSetupIntentUrl", "getRetrieveSetupIntentUrl$stripe_release", "getRetrieveSourceApiUrl", "getRetrieveSourceApiUrl$stripe_release", "getRetrieveTokenApiUrl", "tokenId", "getRetrieveTokenApiUrl$stripe_release", "stripe_release"})
    public static final class Companion {
        private final Map<String, String> createVerificationParam(String verificationId, String userOneTimeCode) {
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)verificationId), TuplesKt.to((Object)"one_time_code", (Object)userOneTimeCode)});
        }

        @NotNull
        public final /* synthetic */ String getTokensUrl$stripe_release() {
            return Companion.getApiUrl("tokens");
        }

        @NotNull
        public final /* synthetic */ String getSourcesUrl$stripe_release() {
            return Companion.getApiUrl("sources");
        }

        @NotNull
        public final /* synthetic */ String getPaymentMethodsUrl$stripe_release() {
            return Companion.getApiUrl("payment_methods");
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getRetrievePaymentIntentUrl$stripe_release(@NotNull String paymentIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)paymentIntentId, (String)"paymentIntentId");
            return this.getApiUrl("payment_intents/%s", paymentIntentId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getConfirmPaymentIntentUrl$stripe_release(@NotNull String paymentIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)paymentIntentId, (String)"paymentIntentId");
            return this.getApiUrl("payment_intents/%s/confirm", paymentIntentId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getCancelPaymentIntentSourceUrl$stripe_release(@NotNull String paymentIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)paymentIntentId, (String)"paymentIntentId");
            return this.getApiUrl("payment_intents/%s/source_cancel", paymentIntentId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getRetrieveSetupIntentUrl$stripe_release(@NotNull String setupIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)setupIntentId, (String)"setupIntentId");
            return this.getApiUrl("setup_intents/%s", setupIntentId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getConfirmSetupIntentUrl$stripe_release(@NotNull String setupIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)setupIntentId, (String)"setupIntentId");
            return this.getApiUrl("setup_intents/%s/confirm", setupIntentId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getCancelSetupIntentSourceUrl$stripe_release(@NotNull String setupIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)setupIntentId, (String)"setupIntentId");
            return this.getApiUrl("setup_intents/%s/source_cancel", setupIntentId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getAddCustomerSourceUrl$stripe_release(@NotNull String customerId) {
            Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
            return this.getApiUrl("customers/%s/sources", customerId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getDeleteCustomerSourceUrl$stripe_release(@NotNull String customerId, @NotNull String sourceId) {
            Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            return this.getApiUrl("customers/%s/sources/%s", customerId, sourceId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getAttachPaymentMethodUrl$stripe_release(@NotNull String paymentMethodId) {
            Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
            return this.getApiUrl("payment_methods/%s/attach", paymentMethodId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getRetrieveCustomerUrl$stripe_release(@NotNull String customerId) {
            Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
            return this.getApiUrl("customers/%s", customerId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getRetrieveSourceApiUrl$stripe_release(@NotNull String sourceId) {
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            return this.getApiUrl("sources/%s", sourceId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getRetrieveTokenApiUrl$stripe_release(@NotNull String tokenId) {
            Intrinsics.checkParameterIsNotNull((Object)tokenId, (String)"tokenId");
            return this.getApiUrl("tokens/%s", tokenId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getIssuingCardPinUrl$stripe_release(@NotNull String cardId) {
            Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
            return this.getApiUrl("issuing/cards/%s/pin", cardId);
        }

        private final String getApiUrl(String path, Object ... args2) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
            Locale locale2 = locale;
            Object[] objectArray = Arrays.copyOf(args2, args2.length);
            Companion companion = this;
            boolean bl = false;
            String string = String.format(locale2, path, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(locale, format, *args)");
            String string2 = string;
            return companion.getApiUrl(string2);
        }

        private final String getApiUrl(String path) {
            return "https://api.stripe.com/v1/" + path;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

