/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.R;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentFlowPagerAdapter$WhenMappings;
import com.stripe.android.view.PaymentFlowPagerEnum;
import com.stripe.android.view.SelectShippingMethodWidget;
import com.stripe.android.view.ShippingInfoWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u00011B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\"\u001a\u00020\u0016J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001cH\u0016J\u001c\u0010'\u001a\u00020\u00162\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\n\u0010,\u001a\u0004\u0018\u00010)H\u0016J\u000e\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u0012J \u0010/\u001a\u00020\u00162\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000bJ\b\u00100\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/stripe/android/view/PaymentFlowPagerAdapter;", "Landroidx/viewpager/widget/PagerAdapter;", "context", "Landroid/content/Context;", "paymentSessionConfig", "Lcom/stripe/android/PaymentSessionConfig;", "customerSession", "Lcom/stripe/android/CustomerSession;", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "shippingMethod", "Lcom/stripe/android/model/ShippingMethod;", "(Landroid/content/Context;Lcom/stripe/android/PaymentSessionConfig;Lcom/stripe/android/CustomerSession;Lcom/stripe/android/model/ShippingInformation;Lcom/stripe/android/model/ShippingMethod;)V", "defaultShippingMethod", "pages", "", "Lcom/stripe/android/view/PaymentFlowPagerEnum;", "shippingInfoSaved", "", "validShippingMethods", "", "destroyItem", "", "collection", "Landroid/view/ViewGroup;", "position", "", "view", "", "getCount", "getPageAt", "getPageAt$stripe_release", "getPageTitle", "", "hideShippingPage", "instantiateItem", "isViewFromObject", "Landroid/view/View;", "o", "restoreState", "state", "Landroid/os/Parcelable;", "loader", "Ljava/lang/ClassLoader;", "saveState", "setShippingInfoSaved", "addressSaved", "setShippingMethods", "shouldAddShippingScreen", "State", "stripe_release"})
public final class PaymentFlowPagerAdapter
extends PagerAdapter {
    private final List<PaymentFlowPagerEnum> pages;
    private boolean shippingInfoSaved;
    private List<ShippingMethod> validShippingMethods;
    private ShippingMethod defaultShippingMethod;
    private final Context context;
    private final PaymentSessionConfig paymentSessionConfig;
    private final CustomerSession customerSession;
    private final ShippingInformation shippingInformation;
    private final ShippingMethod shippingMethod;

    private final boolean shouldAddShippingScreen() {
        return this.paymentSessionConfig.isShippingMethodRequired() && (!this.paymentSessionConfig.isShippingInfoRequired() || this.shippingInfoSaved) && !this.pages.contains((Object)PaymentFlowPagerEnum.SHIPPING_METHOD);
    }

    public final void setShippingInfoSaved(boolean addressSaved) {
        this.shippingInfoSaved = addressSaved;
        if (this.shouldAddShippingScreen()) {
            this.pages.add(PaymentFlowPagerEnum.SHIPPING_METHOD);
        }
        this.notifyDataSetChanged();
    }

    public final void setShippingMethods(@Nullable List<ShippingMethod> validShippingMethods, @Nullable ShippingMethod defaultShippingMethod) {
        this.validShippingMethods = validShippingMethods;
        this.defaultShippingMethod = defaultShippingMethod;
    }

    public final void hideShippingPage() {
        this.pages.remove((Object)PaymentFlowPagerEnum.SHIPPING_METHOD);
        this.notifyDataSetChanged();
    }

    @NotNull
    public Object instantiateItem(@NotNull ViewGroup collection, int position) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        PaymentFlowPagerEnum paymentFlowPagerEnum = this.pages.get(position);
        View view = LayoutInflater.from((Context)this.context).inflate(paymentFlowPagerEnum.getLayoutResId(), collection, false);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup layout2 = (ViewGroup)view;
        switch (PaymentFlowPagerAdapter$WhenMappings.$EnumSwitchMapping$0[paymentFlowPagerEnum.ordinal()]) {
            case 1: {
                this.customerSession.addProductUsageTokenIfValid("ShippingMethodScreen");
                View view2 = layout2.findViewById(R.id.select_shipping_method_widget);
                Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"layout.findViewById(R.id\u2026t_shipping_method_widget)");
                SelectShippingMethodWidget selectShippingMethodWidget = (SelectShippingMethodWidget)view2;
                selectShippingMethodWidget.setShippingMethods(this.validShippingMethods, this.defaultShippingMethod);
                ShippingMethod shippingMethod = this.shippingMethod;
                if (shippingMethod != null) {
                    ShippingMethod shippingMethod2 = shippingMethod;
                    boolean bl = false;
                    boolean bl2 = false;
                    ShippingMethod it = shippingMethod2;
                    boolean bl3 = false;
                    selectShippingMethodWidget.setSelectedShippingMethod(it);
                }
                break;
            }
            case 2: {
                this.customerSession.addProductUsageTokenIfValid("ShippingInfoScreen");
                View view3 = layout2.findViewById(R.id.shipping_info_widget);
                Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"layout.findViewById(R.id.shipping_info_widget)");
                ShippingInfoWidget shippingInfoWidget = (ShippingInfoWidget)view3;
                shippingInfoWidget.setHiddenFields(this.paymentSessionConfig.getHiddenShippingInfoFields());
                shippingInfoWidget.setOptionalFields(this.paymentSessionConfig.getOptionalShippingInfoFields());
                shippingInfoWidget.populateShippingInfo(this.shippingInformation);
            }
        }
        collection.addView((View)layout2);
        return layout2;
    }

    public void destroyItem(@NotNull ViewGroup collection, int position, @NotNull Object view) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        collection.removeView((View)view);
    }

    public int getCount() {
        return this.pages.size();
    }

    @Nullable
    public final PaymentFlowPagerEnum getPageAt$stripe_release(int position) {
        return (PaymentFlowPagerEnum)((Object)CollectionsKt.getOrNull(this.pages, (int)position));
    }

    public boolean isViewFromObject(@NotNull View view, @NotNull Object o) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        return view == o;
    }

    @Nullable
    public CharSequence getPageTitle(int position) {
        return this.context.getString(this.pages.get(position).getTitleResId());
    }

    @Nullable
    public Parcelable saveState() {
        return new State(this.pages, this.shippingInfoSaved, this.validShippingMethods, this.defaultShippingMethod);
    }

    public void restoreState(@Nullable Parcelable state, @Nullable ClassLoader loader) {
        if (state instanceof State) {
            this.pages.clear();
            this.pages.addAll((Collection<PaymentFlowPagerEnum>)((State)state).getPages$stripe_release());
            this.shippingInfoSaved = ((State)state).getShippingInfoSaved$stripe_release();
            this.validShippingMethods = ((State)state).getValidShippingMethods$stripe_release();
            this.defaultShippingMethod = ((State)state).getDefaultShippingMethod$stripe_release();
            this.notifyDataSetChanged();
        }
    }

    public PaymentFlowPagerAdapter(@NotNull Context context, @NotNull PaymentSessionConfig paymentSessionConfig, @NotNull CustomerSession customerSession, @Nullable ShippingInformation shippingInformation, @Nullable ShippingMethod shippingMethod) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)paymentSessionConfig, (String)"paymentSessionConfig");
        Intrinsics.checkParameterIsNotNull((Object)customerSession, (String)"customerSession");
        this.context = context;
        this.paymentSessionConfig = paymentSessionConfig;
        this.customerSession = customerSession;
        this.shippingInformation = shippingInformation;
        this.shippingMethod = shippingMethod;
        this.validShippingMethods = new ArrayList();
        this.pages = new ArrayList();
        if (this.paymentSessionConfig.isShippingInfoRequired()) {
            this.pages.add(PaymentFlowPagerEnum.SHIPPING_INFO);
        }
        if (this.shouldAddShippingScreen()) {
            this.pages.add(PaymentFlowPagerEnum.SHIPPING_METHOD);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0019\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u00d6\u0001R\u0016\u0010\t\u001a\u0004\u0018\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/view/PaymentFlowPagerAdapter$State;", "Landroid/os/Parcelable;", "pages", "", "Lcom/stripe/android/view/PaymentFlowPagerEnum;", "shippingInfoSaved", "", "validShippingMethods", "Lcom/stripe/android/model/ShippingMethod;", "defaultShippingMethod", "(Ljava/util/List;ZLjava/util/List;Lcom/stripe/android/model/ShippingMethod;)V", "getDefaultShippingMethod$stripe_release", "()Lcom/stripe/android/model/ShippingMethod;", "getPages$stripe_release", "()Ljava/util/List;", "getShippingInfoSaved$stripe_release", "()Z", "getValidShippingMethods$stripe_release", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
    @Parcelize
    public static final class State
    implements Parcelable {
        @NotNull
        private final List<PaymentFlowPagerEnum> pages;
        private final boolean shippingInfoSaved;
        @Nullable
        private final List<ShippingMethod> validShippingMethods;
        @Nullable
        private final ShippingMethod defaultShippingMethod;
        public static final Parcelable.Creator CREATOR = new Creator();

        @NotNull
        public final List<PaymentFlowPagerEnum> getPages$stripe_release() {
            return this.pages;
        }

        public final boolean getShippingInfoSaved$stripe_release() {
            return this.shippingInfoSaved;
        }

        @Nullable
        public final List<ShippingMethod> getValidShippingMethods$stripe_release() {
            return this.validShippingMethods;
        }

        @Nullable
        public final ShippingMethod getDefaultShippingMethod$stripe_release() {
            return this.defaultShippingMethod;
        }

        public State(@NotNull List<? extends PaymentFlowPagerEnum> pages, boolean shippingInfoSaved, @Nullable List<ShippingMethod> validShippingMethods, @Nullable ShippingMethod defaultShippingMethod) {
            Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
            this.pages = pages;
            this.shippingInfoSaved = shippingInfoSaved;
            this.validShippingMethods = validShippingMethods;
            this.defaultShippingMethod = defaultShippingMethod;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
            List<PaymentFlowPagerEnum> list = this.pages;
            parcel.writeInt(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator = iterator;
                parcel.writeString(((PaymentFlowPagerEnum)((Object)iterator.next())).name());
            }
            parcel.writeInt(this.shippingInfoSaved ? 1 : 0);
            Parcel parcel2 = parcel;
            List<ShippingMethod> list2 = this.validShippingMethods;
            if (list2 != null) {
                parcel.writeInt(1);
                parcel2.writeInt(list2.size());
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    iterator2 = iterator2;
                    ((ShippingMethod)iterator2.next()).writeToParcel(parcel, 0);
                }
            } else {
                parcel2.writeInt(0);
            }
            Parcel parcel3 = parcel;
            ShippingMethod shippingMethod = this.defaultShippingMethod;
            if (shippingMethod != null) {
                parcel.writeInt(1);
                shippingMethod.writeToParcel(parcel3, 0);
            } else {
                parcel3.writeInt(0);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=3)
        public static final class Creator
        implements Parcelable.Creator {
            @NotNull
            public final Object[] newArray(int size) {
                return new State[size];
            }

            @NotNull
            public final Object createFromParcel(@NotNull Parcel in) {
                ArrayList<ShippingMethod> arrayList;
                Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
                int n = in.readInt();
                ArrayList<PaymentFlowPagerEnum> arrayList2 = new ArrayList<PaymentFlowPagerEnum>(n);
                int n2 = n;
                while (n2 != 0) {
                    arrayList2.add(Enum.valueOf(PaymentFlowPagerEnum.class, in.readString()));
                    arrayList2 = arrayList2;
                    n2 = n2 + -1;
                }
                boolean bl = in.readInt() != 0;
                if (in.readInt() != 0) {
                    n = in.readInt();
                    ArrayList<ShippingMethod> arrayList3 = new ArrayList<ShippingMethod>(n);
                    int n3 = n;
                    while (n3 != 0) {
                        arrayList3.add((ShippingMethod)ShippingMethod.CREATOR.createFromParcel(in));
                        arrayList3 = arrayList3;
                        n3 = n3 + -1;
                    }
                    arrayList = arrayList3;
                } else {
                    arrayList = null;
                }
                return new State(arrayList2, bl, arrayList, in.readInt() != 0 ? (ShippingMethod)ShippingMethod.CREATOR.createFromParcel(in) : null);
            }
        }
    }
}

