/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.PaymentSessionData;
import com.stripe.android.R;
import com.stripe.android.StripeError;
import com.stripe.android.model.Customer;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentFlowActivityStarter;
import com.stripe.android.view.PaymentFlowPagerAdapter;
import com.stripe.android.view.PaymentFlowPagerEnum;
import com.stripe.android.view.SelectShippingMethodWidget;
import com.stripe.android.view.ShippingInfoWidget;
import com.stripe.android.view.StripeActivity;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 /2\u00020\u0001:\u0002/0B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\u0012\u0010\u001e\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\b\u0010!\u001a\u00020\u0016H\u0014J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010#\u001a\u00020\u0016H\u0014J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020 H\u0014J\u0017\u0010&\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b'J\b\u0010(\u001a\u00020\u0016H\u0002J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020\u0016H\u0002J \u0010-\u001a\u00020\u00162\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040.2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/stripe/android/view/PaymentFlowActivity;", "Lcom/stripe/android/view/StripeActivity;", "()V", "defaultShippingMethod", "Lcom/stripe/android/model/ShippingMethod;", "paymentFlowPagerAdapter", "Lcom/stripe/android/view/PaymentFlowPagerAdapter;", "paymentSessionData", "Lcom/stripe/android/PaymentSessionData;", "selectedShippingMethod", "getSelectedShippingMethod", "()Lcom/stripe/android/model/ShippingMethod;", "shippingInfo", "Lcom/stripe/android/model/ShippingInformation;", "getShippingInfo", "()Lcom/stripe/android/model/ShippingInformation;", "shippingInfoSubmittedBroadcastReceiver", "Landroid/content/BroadcastReceiver;", "shippingInformationSubmitted", "validShippingMethods", "", "broadcastShippingInfoSubmitted", "", "shippingInformation", "hasNextPage", "", "hasPreviousPage", "hideKeyboard", "onActionSave", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onPause", "onRestoreInstanceState", "onResume", "onSaveInstanceState", "outState", "onShippingInfoSaved", "onShippingInfoSaved$stripe_release", "onShippingInfoSubmitted", "onShippingInfoValidated", "customerSession", "Lcom/stripe/android/CustomerSession;", "onShippingMethodSave", "onShippingMethodsReady", "", "Companion", "CustomerShippingInfoSavedListener", "stripe_release"})
public final class PaymentFlowActivity
extends StripeActivity {
    private BroadcastReceiver shippingInfoSubmittedBroadcastReceiver;
    private PaymentFlowPagerAdapter paymentFlowPagerAdapter;
    private PaymentSessionData paymentSessionData;
    private ShippingInformation shippingInformationSubmitted;
    private final List<ShippingMethod> validShippingMethods;
    private ShippingMethod defaultShippingMethod;
    @NotNull
    public static final String TOKEN_PAYMENT_FLOW_ACTIVITY = "PaymentFlowActivity";
    @NotNull
    public static final String TOKEN_SHIPPING_INFO_SCREEN = "ShippingInfoScreen";
    @NotNull
    public static final String TOKEN_SHIPPING_METHOD_SCREEN = "ShippingMethodScreen";
    private static final String STATE_SHIPPING_INFO = "state_shipping_info";
    private static final String STATE_SHIPPING_METHOD = "state_shipping_method";
    private static final String STATE_CURRENT_ITEM = "state_current_item";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        PaymentSessionData paymentSessionData;
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        PaymentFlowActivityStarter.Args args = PaymentFlowActivityStarter.Args.Companion.create(intent);
        CustomerSession customerSession = CustomerSession.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)customerSession, (String)"CustomerSession.getInstance()");
        CustomerSession customerSession2 = customerSession;
        customerSession2.addProductUsageTokenIfValid("PaymentSession");
        customerSession2.addProductUsageTokenIfValid(TOKEN_PAYMENT_FLOW_ACTIVITY);
        this.getViewStub().setLayoutResource(R.layout.activity_shipping_flow);
        this.getViewStub().inflate();
        PaymentSessionData paymentSessionData2 = args.getPaymentSessionData$stripe_release();
        PaymentFlowActivity paymentFlowActivity = this;
        boolean bl = false;
        boolean bl2 = false;
        if (paymentSessionData2 == null) {
            boolean bl3 = false;
            String string2 = "PaymentFlowActivity launched without PaymentSessionData";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        paymentFlowActivity.paymentSessionData = paymentSessionData = paymentSessionData2;
        PaymentSessionConfig paymentSessionConfig = args.getPaymentSessionConfig$stripe_release();
        Object object = savedInstanceState;
        if (object == null || (object = (ShippingInformation)object.getParcelable(STATE_SHIPPING_INFO)) == null) {
            object = paymentSessionConfig.getPrepopulatedShippingInfo();
        }
        Object shippingInformation = object;
        Bundle bundle = savedInstanceState;
        this.paymentFlowPagerAdapter = new PaymentFlowPagerAdapter((Context)this, paymentSessionConfig, customerSession2, (ShippingInformation)shippingInformation, bundle != null ? (ShippingMethod)bundle.getParcelable(STATE_SHIPPING_METHOD) : null);
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        PaymentFlowPagerAdapter paymentFlowPagerAdapter = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        viewPager.setAdapter((PagerAdapter)paymentFlowPagerAdapter);
        ((ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager)).addOnPageChangeListener(new ViewPager.OnPageChangeListener(this){
            final /* synthetic */ PaymentFlowActivity this$0;

            public void onPageScrolled(int i, float v, int i1) {
            }

            public void onPageSelected(int i) {
                this.this$0.setTitle(PaymentFlowActivity.access$getPaymentFlowPagerAdapter$p(this.this$0).getPageTitle(i));
                if (PaymentFlowActivity.access$getPaymentFlowPagerAdapter$p(this.this$0).getPageAt$stripe_release(i) == PaymentFlowPagerEnum.SHIPPING_INFO) {
                    PaymentFlowActivity.access$getPaymentFlowPagerAdapter$p(this.this$0).hideShippingPage();
                }
            }

            public void onPageScrollStateChanged(int i) {
            }
            {
                this.this$0 = $outer;
            }
        });
        this.shippingInfoSubmittedBroadcastReceiver = new BroadcastReceiver(this){
            final /* synthetic */ PaymentFlowActivity this$0;

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                boolean isShippingInfoValid = intent.getBooleanExtra("shipping_is_shipping_info_valid", false);
                if (isShippingInfoValid) {
                    CustomerSession customerSession = CustomerSession.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)customerSession, (String)"CustomerSession.getInstance()");
                    PaymentFlowActivity.access$onShippingInfoValidated(this.this$0, customerSession);
                    List intentShippingMethods = intent.getParcelableArrayListExtra("valid_shipping_methods");
                    if (intentShippingMethods != null) {
                        PaymentFlowActivity.access$getValidShippingMethods$p(this.this$0).clear();
                        PaymentFlowActivity.access$getValidShippingMethods$p(this.this$0).addAll(intentShippingMethods);
                    }
                    PaymentFlowActivity.access$setDefaultShippingMethod$p(this.this$0, (ShippingMethod)intent.getParcelableExtra("default_shipping_method"));
                } else {
                    this.this$0.setCommunicatingProgress(false);
                    String shippingInfoError = intent.getStringExtra("shipping_info_error");
                    CharSequence charSequence = shippingInfoError;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        this.this$0.showError(shippingInfoError);
                    } else {
                        String string2 = this.this$0.getString(R.string.invalid_shipping_information);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(R.string.invalid_shipping_information)");
                        this.this$0.showError(string2);
                    }
                    PaymentFlowActivity.access$setShippingInformationSubmitted$p(this.this$0, null);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        PaymentFlowPagerAdapter paymentFlowPagerAdapter2 = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        ViewPager viewPager2 = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager2, (String)"shipping_flow_viewpager");
        this.setTitle(paymentFlowPagerAdapter2.getPageTitle(viewPager2.getCurrentItem()));
    }

    protected void onRestoreInstanceState(@NotNull Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)savedInstanceState, (String)"savedInstanceState");
        super.onRestoreInstanceState(savedInstanceState);
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        viewPager.setCurrentItem(savedInstanceState.getInt(STATE_CURRENT_ITEM, 0));
    }

    @Override
    public void onActionSave() {
        PaymentFlowPagerAdapter paymentFlowPagerAdapter = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        if (PaymentFlowPagerEnum.SHIPPING_INFO == paymentFlowPagerAdapter.getPageAt$stripe_release(viewPager.getCurrentItem())) {
            this.onShippingInfoSubmitted();
        } else {
            this.onShippingMethodSave();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)((Context)this));
        BroadcastReceiver broadcastReceiver = this.shippingInfoSubmittedBroadcastReceiver;
        if (broadcastReceiver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shippingInfoSubmittedBroadcastReceiver");
        }
        localBroadcastManager.unregisterReceiver(broadcastReceiver);
    }

    @Override
    protected void onResume() {
        super.onResume();
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)((Context)this));
        BroadcastReceiver broadcastReceiver = this.shippingInfoSubmittedBroadcastReceiver;
        if (broadcastReceiver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shippingInfoSubmittedBroadcastReceiver");
        }
        localBroadcastManager.registerReceiver(broadcastReceiver, new IntentFilter("shipping_info_processed"));
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        outState.putParcelable(STATE_SHIPPING_INFO, (Parcelable)this.getShippingInfo());
        outState.putParcelable(STATE_SHIPPING_METHOD, (Parcelable)this.getSelectedShippingMethod());
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        outState.putInt(STATE_CURRENT_ITEM, viewPager.getCurrentItem());
    }

    public final /* synthetic */ void onShippingInfoSaved$stripe_release(@Nullable ShippingInformation shippingInformation) {
        this.onShippingMethodsReady(this.validShippingMethods, this.defaultShippingMethod);
        PaymentSessionData paymentSessionData = this.paymentSessionData;
        if (paymentSessionData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentSessionData");
        }
        paymentSessionData.setShippingInformation(shippingInformation);
    }

    private final void onShippingInfoValidated(CustomerSession customerSession) {
        block0: {
            ShippingInformation shippingInformation = this.shippingInformationSubmitted;
            if (shippingInformation == null) break block0;
            ShippingInformation shippingInformation2 = shippingInformation;
            boolean bl = false;
            boolean bl2 = false;
            ShippingInformation it = shippingInformation2;
            boolean bl3 = false;
            customerSession.setCustomerShippingInformation(it, new CustomerShippingInfoSavedListener(this));
        }
    }

    private final void onShippingMethodsReady(List<ShippingMethod> validShippingMethods, ShippingMethod defaultShippingMethod) {
        this.setCommunicatingProgress(false);
        PaymentFlowPagerAdapter paymentFlowPagerAdapter = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        paymentFlowPagerAdapter.setShippingMethods(validShippingMethods, defaultShippingMethod);
        PaymentFlowPagerAdapter paymentFlowPagerAdapter2 = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        paymentFlowPagerAdapter2.setShippingInfoSaved(true);
        if (this.hasNextPage()) {
            ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
            Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
            ViewPager viewPager2 = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
            Intrinsics.checkExpressionValueIsNotNull((Object)viewPager2, (String)"shipping_flow_viewpager");
            viewPager.setCurrentItem(viewPager2.getCurrentItem() + 1);
        } else {
            PaymentSessionData paymentSessionData = this.paymentSessionData;
            if (paymentSessionData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paymentSessionData");
            }
            paymentSessionData.setShippingInformation(this.shippingInformationSubmitted);
            Intent intent = new Intent();
            PaymentSessionData paymentSessionData2 = this.paymentSessionData;
            if (paymentSessionData2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paymentSessionData");
            }
            this.setResult(-1, intent.putExtra("payment_session_data", (Parcelable)paymentSessionData2));
            this.finish();
        }
    }

    private final void onShippingInfoSubmitted() {
        block0: {
            this.hideKeyboard();
            ShippingInformation shippingInformation = this.getShippingInfo();
            if (shippingInformation == null) break block0;
            ShippingInformation shippingInformation2 = shippingInformation;
            boolean bl = false;
            boolean bl2 = false;
            ShippingInformation shippingInfo = shippingInformation2;
            boolean bl3 = false;
            this.shippingInformationSubmitted = shippingInfo;
            this.setCommunicatingProgress(true);
            this.broadcastShippingInfoSubmitted(shippingInfo);
        }
    }

    private final ShippingInformation getShippingInfo() {
        View view = this.findViewById(R.id.shipping_info_widget);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.shipping_info_widget)");
        ShippingInfoWidget shippingInfoWidget = (ShippingInfoWidget)view;
        return shippingInfoWidget.getRawShippingInformation$stripe_release();
    }

    private final ShippingMethod getSelectedShippingMethod() {
        ShippingMethod shippingMethod;
        PaymentFlowPagerAdapter paymentFlowPagerAdapter = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        if (PaymentFlowPagerEnum.SHIPPING_METHOD == paymentFlowPagerAdapter.getPageAt$stripe_release(viewPager.getCurrentItem())) {
            View view = this.findViewById(R.id.select_shipping_method_widget);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.select_shipping_method_widget)");
            SelectShippingMethodWidget selectShippingMethodWidget = (SelectShippingMethodWidget)view;
            shippingMethod = selectShippingMethodWidget.getSelectedShippingMethod();
        } else {
            shippingMethod = null;
        }
        return shippingMethod;
    }

    private final void hideKeyboard() {
        Object object = this.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        if (inputMethodManager.isAcceptingText()) {
            View view = this.getCurrentFocus();
            inputMethodManager.hideSoftInputFromWindow((IBinder)(view != null ? view.getWindowToken() : null), 0);
        }
    }

    private final void broadcastShippingInfoSubmitted(ShippingInformation shippingInformation) {
        LocalBroadcastManager.getInstance((Context)((Context)this)).sendBroadcast(new Intent("shipping_info_submitted").putExtra("shipping_info_data", (Parcelable)shippingInformation));
    }

    private final boolean hasNextPage() {
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        int n = viewPager.getCurrentItem() + 1;
        PaymentFlowPagerAdapter paymentFlowPagerAdapter = this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        return n < paymentFlowPagerAdapter.getCount();
    }

    private final boolean hasPreviousPage() {
        ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
        int currentPageIndex = viewPager.getCurrentItem();
        return currentPageIndex != 0;
    }

    private final void onShippingMethodSave() {
        View view = this.findViewById(R.id.select_shipping_method_widget);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.select_shipping_method_widget)");
        SelectShippingMethodWidget selectShippingMethodWidget = (SelectShippingMethodWidget)view;
        PaymentSessionData paymentSessionData = this.paymentSessionData;
        if (paymentSessionData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentSessionData");
        }
        paymentSessionData.setShippingMethod(selectShippingMethodWidget.getSelectedShippingMethod());
        Intent intent = new Intent();
        PaymentSessionData paymentSessionData2 = this.paymentSessionData;
        if (paymentSessionData2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentSessionData");
        }
        this.setResult(-1, intent.putExtra("payment_session_data", (Parcelable)paymentSessionData2));
        this.finish();
    }

    public void onBackPressed() {
        if (this.hasPreviousPage()) {
            ViewPager viewPager = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
            Intrinsics.checkExpressionValueIsNotNull((Object)viewPager, (String)"shipping_flow_viewpager");
            ViewPager viewPager2 = (ViewPager)this._$_findCachedViewById(R.id.shipping_flow_viewpager);
            Intrinsics.checkExpressionValueIsNotNull((Object)viewPager2, (String)"shipping_flow_viewpager");
            viewPager.setCurrentItem(viewPager2.getCurrentItem() - 1);
        } else {
            super.onBackPressed();
        }
    }

    public PaymentFlowActivity() {
        List list;
        PaymentFlowActivity paymentFlowActivity = this;
        boolean bl = false;
        paymentFlowActivity.validShippingMethods = list = (List)new ArrayList();
    }

    public static final /* synthetic */ PaymentFlowPagerAdapter access$getPaymentFlowPagerAdapter$p(PaymentFlowActivity $this) {
        PaymentFlowPagerAdapter paymentFlowPagerAdapter = $this.paymentFlowPagerAdapter;
        if (paymentFlowPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentFlowPagerAdapter");
        }
        return paymentFlowPagerAdapter;
    }

    public static final /* synthetic */ void access$setPaymentFlowPagerAdapter$p(PaymentFlowActivity $this, PaymentFlowPagerAdapter paymentFlowPagerAdapter) {
        $this.paymentFlowPagerAdapter = paymentFlowPagerAdapter;
    }

    public static final /* synthetic */ void access$onShippingInfoValidated(PaymentFlowActivity $this, CustomerSession customerSession) {
        $this.onShippingInfoValidated(customerSession);
    }

    public static final /* synthetic */ List access$getValidShippingMethods$p(PaymentFlowActivity $this) {
        return $this.validShippingMethods;
    }

    public static final /* synthetic */ ShippingMethod access$getDefaultShippingMethod$p(PaymentFlowActivity $this) {
        return $this.defaultShippingMethod;
    }

    public static final /* synthetic */ void access$setDefaultShippingMethod$p(PaymentFlowActivity $this, ShippingMethod shippingMethod) {
        $this.defaultShippingMethod = shippingMethod;
    }

    public static final /* synthetic */ ShippingInformation access$getShippingInformationSubmitted$p(PaymentFlowActivity $this) {
        return $this.shippingInformationSubmitted;
    }

    public static final /* synthetic */ void access$setShippingInformationSubmitted$p(PaymentFlowActivity $this, ShippingInformation shippingInformation) {
        $this.shippingInformationSubmitted = shippingInformation;
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/view/PaymentFlowActivity$CustomerShippingInfoSavedListener;", "Lcom/stripe/android/CustomerSession$CustomerRetrievalListener;", "activity", "Lcom/stripe/android/view/PaymentFlowActivity;", "(Lcom/stripe/android/view/PaymentFlowActivity;)V", "activityRef", "Ljava/lang/ref/WeakReference;", "onCustomerRetrieved", "", "customer", "Lcom/stripe/android/model/Customer;", "onError", "errorCode", "", "errorMessage", "", "stripeError", "Lcom/stripe/android/StripeError;", "stripe_release"})
    private static final class CustomerShippingInfoSavedListener
    implements CustomerSession.CustomerRetrievalListener {
        private final WeakReference<PaymentFlowActivity> activityRef;

        @Override
        public void onCustomerRetrieved(@NotNull Customer customer) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)customer, (String)"customer");
                PaymentFlowActivity paymentFlowActivity = (PaymentFlowActivity)((Object)this.activityRef.get());
                if (paymentFlowActivity == null) break block0;
                paymentFlowActivity.onShippingInfoSaved$stripe_release(customer.getShippingInformation());
            }
        }

        @Override
        public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                PaymentFlowActivity paymentFlowActivity = (PaymentFlowActivity)((Object)this.activityRef.get());
                if (paymentFlowActivity == null) break block0;
                paymentFlowActivity.showError(errorMessage);
            }
        }

        public CustomerShippingInfoSavedListener(@NotNull PaymentFlowActivity activity) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)activity), (String)"activity");
            this.activityRef = new WeakReference<PaymentFlowActivity>(activity);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/view/PaymentFlowActivity$Companion;", "", "()V", "STATE_CURRENT_ITEM", "", "STATE_SHIPPING_INFO", "STATE_SHIPPING_METHOD", "TOKEN_PAYMENT_FLOW_ACTIVITY", "TOKEN_SHIPPING_INFO_SCREEN", "TOKEN_SHIPPING_METHOD_SCREEN", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

