/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.DrawableRes;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.stripe.android.R;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.CardDisplayTextFactory;
import com.stripe.android.view.ThemeConfig;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0018H\u0016J\b\u0010*\u001a\u00020$H\u0002J\b\u0010+\u001a\u00020$H\u0002J\"\u0010,\u001a\u00020$2\b\b\u0001\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0018H\u0002J\b\u00101\u001a\u00020$H\u0002R*\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8G@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR\u0011\u0010\u001b\u001a\u00020\u001c8G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/stripe/android/view/MaskedCardView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "", "cardBrand", "cardBrand$annotations", "()V", "getCardBrand", "()Ljava/lang/String;", "cardDisplayFactory", "Lcom/stripe/android/view/CardDisplayTextFactory;", "cardIconImageView", "Landroidx/appcompat/widget/AppCompatImageView;", "cardInformationTextView", "Landroidx/appcompat/widget/AppCompatTextView;", "checkMarkImageView", "isSelected", "", "last4", "getLast4", "textColorValues", "", "getTextColorValues", "()[I", "themeConfig", "Lcom/stripe/android/view/ThemeConfig;", "createDisplayString", "Landroid/text/SpannableString;", "initializeCheckMark", "", "setPaymentMethod", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "setSelected", "selected", "updateBrandIcon", "updateCheckMark", "updateDrawable", "resourceId", "imageView", "Landroid/widget/ImageView;", "isCheckMark", "updateUi", "Companion", "stripe_release"})
public final class MaskedCardView
extends LinearLayout {
    @Nullable
    private String cardBrand;
    @Nullable
    private String last4;
    private boolean isSelected;
    private final AppCompatImageView cardIconImageView;
    private final AppCompatTextView cardInformationTextView;
    private final AppCompatImageView checkMarkImageView;
    private final ThemeConfig themeConfig;
    private final CardDisplayTextFactory cardDisplayFactory;
    private static final Map<String, Integer> ICON_RESOURCE_MAP;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    public static /* synthetic */ void cardBrand$annotations() {
    }

    @VisibleForTesting
    @Nullable
    public final String getCardBrand() {
        return this.cardBrand;
    }

    @VisibleForTesting
    @Nullable
    public final String getLast4() {
        return this.last4;
    }

    @VisibleForTesting
    @NotNull
    public final int[] getTextColorValues() {
        return this.themeConfig.getTextColorValues$stripe_release();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
        this.updateCheckMark();
        this.updateUi();
    }

    public final void setPaymentMethod(@NotNull PaymentMethod paymentMethod) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
        this.cardBrand = paymentMethod.card != null ? paymentMethod.card.brand : "unknown";
        this.last4 = paymentMethod.card != null ? paymentMethod.card.last4 : "";
        this.updateUi();
    }

    private final void updateUi() {
        this.updateBrandIcon();
        this.cardInformationTextView.setText((CharSequence)this.createDisplayString());
    }

    private final void initializeCheckMark() {
        this.updateDrawable(R.drawable.ic_checkmark, (ImageView)this.checkMarkImageView, true);
    }

    private final void updateBrandIcon() {
        Map<String, Integer> map = ICON_RESOURCE_MAP;
        String string2 = this.cardBrand;
        boolean bl = false;
        Integer brandIconResId = map.get(string2);
        if (brandIconResId != null) {
            this.updateDrawable(brandIconResId, (ImageView)this.cardIconImageView, false);
        }
    }

    private final void updateDrawable(@DrawableRes int resourceId, ImageView imageView, boolean isCheckMark) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)resourceId);
        if (drawable2 == null) {
            Intrinsics.throwNpe();
        }
        Drawable icon = DrawableCompat.wrap((Drawable)drawable2);
        DrawableCompat.setTint((Drawable)icon.mutate(), (int)this.themeConfig.getTintColor$stripe_release(this.isSelected || isCheckMark));
        imageView.setImageDrawable(icon);
    }

    private final SpannableString createDisplayString() {
        return this.cardDisplayFactory.createStyled$stripe_release(this.cardBrand, this.last4, this.isSelected);
    }

    private final void updateCheckMark() {
        if (this.isSelected) {
            this.checkMarkImageView.setVisibility(0);
        } else {
            this.checkMarkImageView.setVisibility(4);
        }
    }

    @JvmOverloads
    public MaskedCardView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.themeConfig = new ThemeConfig(context);
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        this.cardDisplayFactory = new CardDisplayTextFactory(resources, this.themeConfig);
        View.inflate((Context)this.getContext(), (int)R.layout.masked_card_view, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.masked_icon_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.masked_icon_view)");
        this.cardIconImageView = (AppCompatImageView)view;
        View view2 = this.findViewById(R.id.masked_card_info_view);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.masked_card_info_view)");
        this.cardInformationTextView = (AppCompatTextView)view2;
        View view3 = this.findViewById(R.id.masked_check_icon);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.masked_check_icon)");
        this.checkMarkImageView = (AppCompatImageView)view3;
        this.initializeCheckMark();
        this.updateCheckMark();
    }

    public /* synthetic */ MaskedCardView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public MaskedCardView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public MaskedCardView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        ICON_RESOURCE_MAP = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"amex", (Object)R.drawable.ic_amex_template_32), TuplesKt.to((Object)"diners", (Object)R.drawable.ic_diners_template_32), TuplesKt.to((Object)"discover", (Object)R.drawable.ic_discover_template_32), TuplesKt.to((Object)"jcb", (Object)R.drawable.ic_jcb_template_32), TuplesKt.to((Object)"mastercard", (Object)R.drawable.ic_mastercard_template_32), TuplesKt.to((Object)"visa", (Object)R.drawable.ic_visa_template_32), TuplesKt.to((Object)"unionpay", (Object)R.drawable.ic_unionpay_template_32), TuplesKt.to((Object)"unknown", (Object)R.drawable.ic_unknown)});
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/view/MaskedCardView$Companion;", "", "()V", "ICON_RESOURCE_MAP", "", "", "", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

