/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.R;
import com.stripe.android.CardUtils;
import com.stripe.android.R;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.ViewUtils;
import java.util.HashMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 62\u00020\u0001:\u0003456B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\u0015\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020 2\u0006\u0010%\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b(J\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\nH\u0002J\u0010\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\nH\u0002J\r\u0010-\u001a\u00020 H\u0000\u00a2\u0006\u0002\b.J%\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b3R,\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@@X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00067"}, d2={"Lcom/stripe/android/view/CardNumberEditText;", "Lcom/stripe/android/view/StripeEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "", "cardBrand", "cardBrand$annotations", "()V", "getCardBrand", "()Ljava/lang/String;", "setCardBrand$stripe_release", "(Ljava/lang/String;)V", "cardBrandChangeListener", "Lcom/stripe/android/view/CardNumberEditText$CardBrandChangeListener;", "cardNumber", "getCardNumber", "cardNumberCompleteListener", "Lcom/stripe/android/view/CardNumberEditText$CardNumberCompleteListener;", "ignoreChanges", "", "isCardNumberValid", "()Z", "lengthMax", "getLengthMax", "()I", "listenForTextChanges", "", "onInitializeAccessibilityNodeInfo", "info", "Landroid/view/accessibility/AccessibilityNodeInfo;", "setCardBrandChangeListener", "listener", "setCardBrandChangeListener$stripe_release", "setCardNumberCompleteListener", "setCardNumberCompleteListener$stripe_release", "updateCardBrand", "brand", "updateCardBrandFromNumber", "partialNumber", "updateLengthFilter", "updateLengthFilter$stripe_release", "updateSelectionIndex", "newLength", "editActionStart", "editActionAddition", "updateSelectionIndex$stripe_release", "CardBrandChangeListener", "CardNumberCompleteListener", "Companion", "stripe_release"})
public final class CardNumberEditText
extends StripeEditText {
    @NotNull
    private String cardBrand;
    private CardBrandChangeListener cardBrandChangeListener;
    private CardNumberCompleteListener cardNumberCompleteListener;
    private int lengthMax;
    private boolean ignoreChanges;
    private boolean isCardNumberValid;
    private static final int MAX_LENGTH_COMMON = 19;
    private static final int MAX_LENGTH_AMEX_DINERS = 17;
    private static final Set<Integer> SPACE_SET_COMMON;
    private static final Set<Integer> SPACE_SET_AMEX;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @VisibleForTesting
    public static /* synthetic */ void cardBrand$annotations() {
    }

    @NotNull
    public final String getCardBrand() {
        return this.cardBrand;
    }

    public final void setCardBrand$stripe_release(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.cardBrand = string2;
    }

    public final int getLengthMax() {
        return this.lengthMax;
    }

    public final boolean isCardNumberValid() {
        return this.isCardNumberValid;
    }

    @Nullable
    public final String getCardNumber() {
        String string2;
        if (this.isCardNumberValid) {
            Editable editable = this.getText();
            string2 = StripeTextUtils.removeSpacesAndHyphens(editable != null ? editable.toString() : null);
        } else {
            string2 = null;
        }
        return string2;
    }

    public void onInitializeAccessibilityNodeInfo(@NotNull AccessibilityNodeInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        super.onInitializeAccessibilityNodeInfo(info);
        info.setText((CharSequence)this.getResources().getString(R.string.acc_label_card_number_node, new Object[]{this.getText()}));
    }

    public final /* synthetic */ void setCardNumberCompleteListener$stripe_release(@NotNull CardNumberCompleteListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.cardNumberCompleteListener = listener;
    }

    public final /* synthetic */ void setCardBrandChangeListener$stripe_release(@NotNull CardBrandChangeListener listener) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            CardBrandChangeListener cardBrandChangeListener = this.cardBrandChangeListener = listener;
            if (cardBrandChangeListener == null) break block0;
            cardBrandChangeListener.onCardBrandChanged(this.cardBrand);
        }
    }

    public final /* synthetic */ void updateLengthFilter$stripe_release() {
        this.setFilters(new InputFilter[]{(InputFilter)new InputFilter.LengthFilter(this.lengthMax)});
    }

    public final /* synthetic */ int updateSelectionIndex$stripe_release(int newLength, int editActionStart, int editActionAddition) {
        int gapsJumped = 0;
        Set<Integer> gapSet = Intrinsics.areEqual((Object)"American Express", (Object)this.cardBrand) ? SPACE_SET_AMEX : SPACE_SET_COMMON;
        boolean skipBack = false;
        Iterable $this$forEach$iv = gapSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int gap = ((Number)element$iv).intValue();
            boolean bl = false;
            if (editActionStart <= gap && editActionStart + editActionAddition > gap) {
                int n = gapsJumped;
                gapsJumped = n + 1;
            }
            if (editActionAddition != 0 || editActionStart != gap + 1) continue;
            skipBack = true;
        }
        int newPosition = editActionStart + editActionAddition + gapsJumped;
        if (skipBack && newPosition > 0) {
            --newPosition;
        }
        return newPosition <= newLength ? newPosition : newLength;
    }

    private final void listenForTextChanges() {
        this.addTextChangedListener(new TextWatcher(this){
            private int latestChangeStart;
            private int latestInsertionSize;
            final /* synthetic */ CardNumberEditText this$0;

            public final int getLatestChangeStart() {
                return this.latestChangeStart;
            }

            public final void setLatestChangeStart(int n) {
                this.latestChangeStart = n;
            }

            public final int getLatestInsertionSize() {
                return this.latestInsertionSize;
            }

            public final void setLatestInsertionSize(int n) {
                this.latestInsertionSize = n;
            }

            public void beforeTextChanged(@NotNull CharSequence s, int start2, int count, int after) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                if (!CardNumberEditText.access$getIgnoreChanges$p(this.this$0)) {
                    this.latestChangeStart = start2;
                    this.latestInsertionSize = after;
                }
            }

            /*
             * WARNING - void declaration
             */
            public void onTextChanged(@NotNull CharSequence s, int start2, int before, int count) {
                void i;
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                if (CardNumberEditText.access$getIgnoreChanges$p(this.this$0)) {
                    return;
                }
                if (start2 < 4) {
                    CardNumberEditText.access$updateCardBrandFromNumber(this.this$0, ((Object)s).toString());
                }
                if (start2 > 16) {
                    return;
                }
                String string2 = StripeTextUtils.removeSpacesAndHyphens(((Object)s).toString());
                if (string2 == null) {
                    return;
                }
                String spacelessNumber = string2;
                String[] cardParts = ViewUtils.separateCardNumberGroups(spacelessNumber, this.this$0.getCardBrand());
                StringBuilder formattedNumberBuilder = new StringBuilder();
                int n = 0;
                int n2 = cardParts.length;
                while (n < n2 && cardParts[i] != null) {
                    if (i != false) {
                        formattedNumberBuilder.append(' ');
                    }
                    formattedNumberBuilder.append(cardParts[i]);
                    ++i;
                }
                String string3 = formattedNumberBuilder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"formattedNumberBuilder.toString()");
                String formattedNumber = string3;
                int cursorPosition = this.this$0.updateSelectionIndex$stripe_release(formattedNumber.length(), this.latestChangeStart, this.latestInsertionSize);
                CardNumberEditText.access$setIgnoreChanges$p(this.this$0, true);
                this.this$0.setText(formattedNumber);
                this.this$0.setSelection(cursorPosition);
                CardNumberEditText.access$setIgnoreChanges$p(this.this$0, false);
            }

            public void afterTextChanged(@NotNull Editable s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                if (s.length() == this.this$0.getLengthMax()) {
                    boolean before = this.this$0.isCardNumberValid();
                    CardNumberEditText.access$setCardNumberValid$p(this.this$0, CardUtils.isValidCardNumber(s.toString()));
                    this.this$0.setShouldShowError(!this.this$0.isCardNumberValid());
                    if (!before && this.this$0.isCardNumberValid()) {
                        CardNumberCompleteListener cardNumberCompleteListener = CardNumberEditText.access$getCardNumberCompleteListener$p(this.this$0);
                        if (cardNumberCompleteListener != null) {
                            cardNumberCompleteListener.onCardNumberComplete();
                        }
                    }
                } else {
                    Editable editable = this.this$0.getText();
                    CardNumberEditText.access$setCardNumberValid$p(this.this$0, CardUtils.isValidCardNumber(editable != null ? editable.toString() : null));
                    this.this$0.setShouldShowError(false);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void updateCardBrand(String brand) {
        if (Intrinsics.areEqual((Object)this.cardBrand, (Object)brand)) {
            return;
        }
        this.cardBrand = brand;
        CardBrandChangeListener cardBrandChangeListener = this.cardBrandChangeListener;
        if (cardBrandChangeListener != null) {
            cardBrandChangeListener.onCardBrandChanged(this.cardBrand);
        }
        int oldLength = this.lengthMax;
        this.lengthMax = CardNumberEditText.Companion.getLengthForBrand(this.cardBrand);
        if (oldLength == this.lengthMax) {
            return;
        }
        this.updateLengthFilter$stripe_release();
    }

    private final void updateCardBrandFromNumber(String partialNumber) {
        this.updateCardBrand(CardUtils.getPossibleCardType(partialNumber));
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.cardBrand = "Unknown";
        this.lengthMax = 19;
        this.listenForTextChanges();
    }

    public /* synthetic */ CardNumberEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        SPACE_SET_COMMON = SetsKt.setOf((Object[])new Integer[]{4, 9, 14});
        SPACE_SET_AMEX = SetsKt.setOf((Object[])new Integer[]{4, 11});
    }

    public static final /* synthetic */ boolean access$getIgnoreChanges$p(CardNumberEditText $this) {
        return $this.ignoreChanges;
    }

    public static final /* synthetic */ void access$setIgnoreChanges$p(CardNumberEditText $this, boolean bl) {
        $this.ignoreChanges = bl;
    }

    public static final /* synthetic */ void access$updateCardBrandFromNumber(CardNumberEditText $this, String partialNumber) {
        $this.updateCardBrandFromNumber(partialNumber);
    }

    public static final /* synthetic */ int access$getLengthMax$p(CardNumberEditText $this) {
        return $this.lengthMax;
    }

    public static final /* synthetic */ void access$setLengthMax$p(CardNumberEditText $this, int n) {
        $this.lengthMax = n;
    }

    public static final /* synthetic */ boolean access$isCardNumberValid$p(CardNumberEditText $this) {
        return $this.isCardNumberValid;
    }

    public static final /* synthetic */ void access$setCardNumberValid$p(CardNumberEditText $this, boolean bl) {
        $this.isCardNumberValid = bl;
    }

    public static final /* synthetic */ CardNumberCompleteListener access$getCardNumberCompleteListener$p(CardNumberEditText $this) {
        return $this.cardNumberCompleteListener;
    }

    public static final /* synthetic */ void access$setCardNumberCompleteListener$p(CardNumberEditText $this, CardNumberCompleteListener cardNumberCompleteListener) {
        $this.cardNumberCompleteListener = cardNumberCompleteListener;
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/view/CardNumberEditText$CardNumberCompleteListener;", "", "onCardNumberComplete", "", "stripe_release"})
    public static interface CardNumberCompleteListener {
        public void onCardNumberComplete();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/CardNumberEditText$CardBrandChangeListener;", "", "onCardBrandChanged", "", "brand", "", "stripe_release"})
    public static interface CardBrandChangeListener {
        public void onCardBrandChanged(@NotNull String var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/view/CardNumberEditText$Companion;", "", "()V", "MAX_LENGTH_AMEX_DINERS", "", "MAX_LENGTH_COMMON", "SPACE_SET_AMEX", "", "SPACE_SET_COMMON", "getLengthForBrand", "cardBrand", "", "stripe_release"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final int getLengthForBrand(String cardBrand) {
            String string2 = cardBrand;
            switch (string2.hashCode()) {
                case -298759312: {
                    if (!string2.equals("American Express")) return 19;
                    return 17;
                }
                case -993787207: {
                    if (!string2.equals("Diners Club")) return 19;
                    return 17;
                }
            }
            return 19;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

