/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.model.Address;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripeParamsModel;
import com.stripe.android.model.wallets.Wallet;
import com.stripe.android.model.wallets.WalletFactory;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public final class PaymentMethod
extends StripeModel
implements Parcelable {
    private static final String FIELD_ID = "id";
    private static final String FIELD_BILLING_DETAILS = "billing_details";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_CUSTOMER = "customer";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_METADATA = "metadata";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_CARD = "card";
    private static final String FIELD_CARD_PRESENT = "card_present";
    private static final String FIELD_FPX = "fpx";
    private static final String FIELD_IDEAL = "ideal";
    private static final String FIELD_SEPA_DEBIT = "sepa_debit";
    @Nullable
    public final String id;
    @Nullable
    public final Long created;
    public final boolean liveMode;
    @Nullable
    public final String type;
    @Nullable
    public final BillingDetails billingDetails;
    @Nullable
    public final String customerId;
    @Nullable
    public final Map<String, String> metadata;
    @Nullable
    public final Card card;
    @Nullable
    public final CardPresent cardPresent;
    @Nullable
    public final Fpx fpx;
    @Nullable
    public final Ideal ideal;
    @Nullable
    public final SepaDebit sepaDebit;
    public static final Parcelable.Creator<PaymentMethod> CREATOR = new Parcelable.Creator<PaymentMethod>(){

        @NonNull
        public PaymentMethod createFromParcel(@NonNull Parcel parcel) {
            return new PaymentMethod(parcel);
        }

        public PaymentMethod[] newArray(int size) {
            return new PaymentMethod[size];
        }
    };

    private PaymentMethod(@Nullable String id2, @Nullable Long created, boolean liveMode, @Nullable String type, @Nullable BillingDetails billingDetails, @Nullable String customerId, @Nullable Map<String, String> metadata, @Nullable Card card, @Nullable CardPresent cardPresent, @Nullable Fpx fpx, @Nullable Ideal ideal, @Nullable SepaDebit sepaDebit) {
        this.id = id2;
        this.created = created;
        this.liveMode = liveMode;
        this.type = type;
        this.billingDetails = billingDetails;
        this.customerId = customerId;
        this.metadata = metadata;
        this.card = card;
        this.cardPresent = cardPresent;
        this.fpx = fpx;
        this.ideal = ideal;
        this.sepaDebit = sepaDebit;
    }

    private PaymentMethod(@NonNull Parcel parcel) {
        this(parcel.readString(), parcel.readInt() == 0 ? null : Long.valueOf(parcel.readLong()), parcel.readInt() != 0, parcel.readString(), (BillingDetails)parcel.readParcelable(BillingDetails.class.getClassLoader()), parcel.readString(), PaymentMethod.readMetadata(parcel), (Card)parcel.readParcelable(Card.class.getClassLoader()), (CardPresent)parcel.readParcelable(CardPresent.class.getClassLoader()), (Fpx)parcel.readParcelable(Fpx.class.getClassLoader()), (Ideal)parcel.readParcelable(Ideal.class.getClassLoader()), (SepaDebit)parcel.readParcelable(SepaDebit.class.getClassLoader()));
    }

    public boolean isValid() {
        return this.type != null;
    }

    @Nullable
    public static PaymentMethod fromString(@Nullable String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            return PaymentMethod.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static PaymentMethod fromJson(@Nullable JSONObject paymentMethod) {
        if (paymentMethod == null) {
            return null;
        }
        String type = StripeJsonUtils.optString(paymentMethod, FIELD_TYPE);
        Builder builder = new Builder().setId(StripeJsonUtils.optString(paymentMethod, FIELD_ID)).setType(type).setCreated(StripeJsonUtils.optLong(paymentMethod, FIELD_CREATED)).setBillingDetails(BillingDetails.fromJson(paymentMethod.optJSONObject(FIELD_BILLING_DETAILS))).setCustomerId(StripeJsonUtils.optString(paymentMethod, FIELD_CUSTOMER)).setLiveMode(Boolean.TRUE.equals(paymentMethod.optBoolean(FIELD_LIVEMODE))).setMetadata(StripeJsonUtils.optHash(paymentMethod, FIELD_METADATA));
        if (FIELD_CARD.equals(type)) {
            builder.setCard(Card.fromJson(paymentMethod.optJSONObject(FIELD_CARD)));
        } else if (FIELD_CARD_PRESENT.equals(type)) {
            builder.setCardPresent(CardPresent.EMPTY);
        } else if (FIELD_IDEAL.equals(type)) {
            builder.setIdeal(Ideal.fromJson(paymentMethod.optJSONObject(FIELD_IDEAL)));
        } else if (FIELD_FPX.equals(type)) {
            builder.setFpx(Fpx.fromJson(paymentMethod.optJSONObject(FIELD_FPX)));
        } else if (FIELD_SEPA_DEBIT.equals(type)) {
            builder.setSepaDebit(SepaDebit.fromJson(paymentMethod.optJSONObject(FIELD_SEPA_DEBIT)));
        }
        return builder.build();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof PaymentMethod && this.typedEquals((PaymentMethod)obj);
    }

    private boolean typedEquals(@NonNull PaymentMethod paymentMethod) {
        return Objects.equals(this.id, paymentMethod.id) && Objects.equals(this.created, paymentMethod.created) && this.liveMode == paymentMethod.liveMode && Objects.equals(this.type, paymentMethod.type) && Objects.equals(this.billingDetails, paymentMethod.billingDetails) && Objects.equals(this.card, paymentMethod.card) && Objects.equals(this.cardPresent, paymentMethod.cardPresent) && Objects.equals(this.fpx, paymentMethod.fpx) && Objects.equals(this.ideal, paymentMethod.ideal) && Objects.equals(this.sepaDebit, paymentMethod.sepaDebit) && Objects.equals(this.customerId, paymentMethod.customerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.created, this.liveMode, this.type, this.billingDetails, this.card, this.cardPresent, this.fpx, this.ideal, this.customerId);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.id);
        if (this.created == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeLong(this.created.longValue());
        }
        dest.writeInt(this.liveMode ? 1 : 0);
        dest.writeString(this.type);
        dest.writeParcelable((Parcelable)this.billingDetails, flags);
        dest.writeString(this.customerId);
        dest.writeInt(this.metadata == null ? -1 : this.metadata.size());
        if (this.metadata != null) {
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                dest.writeString(entry.getKey());
                dest.writeString(entry.getValue());
            }
        }
        dest.writeParcelable((Parcelable)this.card, flags);
        dest.writeParcelable((Parcelable)this.cardPresent, flags);
        dest.writeParcelable((Parcelable)this.fpx, flags);
        dest.writeParcelable((Parcelable)this.ideal, flags);
        dest.writeParcelable((Parcelable)this.sepaDebit, flags);
    }

    @Nullable
    private static Map<String, String> readMetadata(@NonNull Parcel parcel) {
        int mapSize = parcel.readInt();
        if (mapSize >= 0) {
            HashMap<String, String> metadata = new HashMap<String, String>(mapSize);
            for (int i = 0; i < mapSize; ++i) {
                String key = parcel.readString();
                String value = parcel.readString();
                if (key == null || value == null) continue;
                metadata.put(key, value);
            }
            return metadata;
        }
        return null;
    }

    private static abstract class PaymentMethodTypeData
    extends StripeModel
    implements Parcelable {
        private PaymentMethodTypeData() {
        }

        public int describeContents() {
            return 0;
        }
    }

    public static final class SepaDebit
    extends PaymentMethodTypeData {
        private static final String FIELD_BANK_CODE = "bank_code";
        private static final String FIELD_BRANCH_CODE = "branch_code";
        private static final String FIELD_COUNTRY = "country";
        private static final String FIELD_FINGERPRINT = "fingerprint";
        private static final String FIELD_LAST4 = "last4";
        @Nullable
        public final String bankCode;
        @Nullable
        public final String branchCode;
        @Nullable
        public final String country;
        @Nullable
        public final String fingerprint;
        @Nullable
        public final String last4;
        public static final Parcelable.Creator<SepaDebit> CREATOR = new Parcelable.Creator<SepaDebit>(){

            public SepaDebit createFromParcel(@NonNull Parcel parcel) {
                return new SepaDebit(parcel);
            }

            public SepaDebit[] newArray(int size) {
                return new SepaDebit[size];
            }
        };

        SepaDebit(@Nullable String bankCode, @Nullable String branchCode, @Nullable String country, @Nullable String fingerprint, @Nullable String last4) {
            this.bankCode = bankCode;
            this.branchCode = branchCode;
            this.country = country;
            this.fingerprint = fingerprint;
            this.last4 = last4;
        }

        private SepaDebit(@NonNull Parcel parcel) {
            this(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.bankCode, this.branchCode, this.country, this.fingerprint, this.last4);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof SepaDebit) {
                return this.typedEquals((SepaDebit)other);
            }
            return false;
        }

        private boolean typedEquals(@NonNull SepaDebit other) {
            return Objects.equals(this.bankCode, other.bankCode) && Objects.equals(this.branchCode, other.branchCode) && Objects.equals(this.country, other.country) && Objects.equals(this.fingerprint, other.fingerprint) && Objects.equals(this.last4, other.last4);
        }

        public void writeToParcel(@NonNull Parcel parcel, int i) {
            parcel.writeString(this.bankCode);
            parcel.writeString(this.branchCode);
            parcel.writeString(this.country);
            parcel.writeString(this.fingerprint);
            parcel.writeString(this.last4);
        }

        @Nullable
        static SepaDebit fromJson(@Nullable JSONObject sepaDebit) {
            if (sepaDebit == null) {
                return null;
            }
            return new SepaDebit(StripeJsonUtils.optString(sepaDebit, FIELD_BANK_CODE), StripeJsonUtils.optString(sepaDebit, FIELD_BRANCH_CODE), StripeJsonUtils.optString(sepaDebit, FIELD_COUNTRY), StripeJsonUtils.optString(sepaDebit, FIELD_FINGERPRINT), StripeJsonUtils.optString(sepaDebit, FIELD_LAST4));
        }
    }

    public static final class Fpx
    extends PaymentMethodTypeData {
        private static final String FIELD_ACCOUNT_HOLDER_TYPE = "account_holder_type";
        private static final String FIELD_BANK = "bank";
        @Nullable
        public final String bank;
        @Nullable
        public final String accountHolderType;
        public static final Parcelable.Creator<Fpx> CREATOR = new Parcelable.Creator<Fpx>(){

            public Fpx createFromParcel(@NonNull Parcel parcel) {
                return new Fpx(parcel);
            }

            public Fpx[] newArray(int size) {
                return new Fpx[size];
            }
        };

        private Fpx(@Nullable String bank, @Nullable String accountHolderType) {
            this.bank = bank;
            this.accountHolderType = accountHolderType;
        }

        private Fpx(@NonNull Parcel parcel) {
            this(parcel.readString(), parcel.readString());
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString(this.bank);
            dest.writeString(this.accountHolderType);
        }

        @Nullable
        public static Fpx fromJson(@Nullable JSONObject fpx) {
            if (fpx == null) {
                return null;
            }
            return new Builder().setBank(StripeJsonUtils.optString(fpx, FIELD_BANK)).setAccountHolderType(StripeJsonUtils.optString(fpx, FIELD_ACCOUNT_HOLDER_TYPE)).build();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.bank, this.accountHolderType);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Fpx && this.typedEquals((Fpx)obj);
        }

        private boolean typedEquals(@NonNull Fpx obj) {
            return Objects.equals(this.bank, obj.bank) && Objects.equals(this.accountHolderType, obj.accountHolderType);
        }

        public static final class Builder
        implements ObjectBuilder<Fpx> {
            private String mBank;
            private String mAccountHolderType;

            @NonNull
            public Builder setBank(@Nullable String bank) {
                this.mBank = bank;
                return this;
            }

            @NonNull
            public Builder setAccountHolderType(@Nullable String bankIdentifierCode) {
                this.mAccountHolderType = bankIdentifierCode;
                return this;
            }

            @Override
            @NonNull
            public Fpx build() {
                return new Fpx(this.mBank, this.mAccountHolderType);
            }
        }
    }

    public static final class Ideal
    extends PaymentMethodTypeData {
        private static final String FIELD_BANK = "bank";
        private static final String FIELD_BIC = "bic";
        @Nullable
        public final String bank;
        @Nullable
        public final String bankIdentifierCode;
        public static final Parcelable.Creator<Ideal> CREATOR = new Parcelable.Creator<Ideal>(){

            public Ideal createFromParcel(@NonNull Parcel parcel) {
                return new Ideal(parcel);
            }

            public Ideal[] newArray(int size) {
                return new Ideal[size];
            }
        };

        private Ideal(@Nullable String bank, @Nullable String bankIdentifierCode) {
            this.bank = bank;
            this.bankIdentifierCode = bankIdentifierCode;
        }

        private Ideal(@NonNull Parcel parcel) {
            this(parcel.readString(), parcel.readString());
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString(this.bank);
            dest.writeString(this.bankIdentifierCode);
        }

        @Nullable
        public static Ideal fromJson(@Nullable JSONObject ideal) {
            if (ideal == null) {
                return null;
            }
            return new Builder().setBank(StripeJsonUtils.optString(ideal, FIELD_BANK)).setBankIdentifierCode(StripeJsonUtils.optString(ideal, FIELD_BIC)).build();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.bank, this.bankIdentifierCode);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Ideal && this.typedEquals((Ideal)obj);
        }

        private boolean typedEquals(@NonNull Ideal obj) {
            return Objects.equals(this.bank, obj.bank) && Objects.equals(this.bankIdentifierCode, obj.bankIdentifierCode);
        }

        public static final class Builder
        implements ObjectBuilder<Ideal> {
            private String mBank;
            private String mBankIdentifierCode;

            @NonNull
            public Builder setBank(@Nullable String bank) {
                this.mBank = bank;
                return this;
            }

            @NonNull
            public Builder setBankIdentifierCode(@Nullable String bankIdentifierCode) {
                this.mBankIdentifierCode = bankIdentifierCode;
                return this;
            }

            @Override
            @NonNull
            public Ideal build() {
                return new Ideal(this.mBank, this.mBankIdentifierCode);
            }
        }
    }

    public static final class CardPresent
    extends PaymentMethodTypeData {
        public static final CardPresent EMPTY = new CardPresent();
        public static final Parcelable.Creator<CardPresent> CREATOR = new Parcelable.Creator<CardPresent>(){

            public CardPresent createFromParcel(@NonNull Parcel parcel) {
                return new CardPresent();
            }

            public CardPresent[] newArray(int size) {
                return new CardPresent[size];
            }
        };

        private CardPresent() {
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof CardPresent;
        }

        public void writeToParcel(Parcel parcel, int i) {
        }
    }

    public static final class Card
    extends PaymentMethodTypeData {
        private static final String FIELD_BRAND = "brand";
        private static final String FIELD_CHECKS = "checks";
        private static final String FIELD_COUNTRY = "country";
        private static final String FIELD_EXP_MONTH = "exp_month";
        private static final String FIELD_EXP_YEAR = "exp_year";
        private static final String FIELD_FUNDING = "funding";
        private static final String FIELD_LAST4 = "last4";
        private static final String FIELD_THREE_D_SECURE_USAGE = "three_d_secure_usage";
        private static final String FIELD_WALLET = "wallet";
        @Nullable
        public final String brand;
        @Nullable
        public final Checks checks;
        @Nullable
        public final String country;
        @Nullable
        public final Integer expiryMonth;
        @Nullable
        public final Integer expiryYear;
        @Nullable
        public final String funding;
        @Nullable
        public final String last4;
        @Nullable
        public final ThreeDSecureUsage threeDSecureUsage;
        @Nullable
        public final Wallet wallet;
        public static final Parcelable.Creator<Card> CREATOR = new Parcelable.Creator<Card>(){

            public Card createFromParcel(@NonNull Parcel parcel) {
                return new Card(parcel);
            }

            public Card[] newArray(int size) {
                return new Card[size];
            }
        };

        private Card(@Nullable String brand, @Nullable Checks checks, @Nullable String country, @Nullable Integer expiryMonth, @Nullable Integer expiryYear, @Nullable String funding, @Nullable String last4, @Nullable ThreeDSecureUsage threeDSecureUsage, @Nullable Wallet wallet) {
            this.brand = brand;
            this.checks = checks;
            this.country = country;
            this.expiryMonth = expiryMonth;
            this.expiryYear = expiryYear;
            this.funding = funding;
            this.last4 = last4;
            this.threeDSecureUsage = threeDSecureUsage;
            this.wallet = wallet;
        }

        private Card(@NonNull Parcel parcel) {
            this(parcel.readString(), (Checks)parcel.readParcelable(Checks.class.getClassLoader()), parcel.readString(), parcel.readInt() == 0 ? null : Integer.valueOf(parcel.readInt()), parcel.readInt() == 0 ? null : Integer.valueOf(parcel.readInt()), parcel.readString(), parcel.readString(), (ThreeDSecureUsage)parcel.readParcelable(ThreeDSecureUsage.class.getClassLoader()), (Wallet)parcel.readParcelable(Wallet.class.getClassLoader()));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString(this.brand);
            dest.writeParcelable((Parcelable)this.checks, flags);
            dest.writeString(this.country);
            if (this.expiryMonth == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeInt(this.expiryMonth.intValue());
            }
            if (this.expiryYear == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeInt(this.expiryYear.intValue());
            }
            dest.writeString(this.funding);
            dest.writeString(this.last4);
            dest.writeParcelable((Parcelable)this.threeDSecureUsage, flags);
            dest.writeParcelable((Parcelable)this.wallet, flags);
        }

        @Nullable
        public static Card fromJson(@Nullable JSONObject cardJson) {
            if (cardJson == null) {
                return null;
            }
            return new Builder().setBrand(StripeJsonUtils.optString(cardJson, FIELD_BRAND)).setChecks(Checks.fromJson(cardJson.optJSONObject(FIELD_CHECKS))).setCountry(StripeJsonUtils.optString(cardJson, FIELD_COUNTRY)).setExpiryMonth(StripeJsonUtils.optInteger(cardJson, FIELD_EXP_MONTH)).setExpiryYear(StripeJsonUtils.optInteger(cardJson, FIELD_EXP_YEAR)).setFunding(StripeJsonUtils.optString(cardJson, FIELD_FUNDING)).setLast4(StripeJsonUtils.optString(cardJson, FIELD_LAST4)).setThreeDSecureUsage(ThreeDSecureUsage.fromJson(cardJson.optJSONObject(FIELD_THREE_D_SECURE_USAGE))).setWallet(new WalletFactory().create(cardJson.optJSONObject(FIELD_WALLET))).build();
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || obj instanceof Card && this.typedEquals((Card)obj);
        }

        private boolean typedEquals(@NonNull Card card) {
            return Objects.equals(this.brand, card.brand) && Objects.equals(this.checks, card.checks) && Objects.equals(this.country, card.country) && Objects.equals(this.expiryMonth, card.expiryMonth) && Objects.equals(this.expiryYear, card.expiryYear) && Objects.equals(this.funding, card.funding) && Objects.equals(this.last4, card.last4) && Objects.equals(this.threeDSecureUsage, card.threeDSecureUsage) && Objects.equals(this.wallet, card.wallet);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.brand, this.checks, this.country, this.expiryMonth, this.expiryYear, this.funding, this.last4, this.threeDSecureUsage, this.wallet);
        }

        public static final class ThreeDSecureUsage
        extends StripeModel
        implements Parcelable {
            private static final String FIELD_IS_SUPPORTED = "supported";
            public final boolean isSupported;
            public static final Parcelable.Creator<ThreeDSecureUsage> CREATOR = new Parcelable.Creator<ThreeDSecureUsage>(){

                public ThreeDSecureUsage createFromParcel(@NonNull Parcel parcel) {
                    return new ThreeDSecureUsage(parcel);
                }

                public ThreeDSecureUsage[] newArray(int size) {
                    return new ThreeDSecureUsage[size];
                }
            };

            private ThreeDSecureUsage(boolean isSupported) {
                this.isSupported = isSupported;
            }

            private ThreeDSecureUsage(@NonNull Parcel parcel) {
                this(parcel.readInt() != 0);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NonNull Parcel dest, int flags) {
                dest.writeInt(this.isSupported ? 1 : 0);
            }

            @Nullable
            public static ThreeDSecureUsage fromJson(@Nullable JSONObject threeDSecureUsage) {
                if (threeDSecureUsage == null) {
                    return null;
                }
                return new Builder().setSupported(Boolean.TRUE.equals(StripeJsonUtils.optBoolean(threeDSecureUsage, FIELD_IS_SUPPORTED))).build();
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.isSupported);
            }

            @Override
            public boolean equals(@Nullable Object obj) {
                return this == obj || obj instanceof ThreeDSecureUsage && this.typedEquals((ThreeDSecureUsage)obj);
            }

            private boolean typedEquals(@NonNull ThreeDSecureUsage threeDSecureUsage) {
                return this.isSupported == threeDSecureUsage.isSupported;
            }

            public static final class Builder
            implements ObjectBuilder<ThreeDSecureUsage> {
                private boolean mIsSupported;

                @NonNull
                public Builder setSupported(boolean supported) {
                    this.mIsSupported = supported;
                    return this;
                }

                @Override
                @NonNull
                public ThreeDSecureUsage build() {
                    return new ThreeDSecureUsage(this.mIsSupported);
                }
            }
        }

        public static final class Checks
        extends StripeModel
        implements Parcelable {
            private static final String FIELD_ADDRESS_LINE1_CHECK = "address_line1_check";
            private static final String FIELD_ADDRESS_POSTAL_CODE_CHECK = "address_postal_code_check";
            private static final String FIELD_CVC_CHECK = "cvc_check";
            @Nullable
            public final String addressLine1Check;
            @Nullable
            public final String addressPostalCodeCheck;
            @Nullable
            public final String cvcCheck;
            public static final Parcelable.Creator<Checks> CREATOR = new Parcelable.Creator<Checks>(){

                public Checks createFromParcel(@NonNull Parcel parcel) {
                    return new Checks(parcel);
                }

                public Checks[] newArray(int size) {
                    return new Checks[size];
                }
            };

            private Checks(@Nullable String addressLine1Check, @Nullable String addressPostalCodeCheck, @Nullable String cvcCheck) {
                this.addressLine1Check = addressLine1Check;
                this.addressPostalCodeCheck = addressPostalCodeCheck;
                this.cvcCheck = cvcCheck;
            }

            private Checks(@NonNull Parcel parcel) {
                this(parcel.readString(), parcel.readString(), parcel.readString());
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NonNull Parcel dest, int flags) {
                dest.writeString(this.addressLine1Check);
                dest.writeString(this.addressPostalCodeCheck);
                dest.writeString(this.cvcCheck);
            }

            @Nullable
            public static Checks fromJson(@Nullable JSONObject checksJson) {
                if (checksJson == null) {
                    return null;
                }
                return new Builder().setAddressLine1Check(StripeJsonUtils.optString(checksJson, FIELD_ADDRESS_LINE1_CHECK)).setAddressPostalCodeCheck(StripeJsonUtils.optString(checksJson, FIELD_ADDRESS_POSTAL_CODE_CHECK)).setCvcCheck(StripeJsonUtils.optString(checksJson, FIELD_CVC_CHECK)).build();
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj || obj instanceof Checks && this.typedEquals((Checks)obj);
            }

            private boolean typedEquals(@NonNull Checks checks) {
                return Objects.equals(this.addressLine1Check, checks.addressLine1Check) && Objects.equals(this.addressPostalCodeCheck, checks.addressPostalCodeCheck) && Objects.equals(this.cvcCheck, checks.cvcCheck);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.addressLine1Check, this.addressPostalCodeCheck, this.cvcCheck);
            }

            public static final class Builder
            implements ObjectBuilder<Checks> {
                @Nullable
                private String addressLine1Check;
                @Nullable
                private String addressPostalCodeCheck;
                @Nullable
                private String cvcCheck;

                @NonNull
                public Builder setAddressLine1Check(@Nullable String addressLine1Check) {
                    this.addressLine1Check = addressLine1Check;
                    return this;
                }

                @NonNull
                public Builder setAddressPostalCodeCheck(@Nullable String addressPostalCodeCheck) {
                    this.addressPostalCodeCheck = addressPostalCodeCheck;
                    return this;
                }

                @NonNull
                public Builder setCvcCheck(@Nullable String cvcCheck) {
                    this.cvcCheck = cvcCheck;
                    return this;
                }

                @Override
                @NonNull
                public Checks build() {
                    return new Checks(this.addressLine1Check, this.addressPostalCodeCheck, this.cvcCheck);
                }
            }
        }

        public static final class Builder
        implements ObjectBuilder<Card> {
            private String mBrand;
            private Checks checks;
            private String mCountry;
            private Integer mExpiryMonth;
            private Integer mExpiryYear;
            private String mFunding;
            private String mLast4;
            private ThreeDSecureUsage mThreeDSecureUsage;
            private Wallet mWallet;

            @NonNull
            public Builder setBrand(@Nullable String brand) {
                this.mBrand = brand;
                return this;
            }

            @NonNull
            public Builder setChecks(@Nullable Checks checks) {
                this.checks = checks;
                return this;
            }

            @NonNull
            public Builder setCountry(@Nullable String country) {
                this.mCountry = country;
                return this;
            }

            @NonNull
            public Builder setExpiryMonth(@Nullable Integer expiryMonth) {
                this.mExpiryMonth = expiryMonth;
                return this;
            }

            @NonNull
            public Builder setExpiryYear(@Nullable Integer expiryYear) {
                this.mExpiryYear = expiryYear;
                return this;
            }

            @NonNull
            public Builder setFunding(@Nullable String funding) {
                this.mFunding = funding;
                return this;
            }

            @NonNull
            public Builder setLast4(@Nullable String last4) {
                this.mLast4 = last4;
                return this;
            }

            @NonNull
            public Builder setThreeDSecureUsage(@Nullable ThreeDSecureUsage threeDSecureUsage) {
                this.mThreeDSecureUsage = threeDSecureUsage;
                return this;
            }

            @NonNull
            public Builder setWallet(@Nullable Wallet wallet) {
                this.mWallet = wallet;
                return this;
            }

            @Override
            @NonNull
            public Card build() {
                return new Card(this.mBrand, this.checks, this.mCountry, this.mExpiryMonth, this.mExpiryYear, this.mFunding, this.mLast4, this.mThreeDSecureUsage, this.mWallet);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Brand {
            public static final String AMERICAN_EXPRESS = "amex";
            public static final String DISCOVER = "discover";
            public static final String JCB = "jcb";
            public static final String DINERS_CLUB = "diners";
            public static final String VISA = "visa";
            public static final String MASTERCARD = "mastercard";
            public static final String UNIONPAY = "unionpay";
            public static final String UNKNOWN = "unknown";
        }
    }

    public static final class BillingDetails
    extends StripeModel
    implements StripeParamsModel,
    Parcelable {
        static final String FIELD_ADDRESS = "address";
        static final String FIELD_EMAIL = "email";
        static final String FIELD_NAME = "name";
        static final String FIELD_PHONE = "phone";
        @Nullable
        public final Address address;
        @Nullable
        public final String email;
        @Nullable
        public final String name;
        @Nullable
        public final String phone;
        public static final Parcelable.Creator<BillingDetails> CREATOR = new Parcelable.Creator<BillingDetails>(){

            public BillingDetails createFromParcel(@NonNull Parcel parcel) {
                return new BillingDetails(parcel);
            }

            public BillingDetails[] newArray(int size) {
                return new BillingDetails[size];
            }
        };

        private BillingDetails(@Nullable Address address, @Nullable String email, @Nullable String name, @Nullable String phone) {
            this.address = address;
            this.email = email;
            this.name = name;
            this.phone = phone;
        }

        private BillingDetails(@NonNull Parcel parcel) {
            this((Address)parcel.readParcelable(Address.class.getClassLoader()), parcel.readString(), parcel.readString(), parcel.readString());
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.address, flags);
            dest.writeString(this.email);
            dest.writeString(this.name);
            dest.writeString(this.phone);
        }

        @NonNull
        public Builder toBuilder() {
            return new Builder().setAddress(this.address).setEmail(this.email).setName(this.name).setPhone(this.phone);
        }

        @Override
        @NonNull
        public Map<String, Object> toParamMap() {
            HashMap<String, Object> billingDetails = new HashMap<String, Object>();
            if (this.address != null) {
                billingDetails.put(FIELD_ADDRESS, this.address.toParamMap());
            }
            if (this.email != null) {
                billingDetails.put(FIELD_EMAIL, this.email);
            }
            if (this.name != null) {
                billingDetails.put(FIELD_NAME, this.name);
            }
            if (this.phone != null) {
                billingDetails.put(FIELD_PHONE, this.phone);
            }
            return billingDetails;
        }

        @Nullable
        public static BillingDetails fromJson(@Nullable JSONObject billingDetails) {
            if (billingDetails == null) {
                return null;
            }
            return new Builder().setAddress(Address.fromJson(billingDetails.optJSONObject(FIELD_ADDRESS))).setEmail(StripeJsonUtils.optString(billingDetails, FIELD_EMAIL)).setName(StripeJsonUtils.optString(billingDetails, FIELD_NAME)).setPhone(StripeJsonUtils.optString(billingDetails, FIELD_PHONE)).build();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.address, this.email, this.name, this.phone);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof BillingDetails && this.typedEquals((BillingDetails)obj);
        }

        private boolean typedEquals(@NonNull BillingDetails obj) {
            return Objects.equals(this.address, obj.address) && Objects.equals(this.email, obj.email) && Objects.equals(this.name, obj.name) && Objects.equals(this.phone, obj.phone);
        }

        public static final class Builder
        implements ObjectBuilder<BillingDetails> {
            private Address mAddress;
            private String mEmail;
            private String mName;
            private String mPhone;

            @NonNull
            public Builder setAddress(@Nullable Address address) {
                this.mAddress = address;
                return this;
            }

            @NonNull
            public Builder setEmail(@Nullable String email) {
                this.mEmail = email;
                return this;
            }

            @NonNull
            public Builder setName(@Nullable String name) {
                this.mName = name;
                return this;
            }

            @NonNull
            public Builder setPhone(@Nullable String phone) {
                this.mPhone = phone;
                return this;
            }

            @Override
            @NonNull
            public BillingDetails build() {
                return new BillingDetails(this.mAddress, this.mEmail, this.mName, this.mPhone);
            }
        }
    }

    public static final class Builder
    implements ObjectBuilder<PaymentMethod> {
        private String mId;
        private Long mCreated;
        private boolean mLiveMode;
        private String mType;
        private BillingDetails mBillingDetails;
        private Map<String, String> mMetadata;
        private String mCustomerId;
        private Card mCard;
        private CardPresent mCardPresent;
        private Ideal mIdeal;
        private Fpx mFpx;
        private SepaDebit mSepaDebit;

        @NonNull
        public Builder setId(@Nullable String id2) {
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setCreated(@Nullable Long created) {
            this.mCreated = created;
            return this;
        }

        @NonNull
        public Builder setLiveMode(boolean liveMode) {
            this.mLiveMode = liveMode;
            return this;
        }

        @NonNull
        public Builder setMetadata(@Nullable Map<String, String> metadata) {
            this.mMetadata = metadata;
            return this;
        }

        @NonNull
        public Builder setType(@Nullable String type) {
            this.mType = type;
            return this;
        }

        @NonNull
        public Builder setBillingDetails(@Nullable BillingDetails billingDetails) {
            this.mBillingDetails = billingDetails;
            return this;
        }

        @NonNull
        public Builder setCard(@Nullable Card card) {
            this.mCard = card;
            return this;
        }

        @NonNull
        public Builder setCardPresent(@Nullable CardPresent cardPresent) {
            this.mCardPresent = cardPresent;
            return this;
        }

        @NonNull
        public Builder setCustomerId(@Nullable String customerId) {
            this.mCustomerId = customerId;
            return this;
        }

        @NonNull
        public Builder setIdeal(@Nullable Ideal ideal) {
            this.mIdeal = ideal;
            return this;
        }

        @NonNull
        public Builder setFpx(@Nullable Fpx fpx) {
            this.mFpx = fpx;
            return this;
        }

        @NonNull
        public Builder setSepaDebit(@Nullable SepaDebit sepaDebit) {
            this.mSepaDebit = sepaDebit;
            return this;
        }

        @Override
        @NonNull
        public PaymentMethod build() {
            return new PaymentMethod(this.mId, this.mCreated, this.mLiveMode, this.mType, this.mBillingDetails, this.mCustomerId, this.mMetadata, this.mCard, this.mCardPresent, this.mFpx, this.mIdeal, this.mSepaDebit);
        }
    }

    public static enum Type implements Parcelable
    {
        Card("card"),
        CardPresent("card_present"),
        Fpx("fpx", false),
        Ideal("ideal"),
        SepaDebit("sepa_debit");

        @NonNull
        public final String code;
        public final boolean isReusable;
        public static final Parcelable.Creator<Type> CREATOR;

        private Type(String code) {
            this(code, true);
        }

        private Type(String code, boolean isReusable) {
            this.code = code;
            this.isReusable = isReusable;
        }

        @NonNull
        public String toString() {
            return this.code;
        }

        @Nullable
        public static Type lookup(@Nullable String code) {
            for (Type type : Type.values()) {
                if (!type.code.equals(code)) continue;
                return type;
            }
            return null;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<Type>(){

                public Type createFromParcel(@NonNull Parcel parcel) {
                    return Type.values()[parcel.readInt()];
                }

                public Type[] newArray(int size) {
                    return new Type[size];
                }
            };
        }
    }
}

